/*************************************************************************
 *
 *  $RCSfile: DispatcherAdapterFactory_Test.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/19 00:28:31 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.lib.sandbox.generic.test;

import com.sun.star.lib.sandbox.generic.Dispatcher;
import com.sun.star.lib.sandbox.generic.DispatcherAdapterBase;
import com.sun.star.lib.sandbox.generic.DispatcherAdapterFactory;

public class DispatcherAdapterFactory_Test implements Dispatcher {
	public static void main(String [] args) {
		boolean bError = false;
		try	{
			String aPrefix;
			int iIndex;
			
			System.out.println( "DispatcherAdapterFactory test " );
			aPrefix = "failed: ";
			
			//================================================================
			System.out.println( "create test" );
			Class aBCClass = Class.forName( "com.sun.star.lib.sandbox.generic.test.Broadcast" );
			Class aTestClass = DispatcherAdapterFactory.createDispatcherAdapter(aBCClass);
			Object aObj = aTestClass.newInstance();
			DispatcherAdapterBase aJSW = (DispatcherAdapterBase)aObj;
			DispatcherAdapterFactory_Test aCallee = new DispatcherAdapterFactory_Test();
			aJSW.setObject( aCallee, "test" );
			Broadcast aBC = (Broadcast)aObj;

			//================================================================
			System.out.println( "return test" );

			{
				aBC.V();
				if( aBC.Z( true ) != true )	{
					System.out.println( aPrefix + "boolean" );
					bError = true;
				}

				if( aBC.B( (byte)3 ) != 3 )	{
					System.out.println( aPrefix + "byte" );
					bError = true;
				}

				if( aBC.S( (short)3 ) != 3 ) {
					System.out.println( aPrefix + "short" );
					bError = true;
				}

				if( aBC.C( (char)3 ) != 3 )	{
					System.out.println( aPrefix + "char" );
					bError = true;
				}

				if( aBC.I( 3 ) != 3 ) {
					System.out.println( aPrefix + "int" );
					bError = true;
				}

				if( aBC.J( 3 ) != 3 ) {
					System.out.println( aPrefix + "long" );
					bError = true;
				}

				if( aBC.F( (float)3.0 ) != (float)3.0 )	{
					System.out.println( aPrefix + "float" );
					bError = true;
				}

				if( aBC.D( 3.3 ) != 3.3 ) {
					System.out.println( aPrefix + "double" );
					bError = true;
				}

				Object aTmpObj = new Object();
				if( aBC.L( aTmpObj ) != aTmpObj ) {
					System.out.println( aPrefix + "Object" );
					bError = true;
				}
			}

			//================================================================
			System.out.println( "MultiArg test" );
			{
				if( aBC.multiArg( true, 5.7, "Hallo", new StringBuffer() ) != true ) {
					System.out.println( aPrefix + "multiArg" );
					bError = true;
				}
			}
        
			//================================================================
			System.out.println( "StringRet test" );
			{
				if( !aBC.stringRet().equals( "String" ) ) {
					System.out.println( aPrefix + "stringRet" );
					bError = true;
				}
			}
        
		}
		catch(Throwable e) {
			System.out.println( "DispatcherAdapterFactory_Test failed: " + e );
			e.printStackTrace();
			bError = true;
		}

		if( bError )
			System.exit( -1 );
	}

    public Object invoke(Object aObj, String aMethodName, Object[] aParams) throws Exception {
		if(true)
			throw new Exception("DDD");

        System.out.print( "" + aObj + ", " + aMethodName );
        for( int i = 0; i < aParams.length; i++ )
            System.out.print( ", " + aParams[ i ] );

        System.out.println( "" );
        if( aMethodName.length() == 1 )	{
			if( aParams.length != 0 )
				return aParams[ 0 ];
			else
				return null;
		}
        else if( "multiArg".equals( aMethodName ) )	{
			if( ((Boolean)aParams[0]).booleanValue() != true )
				return Boolean.FALSE;
			if( ((Double)aParams[1]).doubleValue() != 5.7 )
				return Boolean.FALSE;
			if( !((String)aParams[2]).equals( "Hallo") )
				return Boolean.FALSE;
			if( !(aParams[3] instanceof StringBuffer) )
				return Boolean.FALSE;
			if( aParams.length != 4 )
				return Boolean.FALSE;
			return Boolean.TRUE;
		}
        else if( "stringRet".equals( aMethodName ) ) {
			return "String";
			//              return new StringBuffer( "String" );
		}

        return null;
    }
}

