/*************************************************************************
 *
 *  $RCSfile: chtmode2.cxx,v $
 *
 *  $Revision: 1.19 $
 *
 *  last change: $Author: bm $ $Date: 2002/03/25 10:00:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _STREAM_HXX
// enable stream operators >>/<< for UniString (8 Bit !)
#ifndef ENABLE_STRING_STREAM_OPERATORS
#define ENABLE_STRING_STREAM_OPERATORS
#endif
#include <tools/stream.hxx>
#endif
#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif

#ifndef _SCHATTR_HXX
#include "schattr.hxx"
#endif
#ifndef _SCH_MEMCHRT_HXX
#include "memchrt.hxx"
#endif

#ifndef _SVX_CHRTITEM_HXX //autogen
#define ITEMID_DOUBLE	        0
#define ITEMID_CHARTTEXTORIENT	SCHATTR_TEXT_ORIENT
#define ITEMID_CHARTTEXTORDER   SCHATTR_TEXT_ORDER
#define ITEMID_CHARTLEGENDPOS   SCHATTR_LEGEND_POS
#include <svx/chrtitem.hxx>
#endif

#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
#ifndef _CHTSCENE_HXX
#include "chtscene.hxx"
#endif
#ifndef _SFXITEMPOOL_HXX //autogen
#include <svtools/itempool.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include <svx/svdmark.hxx>

#ifndef _SVDOPATH_HXX //autogen
#include <svx/svdopath.hxx>
#endif
#ifndef _SVDORECT_HXX //autogen
#include <svx/svdorect.hxx>
#endif

#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif

#ifndef _SVX_XLNCLIT_HXX //autogen
#include <svx/xlnclit.hxx>
#endif
#ifndef _SVX_XFLCLIT_HXX //autogen
#include <svx/xflclit.hxx>
#endif
#ifndef _SVX_XLNWTIT_HXX //autogen
#include <svx/xlnwtit.hxx>
#endif
#ifndef _SFXSTYLE_HXX //autogen
#include <svtools/style.hxx>
#endif
#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif
#ifndef _ZFORLIST_HXX //autogen
#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
#include <svtools/zforlist.hxx>
#endif
#ifndef _EEITEM_HXX //autogen
#include <svx/eeitem.hxx>
#endif
#ifndef _ZFORMAT_HXX //autogen
#include <svtools/zformat.hxx>
#endif
// header for getProcessServiceFactory
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#include "chmod3d.hxx" //SchRectObj

#define ITEMID_FONTHEIGHT  EE_CHAR_FONTHEIGHT
#define ITEMID_FONTWIDTH   EE_CHAR_FONTWIDTH
#define ITEMID_FONT        EE_CHAR_FONTINFO
#if SUPD > 364
#include <svx/fhgtitem.hxx>
#include <svx/fwdtitem.hxx>
#include <svx/fontitem.hxx>
#endif
#ifndef _SCH_OBJADJ_HXX
#include  "objadj.hxx"
#endif
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "globfunc.hxx"
#ifndef _SVX_SVXIDS_HRC
#include <svx/svxids.hrc>
#endif
#ifndef _SCH_SCHGROUP_HXX
#include "schgroup.hxx"
#endif
#ifndef _SCH_OBJID_HXX
#include "objid.hxx"
#endif
#ifndef _SCH_SCHRESID_HXX
#include "schresid.hxx"
#endif
#ifndef _SCH_DATAROW_HXX
#include "datarow.hxx"
#endif
#ifndef _SCH_DATAPOIN_HXX
#include "datapoin.hxx"
#endif
#ifndef _SCH_SCHIOCMP_HXX
#include "schiocmp.hxx"
#endif

#include "strings.hrc"
#include "glob.hrc"

#if SUPD > 364
#ifndef _SVX_FHGTITEM_HXX //autogen
#include <svx/fhgtitem.hxx>
#endif
#include <svx/fontitem.hxx>
#else
#include <textitem.hxx>
#endif

#ifndef _TOOLS_TENCCVT_HXX
#include <tools/tenccvt.hxx>
#endif

#include "pairs.hxx"
#include "chaxis.hxx"

#include "chdescr.hxx"
#include "calculat.hxx"


/************************************************************************/
const USHORT nCompatAxisWhichPairs[] =
{
	SCHATTR_TEXT_START, SCHATTR_TEXT_END,
	SCHATTR_Y_AXIS_START, SCHATTR_Z_AXIS_END, //X-Z!
	SCHATTR_AXISTYPE, SCHATTR_AXISTYPE,
	SCHATTR_TEXT_DEGREES,SCHATTR_TEXT_DEGREES,
	SCHATTR_TEXT_OVERLAP, SCHATTR_TEXT_OVERLAP,
	SCHATTR_AXIS_START,SCHATTR_AXIS_END,
	XATTR_LINE_FIRST, XATTR_LINE_LAST,
	EE_ITEMS_START, EE_ITEMS_END,
	SID_TEXTBREAK, SID_TEXTBREAK,
	SID_ATTR_NUMBERFORMAT_VALUE, SID_ATTR_NUMBERFORMAT_VALUE, //10.585
   0
};
/************************************************************************/

enum ChartStyleV0
{
	CHART2D_LINE,
	CHART2D_STACKEDLINE,
	CHART2D_BAR,
	CHART2D_STACKEDBAR,
	CHART2D_COLUMN,
	CHART2D_STACKEDCOLUMN,
	CHART2D_AREA,
	CHART2D_STACKEDAREA,
	CHART2D_PIE,
	CHART3D_STRIPE,
	CHART3D_BAR,
	CHART3D_FLATBAR,
	CHART3D_STACKEDFLATBAR,
	CHART3D_AREA,
	CHART3D_STACKEDAREA,
	CHART3D_SURFACE,
	CHART3D_PIE
};

/*************************************************************************
|*
|* Datenbeschriftung erzeugen
|*
\************************************************************************/

//SdrObject*
void ChartModel::CreateDataDescr(DataDescription& rDescr,long nCol,long nRow,ChartAxis *pAxis,BOOL bRowDescr,BOOL bIsPercent)
{

	UINT32 nDescrFormat=       pAxis ? pAxis->GetNumFormat(FALSE) : GetNumFmt(CHOBJID_DIAGRAM_Y_AXIS,FALSE);
	UINT32 nPercentDescrFormat=pAxis ? pAxis->GetNumFormat(TRUE)  : GetNumFmt(CHOBJID_DIAGRAM_Y_AXIS,TRUE);
	String aText;
	Color* pDummy = NULL;


	if (pAxis && !bIsPercent && ((rDescr.eDescr == CHDESCR_PERCENT)
					 || (rDescr.eDescr == CHDESCR_TEXTANDPERCENT)))
		rDescr.fValue=pAxis->Data2Percent(rDescr.fValue,nCol,nRow);

	switch (rDescr.eDescr)
	{
		case CHDESCR_VALUE:
			pNumFormatter->GetOutputString(rDescr.fValue, nDescrFormat, aText, &pDummy);
			break;

		case CHDESCR_PERCENT:
			pNumFormatter->GetOutputString(rDescr.fValue / 100.0, nPercentDescrFormat, aText, &pDummy);
			break;

		case CHDESCR_TEXT:
			aText = bRowDescr ? RowText(nRow) : ColText(nCol);
			break;

		case CHDESCR_TEXTANDPERCENT:
			pNumFormatter->GetOutputString(rDescr.fValue / 100.0, nPercentDescrFormat, aText, &pDummy);
			aText.Insert( (sal_Unicode)(' '), 0 );
			aText.Insert( bRowDescr ? RowText( nRow ) : ColText( nCol ), 0 );
			break;

		case CHDESCR_TEXTANDVALUE:
			pNumFormatter->GetOutputString(rDescr.fValue, nDescrFormat, aText, &pDummy);
			aText.Insert( sal_Unicode(' '), 0 );
			aText.Insert( bRowDescr ? RowText( nRow ) : ColText( nCol ), 0 );
			break;

		case CHDESCR_NUMFORMAT_PERCENT: //SP3: #49905#
			if(IsAxisChart())
				pNumFormatter->GetOutputString(rDescr.fValue / 100.0, nPercentDescrFormat, aText, &pDummy);
			else //PieChart, hier wird getrickst, um fileformatkompatible den Formatter der X-Achse zu
				// missbrauchen, der NICHT auf Percent gesetzt werden kann, da Pie kein IsPercent()
				// liefert, dieses wird jedoch im Basic bei ...AxisX.Text ausgewertet
				pNumFormatter->GetOutputString(rDescr.fValue / 100.0, nDescrFormat, aText, &pDummy);
			break;

		case CHDESCR_NUMFORMAT_VALUE: //SP3: #49905#
			pNumFormatter->GetOutputString(rDescr.fValue / 100.0, nDescrFormat, aText, &pDummy);
			break;
	}

	SfxItemSet aDataPointAttr(GetFullDataPointAttr(nCol, nRow ));
	SfxItemSet aTextAttr(*pItemPool, nTextWhichPairs);
	aTextAttr.Put(aDataPointAttr);

	SdrObject* pObj;

	// Objekte zuerst mit Position 0,0 anlegen, um dann die relative
	// Position zu setzen; rDescr.aTextPos2D wird dann als AnchorPos verwendet
	if( rDescr.bSymbol )
	{
		pObj = new SchObjGroup;
		pObj->InsertUserData(new SchObjectId( bRowDescr
											  ? CHOBJID_DIAGRAM_DESCR_ROW
											  : CHOBJID_DIAGRAM_DESCR_COL));
		SdrObjList* pObjList = pObj->GetSubList();
		SdrTextObj* pTextObj = CreateTextObj( CHOBJID_TEXT, Point(), aText,
											  aTextAttr, FALSE,
											  CHADJUST_TOP_LEFT,
											  -1);

		long nH = pTextObj->GetLogicRect().GetHeight();

		SfxItemSet aSymbolAttr(aDataPointAttr);
		GenerateSymbolAttr( aSymbolAttr, nRow, SYMBOLMODE_DESCRIPTION );

		SdrRectObj* pRect = new SdrRectObj( Rectangle(Point(), Size(nH, nH)) );
		pRect->SetModel( this );
		pObjList->NbcInsertObject( SetObjectAttr( pRect,
												  CHOBJID_DIAGRAM_DESCR_SYMBOL,
												  TRUE, TRUE, &aSymbolAttr));
		pTextObj->NbcMove(Size(nH + nH/2, 0));
		pObjList->NbcInsertObject(pTextObj);

		Rectangle aRect = pObj->GetLogicRect();
		AdjustRect(aRect, rDescr.eAdjust);
		pObj->NbcSetRelativePos(aRect.TopLeft());
		pObj->NbcSetAnchorPos(rDescr.aTextPos2D);
	}
	else
	{
		pObj = CreateTextObj( bRowDescr
							  ? CHOBJID_DIAGRAM_DESCR_ROW
							  : CHOBJID_DIAGRAM_DESCR_COL,
							  Point(), aText,
							  aTextAttr, FALSE, rDescr.eAdjust, -1);

		pObj->NbcSetRelativePos(pObj->GetLogicRect().TopLeft());
		pObj->NbcSetAnchorPos(rDescr.aTextPos2D);
	}

	if( bRowDescr )
		pObj->InsertUserData(new SchDataRow(nRow));
	else
		pObj->InsertUserData(new SchDataPoint(nCol, nRow));
	// #54870# nRow oben immer 0 (?)

	// return
	rDescr.pLabelObj = pObj;
}

USHORT ChartModel::GetRegressStrId( long nRow )
{

	const SfxItemSet& aDataRowAttr = GetDataRowAttr( nRow );
	USHORT nStringID = 0;

	switch (((const SfxInt32Item &) aDataRowAttr.Get (SCHATTR_STAT_REGRESSTYPE)).GetValue ())
	{
		case CHREGRESS_NONE :
			break;

		case CHREGRESS_LINEAR :
			nStringID = STR_REGRESSION_LINEAR;
			break;

		case CHREGRESS_LOG :
			nStringID = STR_REGRESSION_LOG;
			break;

		case CHREGRESS_EXP :
			nStringID = STR_REGRESSION_EXP;
			break;

		case CHREGRESS_POWER :
			nStringID = STR_REGRESSION_POWER;

	}
	return nStringID;
}
/*************************************************************************
|*
|* Diagrammlegende erzeugen
|*
\************************************************************************/

SdrObjGroup* ChartModel::CreateLegend(const Rectangle &aRect)
{
	// Default ist, dass die Legende nicht breiter als 20% der gesamten Seitenbreite
	// verwenden darf, unter der Bedingung, dass sie links oder rechts vom Chart steht.
	// wenn sie ueber oder unter dem Chart steht, dann ist die Seitenbreite das Maximum

	//TVM: obiges ist nicht richtig, CreateLegend wurde stets ohne 2.Argument
	//aufgerufen, daher galt immer fMax...=0.2, ausserdem bezieht sich die maximale
	//Breite auf den Text in der Legende, nicht auf die Legende selbst
	//(Test: 1-Zeiliges Chart mit langem Text!)
	//Obiges klngt aber durchaus plausibel, also sollte man es mal bei Gelegenheit
	//einbauen (ToDo:-Liste)
	const double  fMaximumWidth=0.2;

	SvxChartLegendPos eLegendPos = ((const SvxChartLegendPosItem&) pLegendAttr->Get(SCHATTR_LEGEND_POS)).
								GetValue();
	BOOL bWide = (eLegendPos == CHLEGEND_TOP || eLegendPos == CHLEGEND_BOTTOM);
	BOOL bRowLegend = !IsPieChart();
	BOOL bReverse = !bWide && IsStackedChart();
	BOOL bForceSolidLine = FALSE;

	SchObjGroup* pGroup = NULL;

	if (bLegendVisible)
	{

		List  aTextList;
		long i;
		long nRowCnt     = GetRowCount();
			// FG: nCnt ist die Anzahl Texte!
		long nCnt        = bRowLegend ? nRowCnt : GetColCount();
		long nMaxX        = 0;
		long nMaxY        = 0;

		long  nLineMaxY = 0; //#50082#

		long* pHeightOfEntry = new long[nCnt*2];    // FG: Wirkliche Hoehe der Zeilen
		long* pWidthOfEntry  = new long[nCnt*2];    // FG: Wirkliche Breite der Zeilen
		long nLines       = 0;                // Anzahl Zeilen
		long nActualColumn = 1; // FG: Zaehlt die Anzahl Spalten

		long* pRegressNr  = new long [nCnt];
		memset (pRegressNr, 0, sizeof (long) * nCnt);

		SfxItemSet aTextAttr(*pItemPool, nTextWhichPairs);

		aTextAttr.Put(*pLegendAttr);

		// FG: Hier wird einmal die Liste aller Texte durchgegangen um die maximale Hoehe und
		//     die maximale Breite zu bestimmen. Bei der Gelegenheit merkt man sich auch die
		//     Ausmasse der einzelnen Eintraege.
		for (i = 0; i < nCnt; i++)
		{
			// FG: Mehr als fMaximumWidth des Charts soll die Legende nie einnehmen
			SdrObject *pText = CreateTextObj(CHOBJID_TEXT, Point (),
									 bRowLegend ? RowText(i) : ColText(i),
									 aTextAttr,
									 FALSE,
									 CHADJUST_TOP_LEFT,  //FG: wie der Default
									 GetPage(0)->GetSize().Width() * fMaximumWidth);

			// FG: Das hier soll verhindern dass der Text in der Legende markiert werden kann
			//     dazu gibt es ja kein gueltiges Kontextmen
			pText->SetMarkProtect(TRUE);
			aTextList.Insert(pText, LIST_APPEND);

			pWidthOfEntry[i] = pText->GetLogicRect().GetWidth();
			pHeightOfEntry[i] = pText->GetLogicRect().GetHeight();
			nMaxX  = Max (nMaxX, pWidthOfEntry[i]);
			nMaxY  = Max (nMaxY, pHeightOfEntry[i]);
		}

		if (IsXYChart())
		{
			USHORT nStringID;
			for( i = 1; i < nCnt; i++ )
			{
				nStringID = GetRegressStrId( i );
				if( nStringID )
				{
					SchResId aRegId = SchResId( nStringID );
					String aRegressStr( aRegId );
					String aSeriesName( bRowLegend
										? RowText( i )
										: ColText( i ));
					String aLegendText( SchResId( STR_STATISTICS_IN_LEGEND ));

					aLegendText.SearchAndReplaceAscii( "$(STATTYP)", aRegressStr );
					aLegendText.SearchAndReplaceAscii( "$(ROWNAME)", aSeriesName );

					SdrObject *pText = CreateTextObj( CHOBJID_TEXT, Point(), aLegendText,
													  aTextAttr, FALSE,
													  CHADJUST_TOP_LEFT,
													  GetPage( 0 )->GetSize().Width() * fMaximumWidth );

					pText->SetMarkProtect( TRUE );
					aTextList.Insert(pText, LIST_APPEND);

					pWidthOfEntry[nLines+nCnt]  = pText->GetLogicRect().GetWidth();
					pHeightOfEntry[nLines+nCnt] = pText->GetLogicRect().GetHeight();
					nMaxX  = Max (nMaxX,  pWidthOfEntry[nLines+nCnt]);
					nMaxY  = Max (nMaxY, pHeightOfEntry[nLines+nCnt]);

				   // nMaxX  = Max (nMaxX, pText->GetLogicRect().GetWidth());
				   // nMaxY  = Max (nMaxY, pText->GetLogicRect().GetHeight());

					pRegressNr [nLines] = i;
					nLines ++;
				}
			}
		}

		if (IsXYChart ()) nCnt --;
		nLines += nCnt;

		long nTextRows    = 0;
		long nTextCols    = 0;
		long nShows       = 0;

		ULONG nLegendHeight = ((SvxFontHeightItem &) pLegendAttr->Get (EE_CHAR_FONTHEIGHT)).GetHeight();
		long nLittleSpace = nLegendHeight / 3;

		// FG: Hier wird berechnet wieviele Spalten und Zeilen die Legende haben soll
		if (!bWide)  // dann ist die Legende mit den Zeilen untereinander links oder rechts
		{
			// FG: Die Legende darf maximal 90% der Blatthoehe einnehmen und maximal 50% der Blattbreite
			if (nLines * (nMaxY + nLittleSpace) < (aRect.GetHeight() - 0.1 * aRect.GetHeight()))
			{
				nTextRows = nLines;
				nTextCols = 1;      // Also eine Spalte
			}
			else  // Es gibt also mehrere Spalten
			{
				nTextRows = (long) ((aRect.GetHeight() - 0.1 * aRect.GetHeight()) / (nMaxY + nLittleSpace));
				if(!nTextRows)
					nTextRows=1;
				nTextCols = (long) ((nLines % nTextRows) ? nLines / nTextRows + 1 : nLines / nTextRows);
				// FG: Falls die Legende zu breit (mehr als 50% der Chart-Breite) wird muss man nachregeln
				if (nTextCols * (nMaxX + nLittleSpace) > aRect.GetWidth())
				{
					nTextCols = (long) (aRect.GetWidth() * 0.5 / (nMaxX + nLittleSpace));
				}
			}
		}
		else  // die Legende befindet sich also unter oder ueber dem Chart (die wird noch beliebig gross)
		{
			nTextCols = (nLines * (nMaxX + 2*nLittleSpace + nLegendHeight) + nLittleSpace < aRect.GetWidth())
						 ? nLines : (aRect.GetWidth() - nLittleSpace) / (nMaxX + 2*nLittleSpace + nLegendHeight);
			nTextRows = nTextCols
						 ? ((nLines % nTextCols) ? nLines / nTextCols + 1 : nLines / nTextCols) : 0;
		}

		if (nTextRows > 0 && nTextCols > 0)
		{
			pGroup = new SchObjGroup;
			pGroup->InsertUserData(new SchObjectId(CHOBJID_LEGEND));
			// pGroup->SetResizeProtect(TRUE);
			SdrObject*  pObj;
			SdrObjList* pObjList = pGroup->GetSubList();

			Point aTextPos (nLittleSpace, nLegendHeight / 4);

			for (i = 0, nShows = 0;
				 i < nLines;
				 i++, nShows ++)
			{
				// FG: bReverse ist fuer gestapelte Diagramme gedacht, damit die Legendensymbole
				//     optisch der Reihenfolge des stapelns entsprechen.
			   long nIndex = (IsXYChart())
							   ?  i+1
							   : (bReverse)
								   ? nCnt - 1 - i
								   : i;

				if (i < nCnt)
				{
					BOOL bIsSymbol = FALSE;
					BOOL bIsLine   = FALSE;
					if(HasSymbols(nIndex))
					{
						bIsSymbol = TRUE;
						pObj = CreateSymbol (Point (aTextPos.X () + nLegendHeight / 2,
															aTextPos.Y () + nLegendHeight / 2 + nLittleSpace / 3),
											 nIndex, 0, (SfxItemSet &) GetDataRowAttr(nIndex), nLegendHeight, FALSE);
						if(pObj)
						{
							Rectangle aRect(pObj->GetSnapRect());
							if((aRect.GetHeight() > nLegendHeight) && nLegendHeight)
							{
								Fraction aFract(nLegendHeight,aRect.GetHeight());
								pObj->NbcResize(aRect.Center(),aFract,aFract);
							}
						}
						else //dann Linie als Legendensymbol, sonst geht evtl. garnix mehr
						{
							XPolygon aLine(2);
							aLine [0] =
							aLine [1] = aTextPos;
							aLine [1].X() += nLegendHeight;
							aLine [1].Y() += nLegendHeight;
							bIsLine = TRUE;
							pObj = new SdrPathObj(OBJ_PLIN, aLine);
						}
					}
					else if (IsLine(nIndex))
					{
						XPolygon aLine(2);

						aLine [0] =
						aLine [1] = aTextPos;
						aLine [1].X() += nLegendHeight;
						aLine [1].Y() += nLegendHeight;

						bIsLine = TRUE;
						pObj = new SdrPathObj(OBJ_PLIN, aLine);
					}
					else
					{
						// create rectangular shape as legend symbol
						pObj = new SdrRectObj(Rectangle(Point (aTextPos.X(),
															   aTextPos.Y() + nLittleSpace / 3),
														Size(nLegendHeight, nLegendHeight)));
						bForceSolidLine = TRUE;
					}
					// FG: setzen des Symbols neben dem Legendentext

					SfxItemSet *pSymbolAttr;

					if( bRowLegend )
					{
						pSymbolAttr = new SfxItemSet( GetDataRowAttr( nIndex ) );
						if( ! bIsLine && pSymbolAttr )
						  GenerateSymbolAttr( *pSymbolAttr, nIndex, SYMBOLMODE_LEGEND );
					}
					else
					{
						pSymbolAttr = new SfxItemSet( GetFullDataPointAttr( nIndex, 0 ) );
						if( ! bIsLine && pSymbolAttr )
						  GenerateSymbolAttr( *pSymbolAttr, 0, SYMBOLMODE_LEGEND );
					}

					if( bForceSolidLine )
					{
						XLineStyle eLineStyle =
							SAL_STATIC_CAST( const XLineStyleItem *, &(pSymbolAttr->Get( XATTR_LINESTYLE )) )->GetValue(); // bug in Win-C++ compiler: casting to pointer

						if( eLineStyle == XLINE_NONE )
						{
							pSymbolAttr->ClearItem( XATTR_LINESTYLE );
							pSymbolAttr->ClearItem( XATTR_LINEWIDTH );
							pSymbolAttr->ClearItem( XATTR_LINECOLOR );
						}
					}

//-/					pObj->NbcSetAttributes( *pSymbolAttr, FALSE );
					pObj->SetItemSet(*pSymbolAttr);


					if(bRowLegend)
					{
						pObj->InsertUserData(new SchObjectId(CHOBJID_LEGEND_SYMBOL_ROW));
						pObj->InsertUserData(new SchDataRow(nIndex));
					}
					else
					{
						pObj->InsertUserData(new SchObjectId(CHOBJID_LEGEND_SYMBOL_COL));
						pObj->InsertUserData(new SchDataPoint(nIndex, 0));
					}

					pObj->SetMoveProtect(TRUE);
					pObj->SetResizeProtect(TRUE);
					pObjList->NbcInsertObject(pObj);

					SdrObject *pText = (SdrObject*)aTextList.GetObject(nIndex);

					pText->NbcMove(Size(aTextPos.X() + nLittleSpace + nLegendHeight, aTextPos.Y()));
					pObjList->NbcInsertObject(pText);

					delete pSymbolAttr;
				}
				else //i >= nCnt
				{
					if (pRegressNr [i - nCnt])
					{
						XPolygon aLine(2);

						aLine [0] =
						aLine [1] = aTextPos;
						aLine [1].X () += nLegendHeight;
						aLine [1].Y () += nLegendHeight;

						pObj = new SdrPathObj(OBJ_PLIN, aLine);

						//	Set the object's user data so that the
						//	object can't be deleted via the GUI.
						pObj->InsertUserData(new SchObjectId (CHOBJID_LINE));

//-/						pObj->NbcSetAttributes(GetRegressAttr(pRegressNr[i-nCnt]), FALSE);
						pObj->SetItemSet(GetRegressAttr(pRegressNr[i-nCnt]));


						pObj->SetMoveProtect(TRUE);
						pObj->SetResizeProtect(TRUE);
						pObjList->NbcInsertObject(pObj);

						SdrObject* pText = (SdrObject*)aTextList.GetObject(nIndex);

						pText->Move(Size(aTextPos.X() + nLittleSpace + nLegendHeight, aTextPos.Y()));
						pObjList->NbcInsertObject(pText);
					}
				}

				// FG: Jetzt wird aTextPos fr den naechsten Legendeneintrag gesetzt
			   if (bWide)
				{
					if (nShows >= nTextCols - 1)
					{
						nLineMaxY = Max(nLineMaxY,pHeightOfEntry[i]);//#50082# #NACHTRAG#
						aTextPos.Y () += nLineMaxY  + nLittleSpace;//#50082#
						aTextPos.X ()  = nLittleSpace;//nLegendHeight / 6;//SP3: #49906#
						nLineMaxY = 0; //#50082# #NACHTRAG#
						nShows = -1;
					}
					else
					{
						nLineMaxY = Max(nLineMaxY,pHeightOfEntry[i]);//#50082#
						aTextPos.X () += nMaxX +  2 * nLittleSpace + nLegendHeight;
					}
				}
				else if (nShows >= nTextRows - 1) // FG: Die Legende wird in mehrere Spalten umgebrochen
				{                                 //     also den Spaltenabstand setzen
					aTextPos.X () += nMaxX + nLittleSpace + nLegendHeight + 2*nLittleSpace;
					aTextPos.Y ()  = nLegendHeight / 4;
					nShows = -1;
					if (nActualColumn >= nTextCols)  // FG: Dann wird die Legende zu breit!
					{
						break;                       // aus der for-Schleife raus,
													 // es muessen noch Felder deleted werden.
					}
					nActualColumn++;
				}
				else
				{

					aTextPos.Y() += pHeightOfEntry[nIndex] + nLittleSpace;
				}
			}

				//FG: Jetzt wird das umschliessende Rechteck berechnet. Man fraegt erst das
				//    BoundingRect des Legenden-Gruppenobjektes ab und addiert an den Raendern ein
				//    wenig Platz dazu.
			Rectangle aLogRect = pGroup->GetLogicRect();
			aLogRect.Left() -= nLittleSpace;
			aLogRect.Right() += nLittleSpace;
			aLogRect.Top() -= nLittleSpace;
			aLogRect.Bottom() += nLittleSpace;
			SdrRectObj* pRectObj = new SchRectObj(aLogRect);
			// FG: Das hier soll verhindern dass das Rechteck um die Legende markiert werden kann
			pRectObj->SetMarkProtect(TRUE);
			pRectObj->SetModel( this );
			pObjList->NbcInsertObject(SetObjectAttr(pRectObj, CHOBJID_LEGEND_BACK,
													TRUE, TRUE, pLegendAttr), 0);
		}

		delete[] pRegressNr;
		delete[] pHeightOfEntry;
		delete[] pWidthOfEntry;
	}

	return pGroup;
}

/*************************************************************************
|*
|* Diagramm erzeugen
|*
\************************************************************************/

SdrObjGroup* ChartModel::CreateChart(const Rectangle &rRect)
{
	if( pDocShell )
		pDocShell->SetWaitCursor( TRUE );

	Rectangle aRect( rRect );
	SdrObjGroup* pGroup;

	switch (eChartStyle)
	{
		case CHSTYLE_2D_AREA:
		case CHSTYLE_2D_STACKEDAREA:
		case CHSTYLE_2D_PERCENTAREA:
			pGroup = Create2DRowLineChart(aRect);//neu, test!
			break;

		case CHSTYLE_2D_LINE:
		case CHSTYLE_2D_STACKEDLINE:
		case CHSTYLE_2D_PERCENTLINE:
		case CHSTYLE_2D_LINESYMBOLS :
		case CHSTYLE_2D_STACKEDLINESYM :
		case CHSTYLE_2D_PERCENTLINESYM :
		case CHSTYLE_2D_CUBIC_SPLINE :
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL :
		case CHSTYLE_2D_B_SPLINE :
		case CHSTYLE_2D_B_SPLINE_SYMBOL :
		case CHSTYLE_2D_STOCK_1:
		case CHSTYLE_2D_STOCK_2:
		case CHSTYLE_2D_STOCK_3:
		case CHSTYLE_2D_STOCK_4:
			pGroup = Create2DRowLineChart(aRect);
			break;

		case CHSTYLE_2D_COLUMN:
		case CHSTYLE_2D_STACKEDCOLUMN:
		case CHSTYLE_2D_PERCENTCOLUMN:
		case CHSTYLE_2D_BAR:
		case CHSTYLE_2D_STACKEDBAR:
		case CHSTYLE_2D_PERCENTBAR:
		case CHSTYLE_2D_LINE_COLUMN:
		case CHSTYLE_2D_LINE_STACKEDCOLUMN:
			pGroup = Create2DColChart(aRect);
			break;

		case CHSTYLE_2D_PIE_SEGOF1:
		{
			for (short i = 1; i < nPieSegCount; i++)
				SetPieSegOfs(i, 0);
            SetPieSegOfs( 0, 10 );
			pGroup = Create2DPieChart(aRect);
			break;
		}

		case CHSTYLE_2D_PIE_SEGOFALL:
		{
			for (short i = 0; i < nPieSegCount; i++)
                SetPieSegOfs( i, 10 );
		}

		case CHSTYLE_2D_PIE:
			 pGroup = Create2DPieChart(aRect);
			break;

		case CHSTYLE_2D_DONUT1:  //DonutCharts haben jetzt eigenes Create
		case CHSTYLE_2D_DONUT2:
			pGroup = Create2DDonutChart(aRect);
			break;

		case CHSTYLE_2D_XYSYMBOLS :
		case CHSTYLE_2D_XY_LINE :
		case CHSTYLE_2D_XY :
		case CHSTYLE_2D_CUBIC_SPLINE_XY :
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY :
		case CHSTYLE_2D_B_SPLINE_XY :
		case CHSTYLE_2D_B_SPLINE_SYMBOL_XY :
			pGroup = Create2DXYChart(aRect);
			break;

		case CHSTYLE_2D_NET:
		case CHSTYLE_2D_NET_SYMBOLS:
		case CHSTYLE_2D_NET_STACK:
		case CHSTYLE_2D_NET_SYMBOLS_STACK:
		case CHSTYLE_2D_NET_PERCENT:
		case CHSTYLE_2D_NET_SYMBOLS_PERCENT:
			pGroup = Create2DNetChart(aRect);
			break;

		case CHSTYLE_3D_COLUMN:
		case CHSTYLE_3D_BAR:
		case CHSTYLE_3D_STRIPE:
		case CHSTYLE_3D_AREA:
		case CHSTYLE_3D_SURFACE:
			pGroup = Create3DDeepChart(aRect);
			break;

		case CHSTYLE_3D_FLATCOLUMN:
		case CHSTYLE_3D_STACKEDFLATCOLUMN:
		case CHSTYLE_3D_PERCENTFLATCOLUMN:
		case CHSTYLE_3D_STACKEDAREA:
		case CHSTYLE_3D_PERCENTAREA:
		case CHSTYLE_3D_FLATBAR:
		case CHSTYLE_3D_STACKEDFLATBAR:
		case CHSTYLE_3D_PERCENTFLATBAR:
			pGroup = Create3DFlatChart(aRect);
			break;

		case CHSTYLE_3D_PIE:
			pGroup = Create3DNewPieChart(aRect);
			break;

		default:
			eChartStyle = CHSTYLE_2D_COLUMN;
			pGroup = Create2DColChart(aRect);
			break;
	}

	if( pDocShell )
		pDocShell->SetWaitCursor( FALSE );

	SdrPage* pPage=GetPage( 0 );
	SdrObject* pObj = GetObjWithId( CHOBJID_DIAGRAM_AREA, *pPage );
	if( pObj )
		pObj->SetMoveProtect( TRUE );

	return pGroup;
}

void ChartModel::PrepareOld3DStorage()
{
	SfxItemSet aTmpSet(*pItemPool,nRowWhichPairs);
	aTmpSet.Put(XLineStyleItem(XLINE_SOLID));
	aTmpSet.Put(XLineWidthItem(0));
	aTmpSet.Put(XLineColorItem(String(), RGBColor(COL_BLACK)));


	long i,nCount=aDataRowAttrList.Count();
	for (i=0;i<nCount;i++)
	{
		SfxItemSet *pDataRowAttr = new SfxItemSet (*pItemPool, nRowWhichPairs);
		pDataRowAttr->Put(*(aDataRowAttrList.GetObject(i)));
		pDataRowAttr->Put(aTmpSet);
		aTmpDataRowAttrList.Insert (pDataRowAttr, LIST_APPEND);
	}

	SfxItemSet	*	pItemSet;
	nCount=aDataPointAttrList.Count();
	for (i=0;i<nCount;i++)
	 {
		SfxItemSet* pSet=new SfxItemSet(*pItemPool, nRowWhichPairs);
		pItemSet = aDataPointAttrList.GetObject(i);
		if (pItemSet != NULL)
			pSet->Put(*pItemSet);
		pSet->Put(aTmpSet);
		aTmpDataPointAttrList.Insert (pSet, LIST_APPEND);
	 }

	nCount=aSwitchDataPointAttrList.Count();
	for (i=0;i<nCount;i++)
	 {
		SfxItemSet* pSet=new SfxItemSet(*pItemPool, nRowWhichPairs);
		pItemSet = aSwitchDataPointAttrList.GetObject(i);
		if (pItemSet != NULL)
			pSet->Put(*pItemSet);
		pSet->Put(aTmpSet);
		aTmpSwitchDataPointAttrList.Insert (pSet, LIST_APPEND);
	 }
}
void ChartModel::CleanupOld3DStorage()
{
	long i,nCount = aTmpDataRowAttrList.Count();
	for (i = 0 ; i < nCount; i++)
		delete aTmpDataRowAttrList.GetObject(i);
	aTmpDataRowAttrList.Clear();

	nCount = aTmpDataPointAttrList.Count();
	for (i = 0 ; i < nCount; i++)
		delete aTmpDataPointAttrList.GetObject(i);
	aTmpDataPointAttrList.Clear();

	nCount = aTmpSwitchDataPointAttrList.Count();
	for (i = 0 ; i < nCount; i++)
		delete aTmpSwitchDataPointAttrList.GetObject(i);
	aTmpSwitchDataPointAttrList.Clear();
}
/*************************************************************************
|*
|* Chart-Attribute speichern

\************************************************************************/
void ChartModel::PrepareAxisStorage()
{
	if(pTmpXItems)
		delete pTmpXItems;
	if(pTmpYItems)
		delete pTmpYItems;
	if(pTmpZItems)
		delete pTmpZItems;
	//Leider muss das ummappen vorm speichern des pools stattfinden
	pTmpXItems = new SfxItemSet(*pItemPool,nCompatAxisWhichPairs);
	pTmpYItems = new SfxItemSet(*pItemPool,nCompatAxisWhichPairs);
	pTmpZItems = new SfxItemSet(*pItemPool,nCompatAxisWhichPairs);

	pTmpXItems->Put(GetAttr(CHOBJID_DIAGRAM_X_AXIS));
	AxisAttrNew2Old(*pTmpXItems,CHOBJID_DIAGRAM_X_AXIS,TRUE);

	pTmpYItems->Put(GetAttr(CHOBJID_DIAGRAM_Y_AXIS));
	AxisAttrNew2Old(*pTmpYItems,CHOBJID_DIAGRAM_Y_AXIS,TRUE);

	pTmpZItems->Put(GetAttr(CHOBJID_DIAGRAM_Z_AXIS));
	AxisAttrNew2Old(*pTmpZItems,CHOBJID_DIAGRAM_Z_AXIS,TRUE);


	//Achse wird auf Attr-Basis gestreamt!
	pChartXAxis->FillItemSet();
	pChartYAxis->FillItemSet();
	pChartZAxis->FillItemSet();
	pChartBAxis->FillItemSet();
	pChartAAxis->FillItemSet();
}

void ChartModel::StoreAttributes(SvStream& rOut) const
{
#ifdef DBG_UTIL
	ByteString aBStr( aMainTitle, RTL_TEXTENCODING_ASCII_US );
	CHART_TRACE1( "ChartModel::StoreAttributes (%s)", aBStr.GetBuffer() );
#endif

	rtl_TextEncoding eSysSet = ::GetSOStoreTextEncoding( gsl_getSystemTextEncoding());
	rOut.SetStreamCharSet( eSysSet );

	SchIOCompat aIO(rOut, STREAM_WRITE, 17);
	long nFileFormat = rOut.GetVersion ();

	//#50116# 8->9
	//#54870# ->10
	//12: ChartAchsen
	//13 Nachtrag: X-AchsenAttr-default bei XY-Charts (store unverndert)
	//14 Overlap , Gapwith der 2 Y-Achsen
	//15 Neues 3D-Pie
	//16 Items fr Achse SCHATTR_AXIS_SHOWDESCR,SCHATTR_AXIS_SHOWAXIS aktiviert,
	//    bisher nur von pChartBAxis genutzt!

	//FG: 12 - seit 20.02.1997 - Umbruch ja/ein pro Achse hinzu
	//FG: 13 - seit 09.03.1997 Alle Variablen mit Tag 13:
	//DL: 14 - seit 11.03.1997 aSpotColor & aAmbientColor
	//                         FG  + TextausPositionen
	//FG: 15 - set  14.03.1997 Textausrichtung
	//SOH:16 - seit 04.05.1997 NumberFormatter

	//TODO: konvertieren der Attribute pChartAttr in eChartStyle (Fileversion >=10)

	UINT32 nMoreData = 16;

	short i, nCount;

	rOut << aLightVec->X ();
	rOut << aLightVec->Y ();
	rOut << aLightVec->Z ();

	if (pChartData)
	{
		INT16 ID = CHDATAID_MEMCHART;    // damit aeltere versionen damit fertig werden
		rOut << (INT16) ID;
		rOut << *(SchMemChart*)pChartData;
	}
	else
	{
		INT16 nInt16 = (INT16)CHDATAID_NONE; rOut << nInt16;
	}

	BOOL bDummy = TRUE;            // war frueher bOwnChart
	rOut << bIsCopied;
	rOut << fMinData;
	rOut << (INT16)eChartStyle;

	for (i = 0; i < LINE_POINT_COUNT; i++)
		rOut << (INT16)eChartLinePoints[i];


	// Das ehemalige Member aRowColors[]. Es wird hier simuliert, damit
	// alte Codeversionen mit der hier geschriebenen Datei arbeiten koennen.
	Color aRowColors[ROW_COLOR_COUNT];

	aRowColors[0]   = Color(  0, 153, 255);
	aRowColors[1]   = Color(255,  51, 102);
	aRowColors[2]   = Color(102, 102, 102);
	aRowColors[3]   = Color( 51, 204, 102);
	aRowColors[4]   = Color(153, 102, 204);
	aRowColors[5]   = Color(255, 153, 102);
	aRowColors[6]   = Color(255, 204, 153);
	aRowColors[7]   = Color(153, 204, 255);
	aRowColors[8]   = Color(  0, 204, 204);
	aRowColors[9]   = Color(153,   0, 153);
	aRowColors[10]  = Color(255,  51,  51);

	aRowColors[11]  = RGBColor(COL_WHITE);
	for (i = 0; i < ROW_COLOR_COUNT; i++)
		rOut << aRowColors[i];

	const long nGapWidth  = 10;
	const long nOverlap = 0;
	rOut << (INT32)nGapWidth;
	rOut << (INT32)nOverlap;
	rOut << (INT32)nMarkLen; //entfllt demnchst! -> ChartAxis
	rOut << aChartRect;
	rOut << (INT32)nPieHeight;

	rOut << (INT16)nPieSegCount;
	for (i = 0; i < nPieSegCount; i++)
		rOut << (INT32)pPieSegOfs[i];

	INT16 nXA=nXAngle;
	INT16 nYA=nYAngle;
	INT16 nZA=nZAngle;
	if(IsReal3D() && IsPieChart())
	{
		Vector3D aVRot,aVTrans,aVShear,aVScale;
		aSceneMatrix.Decompose(aVScale,aVTrans,aVRot,aVShear);
		long nAngle= (long)(aVRot.Z() * 1800.0 / F_PI);
		nAngle -= 900;
		nAngle += 3600;
		nAngle %= 3600;
		nYA = (INT16)nAngle;
	}

	rOut << (INT16)nXA;//anle;
	rOut << (INT16)nYA;//ngle;
	rOut << (INT16)nZA;//ngle;


	//neu wegen Achsenrestrukturierung
	BOOL bShowXAxis =pChartXAxis->IsVisible();
	BOOL bShowXDescr=pChartXAxis->HasDescription();
	BOOL bShowYAxis =pChartYAxis->IsVisible();
	BOOL bShowYDescr=pChartYAxis->HasDescription();
	BOOL bShowZAxis =pChartZAxis->IsVisible();
	BOOL bShowZDescr=pChartZAxis->HasDescription();


	// save unicode strings as ascii-strings for old binary format
	rOut << (INT16)eSysSet;

	rOut << bShowMainTitle;
	rOut << aMainTitle;
	rOut << bShowSubTitle;
	rOut << aSubTitle;
	rOut << bShowXAxisTitle;
	rOut << aXAxisTitle;
	rOut << bShowYAxisTitle;
	rOut << aYAxisTitle;
	rOut << bShowZAxisTitle;
	rOut << aZAxisTitle;
	rOut << bShowXAxis;
	rOut << bShowXGridMain;
	rOut << bShowXGridHelp;
	rOut << bShowXDescr;
	rOut << bShowYAxis;
	rOut << bShowYGridMain;
	rOut << bShowYGridHelp;
	rOut << bShowYDescr;
	rOut << bShowZAxis;
	rOut << bShowZGridMain;
	rOut << bShowZGridHelp;
	rOut << bShowZDescr;

	// In diesem Set koennten ungueltige Items vorhanden sein, da es
	// das Set der allgemeinen TitleAttribute (aller Titel) ist
	pTitleAttr->ClearInvalidItems();
	pTitleAttr->Store(rOut);

	pMainTitleAttr->Store(rOut);
	pSubTitleAttr->Store(rOut);
	pXAxisTitleAttr->Store(rOut);
	pYAxisTitleAttr->Store(rOut);
	pZAxisTitleAttr->Store(rOut);

	pAxisAttr->ClearInvalidItems();

	pAxisAttr->Store(rOut);





	//Abwrtskompatibel speichern (this->PrepareAxisStorage())
	pTmpXItems->Store(rOut);
	pTmpYItems->Store(rOut);
	pTmpZItems->Store(rOut);

	pGridAttr->ClearInvalidItems();
	pGridAttr->Store(rOut);
	pXGridMainAttr->Store(rOut);
	pYGridMainAttr->Store(rOut);
	pZGridMainAttr->Store(rOut);
	pXGridHelpAttr->Store(rOut);
	pYGridHelpAttr->Store(rOut);
	pZGridHelpAttr->Store(rOut);
	pDiagramAreaAttr->Store(rOut);
	pDiagramWallAttr->Store(rOut);
	pDiagramFloorAttr->Store(rOut);
	pLegendAttr->Store(rOut);



	if (nFileFormat == SOFFICE_FILEFORMAT_31)
	{

		SfxItemSet aStoreAttr (*pItemPool, XATTR_LINE_FIRST, XATTR_LINE_LAST,
										   XATTR_FILL_FIRST, XATTR_FILL_LAST,
										   //EE_ITEMS_START, EE_ITEMS_END,
										   SCHATTR_DATADESCR_START, SCHATTR_DATADESCR_END, 0),
					aPoolItemSet (*pItemPool, nRowWhichPairs),
					*pItemSet;

		// FG: 25.2.97 Das Schreiben im 3.1 Format  geht schief wenn man
		//     in globfunc.cxx die Routine CopyAttributesFrom40to31 verwendet.
		//     Dort wurden die items per Invalidate und Set einzeln kopiert. (falsch)
		nCount = (short)aDataRowAttrList.Count();
		rOut << (INT16)nCount;
		for (i = 0; i < nCount; i++)
		{
			SfxItemSet* pSet = aStoreAttr.Clone();
			pSet->Put( *aDataRowAttrList.GetObject(i), TRUE );
			pSet->Store( rOut );
			delete pSet;
		}

		nCount = (short)aDataPointAttrList.Count();
		rOut << (INT16)nCount;
		for (i = 0; i < nCount; i++)
		{
			SfxItemSet* pSet = aStoreAttr.Clone();
			pItemSet = aDataPointAttrList.GetObject(i);
			if (pItemSet != NULL)
				pSet->Put (*pItemSet, TRUE );
			else
				pSet->Put (aPoolItemSet, TRUE);
			pSet->Store(rOut);
			delete pSet;
		}

		nCount = (short)aSwitchDataPointAttrList.Count();
		rOut << (INT16)nCount;
		for (i = 0; i < nCount; i++)
		{
			SfxItemSet* pSet = aStoreAttr.Clone();
			pItemSet = aSwitchDataPointAttrList.GetObject(i);
			if (pItemSet != NULL)
				pSet->Put (*pItemSet, TRUE );
			else
				pSet->Put (aPoolItemSet, TRUE);
			pSet->Store(rOut);
			delete pSet;
		}
	}
	else if(nFileFormat <= SOFFICE_FILEFORMAT_40 && IsReal3D()) //siehe auch DocShell, Save,SaveAs!!!!!
	{

		nCount = (short)aTmpDataRowAttrList.Count();
		rOut << (INT16)nCount;
		for (i = 0; i < nCount; i++)
			aTmpDataRowAttrList.GetObject(i)->Store(rOut);

		nCount = (short)aTmpDataPointAttrList.Count();
		rOut << (INT16)nCount;
		for (i = 0; i < nCount; i++)
			aTmpDataPointAttrList.GetObject(i)->Store(rOut);

		nCount = (short)aTmpSwitchDataPointAttrList.Count();
		rOut << (INT16)nCount;
		for (i = 0; i < nCount; i++)
			aTmpSwitchDataPointAttrList.GetObject(i)->Store(rOut);

	}
	else
	{
		SfxItemSet	aPoolItemSet (*pItemPool, nRowWhichPairs),
				*	pItemSet;
					
		nCount = (short)aDataRowAttrList.Count();
		rOut << (INT16)nCount;
		for (i = 0; i < nCount; i++)
			aDataRowAttrList.GetObject(i)->Store(rOut);

		nCount = (short)aDataPointAttrList.Count();
		rOut << (INT16)nCount;
		for (i = 0; i < nCount; i++)
		{
			pItemSet = aDataPointAttrList.GetObject(i);
			if (pItemSet != NULL)
				pItemSet->Store(rOut);
			else
				aPoolItemSet.Store(rOut);
		}
		
		nCount = (short)aSwitchDataPointAttrList.Count();
		rOut << (INT16)nCount;
		for (i = 0; i < nCount; i++)
		{
			pItemSet = aSwitchDataPointAttrList.GetObject(i);
			if (pItemSet != NULL)
				pItemSet->Store(rOut);
			else
				aPoolItemSet.Store(rOut);
		}
	}

	rOut << (INT16)eDataDescr;
	rOut << bShowSym;
	rOut << bSwitchData;

	UINT32 nTmp;

	nTmp=((ChartModel*)this)->GetNumFmt(CHOBJID_DIAGRAM_Y_AXIS,FALSE);
	rOut << nTmp;//nValFormat;
	nTmp=((ChartModel*)this)->GetNumFmt(CHOBJID_DIAGRAM_Y_AXIS,TRUE);
	rOut << nTmp;//nPercentValFormat;
	nTmp=((ChartModel*)this)->GetNumFmt(CHOBJID_DIAGRAM_X_AXIS,FALSE);
	rOut << nTmp;//nDescrFormat;
	nTmp=((ChartModel*)this)->GetNumFmt(CHOBJID_DIAGRAM_X_AXIS,TRUE);
	rOut << nTmp;//nPercentDescrFormat;

	// Achtung : Gravierende Aenderungen an der Datei gegenueber der Auslieferungsversion
	// es werden mehr Daten geschrieben : Die alte Version muss (!) das aber auch verkraften
	// Die Reihenfolge mu (!!!!) eingehalten werden
	pChartYAxis->StoreMemberCompat(rOut);
	pChartXAxis->StoreMemberCompat(rOut);
	pChartZAxis->StoreMemberCompat(rOut);

	rOut << fMaxData;

	rOut << nMoreData;

	if (nMoreData >= 2)
		if (pChartData)
		{
			rOut << pChartData->SomeData1();
			rOut << pChartData->SomeData2();
			rOut << pChartData->SomeData3();
			rOut << pChartData->SomeData4();
		}
		else
		{
			String aEmpty;

			rOut << aEmpty;
			rOut << aEmpty;
			rOut << aEmpty;
			rOut << aEmpty;
		}

	if (nMoreData >= 3) rOut << fSpotIntensity;

	if (nMoreData >= 4)
	{
		BOOL bDummy = TRUE;   // war frueher bIsRegression

		rOut << bShowAverage;
		rOut << (INT16)eErrorKind;
		rOut << bDummy;
		rOut << (INT16)eIndicate;
		rOut << fIndicatePercent;
		rOut << fIndicateBigError;
		rOut << fIndicatePlus;
		rOut << fIndicateMinus;
	}

	if (nMoreData >= 5) rOut << (INT16) eRegression;

	if (nMoreData >= 6)
	{
		rOut << (INT32) nSplineDepth;
		rOut << (INT32) nGranularity;
	}

	if (nMoreData >= 7)
	{
		rOut << bLegendVisible;
	}

	if (nMoreData >= 8)
	{
		nCount = (short)aRegressAttrList.Count();
		rOut << (INT16)nCount;
		for (i = 0; i < nCount; i++)
			aRegressAttrList.GetObject(i)->Store(rOut);

		nCount = (short)aAverageAttrList.Count();
		rOut << (INT16)nCount;
		for (i = 0; i < nCount; i++)
			aAverageAttrList.GetObject(i)->Store(rOut);

		nCount = (short)aErrorAttrList.Count();
		rOut << (INT16)nCount;
		for (i = 0; i < nCount; i++)
			aErrorAttrList.GetObject(i)->Store(rOut);

	}

	if (nMoreData >= 9) rOut << fAmbientIntensity;
	if (nMoreData >= 10) rOut << bTextScalable;
	if (nMoreData >= 11) rOut << aInitialSize;
	if (nMoreData >= 12) // FG: Zusaetze wegen des Umruchs von Achsentext und Legendentext 20.02.97
	{
		// FG: Vielleicht etwas viel Speicher fuer BOOL, aber es macht nur 8 Byte pro Chart
		rOut << (INT16) bFormatXAxisTextInMultipleLinesIfNecessary;
		rOut << (INT16) bFormatYAxisTextInMultipleLinesIfNecessary;
		rOut << (INT16) bFormatZAxisTextInMultipleLinesIfNecessary;
		rOut << (INT16) bFormatLegendTextInMultipleLinesIfNecessary;
	}
	if (nMoreData >= 13) // FG: 9.3.1997 Zusaetze wegen einer freien Positionierung und einem freien
	{                    //     Resize von Gruppenobjekten im Chart.
		rOut << (INT16) nXAxisTextMaximumNumberOfLines;
		rOut << (INT16) nYAxisTextMaximumNumberOfLines;
		rOut << (INT16) nZAxisTextMaximumNumberOfLines;
		rOut << (INT32) nWidthOfFirstXAxisText;
		rOut << (INT32) nWidthOfLastXAxisText;
		rOut << aTitleTopCenter;
		rOut << aSubTitleTopCenter;
		rOut << aDiagramRectangle;
		rOut << aLegendTopLeft;
		rOut << aTitleXAxisPosition;
		rOut << aTitleYAxisPosition;
		rOut << aTitleZAxisPosition;
		rOut << (INT16) bUseRelativePositionsForChartGroups;
		rOut << (INT16) bAdjustMarginsForLegend;
		rOut << (INT16) bAdjustMarginsForMainTitle;
		rOut << (INT16) bAdjustMarginsForSubTitle;
		rOut << (INT16) bAdjustMarginsForXAxisTitle;
		rOut << (INT16) bAdjustMarginsForYAxisTitle;
		rOut << (INT16) bAdjustMarginsForZAxisTitle;
	}
	if (nMoreData >= 14)
	{
		rOut << aSpotColor;     // FG: Von DL, um sich die Farbeinstellungen der 3d-Lichter
		rOut << aAmbientColor;  //     bei 3d-Charts merken zu koennen.

		BOOL bTmp=bDiagramHasBeenMovedOrResized; //neu -> alt: dann immer rearrange
		if(IsReal3D() && IsPieChart())
			bTmp=FALSE;

		rOut << bTmp; // FG: 12.3.97, Falls das Chart gespeichert wird
		rOut << bMainTitleHasBeenMoved;        //     soll es immer noch die relativen Positionen
		rOut << bSubTitleHasBeenMoved;         //     der Objektgruppen beachten, falls eine
		rOut << bLegendHasBeenMoved;           //     dieser Gruppen bewegt worden ist.
		rOut << bXAxisTitleHasBeenMoved;
		rOut << bYAxisTitleHasBeenMoved;
		rOut << bZAxisTitleHasBeenMoved;
	}
	if (nMoreData >= 15)  // FG: 14.3.97 Damit bei einem angefassten Text die Position sinnvoll gesetzt werden
	{                     //     auch nach einer Schriftgroessenaenderung muss man sich merken wie die Ausrichtung war
		rOut << (INT16) eAdjustXAxesTitle;
		rOut << (INT16) eAdjustYAxesTitle;
		rOut << (INT16) eAdjustZAxesTitle;
	}
	if (nMoreData >= 16) // NumberFormater waren bisher nicht persistent
	{
		pNumFormatter->Save( rOut );
		pNumFormatter->Save( rOut );
		pNumFormatter->Save( rOut );
	}

	rOut << (INT16) nBarPercentWidth; //#50116# ist ein long, aber Range von 0..100
	rOut << (INT32) m_nDefaultColorSet;//#50149#

	rOut << (INT32) nNumLinesInColChart;//#50212#

 	// #74536# BM use these three former -1 dummies for
 	// numberformat last set by CALC
 	rOut << (INT32) nXLastNumFmt;
 	rOut << (INT32) nYLastNumFmt;
 	rOut << (INT32) nBLastNumFmt;

	rOut << (INT32)(-1);		// dummy

	//IOVer 11
	pStockLineAttr->Store(rOut);
	pStockLossAttr->Store(rOut);
	pStockPlusAttr->Store(rOut);


	//IOVer12:
	//nAxisId ist die zu ladene/speichernde Achse,
	//festgelegt sind in V12 nur 1=X, 2=Y,3=Z und 4=2.Y-Achse (B)
	//neu: 5 = 2. X-Achse
	//-1 bedeutet KEINE WEITEREN ACHSEN!
	//Es MUSS keine Achse gestreamt werden (siehe Lade-Routine)
	//Die Reihenfolge ist eigentlich auch egal, jedoch gilt beim Laden:
	//erst die primre und dann die sekundre (X, bzw. evtl auch Y) Achse
	//(um defaults aus der primren Achse heraus zu erzeugen)

	INT32 nAxisId=CHART_AXIS_PRIMARY_X;
	rOut << nAxisId;
	GetAttr(CHOBJID_DIAGRAM_X_AXIS).Store(rOut);

	nAxisId=CHART_AXIS_PRIMARY_Y;
	rOut << nAxisId;
	GetAttr(CHOBJID_DIAGRAM_Y_AXIS).Store(rOut);

	nAxisId=CHART_AXIS_PRIMARY_Z;
	rOut << nAxisId;
	GetAttr(CHOBJID_DIAGRAM_Z_AXIS).Store(rOut);

	nAxisId=CHART_AXIS_SECONDARY_Y;
	rOut << nAxisId;
	GetAttr(CHOBJID_DIAGRAM_B_AXIS).Store(rOut);

	nAxisId=CHART_AXIS_SECONDARY_X;
	rOut << nAxisId;
	GetAttr(CHOBJID_DIAGRAM_A_AXIS).Store(rOut);

	//Elementar wichtig! Diesen Wert zu streamen ist absolutes Minimum
	//die obigen derzeit 4 Achsen kann man dagegen getrost reduzieren oder aufstocken
	//ohne da die abwrtskompatiblitt leidet! Genauso lassen sich beliebige
	//Achsen mit einer Id>4 dazwischen hngen. In alten Versionen wird bei
	//unbekannter id einfach ein Dummy geladen (und weggeschmissen)
	nAxisId=-1;
	rOut << nAxisId;
	//Ende IOVersion 12

	nTmp = aBarY1.GetGap();
	rOut << nTmp;
	nTmp = aBarY1.GetOverlap();
	rOut << nTmp;
	nTmp = aBarY2.GetGap();
	rOut << nTmp;
	nTmp = aBarY2.GetOverlap();
	rOut << nTmp;


 	// IOVersion 15
	rOut << bDiagramHasBeenMovedOrResized; // FG: 12.3.97, Falls das Chart gespeichert wird
}

/*************************************************************************
|*
|* Chart-Attribute laden
|*
\************************************************************************/

void ChartModel::LoadAttributes(SvStream& rIn)
{
#ifdef DBG_UTIL
	ByteString aBStr( aMainTitle, RTL_TEXTENCODING_ASCII_US );
	CHART_TRACE1( "ChartModel::LoadAttributes (%s)", aBStr.GetBuffer() );
#endif

    // aInfo is a member of SdrModel
    // the SdrModel was read before this, so the value is set
    rtl_TextEncoding eSysSet = ::GetSOLoadTextEncoding( aInfo.eLastReadCharSet, rIn.GetVersion());
	rIn.SetStreamCharSet( eSysSet );
    // Note: The CharSet is stored in the MemChart and later set again at the stream !

	SchIOCompat aIO(rIn, STREAM_READ);

	short       i, nCount;
	INT16       nInt16, nCharSet;
	INT32       nInt32;
	SfxItemSet* pAttr;
	BOOL        bNoMore = FALSE;
	int			nVersion = aIO.GetVersion();

	rIn >> aLightVec->X ();
	rIn >> aLightVec->Y ();
	rIn >> aLightVec->Z ();

	if (nVersion >= 3)
	{
		rIn >> nInt16;

		// fuer den fall, dass initial das diagrammfenster generiert wurde
		delete pChartData;

        // Note: The CharSet is stored in the MemChart and set there at the stream !
		switch ((ChartDataId)nInt16)
		{
			case CHDATAID_MEMCHART_PLUS :
				pChartData = new SchMemChart (CHDATAID_MEMCHART_PLUS);
				rIn >> *(SchMemChart*)pChartData;
				pChartData->IncreaseRefCount();
				break;

			case CHDATAID_DYNCHART:
			case CHDATAID_MEMCHART:
				pChartData = new SchMemChart (CHDATAID_MEMCHART);
				rIn >> *(SchMemChart*)pChartData;
				pChartData->IncreaseRefCount();
				break;

			default :
				bNoMore = TRUE;
		}

		if (nVersion >= 5) rIn >> bIsCopied;

		if (nVersion >= 8) rIn >> fMinData;
		else if (pChartData)
		{
			long nColCnt = GetColCount();
			long nRowCnt = GetRowCount();

			for (short nCol = 0; nCol < nColCnt; nCol++)
				for (short nRow = 0; nRow < nRowCnt; nRow++)
				{
					double fData = GetData(nCol, nRow);

					if ((nCol == 0) && (nRow == 0))
					{
						pChartYAxis->SetMin(fData);
						pChartYAxis->SetMax(fData);
					}
					if (fData < pChartYAxis->GetMin())
						pChartYAxis->SetMin(fData);
					if (fData > pChartYAxis->GetMax())
						pChartYAxis->SetMax(fData);
				}

			bNoMore = TRUE;
		}
	}

	rIn >> nInt16;
	if (nVersion < 1)
	{
		switch ((ChartStyleV0)nInt16)
		{
			case CHART2D_LINE:
				eChartStyle = CHSTYLE_2D_LINE;
				break;

			case CHART2D_STACKEDLINE:
				eChartStyle = CHSTYLE_2D_STACKEDLINE;
				break;

			case CHART2D_BAR:
				eChartStyle = CHSTYLE_2D_COLUMN;
				break;

			case CHART2D_STACKEDBAR:
				eChartStyle = CHSTYLE_2D_STACKEDCOLUMN;
				break;

			case CHART2D_COLUMN:
				eChartStyle = CHSTYLE_2D_BAR;
				break;

			case CHART2D_STACKEDCOLUMN:
				eChartStyle = CHSTYLE_2D_STACKEDBAR;
				break;

			case CHART2D_AREA:
				eChartStyle = CHSTYLE_2D_AREA;
				break;

			case CHART2D_STACKEDAREA:
				eChartStyle = CHSTYLE_2D_STACKEDAREA;
				break;

			case CHART2D_PIE:
				eChartStyle = CHSTYLE_2D_PIE;
				break;

			case CHART3D_STRIPE:
				eChartStyle = CHSTYLE_3D_STRIPE;
				break;

			case CHART3D_BAR:
				eChartStyle = CHSTYLE_3D_COLUMN;
				break;

			case CHART3D_FLATBAR:
				eChartStyle = CHSTYLE_3D_FLATCOLUMN;
				break;

			case CHART3D_STACKEDFLATBAR:
				eChartStyle = CHSTYLE_3D_STACKEDFLATCOLUMN;
				break;

			case CHART3D_AREA:
				eChartStyle = CHSTYLE_3D_AREA;
				break;

			case CHART3D_STACKEDAREA:
				eChartStyle = CHSTYLE_3D_STACKEDAREA;
				break;

			case CHART3D_SURFACE:
				eChartStyle = CHSTYLE_3D_SURFACE;
				break;

			case CHART3D_PIE:
				eChartStyle = CHSTYLE_3D_PIE;
				break;

			default :
				eChartStyle = CHSTYLE_2D_COLUMN;
				break;
		}

		bNoMore = TRUE;
	}
	else
		eChartStyle = (SvxChartStyle)nInt16;

	for (i = 0; i < LINE_POINT_COUNT; i++)
	{
		rIn >> nInt16; eChartLinePoints[i] = nInt16;
	}

	// Das ehemalige Member aRowColors[] wird eingelesen.
	Color aDummyColor;
	for (i = 0; i < ROW_COLOR_COUNT; i++)
		rIn >> aDummyColor;

	long nOverlap;
	rIn >> nInt32; //nGapWidth = (long)nInt32;
	rIn >> nInt32; nOverlap = (long)nInt32;
	rIn >> nInt32;
	DBG_ASSERT( nInt32 == 100, "LoadAttributes: nMarkLen's value differs from 100 in this stream" );

	rIn >> aChartRect;
	rIn >> nInt32; nPieHeight = (long)nInt32;

	if (nVersion >= 6)
	{
		rIn >> nInt16; nPieSegCount = (short)nInt16;
		pPieSegOfs = new long[nPieSegCount];

		BOOL bNullify = (nVersion < 17) && eChartStyle == CHSTYLE_2D_PIE;

		for( i = 0; i < nPieSegCount; i++ )
		{
			rIn >> nInt32;
			pPieSegOfs[ i ] = bNullify? 0: (long)nInt32;
		}
	}

	rIn >> nInt16; nXAngle = (short)nInt16;
	rIn >> nInt16; nYAngle = (short)nInt16;
	rIn >> nInt16; nZAngle = (short)nInt16;

	rIn >> nCharSet;

	/**************************************************************************
	* So machts der Writer, und so muessen es alle machen:
	* Bug 9714: Der CharSet an den Fonts muss geaendert werden, wenn
	* es der globale CharSet ist (MT)
	**************************************************************************/
	SfxItemPool& rPool = GetItemPool();
	USHORT nMaxItems = rPool.GetItemCount(EE_CHAR_FONTINFO);
	SvxFontItem* pItem;

	for (USHORT n = 0; n < nMaxItems; ++n)
	{
		pItem = (SvxFontItem*) rPool.GetItem(EE_CHAR_FONTINFO, n);
		if (pItem && pItem->GetCharSet() == nCharSet)
		{
			pItem->GetCharSet() = eSysSet;
		}
	}


	BOOL bShowXAxis;
	BOOL bShowXDescr;
	BOOL bShowYAxis;
	BOOL bShowYDescr;
	BOOL bShowZAxis;
	BOOL bShowZDescr;

	rIn >> bShowMainTitle;
	rIn >> aMainTitle;
	rIn >> bShowSubTitle;
	rIn >> aSubTitle;
	rIn >> bShowXAxisTitle;
	rIn >> aXAxisTitle;
	rIn >> bShowYAxisTitle;
	rIn >> aYAxisTitle;
	rIn >> bShowZAxisTitle;
	rIn >> aZAxisTitle;
	rIn >> bShowXAxis;
	rIn >> bShowXGridMain;
	rIn >> bShowXGridHelp;
	rIn >> bShowXDescr;
	rIn >> bShowYAxis;
	rIn >> bShowYGridMain;
	rIn >> bShowYGridHelp;
	rIn >> bShowYDescr;
	rIn >> bShowZAxis;
	rIn >> bShowZGridMain;
	rIn >> bShowZGridHelp;
	rIn >> bShowZDescr;

	/**************************************************************************
	* Nun werden die Attribut-ItemSets geladen
	* Die etwas umstaendliche Art und Weise ist notwendig, da fruehere Charts
	* nicht alle Items weggeschrieben haben. Daher wird in ein leeres ItemSet
	* gestreamt und dieses in das Default-ItemSet geputtet (damit keine
	* Pool-Defaults zum Tragen kommen).
	**************************************************************************/

	SfxItemSet aTitleAttr(*pItemPool, nTitleWhichPairs);
	aTitleAttr.Load(rIn);
	PutItemSetWithNameCreation( *pTitleAttr, aTitleAttr );

	SfxItemSet aMainTitleAttr(*pItemPool, nTitleWhichPairs);
	aMainTitleAttr.Load(rIn);
	PutItemSetWithNameCreation( *pMainTitleAttr, aMainTitleAttr );

	SfxItemSet aSubTitleAttr(*pItemPool, nTitleWhichPairs);
	aSubTitleAttr.Load(rIn);
	PutItemSetWithNameCreation( *pSubTitleAttr, aSubTitleAttr );

	SfxItemSet aXAxisTitleAttr(*pItemPool, nTitleWhichPairs);
	aXAxisTitleAttr.Load(rIn);
	PutItemSetWithNameCreation( *pXAxisTitleAttr, aXAxisTitleAttr );

	SfxItemSet aYAxisTitleAttr(*pItemPool, nTitleWhichPairs);
	aYAxisTitleAttr.Load(rIn);
	PutItemSetWithNameCreation( *pYAxisTitleAttr, aYAxisTitleAttr );

	SfxItemSet aZAxisTitleAttr(*pItemPool, nTitleWhichPairs);
	aZAxisTitleAttr.Load(rIn);
	PutItemSetWithNameCreation( *pZAxisTitleAttr, aZAxisTitleAttr );

	SfxItemSet aAxisAttr(*pItemPool, nAllAxisWhichPairs);
	aAxisAttr.Load(rIn);
	pAxisAttr->Put(aAxisAttr);

CHART_TRACE( "LoadAttributes: Debugging load of old axis attr BEFORE conversion" );
	SfxItemSet aXAxisAttr(*pItemPool, nCompatAxisWhichPairs);//nXAxisWhich....
	aXAxisAttr.Load(rIn);
DBG_ITEMS(aXAxisAttr,(ChartModel*)this);
	SfxItemSet aYAxisAttr(*pItemPool, nCompatAxisWhichPairs);
	aYAxisAttr.Load(rIn);
DBG_ITEMS(aYAxisAttr,(ChartModel*)this);
	SfxItemSet aZAxisAttr(*pItemPool, nCompatAxisWhichPairs);
	aZAxisAttr.Load(rIn);
DBG_ITEMS(aZAxisAttr,(ChartModel*)this);

	if(nVersion < 12) //sonst wirds eh bergebgelt:
	{
		//konvertieren:
		AxisAttrOld2New(aXAxisAttr,TRUE,CHOBJID_DIAGRAM_X_AXIS);
		AxisAttrOld2New(aYAxisAttr,TRUE,CHOBJID_DIAGRAM_Y_AXIS);
		AxisAttrOld2New(aZAxisAttr,TRUE,CHOBJID_DIAGRAM_Z_AXIS);
		pChartXAxis->SetAttributes(aXAxisAttr);
		pChartYAxis->SetAttributes(aYAxisAttr);
		pChartZAxis->SetAttributes(aZAxisAttr);
CHART_TRACE( "LoadAttributes: Debugging AFTER conversion" );
DBG_ITEMS(aXAxisAttr,(ChartModel*)this);
DBG_ITEMS(aYAxisAttr,(ChartModel*)this);
DBG_ITEMS(aZAxisAttr,(ChartModel*)this);
	}

	SfxItemSet aGridAttr(*pItemPool, nGridWhichPairs);
	aGridAttr.Load(rIn);
	pGridAttr->Put(aGridAttr);

	SfxItemSet aXGridMainAttr(*pItemPool, nGridWhichPairs);
	aXGridMainAttr.Load(rIn);
	pXGridMainAttr->Put(aXGridMainAttr);

	SfxItemSet aYGridMainAttr(*pItemPool, nGridWhichPairs);
	aYGridMainAttr.Load(rIn);
	pYGridMainAttr->Put(aYGridMainAttr);

	SfxItemSet aZGridMainAttr(*pItemPool, nGridWhichPairs);
	aZGridMainAttr.Load(rIn);
	pZGridMainAttr->Put(aZGridMainAttr);

	SfxItemSet aXGridHelpAttr(*pItemPool, nGridWhichPairs);
	aXGridHelpAttr.Load(rIn);
	pXGridHelpAttr->Put(aXGridHelpAttr);

	SfxItemSet aYGridHelpAttr(*pItemPool, nGridWhichPairs);
	aYGridHelpAttr.Load(rIn);
	pYGridHelpAttr->Put(aYGridHelpAttr);

	SfxItemSet aZGridHelpAttr(*pItemPool, nGridWhichPairs);
	aZGridHelpAttr.Load(rIn);
	pZGridHelpAttr->Put(aZGridHelpAttr);

	SfxItemSet aDiagramAreaAttr(*pItemPool, nDiagramAreaWhichPairs);
	aDiagramAreaAttr.Load(rIn);
	PutItemSetWithNameCreation( *pDiagramAreaAttr, aDiagramAreaAttr );

	SfxItemSet aDiagramWallAttr(*pItemPool, nDiagramAreaWhichPairs);
	aDiagramWallAttr.Load(rIn);
	PutItemSetWithNameCreation( *pDiagramWallAttr, aDiagramWallAttr );

	SfxItemSet aDiagramFloorAttr(*pItemPool, nDiagramAreaWhichPairs);
	aDiagramFloorAttr.Load(rIn);
	PutItemSetWithNameCreation( *pDiagramFloorAttr, aDiagramFloorAttr );

	SfxItemSet aLegendAttr(*pItemPool, nLegendWhichPairs);
	aLegendAttr.Load(rIn);
	PutItemSetWithNameCreation( *pLegendAttr, aLegendAttr );

	if (nVersion < 2)
	{
		pTitleAttr->Put(SvxChartTextOrientItem(CHTXTORIENT_AUTOMATIC));
		pMainTitleAttr->Put(SvxChartTextOrientItem(CHTXTORIENT_AUTOMATIC));
		pSubTitleAttr->Put(SvxChartTextOrientItem(CHTXTORIENT_AUTOMATIC));
		pXAxisTitleAttr->Put(SvxChartTextOrientItem(CHTXTORIENT_AUTOMATIC));
		pYAxisTitleAttr->Put(SvxChartTextOrientItem(CHTXTORIENT_AUTOMATIC));
		pZAxisTitleAttr->Put(SvxChartTextOrientItem(CHTXTORIENT_AUTOMATIC));
		pAxisAttr->Put(SvxChartTextOrientItem(CHTXTORIENT_AUTOMATIC));

		//Achsen auch fr V12+ OK, (ToDo: Hier ist recht viel Overhead! )
		aXAxisAttr.ClearItem();
		aYAxisAttr.ClearItem();
		aZAxisAttr.ClearItem();
		aXAxisAttr.Put(SvxChartTextOrientItem(CHTXTORIENT_AUTOMATIC));
		aXAxisAttr.Put(SvxChartTextOrderItem(CHTXTORDER_SIDEBYSIDE));
		aYAxisAttr.Put(SvxChartTextOrientItem(CHTXTORIENT_AUTOMATIC));
		aYAxisAttr.Put(SvxChartTextOrderItem(CHTXTORDER_SIDEBYSIDE));
		aZAxisAttr.Put(SvxChartTextOrientItem(CHTXTORIENT_AUTOMATIC));
		pChartXAxis->SetAttributes(aXAxisAttr);
		pChartYAxis->SetAttributes(aYAxisAttr);
		pChartZAxis->SetAttributes(aZAxisAttr);

		bNoMore = TRUE;
	}

	if (nVersion < 7)
	{
		GetAttr(CHOBJID_DIAGRAM_Y_AXIS).Put(SfxBoolItem(SCHATTR_AXIS_AUTO_ORIGIN, TRUE));
		GetAttr(CHOBJID_DIAGRAM_Y_AXIS).Put(SvxDoubleItem(0.0, SCHATTR_AXIS_ORIGIN));

		bNoMore = TRUE;
	}

	rIn >> nInt16; nCount = (short)nInt16;
	for (i = 0; i < nCount; i++)
	{
		pAttr = new SfxItemSet(*pItemPool, nRowWhichPairs);

		pAttr->Load(rIn);
		aDataRowAttrList.Insert(pAttr, LIST_APPEND);

//		Debug-Code
//
//  		SfxItemState sfx_test_state = aDataRowAttrList.GetObject(i)->GetItemState(XATTR_FILLSTYLE);
//  		if (sfx_test_state >= SFX_ITEM_AVAILABLE)
//  		{
//  			XFillStyleItem& rTest_set = (XFillStyleItem&) aDataRowAttrList.GetObject(i)->Get(XATTR_FILLSTYLE);
//  		}
//  		sfx_test_state = aDataRowAttrList.GetObject(i)->GetItemState(XATTR_FILLCOLOR);
//  		if (sfx_test_state >= SFX_ITEM_AVAILABLE)
//  		{
//  			XColorItem& rTest_set = (XColorItem&) aDataRowAttrList.GetObject(i)->Get(XATTR_FILLCOLOR);
//  		}
	}

	rIn >> nInt16; nCount = (short)nInt16;
	for (i = 0; i < nCount; i++)
	{
		pAttr = new SfxItemSet(*pItemPool, nRowWhichPairs);

		pAttr->Load(rIn);
		if (pAttr->Count() == 0)
		{
			delete pAttr;
			pAttr = NULL;
		}
		aDataPointAttrList.Insert(pAttr, LIST_APPEND);
	}

	if (nVersion < 4)
	{
		for (i = 0; i < nCount; i++)
		{
//			SfxItemSet* pDataPointAttr =
//				new SfxItemSet(*pItemPool, nRowWhichPairs);
			aSwitchDataPointAttrList.Insert(NULL, LIST_APPEND);
		}

		bNoMore = TRUE;
	}
	else
	{
		rIn >> nInt16; nCount = (short)nInt16;
		for (i = 0; i < nCount; i++)
		{
			pAttr = new SfxItemSet(*pItemPool, nRowWhichPairs);

			pAttr->Load(rIn);
			if (pAttr->Count() == 0)
			{
				delete pAttr;
				pAttr = NULL;
			}
			aSwitchDataPointAttrList.Insert(pAttr, LIST_APPEND);
		}
	}

	rIn >> nInt16; eDataDescr = (SvxChartDataDescr)nInt16;
	rIn >> bShowSym;
	rIn >> bSwitchData;

	if (nVersion < 1)
	{
		BOOL bDataPercent;
		rIn >> bDataPercent;

		switch (eChartStyle)
		{
			case CHSTYLE_2D_LINE:
				eChartStyle = CHSTYLE_2D_PERCENTLINE;
				break;

			case CHSTYLE_2D_COLUMN:
				eChartStyle = CHSTYLE_2D_PERCENTCOLUMN;
				break;

			case CHSTYLE_2D_BAR:
				eChartStyle = CHSTYLE_2D_PERCENTBAR;
				break;

			case CHSTYLE_2D_AREA:
				eChartStyle = CHSTYLE_2D_PERCENTAREA;
				break;

			case CHSTYLE_3D_FLATCOLUMN:
				eChartStyle = CHSTYLE_3D_PERCENTFLATCOLUMN;
				break;

			case CHSTYLE_3D_AREA:
				eChartStyle = CHSTYLE_3D_PERCENTAREA;
				break;
		}

		bNoMore = TRUE;
	}

	UINT32 nTmp,nDescrFormat,nDescrPercentFormat;
	rIn >> nTmp;//nValFo rmat;
	SetNumFmt(CHOBJID_DIAGRAM_Y_AXIS,nTmp,FALSE);
	rIn >> nTmp;//nPerce ntValFormat;
	SetNumFmt(CHOBJID_DIAGRAM_Y_AXIS,nTmp,TRUE);
	rIn >> nDescrFormat;
	SetNumFmt(CHOBJID_DIAGRAM_X_AXIS,nDescrFormat,FALSE);
	rIn >> nDescrPercentFormat;
	SetNumFmt(CHOBJID_DIAGRAM_X_AXIS,nDescrPercentFormat,TRUE);

	// Achtung : Gravierende Aenderungen an der Datei gegenueber der Auslieferungsversion
	// es werden mehr Daten geschrieben : Die alte Version muss (!) das aber auch verkraften
	// Die Reihenfolge mu (!!!!) eingehalten werden
	pChartYAxis->LoadMemberCompat(rIn);
	pChartXAxis->LoadMemberCompat(rIn);
	pChartZAxis->LoadMemberCompat(rIn);

	rIn >> fMaxData;

	if (!bNoMore)
	{
		UINT32 nMoreData = 0;
		rIn >> nMoreData;

		// nMoreData soll als Weiche fuer zukuenftige Versionen dienen,
		// insbesondere fuer den Fall, dass weitere Daten geschrieben werden
		// muessen. Die Pools duerfen ab dem 19.01.1996 auf gar keinen Fall
		// mehr modifiziert oder aufgebohrt werden !!!!
		// nMoreData = 1     (Version vom 19.01.1996)
		// nMoreData = 2     (Version vom 13.03.1996)
		// nMoreData = 3     (Version vom 1.04.1996)
		// nMoreData = 4     (Version vom 13.05.1996)
		// nMoreData = 5     (Version vom 20.05.1996)
		// nMoreData = 6     (Version vom 20.06.1996)
		// nMoreData = 7     (Version vom 02.07.1996)
		// nMoreData = 8     (Version vom 09.07.1996)
		// nMoreData = 9     (Version vom 11.07.1996)
		// ...
		// nMoreData = 12    (Version vom 20.02.1997) FG (Vobis-Version 4.0)
		// nMoreData = 13    (Version vom 9.3.1997) FG Cebit-Version
		// .... siehe Text unten
		// nMoreData = 15    (Version vom 14.3.1997)  FG V4.0 nach Cebit >= 358
		if (nMoreData > 1)
		{
			ByteString aReadString;

			rIn >> pChartData->SomeData1();
			rIn >> pChartData->SomeData2();
			rIn >> pChartData->SomeData3();
			rIn >> pChartData->SomeData4();

			if (nMoreData >= 3) rIn >> fSpotIntensity;
			if (nMoreData <= 8) fAmbientIntensity = fSpotIntensity;

			if (nMoreData >= 4)
			{
				BOOL bDummy;

				rIn >> bShowAverage;
				rIn >> nInt16; eErrorKind = (SvxChartKindError) nInt16;
				rIn >> bDummy;
				rIn >> nInt16; eIndicate = (SvxChartIndicate) nInt16;
				rIn >> fIndicatePercent;
				rIn >> fIndicateBigError;
				rIn >> fIndicatePlus;
				rIn >> fIndicateMinus;
			}

			if (nMoreData >= 5)
			{
				rIn >> nInt16; eRegression = (SvxChartRegress) nInt16;
			}

			if (nMoreData >= 6)
			{
				INT32 nInt32;
				rIn >> nInt32; nSplineDepth = nInt32;
				rIn >> nInt32; nGranularity = nInt32;
			}

			if (nMoreData >= 7)
			{
				rIn >> bLegendVisible;
			}

			if (nMoreData >= 8)
			{
				rIn >> nInt16; nCount = (short)nInt16;
				for (i = 0; i < nCount; i++)
				{
					pAttr = new SfxItemSet(*pItemPool, nGridWhichPairs);

					pAttr->Load(rIn);
					aRegressAttrList.Insert(pAttr, LIST_APPEND);
				}

				rIn >> nInt16; nCount = (short)nInt16;
				for (i = 0; i < nCount; i++)
				{
					pAttr = new SfxItemSet(*pItemPool, nGridWhichPairs);

					pAttr->Load(rIn);
					aAverageAttrList.Insert(pAttr, LIST_APPEND);
				}

				rIn >> nInt16; nCount = (short)nInt16;
				for (i = 0; i < nCount; i++)
				{
					pAttr = new SfxItemSet(*pItemPool, nGridWhichPairs);

					pAttr->Load(rIn);
					aErrorAttrList.Insert(pAttr, LIST_APPEND);
				}
			}

			if (nMoreData >= 9) rIn >> fAmbientIntensity;
			if (nMoreData >= 10) rIn >> bTextScalable;
			if (nMoreData >= 11) rIn >> aInitialSize;
			if (nMoreData >= 12)     //FG: 20.2.1997
			{
				// FG: Vielleicht etwas viel Speicher fuer BOOL, aber es macht nur 16 Byte pro Chart
				rIn >> nInt16;  bFormatXAxisTextInMultipleLinesIfNecessary = (BOOL) nInt16;
				rIn >> nInt16;  bFormatYAxisTextInMultipleLinesIfNecessary = (BOOL) nInt16;
				rIn >> nInt16;  bFormatZAxisTextInMultipleLinesIfNecessary = (BOOL) nInt16;
				rIn >> nInt16;  bFormatLegendTextInMultipleLinesIfNecessary = (BOOL) nInt16;
			}
			if (nMoreData >= 13) // FG: 9.3.1997 Zusaetze wegen einer freien Positionierung und einem freien
			{                    //     Resize von Gruppenobjekten im Chart.
				rIn >> nInt16;  nXAxisTextMaximumNumberOfLines = nInt16;
				rIn >> nInt16;  nYAxisTextMaximumNumberOfLines = nInt16;
				rIn >> nInt16;  nZAxisTextMaximumNumberOfLines = nInt16;
				rIn >> nInt32; nWidthOfFirstXAxisText = nInt32;
				rIn >> nInt32; nWidthOfLastXAxisText = nInt32;
				rIn >> aTitleTopCenter;
				rIn >> aSubTitleTopCenter;
				rIn >> aDiagramRectangle;
				rIn >> aLegendTopLeft;
				rIn >> aTitleXAxisPosition; // FG: welcher Punkt da jeweils gemeint ist findet
				rIn >> aTitleYAxisPosition; //     bei nMoreData = 15
				rIn >> aTitleZAxisPosition;
				rIn >> nInt16;  bUseRelativePositionsForChartGroups = (BOOL) nInt16;
				rIn >> nInt16;  bAdjustMarginsForLegend = (BOOL) nInt16;
				rIn >> nInt16;  bAdjustMarginsForMainTitle = (BOOL) nInt16;
				rIn >> nInt16;  bAdjustMarginsForSubTitle = (BOOL) nInt16;
				rIn >> nInt16;  bAdjustMarginsForXAxisTitle = (BOOL) nInt16;
				rIn >> nInt16;  bAdjustMarginsForYAxisTitle = (BOOL) nInt16;
				rIn >> nInt16;  bAdjustMarginsForZAxisTitle = (BOOL) nInt16;
			}
			if (nMoreData >= 14)
			{
				rIn >> aSpotColor;       // FG: Aenderung von DL damit sich das 3d-Chart die
				rIn >> aAmbientColor;    //     Farbfilter-Einstellungen merkt.

				rIn >> bDiagramHasBeenMovedOrResized; // FG: 12.3.97, Falls das Chart gespeichert wird
				rIn >> bMainTitleHasBeenMoved;        //     soll es immer noch die relativen Positionen
				rIn >> bSubTitleHasBeenMoved;         //     der Objektgruppen beachten, falls eine
				rIn >> bLegendHasBeenMoved;           //     dieser Gruppen bewegt worden ist.
				rIn >> bXAxisTitleHasBeenMoved;
				rIn >> bYAxisTitleHasBeenMoved;
				rIn >> bZAxisTitleHasBeenMoved;
			}
			if (nMoreData >= 15) // FG: 14.3.97 Es braucht noch die Information der Ausrichtung
			{                    //             damit beim Resize die Texte richtig plaziert werden
				rIn >> nInt16; eAdjustXAxesTitle = (ChartAdjust) nInt16;
				rIn >> nInt16; eAdjustYAxesTitle = (ChartAdjust) nInt16;
				rIn >> nInt16; eAdjustZAxesTitle = (ChartAdjust) nInt16;
			}
			if (nMoreData >= 16)
			{
				BOOL bNeedMerge=FALSE;
				String aFmtStr;
				ULONG nId;
				if(nVersion <= 11)//ab V 12 X=Y=Z-Numberformatter!
				{
					SvNumberFormatter *pTmp = new SvNumberFormatter( ::comphelper::getProcessServiceFactory(),
																	 LANGUAGE_SYSTEM );
					pTmp->Load(rIn);
					nId = IsPercentChart() ? nDescrPercentFormat : nDescrFormat;
					const SvNumberformat* pFmt=pTmp->GetEntry(nId);

					if(pFmt && (pFmt->GetType() & NUMBERFORMAT_DEFINED))
					{
						aFmtStr = pFmt->GetFormatstring();
						bNeedMerge=TRUE;
					}
					delete pTmp;
				}
				else
				{
					pNumFormatter->SkipNumberFormatterInStream( rIn ); //Skip x
				}
				pOwnNumFormatter->Load( rIn );		// if not skipped load the own formatter ...
				pNumFormatter = pOwnNumFormatter;	// ... and use it

				// merge user formats of x axis formatter
				if(bNeedMerge)
				{
					xub_StrLen nChk;
					short nType;
					pNumFormatter->PutEntry(aFmtStr,nChk,nType,nId,LANGUAGE_SYSTEM);
					DBG_ASSERT(nChk==0,"Chart:: Converting X-Axis Numformat failed");
					SetNumFmt(CHOBJID_DIAGRAM_X_AXIS,nId,IsPercentChart());
				}

				pNumFormatter->SkipNumberFormatterInStream(rIn);//aTmp.Load( rIn );//pNumFormatterZ //immer wegschmeissen, hatte nie userdef. formats
			}
		}
		aLastDiagramRectangle = aDiagramRectangle;	// #68131# (#67459#)
	}

	// FG: Das ist notwendig damit in SchChartDocShell::Draw das Chart Initialisiert
	//     wird, es also die wirkliche Groesse mitbekommt. Zum jetzigen Zeitpunkt nach dem
	//     Laden gibt es ja noch kein Fenster. Ein Aufruf von BuildChart an dieser Stelle
	//     geht also nicht. Bei einem Repaint wird in der oben genannten Methode abgefragt
	//     ob das Chart bereits existiert (bNoBuildChart), falls nicht wird es neu angelegt.
	//
	//     bei den Versionen 4.0 oder hoeher wird die Initialisierung richtig gemacht
	//     bei Charts die Inplace aus Versionen 3.1 verwendet werden passiert das schon
	//     richtig.
	//
	//     Dies betrifft nur 3D-Charts, die im Format der Version 3.1 geschrieben wurden.
	//
	//     21.4. Aenderung: Das Chart kann ja aus allen gespeicheten Daten erzeugt werden.
	//     um das File klein zu halten und da die Neuberechnung sehr viel schneller
	//     geworden ist.
	if (((rIn.GetVersion() <= SOFFICE_FILEFORMAT_31) && (Is3DChart())) ||
		bUseRelativePositionsForChartGroups || (rIn.GetVersion() > SOFFICE_FILEFORMAT_31))
	{
		bNoBuildChart = TRUE;
	}



	if (nVersion >= 9)//#50116# Saeulenbreite
	{
		rIn >> nInt16; SetBarPercentWidth((long)nInt16);

		rIn >> nInt32; m_nDefaultColorSet=nInt32;//#50149#

		rIn >> nInt32;
		// #78911# always set to 0 if charttype doesn't support lines
		SetNumLinesColChart( ( eChartStyle == CHSTYLE_2D_LINE_COLUMN )? nInt32: 0 );

		// #74536# BM use these three former -1 dummies for
		// numberformat last set by CALC
		rIn	>> nXLastNumFmt;
		rIn	>> nYLastNumFmt;
 		rIn	>> nBLastNumFmt;
		rIn >> nInt32; // still dummy (-1)

	}

	if(nVersion >= 11)//10 existiert nicht (pChartAttr)
	{

		SfxItemSet aAttr(*pItemPool, nRowWhichPairs);
		aAttr.Load(rIn);
		pStockLineAttr->Put(aAttr);

		aAttr.ClearItem();
		aAttr.Load(rIn);
		pStockLossAttr->Put(aAttr);

		aAttr.ClearItem();
		aAttr.Load(rIn);
		pStockPlusAttr->Put(aAttr);
	}

	InitChartData(FALSE); //weia, beeinflusst die Achsen....also erst ab hier:


	if(nVersion >= 12)
	{
		//Achse wird nur noch auf Attr-Basis gestreamt!

		//nAxisId ist die zu ladene/speichernde Achse,
		//festgelegt sind in V12 nur 1=X, 2=Y,3=Z und 4=B (2.Y-Achse)
		//-1 bedeutet KEINE WEITEREN ACHSEN !!!!!!!!!!!
		//Es MUSS keine Achse gestreamt werden (siehe Lade-Routine)
		INT32 nAxisId=0;
		SfxItemSet aAxisSet(*pItemPool,nAxisWhichPairs);
		while(nAxisId != -1)//hier knnen beliebig viele, auch unbekannte Achsen kommen
		{
			aAxisSet.ClearItem();
			rIn >> nAxisId;

			switch(nAxisId)
			{
				case CHART_AXIS_PRIMARY_X:
					aAxisSet.Load(rIn);
					SetAttributes(CHOBJID_DIAGRAM_X_AXIS,aAxisSet,FALSE);
					SetAttributes(CHOBJID_DIAGRAM_A_AXIS,aAxisSet,FALSE);//falls nicht spter geladen wird, hier neue defaults setzen
					pChartAAxis->ShowAxis(FALSE); //default aus
					pChartAAxis->ShowDescr(FALSE);
					pChartXAxis->Update();	//Ab V12 kann jetzt der ganze LoadMemberCompat...Kram bergebgelt werden, in den Attr war alles drin!
					pChartAAxis->Update();
				break;
				case CHART_AXIS_PRIMARY_Y:
					aAxisSet.Load(rIn);
					SetAttributes(CHOBJID_DIAGRAM_Y_AXIS,aAxisSet,FALSE);
					pChartYAxis->Update();
				break;
				case CHART_AXIS_PRIMARY_Z:
					aAxisSet.Load(rIn);
					SetAttributes(CHOBJID_DIAGRAM_Z_AXIS,aAxisSet,FALSE);
					pChartZAxis->Update();
				break;
				case CHART_AXIS_SECONDARY_Y:
					aAxisSet.Load(rIn);
					SetAttributes(CHOBJID_DIAGRAM_B_AXIS,aAxisSet,FALSE);
					pChartBAxis->Update();
				break;
				case CHART_AXIS_SECONDARY_X:
					aAxisSet.Load(rIn);
					SetAttributes(CHOBJID_DIAGRAM_A_AXIS,aAxisSet,FALSE);
					pChartAAxis->Update();
				break;
				case -1: //Ende der Achsen!
					break;
				default: //Attrset kommt aus der Zukunft! Laden und vernichten:
					{
						aAxisSet.Load(rIn);
					}
					break;
			}
		}
	}
	else //defaults ergnzen
	{
		SfxItemSet aSet(*pItemPool,nAxisWhichPairs);
		aSet.Put(SfxInt32Item(SCHATTR_AXIS_TICKS,CHAXIS_MARK_OUTER));
		SetAttributes(CHOBJID_DIAGRAM_X_AXIS,aSet);
		SetAttributes(CHOBJID_DIAGRAM_Y_AXIS,aSet);
	}
	//Ende IOVersion 12


	if(nVersion >= 14)
	{
		rIn >> nTmp;
		aBarY1.SetGap(nTmp);
		rIn >> nTmp;
		aBarY1.SetOverlap(nTmp);
		rIn >> nTmp;
		aBarY2.SetGap(nTmp);
		rIn >> nTmp;
		aBarY2.SetOverlap(nTmp);
	}
	else
	{
/*		aBarY1.SetGap()
		aBarY1.SetOverlap(nTmp)
		aBarY2.SetGap(nTmp)
		aBarY2.SetOverlap(nTmp)
		*/
	}

	if(nVersion >= 15)
	{
		SfxItemSet	*	pAttributes;
		bResizePie=FALSE;
		rIn >> bDiagramHasBeenMovedOrResized; // FG: 12.3.97, Falls das Chart gespeichert wird

		if(IsReal3D() && (IsPieChart()||IsLine())) //Hack wegen  #62363#, double-sided neu defaulten
		{
			long nMax;
			nMax=aDataRowAttrList.Count();
			for(i=0;i<nMax;i++)
//-/				aDataRowAttrList.GetObject(i)->Put(SfxBoolItem(SID_ATTR_3D_DOUBLE_SIDED,TRUE));
				aDataRowAttrList.GetObject(i)->Put(Svx3DDoubleSidedItem(TRUE));
			nMax=aDataPointAttrList.Count();
			for(i=0;i<nMax;i++)
			{
				pAttributes = aDataPointAttrList.GetObject(i);
				if (pAttributes != NULL)
					pAttributes->Put(Svx3DDoubleSidedItem(TRUE));
			}
			nMax=aSwitchDataPointAttrList.Count();
			for(i=0;i<nMax;i++)
			{
				pAttributes = aSwitchDataPointAttrList.GetObject(i);
				if (pAttributes != NULL)
					pAttributes->Put(Svx3DDoubleSidedItem(TRUE));
			}
		}
	}
	else
	{
		//altes 3D-Pie?
		bResizePie=TRUE;
		if(IsReal3D() && IsPieChart())
		{
			Matrix4D aTmp;        //Matrix auf default

			aTmp.RotateZ((900 + nYAngle) * F_PI / 1800); //??? !!!
			aTmp.RotateX(-F_PI/3);

			aSceneMatrix=aTmp;
		}

		if(IsReal3D()) //#61923#
		{
			long nMax;
			nMax=aDataRowAttrList.Count();
			SfxItemSet	*	pAttributes;
			
			for(i=0;i<nMax;i++)
			{
				if(IsPieChart()||IsLine())
//-/					aDataRowAttrList.GetObject(i)->Put(SfxBoolItem(SID_ATTR_3D_DOUBLE_SIDED,TRUE));
					aDataRowAttrList.GetObject(i)->Put(Svx3DDoubleSidedItem(TRUE));
				aDataRowAttrList.GetObject(i)->Put(XLineStyleItem(XLINE_NONE));
			}

			nMax=aDataPointAttrList.Count();
			for(i=0;i<nMax;i++)
			{
				pAttributes = aDataPointAttrList.GetObject(i);
				if (pAttributes == NULL)
					continue;
				if(IsPieChart()||IsLine())
					aDataPointAttrList.GetObject(i)->Put(Svx3DDoubleSidedItem(TRUE));
				aDataPointAttrList.GetObject(i)->Put(XLineStyleItem(XLINE_NONE));
			}


			nMax=aSwitchDataPointAttrList.Count();
			for(i=0;i<nMax;i++)
			{
				pAttributes = aSwitchDataPointAttrList.GetObject(i);
				if (pAttributes == NULL)
					continue;
				if(IsPieChart()||IsLine())
					aSwitchDataPointAttrList.GetObject(i)->Put(Svx3DDoubleSidedItem(TRUE));
				aSwitchDataPointAttrList.GetObject(i)->Put(XLineStyleItem(XLINE_NONE));
			}
		}
	}

	// ******************** LAST READ ********************


	// ############# defaults erstellen, falls alte Fileversion ####################

	if(nVersion < 13)
	{
		if(IsXYChart())
			aDataRowAttrList.GetObject(0)->Put(SfxInt32Item(SCHATTR_AXIS,CHART_AXIS_PRIMARY_X));
	}
	//#54870# restaurieren der line-attribute
	if( nVersion < 10)
	{
	   SetupLineColors(SETLINES_COMPAT);
	}
	if( nVersion < 16) //Automatische 2.YAchse in Items umsetzten
	{
		const SfxPoolItem* pPoolItem=NULL;
		for(long n=0;n<GetRowCount();n++)
			if(GetDataRowAttr(n).GetItemState(SCHATTR_AXIS,TRUE, &pPoolItem) == SFX_ITEM_SET)
			if(((const SfxInt32Item*)pPoolItem)->GetValue()==CHART_AXIS_SECONDARY_Y)
			{
				n=GetRowCount();//abbruch
				pChartBAxis->ShowDescr(TRUE);
				pChartBAxis->ShowAxis(TRUE);
			}
	}

	//dies ist immer mglich (IoVersion<=16), in Zukunft sollten nur noch die Attr untersttzt werden, dann kann hier evtl. mit IOVersion geklammert werden!
	pChartXAxis->ShowDescr(bShowXDescr);
	pChartXAxis->ShowAxis(bShowXAxis);
	pChartYAxis->ShowDescr(bShowYDescr);
	pChartYAxis->ShowAxis(bShowYAxis);
	pChartZAxis->ShowDescr(bShowZDescr);
	pChartZAxis->ShowAxis(bShowZAxis);


	//Bei unsortierten Charts machts keinen Sinn, nachdem Laden nochmal zu fragen
	if( IsXYChart() )
		SETFLAG( nChartStatus, CHS_USER_NOQUERY );
	else
		RESETFLAG( nChartStatus, CHS_USER_NOQUERY );

	CHART_TRACE( "ChartModel::LoadAttributes END" );
}

/*************************************************************************
|*
|* Titel aendern;
|* Liefert TRUE, wenn ein Titel geaendert wurde.
|*
\************************************************************************/

BOOL ChartModel::ChangeTitle(BOOL bShowMain, const String& rMainTitle,
							 BOOL bShowSub, const String& rSubTitle,
							 BOOL bShowX, const String& rXAxisTitle,
							 BOOL bShowY, const String& rYAxisTitle,
							 BOOL bShowZ, const String& rZAxisTitle)
{
	BOOL bMainTitleChanged  = (bShowMain != bShowMainTitle || ! rMainTitle.Equals( aMainTitle ));
	BOOL bSubTitleChanged   = (bShowSub != bShowSubTitle || ! rSubTitle.Equals( aSubTitle ));
	BOOL bXAxisTitleChanged = (bShowX != bShowXAxisTitle || ! rXAxisTitle.Equals( aXAxisTitle ));
	BOOL bYAxisTitleChanged = (bShowY != bShowYAxisTitle || ! rYAxisTitle.Equals( aYAxisTitle ));
	BOOL bZAxisTitleChanged = (bShowZ != bShowZAxisTitle || ! rZAxisTitle.Equals( aZAxisTitle ));

	if (!bMainTitleChanged && !bSubTitleChanged &&
		!bXAxisTitleChanged && !bYAxisTitleChanged &&
		!bZAxisTitleChanged) return FALSE;
	else
	{
		if (bMainTitleChanged)
		{
			bShowMainTitle  = (bMainTitleChanged && (!rMainTitle.Len ()))
								  ? FALSE
								  : bShowMain;
			aMainTitle      = rMainTitle;
		}

		if (bSubTitleChanged)
		{
			bShowSubTitle   = (bSubTitleChanged && (!rSubTitle.Len ()))
								  ? FALSE
								  : bShowSub;
			aSubTitle       = rSubTitle;
		}

		if (bXAxisTitleChanged)
		{
			bShowXAxisTitle = (bXAxisTitleChanged && (!rXAxisTitle.Len ()))
								  ? FALSE
								  : bShowX;
			aXAxisTitle     = rXAxisTitle;
		}

		if (bYAxisTitleChanged)
		{
			bShowYAxisTitle = (bYAxisTitleChanged && (!rYAxisTitle.Len ()))
								  ? FALSE
								  : bShowY;
			aYAxisTitle     = rYAxisTitle;
		}

		if (bZAxisTitleChanged)
		{
			bShowZAxisTitle = (bZAxisTitleChanged && (!rZAxisTitle.Len ()))
								  ? FALSE
								  : bShowZ;
			aZAxisTitle     = rZAxisTitle;
		}

		if (bMainTitleChanged || bSubTitleChanged || bXAxisTitleChanged ||
			bYAxisTitleChanged || bZAxisTitleChanged) BuildChart(FALSE);

		return TRUE;
	}
}
/*************************************************************************
|*
|* Titel-Attribute setzen
|*
\************************************************************************/

void ChartModel::PutTitleAttr(const SfxItemSet& rAttr,BOOL bMerge)
{
	if(!bMerge)
	{
		pTitleAttr->ClearItem();
		pMainTitleAttr->ClearItem();
		pSubTitleAttr->ClearItem();
		pXAxisTitleAttr->ClearItem();
		pYAxisTitleAttr->ClearItem();
		pZAxisTitleAttr->ClearItem();
	}
	pTitleAttr->Put(rAttr);
	pMainTitleAttr->Put(rAttr);
	pSubTitleAttr->Put(rAttr);
	pXAxisTitleAttr->Put(rAttr);
	pYAxisTitleAttr->Put(rAttr);
	pZAxisTitleAttr->Put(rAttr);
}

/*************************************************************************
|*
|* Titel-Attribute ermitteln
|*
\************************************************************************/

const SfxItemSet & ChartModel::GetTitleAttr( UINT16 nChobjID ) const
{
    switch( nChobjID )
    {
        case CHOBJID_TITLE_MAIN:
            return *pMainTitleAttr;

        case CHOBJID_TITLE_SUB:
            return *pSubTitleAttr;

        case CHOBJID_DIAGRAM_TITLE_X_AXIS:
            return *pXAxisTitleAttr;

        case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
            return *pYAxisTitleAttr;

        case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
            return *pYAxisTitleAttr;
    }
    return *pTitleAttr;
}

const SfxItemSet & ChartModel::GetTitleAttr( const SdrTextObj* pTextObj ) const
{
	if( pTextObj )
	{
		SchObjectId* pObjId = GetObjectId( * pTextObj );
        if( pObjId )
            return GetTitleAttr( pObjId->GetObjId() );
    }
    return *pTitleAttr;
}

/*************************************************************************
|*
|* Titel-Attribute ermitteln
|*
\************************************************************************/

SfxItemSet ChartModel::GetFullTitleAttr(const SdrTextObj* pTextObj) const
{
	if (pTextObj)
	{
		SfxItemSet aAttr(*pItemPool, nTitleWhichPairs);

		aAttr.ClearItem ();

		SchObjectId* pObjId = GetObjectId(*pTextObj);

		if (pObjId) switch (pObjId->GetObjId())
					{
						case CHOBJID_TITLE_MAIN:
						{
							aAttr.Put(*pMainTitleAttr);
							break;
						}

						case CHOBJID_TITLE_SUB:
						{
							aAttr.Put(*pSubTitleAttr);
							break;
						}

						case CHOBJID_DIAGRAM_TITLE_X_AXIS:
						{
							aAttr.Put(*pXAxisTitleAttr);
							break;
						}

						case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
						{
							aAttr.Put(*pYAxisTitleAttr);
							break;
						}

						case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
						{
							aAttr.Put(*pZAxisTitleAttr);
							break;
						}
					}
		return aAttr;
	}
	else
	{
		pTitleAttr->ClearItem ();
		pTitleAttr->Put (*pMainTitleAttr);
		CompareSets (*pSubTitleAttr, *pTitleAttr);
		CompareSets (*pXAxisTitleAttr, *pTitleAttr);
		CompareSets (*pYAxisTitleAttr, *pTitleAttr);
		CompareSets (*pZAxisTitleAttr, *pTitleAttr);

		return *pTitleAttr;
	}
}

/*************************************************************************
|*
|* Titel-Attribute aendern;
|* Liefert bei geaenderten Attributen TRUE.
|*
\************************************************************************/

BOOL ChartModel::ChangeTitleAttr(const SfxItemSet &rAttr,
								 SdrTextObj       *pTitleObj,
								 BOOL             bMerge)
{
	if (pTitleObj)
	{
		SchObjectId* pObjId = GetObjectId(*pTitleObj);

		if (!pObjId) return FALSE;
		else
		{
			SchObjectAdjust* pObjAdjust = GetObjectAdjust(*pTitleObj);
			DBG_ASSERT( pObjAdjust, "ChartModel::ChangeTitleAttr: no adjustment info in text obj") ;

			const SfxPoolItem  *pPoolItem = NULL;
			SvxChartTextOrient eOldOrient = pObjAdjust->GetOrient();
			SvxChartTextOrient eNewOrient = (rAttr.GetItemState(SCHATTR_TEXT_ORIENT, TRUE, &pPoolItem) == SFX_ITEM_SET)
												? ((const SvxChartTextOrientItem*)pPoolItem)->GetValue()
												: eOldOrient;

			switch (pObjId->GetObjId())
			{
				case CHOBJID_TITLE_MAIN:
					PutMainTitleAttr(rAttr,bMerge);
					TitleOrientChanged (pTitleObj, pMainTitleAttr,eOldOrient, eNewOrient);

					if(IsAttrChangeNeedsBuildChart(rAttr))
						BuildChart(FALSE, CHOBJID_TITLE_MAIN);
					else
//-/						GetObjWithId(CHOBJID_TITLE_MAIN,*GetPage(0))->SetAttributes(rAttr,FALSE);
						GetObjWithId(CHOBJID_TITLE_MAIN,*GetPage(0))->SetItemSet(rAttr);
					break;

				case CHOBJID_TITLE_SUB:
					PutSubTitleAttr(rAttr,bMerge);
					TitleOrientChanged (pTitleObj, pSubTitleAttr,eOldOrient, eNewOrient);
					if(IsAttrChangeNeedsBuildChart(rAttr))
						BuildChart(FALSE, CHOBJID_TITLE_SUB);
					else
//-/						GetObjWithId(CHOBJID_TITLE_SUB,*GetPage(0))->SetAttributes(rAttr,FALSE);
						GetObjWithId(CHOBJID_TITLE_SUB,*GetPage(0))->SetItemSet(rAttr);
					break;

				case CHOBJID_DIAGRAM_TITLE_X_AXIS:
					PutXAxisTitleAttr(rAttr,bMerge);
					TitleOrientChanged (pTitleObj, pXAxisTitleAttr,eOldOrient, eNewOrient);
					 if(IsAttrChangeNeedsBuildChart(rAttr))
						BuildChart(FALSE, CHOBJID_DIAGRAM_TITLE_X_AXIS);
					else
//-/						GetObjWithId(CHOBJID_DIAGRAM_TITLE_X_AXIS,*GetPage(0))->SetAttributes(rAttr,FALSE);
						GetObjWithId(CHOBJID_DIAGRAM_TITLE_X_AXIS,*GetPage(0))->SetItemSet(rAttr);
					break;

				case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
					PutYAxisTitleAttr(rAttr,bMerge);
					TitleOrientChanged (pTitleObj, pYAxisTitleAttr,eOldOrient, eNewOrient);
					if(IsAttrChangeNeedsBuildChart(rAttr))
						BuildChart(FALSE, CHOBJID_DIAGRAM_TITLE_Y_AXIS);
					else
//-/						GetObjWithId(CHOBJID_DIAGRAM_TITLE_Y_AXIS,*GetPage(0))->SetAttributes(rAttr,FALSE);
						GetObjWithId(CHOBJID_DIAGRAM_TITLE_Y_AXIS,*GetPage(0))->SetItemSet(rAttr);
					break;

				case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
					PutZAxisTitleAttr(rAttr,bMerge);
					TitleOrientChanged (pTitleObj, pZAxisTitleAttr,eOldOrient, eNewOrient);
					if(IsAttrChangeNeedsBuildChart(rAttr))
						BuildChart(FALSE, CHOBJID_DIAGRAM_TITLE_Z_AXIS);
					else
//-/						GetObjWithId(CHOBJID_DIAGRAM_TITLE_Z_AXIS,*GetPage(0))->SetAttributes(rAttr,FALSE);
						GetObjWithId(CHOBJID_DIAGRAM_TITLE_Z_AXIS,*GetPage(0))->SetItemSet(rAttr);
					break;
			}

			return TRUE;
		}
	}
	else
	{
		PutTitleAttr(rAttr,bMerge);
		return SetAllTitleAttributes (rAttr);
	}
}

/*************************************************************************
|*
|* Titel-Attribute aendern;
|* Liefert bei geaenderten Attributen TRUE.
|*
\************************************************************************/

BOOL ChartModel::ChangeTitleAttr(const SfxItemSet &rMainTitleAttr,
								 const SfxItemSet &rSubTitleAttr,
								 const SfxItemSet &rXAxisTitleAttr,
								 const SfxItemSet &rYAxisTitleAttr,
								 const SfxItemSet &rZAxisTitleAttr,
								 BOOL             bMerge)
{
	PutMainTitleAttr( rMainTitleAttr ,bMerge);
	PutSubTitleAttr(  rSubTitleAttr  ,bMerge);
	PutXAxisTitleAttr(rXAxisTitleAttr,bMerge);
	PutYAxisTitleAttr(rYAxisTitleAttr,bMerge);
	PutZAxisTitleAttr(rZAxisTitleAttr,bMerge);

	return SetAllTitleAttributes (*pMainTitleAttr);
}

/*************************************************************************
|*
|* Ermittelt, ob Legende angezeigt wird
|*
\************************************************************************/

BOOL ChartModel::GetShowLegend() const
{
	SvxChartLegendPos ePos = ((const SvxChartLegendPosItem&) pLegendAttr->Get(SCHATTR_LEGEND_POS)).GetValue();

	switch (ePos)
	{
		case CHLEGEND_LEFT :
		case CHLEGEND_TOP :
		case CHLEGEND_RIGHT :
		case CHLEGEND_BOTTOM :
			return TRUE;

		default :
			return FALSE;
	}
}
/*************************************************************************
|*
|* Zeigt Legende an bzw. loescht sie.
|*
\************************************************************************/

void ChartModel::SetShowLegend(BOOL bShow)
{
	pLegendAttr->Put(SvxChartLegendPosItem(bShow
											   ? CHLEGEND_RIGHT
											   : CHLEGEND_NONE));
	bLegendVisible = bShow;
}
/*************************************************************************
|*
|* Legenden-Attribute ermitteln
|*
\************************************************************************/

SfxItemSet ChartModel::GetFullLegendAttr() const
{
	SfxItemSet aAttr(*pItemPool, nLegendWhichPairs);
	aAttr.Put(*pLegendAttr);
	return aAttr;
}

/*************************************************************************
|*
|* Legenden-Attribute aendern;
|* Liefert bei geaenderten Attributen TRUE.
|*
\************************************************************************/

void ChartModel::ChangeLegendAttr(const SfxItemSet& rAttr,
								  BOOL              bMerge)
{
	long nWEidth = ((XLineWidthItem &)rAttr.Get (XATTR_LINEWIDTH)).GetValue ();

	SdrPage* pPage = GetPage(0);
	DBG_ASSERT( pPage, "ChangeLegendAttr: page object is NULL" );

	const SfxPoolItem* pPoolItem = NULL;

	SvxChartLegendPos eOldPos = ((const SvxChartLegendPosItem&) pLegendAttr->Get(SCHATTR_LEGEND_POS)).GetValue();

	SvxChartLegendPos eNewPos;
	if (rAttr.GetItemState(SCHATTR_LEGEND_POS, TRUE, &pPoolItem) == SFX_ITEM_SET)
		eNewPos = ((const SvxChartLegendPosItem*)pPoolItem)->GetValue();
	else eNewPos = eOldPos;


	//#50913#: Legende hat neue Position? Wenn ja, dann relative Pos lschen:
	if(eOldPos!=eNewPos)
		SetLegendHasBeenMoved(FALSE);

	PutLegendAttr(rAttr,bMerge);

	if ((eOldPos != CHLEGEND_NONE) && bLegendVisible)
	{
		SdrObjGroup *pLegendObj = (SdrObjGroup*)GetObjWithId(CHOBJID_LEGEND, *pPage);

		if ((eNewPos != CHLEGEND_NONE) && pLegendObj)
		{
			SdrObjList* pObjList = pLegendObj->GetSubList();
			SdrObject* pObj = GetObjWithId(CHOBJID_LEGEND_BACK, *pObjList);
			DBG_ASSERT(pObj, "ChartModel::ChangeLegendAttr: legend back obj not found");

//-/			pObj->SetAttributes(*pLegendAttr, FALSE);
			pObj->SetItemSetAndBroadcast(*pLegendAttr);

			SfxItemSet aTextAttr(*pItemPool, nTextWhichPairs);
			aTextAttr.Put(rAttr);

			SdrObjListIter aIterator(*pLegendObj->GetSubList(), IM_FLAT);
			while (aIterator.IsMore())
			{
				SdrObject* pObj = aIterator.Next();
				if (pObj->GetObjIdentifier() == OBJ_TEXT)
				{
					SetTextAttr(*(SdrTextObj*)pObj,aTextAttr);

//-/					pObj->SetAttributes(rAttr,0);
					pObj->SetItemSetAndBroadcast(rAttr);
				}
			}
		}
	}
	if(IsAttrChangeNeedsBuildChart(rAttr))
		BuildChart(FALSE, CHOBJID_LEGEND);
}
/*************************************************************************
|*
|* Chart-Attribute aendern;
|* Liefert bei geaenderten Attributen TRUE.
|*
\************************************************************************/
void ChartModel::ChangeChartAttr(const SfxItemSet& rAttr,BOOL bMerge)
{
	PutChartAttr(rAttr,bMerge);

	//Todo: Attr->eChartStyle
	BuildChart(FALSE);
}

/*************************************************************************
|*
|* Erstelle Symbole fuer Diagrammtypen mit Symbolen
|*
\************************************************************************/

BOOL ChartModel::TitleOrientChanged (const SdrTextObj   *pTitleObj,
									 const SfxItemSet   *pAttr,
									 SvxChartTextOrient eOldOrient,
									 SvxChartTextOrient eNewOrient)
{
	if (eOldOrient == eNewOrient) return TRUE;
	else
	{
		if( eNewOrient == CHTXTORIENT_STACKED && pTitleObj )
		{
			pOutliner->SetText( *(pTitleObj->GetOutlinerParaObject()) );
			String aTitle = pOutliner->GetText( pOutliner->GetParagraph( 0 ), pOutliner->GetParagraphCount() );
			pOutliner->Clear();
			SAL_CONST_CAST( SdrTextObj*, pTitleObj )->SetText( StackString( aTitle ) );
		}
		else if( eOldOrient == CHTXTORIENT_STACKED && pTitleObj )
		{
			pOutliner->SetText( *(pTitleObj->GetOutlinerParaObject()) );
			String aTitle = pOutliner->GetText( pOutliner->GetParagraph( 0 ), pOutliner->GetParagraphCount() );
			pOutliner->Clear();
			SAL_CONST_CAST( SdrTextObj*, pTitleObj )->SetText( UnstackString( aTitle ) );
		}

		long nOldHeight = GetOutputSize(*((SdrTextObj *)pTitleObj)).Height();

		SetTextAttr(*((SdrTextObj *) pTitleObj),*pAttr);
		return nOldHeight != GetOutputSize(*((SdrTextObj *)pTitleObj)).Height();
	}
}

/*************************************************************************
|*
|* Aendere die Attribute einer Achse
|*
\************************************************************************/

BOOL ChartModel::SetAllTitleAttributes(const SfxItemSet &rAttr)
{
	SdrPage          *pPage=GetPage(0);
	if (!pPage) return FALSE;
	else
	{
		BOOL               bBuildChart = FALSE;
		const SfxPoolItem  *pPoolItem  = NULL;
		SvxChartTextOrient eOldOrient  = (rAttr.GetItemState(SCHATTR_TEXT_ORIENT, TRUE, &pPoolItem) == SFX_ITEM_SET)
											 ? ((const SvxChartTextOrientItem*)pPoolItem)->GetValue()
											 : CHTXTORIENT_AUTOMATIC;

		if (bShowMainTitle)
			if (TitleOrientChanged ((SdrTextObj*)GetObjWithId(CHOBJID_TITLE_MAIN, *pPage), pMainTitleAttr,
									 eOldOrient,
									((const SvxChartTextOrientItem&)pMainTitleAttr->Get(SCHATTR_TEXT_ORIENT)).GetValue()))
				bBuildChart = TRUE;

		if (!bBuildChart && bShowSubTitle)
			if (TitleOrientChanged ((SdrTextObj*)GetObjWithId(CHOBJID_TITLE_SUB, *pPage), pSubTitleAttr,
									 eOldOrient,
									((const SvxChartTextOrientItem&)pSubTitleAttr->Get(SCHATTR_TEXT_ORIENT)).GetValue()))
				bBuildChart = TRUE;

		if (!bBuildChart)
		{
			SdrObjGroup *pGroup = (SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM, *pPage);
			SdrObjList  *pList  = pGroup->GetSubList();

			if (bShowXAxisTitle)
				if (Is3DChart() ||                                                                     //TVMNEW: DEEP unoetig
					TitleOrientChanged ((SdrTextObj*)GetObjWithId(CHOBJID_DIAGRAM_TITLE_X_AXIS, *pPage) // 0,IM_DEEPWITHGROUPS)
																  , pXAxisTitleAttr, eOldOrient,
										((const SvxChartTextOrientItem&)pXAxisTitleAttr->Get(SCHATTR_TEXT_ORIENT)).GetValue()))
					bBuildChart = TRUE;

			if (!bBuildChart && bShowYAxisTitle)
				if (Is3DChart() ||
					TitleOrientChanged ((SdrTextObj*)GetObjWithId(CHOBJID_DIAGRAM_TITLE_Y_AXIS, *pPage)//0,IM_DEEPWITHGROUPS)
																  , pYAxisTitleAttr, eOldOrient,
										((const SvxChartTextOrientItem&)pYAxisTitleAttr->Get(SCHATTR_TEXT_ORIENT)).GetValue()))
					bBuildChart = TRUE;

			if (!bBuildChart && Is3DChart() && bShowZAxisTitle)
				if (Is3DChart() ||
					TitleOrientChanged ((SdrTextObj*)GetObjWithId(CHOBJID_DIAGRAM_TITLE_Z_AXIS, *pPage) // 0,IM_DEEPWITHGROUPS)
																  , pZAxisTitleAttr,eOldOrient,
										((const SvxChartTextOrientItem&)pZAxisTitleAttr->Get(SCHATTR_TEXT_ORIENT)).GetValue()))
					bBuildChart = TRUE;
		}

		if (bBuildChart) BuildChart(FALSE);
		return TRUE;
	}
}

