/*************************************************************************
 *
 *  $RCSfile: AccLegend.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: bm $ $Date: 2002/11/21 15:34:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "AccLegend.hxx"

// for SolarMutex
#ifndef _SV_SVAPP_HXX 
#include <vcl/svapp.hxx>
#endif

#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif

#include "AccLegendEntry.hxx"

using ::rtl::OUString;

namespace accessibility
{

Legend::Legend( AccessibleBase * pParent ) :
        AccessibleChartElement( AccessibleUniqueId( CHOBJID_LEGEND ),
                                pParent,
                                true /* may have children */ ),
    m_nEntries( 0 )
{
    ChartModel * pModel = GetChartModel();
    OSL_ASSERT( pModel );

    // /-- solar
    ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
    SetItemSet( pModel->GetLegendAttr() );
    // \-- solar
}

Legend::~Legend()
{}

// OUString SAL_CALL Legend::getAccessibleName()
//     throw (::com::sun::star::uno::RuntimeException)
// {
//     return OUString( RTL_CONSTASCII_USTRINGPARAM( "Legend" ) );
// }

bool Legend::UpdateChildren()
{
    ChartModel * pModel = GetChartModel();
    sal_uInt16 nNumChildren = 0;

    bool bHasDomain = false;
    bool bIsPieChart = false;
    
    {
        // /-- solar
        ::vos::OClearableGuard aSolarGuard( Application::GetSolarMutex() );
        bHasDomain = (pModel && pModel->IsXYChart());
        bIsPieChart = (pModel && pModel->IsPieChart());

        nNumChildren = static_cast< sal_uInt16 >( bIsPieChart
                                                  ? pModel->GetColCount()
                                                  : pModel->GetRowCount() );
        if( bHasDomain )
        {
            OSL_ASSERT( ! bIsPieChart );
            --nNumChildren;
        }
        // \-- solar
    }

    // /--
    ::osl::ResettableMutexGuard aGuard( GetMutex());
    sal_uInt16 nEntry = 0;
    sal_uInt16 nMemberEntries = m_nEntries;
    sal_uInt16 nOffset = bHasDomain ? 1 : 0;

    aGuard.clear();
    // \--

    // remove legend entries
    for( nEntry = nNumChildren; nEntry < nMemberEntries; ++nEntry )
    {
        UpdateChild( AccessibleUniqueId( LegendEntry::ObjectId, nEntry + nOffset ),
                     true, false );
    }

    // add legend entries
    for( nEntry = nMemberEntries; nEntry < nNumChildren; ++nEntry )
    {
        UpdateChild( AccessibleUniqueId( LegendEntry::ObjectId, nEntry + nOffset ),
                     false, true );
    }

    // /--
    aGuard.reset();

    m_nEntries = nNumChildren;
    return true;
    // \--
}

OUString SAL_CALL Legend::getImplementationName() 
    throw (::com::sun::star::uno::RuntimeException)
{
    return OUString( RTL_CONSTASCII_USTRINGPARAM( "AccLegend" ));
}

}  // namespace accessibility
