/*************************************************************************
 *
 *  $RCSfile: fuinsaxi.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: af $ $Date: 2001/05/11 15:37:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CTRLTOOL_HXX //autogen
#include <svtools/ctrltool.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif
#include <svx/flstitem.hxx>
#ifndef _SFX_OBJSH_HXX //autogen
#include <sfx2/objsh.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <sfx2/request.hxx>
#endif

#pragma hdrstop

#include "app.hrc"
#include "schresid.hxx"
#include "schdll.hxx"
#include "strings.hrc"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "viewshel.hxx"
#include "axisgrid.hxx"
#include "uninsaxi.hxx"
#include "undatrow.hxx"
#include "fuinsaxi.hxx"

TYPEINIT1(SchFuInsertAxis, SchFuPoor);

#include "chaxis.hxx"

// ============================================================
//
// class SchFuInsertAxis
//
// ============================================================

SchFuInsertAxis::SchFuInsertAxis( SchViewShell* pViewSh,
								  SchWindow* pWin, SchView* pView,
								  ChartModel* pDoc,
								  SfxRequest& rReq ) :
		SchFuPoor( pViewSh, pWin, pView, pDoc, rReq )
{
	nMarkedID           = 0;

	BOOL bOldXAxis		= pDoc->ShowXAxis();
	BOOL bOldYAxis		= pDoc->ShowYAxis();
	BOOL bOldZAxis		= pDoc->ShowZAxis();
	BOOL bOld2YAxis		= pDoc->GetAxisByUID(CHART_AXIS_SECONDARY_Y)->IsVisible();
	BOOL bOld2XAxis		= pDoc->GetAxisByUID(CHART_AXIS_SECONDARY_X)->IsVisible();

	BOOL bOldXDescr		= pDoc->ShowXDescr();
	BOOL bOldYDescr		= pDoc->ShowYDescr();
	BOOL bOldZDescr		= pDoc->ShowZDescr();
	BOOL bOld2YDescr	= pDoc->GetAxisByUID(CHART_AXIS_SECONDARY_Y)->HasDescription();
	BOOL bOld2XDescr	= pDoc->GetAxisByUID(CHART_AXIS_SECONDARY_X)->HasDescription();

	const SfxItemSet* pArgs = rReq.GetArgs();

	if( !pArgs )
	{
		SfxItemSet aNewAttr( pViewSh->GetPool(), CHATTR_START, CHATTR_END );

		aNewAttr.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_X_AXIS, bOldXAxis ));
		aNewAttr.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Y_AXIS, bOldYAxis ));
		aNewAttr.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Z_AXIS, bOldZAxis ));
		aNewAttr.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_2Y_AXIS, bOld2YAxis ));
		aNewAttr.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_2X_AXIS, bOld2XAxis ));

		aNewAttr.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_X_DESCR, bOldXDescr ));
		aNewAttr.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Y_DESCR, bOldYDescr ));
		aNewAttr.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Z_DESCR, bOldZDescr ));
		aNewAttr.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_2X_DESCR, bOld2XDescr ));
		aNewAttr.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_2Y_DESCR, bOld2YDescr ));

		SchAxisDlg* pDlg = new SchAxisDlg( NULL,
										   aNewAttr, pDoc->Is3DChart(), pDoc->IsNetChart (),
										   pDoc->CanAxis( CHART_AXIS_SECONDARY_X ),
										   pDoc->CanAxis( CHART_AXIS_SECONDARY_Y ) );

		if( pDlg->Execute() == RET_OK )
		{
			pDlg->GetAttr( aNewAttr );
			rReq.Done( aNewAttr );
			pArgs = rReq.GetArgs();
			delete pDlg;
		}
		else
		{
			delete pDlg;
			return;
		}

		pChDoc->CanRebuild( TRUE );
	}
	else pChDoc->CanRebuild( FALSE );

	pViewSh->GetViewFrame()->GetDispatcher()->Execute( SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON );

	BOOL bNewXAxis		= ((const SfxBoolItem&)pArgs->
							Get(CHATTR_AXISGRID_SHOW_X_AXIS)).GetValue();
	BOOL bNewYAxis		= ((const SfxBoolItem&)pArgs->
							Get(CHATTR_AXISGRID_SHOW_Y_AXIS)).GetValue();
	BOOL bNewZAxis		= ((const SfxBoolItem&)pArgs->
							Get(CHATTR_AXISGRID_SHOW_Z_AXIS)).GetValue();
	BOOL bNew2YAxis		= ((const SfxBoolItem&)pArgs->
							Get(CHATTR_AXISGRID_SHOW_2Y_AXIS)).GetValue();
	BOOL bNew2XAxis		= ((const SfxBoolItem&)pArgs->
							Get(CHATTR_AXISGRID_SHOW_2X_AXIS)).GetValue();

	BOOL bNewXDescr		= ((const SfxBoolItem&)pArgs->
							Get(CHATTR_AXISGRID_SHOW_X_DESCR)).GetValue();
	BOOL bNewYDescr		= ((const SfxBoolItem&)pArgs->
							Get(CHATTR_AXISGRID_SHOW_Y_DESCR)).GetValue();
	BOOL bNewZDescr		= ((const SfxBoolItem&)pArgs->
							Get(CHATTR_AXISGRID_SHOW_Z_DESCR)).GetValue();
	BOOL bNew2YDescr	= ((const SfxBoolItem&)pArgs->
							Get(CHATTR_AXISGRID_SHOW_2Y_DESCR)).GetValue();
	BOOL bNew2XDescr	= ((const SfxBoolItem&)pArgs->
							Get(CHATTR_AXISGRID_SHOW_2X_DESCR)).GetValue();
	//	If the visibility of one of the axes changed, add the necessary
	//	undo actions.

	//	Remember the item sets of data series that are attached to the
	//	second y-axis.  They are needed for undo actions later.
	SfxItemSet ** pOldAttrAtY2 = NULL;
	if (bOld2YAxis && ! bNew2YAxis)
	{
		pOldAttrAtY2 = new SfxItemSet* [pDoc->GetRowCount()];
		for (int nRow=0; nRow<pDoc->GetRowCount(); nRow++)
			if (static_cast<const SfxInt32Item&>(
					pDoc->GetDataRowAttr(nRow).Get(SCHATTR_AXIS)).GetValue()
				== CHAXIS_AXIS_B)
			pOldAttrAtY2[nRow] = new SfxItemSet (pDoc->GetDataRowAttr (nRow));
		else
			pOldAttrAtY2[nRow] = NULL;
	}
	
	if( pDoc->ChangeAxis( bNewXAxis, bNewXDescr,
						  bNewYAxis, bNewYDescr,
						  bNewZAxis, bNewZDescr,
						  bNew2YAxis,bNew2YDescr,
						  bNew2XAxis,bNew2XDescr ) )
	{
		String sUndoComment (SchResId( STR_UNDO_INSERT_AXIS ));
		
		SchUndoInsertAxis* pUndo =
			new SchUndoInsertAxis (*pDoc,
								   pDoc->ShowXAxis(), bOldXDescr,
								   bOldYAxis, bOldYDescr,
								   bOldZAxis, bOldZDescr,
								   bOld2YAxis,bOld2YDescr,
								   bOld2XAxis,bOld2XDescr,

								   bNewXAxis, bNewXDescr,
								   bNewYAxis, bNewYDescr,
								   bNewZAxis, bNewZDescr,
								   bNew2YAxis,bNew2YDescr,
								   bNew2XAxis,bNew2XDescr );
		pUndo->SetComment (sUndoComment);

		//	Start a undo list action so that all undo actions created in this
		//	method are executed together in a single step.
		pViewShell->GetViewFrame()->GetObjectShell()->GetUndoManager()
			->EnterListAction (sUndoComment, sUndoComment);
		pViewShell->GetViewFrame()->GetObjectShell()->GetUndoManager()
			->AddUndoAction (pUndo);
			
		//	If the secondary y-axis has just vanished then add undo
		//	actions for all data series attached to this axis in order
		//	to reattach them when an undo takes place.
		BOOL	bNeedRebuild = FALSE;
		if (pOldAttrAtY2 != NULL)
		{
			for (int nRow=0; nRow<pDoc->GetRowCount(); nRow++)
				if (pOldAttrAtY2[nRow] != NULL)
				{
					SchUndoDataRow * pUndoY2 = new SchUndoDataRow (
						*pDoc,
						nRow,
						*pOldAttrAtY2[nRow],
						pDoc->GetDataRowAttr (nRow));
					pUndoY2->SetComment (sUndoComment);
					pViewShell->GetViewFrame()->GetObjectShell()
						->GetUndoManager()->AddUndoAction (pUndoY2);
					delete pOldAttrAtY2[nRow];
				}
			delete pOldAttrAtY2;
		}
		
		pViewShell->GetViewFrame()->GetObjectShell()->GetUndoManager()
			->LeaveListAction ();
			
		if (bNeedRebuild)
			pDoc->BuildChart (FALSE);
	}

	RemarkObject ();
}

void SchFuInsertAxis::Activate()
{
}

void SchFuInsertAxis::Deactivate()
{
}

// ============================================================
//
// class SchFuInsertGrid
//
// ============================================================

TYPEINIT1(SchFuInsertGrid, SchFuPoor);

SchFuInsertGrid::SchFuInsertGrid( SchViewShell* pViewSh,
								  SchWindow* pWin, SchView* pView,
								  ChartModel* pDoc,
								  SfxRequest& rReq ) :
		SchFuPoor( pViewSh, pWin, pView, pDoc, rReq )
{
	nMarkedID           = 0;

	BOOL bOldXGridMain	= pDoc->ShowXGridMain();
	BOOL bOldXGridHelp	= pDoc->ShowXGridHelp();
	BOOL bOldYGridMain	= pDoc->ShowYGridMain();
	BOOL bOldYGridHelp	= pDoc->ShowYGridHelp();
	BOOL bOldZGridMain	= pDoc->ShowZGridMain();
	BOOL bOldZGridHelp	= pDoc->ShowZGridHelp();

	const SfxItemSet* pArgs = rReq.GetArgs();

	if (!pArgs)
	{
		SfxItemSet aNewAttr( pViewSh->GetPool(), CHATTR_START,CHATTR_END );

		aNewAttr.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_X_MAIN, bOldXGridMain ));
		aNewAttr.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_X_HELP, bOldXGridHelp ));
		aNewAttr.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Y_MAIN, bOldYGridMain ));
		aNewAttr.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Y_HELP, bOldYGridHelp ));
		aNewAttr.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Z_MAIN, bOldZGridMain ));
		aNewAttr.Put( SfxBoolItem( CHATTR_AXISGRID_SHOW_Z_HELP, bOldZGridHelp ));
		
		SchGridDlg* pDlg = new SchGridDlg( NULL,
										   aNewAttr, pDoc->Is3DChart(), pDoc->IsNetChart (),
										   pDoc->CanAxis( CHART_AXIS_SECONDARY_X ),
										   pDoc->CanAxis( CHART_AXIS_SECONDARY_Y ) );

		if(pDlg->Execute() == RET_OK)
		{
			pDlg->GetAttr(aNewAttr);
			rReq.Done(aNewAttr);
			pArgs = rReq.GetArgs();
			delete pDlg;
		}
		else
		{
			delete pDlg;
			return;
		}

		pChDoc->CanRebuild (TRUE);
	}
	else pChDoc->CanRebuild (FALSE);

	pViewSh->GetViewFrame()->GetDispatcher()->Execute(SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON);

	BOOL bNewXGridMain	= ((const SfxBoolItem&)pArgs->
							Get(CHATTR_AXISGRID_SHOW_X_MAIN)).GetValue();
	BOOL bNewXGridHelp	= ((const SfxBoolItem&)pArgs->
							Get(CHATTR_AXISGRID_SHOW_X_HELP)).GetValue();
	BOOL bNewYGridMain	= ((const SfxBoolItem&)pArgs->
							Get(CHATTR_AXISGRID_SHOW_Y_MAIN)).GetValue();
	BOOL bNewYGridHelp	= ((const SfxBoolItem&)pArgs->
							Get(CHATTR_AXISGRID_SHOW_Y_HELP)).GetValue();
	BOOL bNewZGridMain	= ((const SfxBoolItem&)pArgs->
							Get(CHATTR_AXISGRID_SHOW_Z_MAIN)).GetValue();
	BOOL bNewZGridHelp	= ((const SfxBoolItem&)pArgs->
							Get(CHATTR_AXISGRID_SHOW_Z_HELP)).GetValue();

	if( pDoc->ChangeGrid( bNewXGridMain, bNewXGridHelp,
						  bNewYGridMain, bNewYGridHelp,
						  bNewZGridMain, bNewZGridHelp, TRUE ) )
	{
		SchUndoInsertGrid* pUndo =
			new SchUndoInsertGrid( *pDoc,
								   bOldXGridMain, bOldXGridHelp,
								   bOldYGridMain, bOldYGridHelp,
								   bOldZGridMain, bOldZGridHelp,
								   bNewXGridMain, bNewXGridHelp,
								   bNewYGridMain, bNewYGridHelp,
								   bNewZGridMain, bNewZGridHelp );

		pUndo->SetComment(String(SchResId( STR_UNDO_INSERT_GRID )));

		pViewSh->GetViewFrame()->GetObjectShell()->
			GetUndoManager()->AddUndoAction(pUndo);
	}

	RemarkObject ();
}

void SchFuInsertGrid::Activate()
{
}

void SchFuInsertGrid::Deactivate()
{
}

