/*************************************************************************
 *
 *  $RCSfile: futext.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2003/04/24 14:58:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


//#define SI_NOITEMS
#define SI_NODRW
#define _SI_NOSBXCONTROLS
#define _SI_NOOTHERFORMS
#define _SI_NOCONTROL
#define _SI_NOSBXCONTROLS

//svdraw.hxx
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
#define _SDR_NOVIEWMARKER
#define _SDR_NODRAGMETHODS
#define _SDR_NOUNDO
#define _SDR_NOXOUTDEV


#pragma hdrstop

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include <svx/flstitem.hxx>

#ifndef _CTRLTOOL_HXX //autogen
#include <svtools/ctrltool.hxx>
#endif
#ifndef _SFX_BINDINGS_HXX //autogen
#include <sfx2/bindings.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif
#ifndef _SFX_PRINTER_HXX
#include <sfx2/printer.hxx>
#endif
#ifndef _SVDOUTL_HXX
#include <svx/svdoutl.hxx>
#endif

#include <svx/svdetc.hxx>




#include "chwindow.hxx"
#include "app.hrc"
#include "strings.hrc"
#include "schresid.hxx"
#include "eetext.hxx"
#include "unedtit.hxx"
#include "uninstit.hxx"
#include "futext.hxx"
#include "viewshel.hxx"
#include "schview.hxx"
#include "objid.hxx"

TYPEINIT1(SchFuText, SchFuDraw);


/*************************************************************************
|*
|* Basisklasse fuer Textfunktionen
|*
\************************************************************************/

SchFuText::SchFuText(SchViewShell* pViewSh, SchWindow* pWin, SchView* pView,
					 ChartModel* pDoc, SfxRequest& rReq) :
	SchFuDraw(pViewSh, pWin, pView, pDoc, rReq),
	pTextObj(NULL),
	pOutlinerParaObject(NULL)
{
	StartEditMode();
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchFuText::~SchFuText()
{
	EndEditMode();
}

/*************************************************************************
|*
|* Tastaturereignisse bearbeiten
|*
|* Wird ein KeyEvent bearbeitet, so ist der Return-Wert TRUE, andernfalls
|* FALSE.
|*
\************************************************************************/

BOOL SchFuText::KeyInput(const KeyEvent& rKEvt)
{
	BOOL bReturn = FALSE;

	KeyCode nCode = rKEvt.GetKeyCode();
	BOOL bShift = nCode.IsShift();

	USHORT nKey = nCode.GetCode();
	KeyCode aKeyCode (nKey, bShift, nCode.IsMod1(), nCode.IsMod2());
	KeyEvent aKEvt(rKEvt.GetCharCode(), aKeyCode);

	if (pView->KeyInput(aKEvt, pWindow))
	{
		bReturn = TRUE;

		SfxBindings& rBindings = pViewShell->GetViewFrame()->GetBindings();

		rBindings.Invalidate(SID_CUT);
		rBindings.Invalidate(SID_COPY);
	}
	else if (rKEvt.GetKeyCode().GetCode() == KEY_ESCAPE &&
			 EndEditMode())
	{
		ForcePointer();
		pViewShell->GetViewFrame()->GetDispatcher()->Execute(
			SID_TOOL_SELECT, SFX_CALLMODE_ASYNCHRON );
		bReturn = TRUE;
	}
	else
		bReturn = SchFuDraw::KeyInput(aKEvt);

	return bReturn;
}

/*************************************************************************
|*
|* MouseButtonDown-event
|*
\************************************************************************/

BOOL SchFuText::MouseButtonDown(const MouseEvent& rMEvt)
{
	bMBDown = TRUE;

	BOOL bReturn = SchFuDraw::MouseButtonDown(rMEvt);

	// Fuer PopupMenu (vorher DrawViewShell)
	if ((rMEvt.GetButtons() == MOUSE_RIGHT) &&
		 rMEvt.GetClicks() == 1 && pView->IsTextEdit())
		return TRUE;

	if (pView->MouseButtonDown(rMEvt, pWindow))
		return TRUE;				   // Event von der SdrView ausgewertet

	// clicked in outer region
	EndEditMode();
	pViewShell->GetViewFrame()->GetDispatcher()->Execute( SID_TOOL_SELECT, SFX_CALLMODE_ASYNCHRON );

	ForcePointer(&rMEvt);

	SfxBindings& rBindings = pViewShell->GetViewFrame()->GetBindings();

	rBindings.Invalidate(SID_CUT);
	rBindings.Invalidate(SID_COPY);

	return bReturn;
}

/*************************************************************************
|*
|* MouseMove-event
|*
\************************************************************************/

BOOL SchFuText::MouseMove(const MouseEvent& rMEvt)
{
	BOOL bReturn = SchFuDraw::MouseMove(rMEvt);

	if (pView->MouseMove(rMEvt, pWindow))
		// Event von der SdrView ausgewertet
		bReturn = TRUE;

	ForcePointer(&rMEvt);

	return bReturn;
}

/*************************************************************************
|*
|* MouseButtonUp-event
|*
\************************************************************************/

BOOL SchFuText::MouseButtonUp(const MouseEvent& rMEvt)
{
	SfxBindings& rBindings = pViewShell->GetViewFrame()->GetBindings();

	rBindings.Invalidate(SID_CUT);
	rBindings.Invalidate(SID_COPY);

	if (pView->MouseButtonUp(rMEvt, pWindow))
		return TRUE; // Event von der SdrView ausgewertet

	pWindow->ReleaseMouse();

	if (rMEvt.GetClicks() == 2 && rMEvt.IsLeft() && bMBDown &&
		!rMEvt.IsMod1() && !rMEvt.IsMod2() && !rMEvt.IsShift())
		DoubleClick();

	bMBDown = FALSE;

	return SchFuDraw::MouseButtonUp(rMEvt);
}

/*************************************************************************
|*
|* Command-event
|*
\************************************************************************/

BOOL SchFuText::Command(const CommandEvent& rCEvt)
{
	return SchFuPoor::Command( rCEvt );
}

/*************************************************************************
|*
|* Funktion aktivieren
|*
\************************************************************************/

void SchFuText::Activate()
{
	OutlinerView* pOLV = pView->GetTextEditOutlinerView();

	if (pOLV)
		pOLV->ShowCursor();

	SchFuDraw::Activate();
}

/*************************************************************************
|*
|* Funktion deaktivieren
|*
\************************************************************************/

void SchFuText::Deactivate()
{
	OutlinerView* pOLV = pView->GetTextEditOutlinerView();

	if (pOLV)
		pOLV->HideCursor();

	EndEditMode ();

	SchFuDraw::Deactivate();
}

/*************************************************************************
|*
|* Maus-Pointer umschalten
|*
\************************************************************************/

void SchFuText::ForcePointer(const MouseEvent* pMEvt)
{
	if (pView->IsTextEdit())
	{
		Point aPnt;

		if (pMEvt)
			aPnt = pWindow->PixelToLogic(pMEvt->GetPosPixel());
		else
			aPnt = pWindow->PixelToLogic(pWindow->GetPointerPosPixel());

		if (pTextObj->GetBoundRect().IsInside(aPnt))
		{
			pWindow->SetPointer(pView->GetPreferedPointer(aPnt, pWindow));
			return;
		}
	}

	pWindow->SetPointer(aOldPointer);
}

/*************************************************************************
|*
|* Edit-Mode starten
|* Liefert TRUE, wenn der Editiermodus gestartet wurde
|*
\************************************************************************/

BOOL SchFuText::StartEditMode()
{
	if (!pView->IsTextEdit())
	{
		pTextObj = NULL;

		if (pView->HasMarkedObj())
		{
			const SdrMarkList& rMarkList = pView->GetMarkList();

			if (rMarkList.GetMarkCount() == 1)
			{
				SdrMark* pMark = rMarkList.GetMark(0);
				SdrObject* pObj = pMark->GetObj();

				SchObjectId* pObjId = GetObjectId(*pObj);

				if (pObjId)
				{
					USHORT nId = pObjId->GetObjId();

					switch (nId)
					{
						case CHOBJID_TITLE_MAIN:
						case CHOBJID_TITLE_SUB:
						case CHOBJID_DIAGRAM_TITLE_X_AXIS:
						case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
						case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
							if (pObj->HasTextEdit())
							{
								pTextObj = (SdrTextObj*)pObj;
								pChDoc->PrepareEdit(*pTextObj);

								aTextRect = pObj->GetLogicRect();

								// neuen Outliner machen; gehoert der SdrObjEditView

								SdrOutliner* pOutliner = SdrMakeOutliner( OUTLINERMODE_TEXTOBJECT, pChDoc );

								pOutliner->SetRefDevice(
                                    static_cast< SchChartDocShell * >( pChDoc->GetObjectShell() )->GetRefDevice() );

								pOutliner->SetStyleSheetPool((SfxStyleSheetPool*)
												 pChDoc->GetStyleSheetPool());

								if (pView->BegTextEdit
										(pTextObj, pView->GetPageViewPvNum(0),
										 pWindow, TRUE, pOutliner))//NULL
									pView->SetEditMode();
							}
							break;
					}
				}
			}
		}

		return TRUE;
	}

	return FALSE;
}

/*************************************************************************
|*
|* Edit-Mode beenden
|* Liefert TRUE, wenn der Editiermodus beendet wurde
|*
\************************************************************************/

BOOL SchFuText::EndEditMode()
{
	BOOL bReturn;

	if (pView->IsTextEdit())
	{
		BOOL bAuto=pChDoc->SetAttrAutoStorage(FALSE);
		pView->EndTextEdit();
		pChDoc->SetAttrAutoStorage(bAuto);
		bReturn = TRUE;
	}
	else
		bReturn = FALSE;

	if (pTextObj)
	{
		SdrOutliner* pOutliner = pChDoc->GetOutliner();

		// the OutlinerParaObject may by NULL if an empty text has been entered
		OutlinerParaObject* pParaObj = pTextObj->GetOutlinerParaObject();
		if( pParaObj )
			pOutliner->SetText( *pParaObj );

		String aString =
			pOutliner->GetText(pOutliner->GetParagraph( 0 ),
							   pOutliner->GetParagraphCount());
		pOutliner->Clear();

		SchObjectId* pObjId = GetObjectId(*pTextObj);

		if( pObjId )
		{
			USHORT nId = pObjId->GetObjId();

			String aOldMain		= pChDoc->MainTitle();
			String aOldSub		= pChDoc->SubTitle();
			String aOldXAxis	= pChDoc->XAxisTitle();
			String aOldYAxis	= pChDoc->YAxisTitle();
			String aOldZAxis	= pChDoc->ZAxisTitle();

			String aNewMain		= aOldMain;
			String aNewSub		= aOldSub;
			String aNewXAxis	= aOldXAxis;
			String aNewYAxis	= aOldYAxis;
			String aNewZAxis	= aOldZAxis;

			BOOL bOldShowMain	= pChDoc->ShowMainTitle();
			BOOL bOldShowSub 	= pChDoc->ShowSubTitle();
			BOOL bOldShowXAxis	= pChDoc->ShowXAxisTitle();
			BOOL bOldShowYAxis	= pChDoc->ShowYAxisTitle();
			BOOL bOldShowZAxis	= pChDoc->ShowZAxisTitle();

			BOOL bNewShowMain	= bOldShowMain;
			BOOL bNewShowSub	= bOldShowSub;
			BOOL bNewShowXAxis	= bOldShowXAxis;
			BOOL bNewShowYAxis	= bOldShowYAxis;
			BOOL bNewShowZAxis	= bOldShowZAxis;

			BOOL bStringEmpty	= (aString.Len() == 0);

			if( ! bStringEmpty )
			{
                // #102159# SetItemSet will result in setting the Title member
                // of the ChartModel from the outliner content if auto-storage
                // is true
                BOOL bOldAutoStorage = pChDoc->SetAttrAutoStorage( FALSE );

                BOOL bAutoGrowHeight = pTextObj->IsAutoGrowHeight();
				SfxItemSet aAttr(pChDoc->GetPool(), SDRATTR_TEXT_AUTOGROWHEIGHT,
								 SDRATTR_TEXT_AUTOGROWHEIGHT);
				aAttr.Put(SdrTextAutoGrowHeightItem(FALSE));
                pTextObj->SetItemSet(aAttr);

                pTextObj->NbcSetLogicRect(aTextRect);
				aAttr.Put(SdrTextAutoGrowHeightItem(bAutoGrowHeight));
                pTextObj->SetItemSet(aAttr);

                pChDoc->SetAttrAutoStorage( bOldAutoStorage );
			}

			switch( nId )
			{
				case CHOBJID_TITLE_MAIN:
					if( bStringEmpty )
						bNewShowMain = FALSE;
					else
						aNewMain = aString;
					break;
				case CHOBJID_TITLE_SUB:
					if( bStringEmpty )
						bNewShowSub = FALSE;
					else
						aNewSub = aString;
					break;
				case CHOBJID_DIAGRAM_TITLE_X_AXIS:
					if( bStringEmpty )
						bNewShowXAxis = FALSE;
					else
						aNewXAxis = aString;
					break;
				case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
					if( bStringEmpty )
						bNewShowYAxis = FALSE;
					else
						aNewYAxis = aString;
					break;
				case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
					if( bStringEmpty )
						bNewShowZAxis = FALSE;
					else
						aNewZAxis = aString;
					break;
			}

			if( pChDoc->ChangeTitle( bNewShowMain,	aNewMain,
									 bNewShowSub,	aNewSub,
									 bNewShowXAxis,	aNewXAxis,
									 bNewShowYAxis,	aNewYAxis,
									 bNewShowZAxis,	aNewZAxis ))
			{
				SchUndoAction* pUndo;

				if( bStringEmpty )
				{
					// give the old strings as new strings. This way when activating
					// the title again the string last used is taken
					pUndo = new SchUndoInsertTitle(
						*pChDoc,
						bOldShowMain,  aOldMain,	bOldShowSub,   aOldSub,
						bOldShowXAxis, aOldXAxis,	bOldShowYAxis, aOldYAxis,
						bOldShowZAxis, aOldZAxis,
						bNewShowMain,  aOldMain,	bNewShowSub,   aOldSub,
						bNewShowXAxis, aOldXAxis,	bNewShowYAxis, aOldYAxis,
						bNewShowZAxis, aOldZAxis );

					pUndo->SetComment( String( SchResId( STR_UNDO_INSERT_TITLE )));
				}
				else
				{
					pUndo = new SchUndoEditTitle(
						*pChDoc,
						aOldMain, aOldSub, aOldXAxis, aOldYAxis, aOldZAxis,
						aNewMain, aNewSub, aNewXAxis, aNewYAxis, aNewZAxis );

					pUndo->SetComment( String( SchResId( STR_UNDO_EDIT_TITLE )));
				}

				pViewShell->GetViewFrame()->GetObjectShell()->
					GetUndoManager()->AddUndoAction( pUndo );
			}
			else
				pChDoc->CommitEdit( *pTextObj );
		}

		pTextObj = NULL;

		// die RequestHandler der benutzten Outliner zuruecksetzen auf den
		// Handler am Dokument

		pOutliner = pView->GetTextEditOutliner();
		if (pOutliner)
			pOutliner->SetStyleSheetPool
				((SfxStyleSheetPool*)pChDoc->GetStyleSheetPool());
	}

	return bReturn;
}


