/*************************************************************************
 *
 *  $RCSfile: ChXChartView.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: bm $ $Date: 2002/03/25 09:36:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CHART_VIEW_HXX
#define _CHART_VIEW_HXX

#ifndef _COM_SUN_STAR_VIEW_XSELECTIONSUPPLIER_HPP_
#include <com/sun/star/view/XSelectionSupplier.hpp>
#endif
#ifndef _SFX_SFXBASECONTROLLER_HXX_
#include <sfx2/sfxbasecontroller.hxx>
#endif
#ifndef _CPPUHELPER_INTERFACECONTAINER_HXX_
#include <cppuhelper/interfacecontainer.hxx>
#endif
#ifndef _CPPUHELPER_PROPSHLP_HXX
#include <cppuhelper/propshlp.hxx>
#endif

#include "ViewPropertySet.hxx"

class SchViewShell;

class ChXChartView :
	public ::com::sun::star::view::XSelectionSupplier,
    // provides XController, XComponent
	public SfxBaseController,
    public ViewPropertySet
{
private:
    ::osl::Mutex m_aViewMutex;

    SchViewShell*	 mpViewShell;
	::com::sun::star::uno::Sequence< com::sun::star::uno::Type > maTypeSequence;
    ::cppu::OBroadcastHelper  maSelectionListenerManager;

public:
	ChXChartView( SchViewShell* pSchViewShell );
	virtual ~ChXChartView();

    /** this method should be called (from the core) whenever the current
        selection has changed.  It will then notify all selection change
        listeners registered at this view
     */
	void fireSelectionChangeListener() throw();

	// XSelectionSupplier
    virtual sal_Bool SAL_CALL select( const ::com::sun::star::uno::Any& aSelection )
		throw( com::sun::star::lang::IllegalArgumentException,
			   com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Any SAL_CALL getSelection()
		throw( com::sun::star::uno::RuntimeException );
    virtual void SAL_CALL addSelectionChangeListener(
		const ::com::sun::star::uno::Reference< ::com::sun::star::view::XSelectionChangeListener >& xListener )
		throw( com::sun::star::uno::RuntimeException );
    virtual void SAL_CALL removeSelectionChangeListener(
		const ::com::sun::star::uno::Reference< ::com::sun::star::view::XSelectionChangeListener >& xListener )
		throw( com::sun::star::uno::RuntimeException );

	// XInterface
	virtual com::sun::star::uno::Any SAL_CALL queryInterface( const com::sun::star::uno::Type & rType )
		throw( com::sun::star::uno::RuntimeException );	
    virtual void SAL_CALL acquire() throw();
    virtual void SAL_CALL release() throw();

	// XTypeProvider ( ::SfxBaseController )
	virtual com::sun::star::uno::Sequence< ::com::sun::star::uno::Type > SAL_CALL getTypes()
		throw( com::sun::star::uno::RuntimeException );
    virtual com::sun::star::uno::Sequence< sal_Int8 > SAL_CALL getImplementationId()
		throw( com::sun::star::uno::RuntimeException );

    // XComponent ( ::XController::SfxBaseController )
	virtual void SAL_CALL dispose() throw( ::com::sun::star::uno::RuntimeException );
};

#endif	// _CHART_VIEW_HXX

