%{
#ifdef WNT
#include <stdarg.h>
namespace std {
int fprintf(FILE* stream, const char* format, ...)
{
    va_list va_param;

    va_start(va_param, format);
	int res = ::vfprintf(stream, format, va_param);
    va_end(va_param);

    return res;
}

void* malloc( size_t size )
{
    return ::malloc(size);
}

void free( void *memblock )
{
    ::free(memblock);
}
    
};
#endif
%}

%union {
	const char*			_pString;
	Parameter*			_pParameter;
	ParameterList*			_pParameterList;
	Object*				_pObject;
	ObjectList* 			_pObjectList;
}

/* Token */
%token <_pString>       WORD
%token <_pString>       END

%type <_pString>        value
%type <_pString>        wordlist
%type <_pParameter>     param
%type <_pParameterList> paramlist
%type <_pObject>        object
%type <_pObjectList>    objectlist

%start objectlist
%%

value:
WORD
{
	$$ = $1;
}
|
'(' wordlist ')'
{
	ByteString aRet = '(';
	aRet += $2;
	aRet += ')';
	$$ = strdup( aRet.GetBuffer() );
	free( (char*)$2 );
};


wordlist:
{
	$$ = strdup( "" );
}
|
WORD
{
	$$ = $1;
}
|
wordlist ',' WORD
{
	ByteString aRet = $1;
	aRet += ',';
	aRet += $3;
	$$ = strdup( aRet.GetBuffer() );
	free( (char*)$1 );
	free( (char*)$3 );
};


param:
value '=' value ';'
{
	Parameter* pParam = new Parameter;
	pParam->m_aKey = $1;
	pParam->m_aValue = $3;
	free( (char*)$1 );
	free( (char*)$3 );
	$$ = pParam;
}
|
WORD value '=' value ';'
{
	Parameter* pParam = new Parameter;
	pParam->m_aKey = $1;
	pParam->m_aLanguage = $2;
	pParam->m_aValue = $4;
	free( (char*)$1 );
	free( (char*)$2 );
	free( (char*)$4 );
	$$ = pParam;
};

paramlist:
param
{
	ParameterList* pList = new ParameterList;
	pList->Insert($1, LIST_APPEND);
	$$ = pList;
}
|
paramlist param
{
	$1->Insert($2, LIST_APPEND);
	$$ = $1;
};

object:
WORD WORD paramlist END
{
	Object* pObj = new Object;
	pObj->m_aType = $1;
	pObj->m_aId = $2;
	pObj->m_pParameters = $3;
	free( (char*)$1 );
	free( (char*)$2 );
	$$ = pObj;
};

objectlist:
object
{
	aObjectList.Insert($1, LIST_APPEND);
	$$ = &aObjectList;
}
|
objectlist object
{
	aObjectList.Insert($2, LIST_APPEND);
	$$ = &aObjectList;
};

