/*************************************************************************
 *
 *  $RCSfile: newfoil.cxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: ka $ $Date: 2002/08/01 11:29:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#ifndef _SFXITEMSET_HXX //autogen
#include <svtools/itemset.hxx>
#endif
#ifndef _AEITEM_HXX //autogen
#include <svtools/aeitem.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SVTOOLS_CJKOPTIONS_HXX
#include <svtools/languageoptions.hxx>
#endif
#ifndef _COM_SUN_STAR_TEXT_WRITINGMODE_HPP_ 
#include <com/sun/star/text/WritingMode.hpp>
#endif

#include "helpids.h"
#include "app.hrc"
#include "res_bmp.hrc"
#include "strings.hrc"
#include "sdresid.hxx"
#include "new_foil.hxx"
#include "new_foil.hrc"
#include "sdattr.hxx"
#include "docshell.hxx"
#include "drawdoc.hxx"

/************************************************************************/

#define MAX_AUTO_LAYOUT 25
static AutoLayout LayoutArray[ MAX_AUTO_LAYOUT ] =
{
	AUTOLAYOUT_NONE,
	AUTOLAYOUT_NONE,
	AUTOLAYOUT_TITLE,
	AUTOLAYOUT_ENUM,
	AUTOLAYOUT_2TEXT,
	AUTOLAYOUT_ONLY_TITLE,
	AUTOLAYOUT_OBJ,
	AUTOLAYOUT_CHART,
	AUTOLAYOUT_TAB,
	AUTOLAYOUT_CLIPTEXT,
	AUTOLAYOUT_TEXTCHART,
	AUTOLAYOUT_TEXTCLIP,
	AUTOLAYOUT_CHARTTEXT,
	AUTOLAYOUT_TEXTOBJ,
	AUTOLAYOUT_TEXT2OBJ,
	AUTOLAYOUT_OBJTEXT,
	AUTOLAYOUT_OBJOVERTEXT,
	AUTOLAYOUT_2OBJTEXT,
	AUTOLAYOUT_2OBJOVERTEXT,
	AUTOLAYOUT_TEXTOVEROBJ,
	AUTOLAYOUT_4OBJ,
//	AUTOLAYOUT_ORG,
	AUTOLAYOUT_VERTICAL_TITLE_TEXT_CHART,
	AUTOLAYOUT_VERTICAL_TITLE_VERTICAL_OUTLINE,
	AUTOLAYOUT_TITLE_VERTICAL_OUTLINE,
	AUTOLAYOUT_TITLE_VERTICAL_OUTLINE_CLIPART,
};

#define MAX_AUTO_HANDOUTLAYOUT 6
static AutoLayout HandoutLayoutArray[ MAX_AUTO_HANDOUTLAYOUT ] =
{
	AUTOLAYOUT_NONE,
	AUTOLAYOUT_HANDOUT1,
	AUTOLAYOUT_HANDOUT2,
	AUTOLAYOUT_HANDOUT3,
	AUTOLAYOUT_HANDOUT4,
	AUTOLAYOUT_HANDOUT6
};

#define MAX_AUTO_NOTESLAYOUT 2
static AutoLayout NotesLayoutArray[ MAX_AUTO_NOTESLAYOUT ] =
{
	AUTOLAYOUT_NONE, // nur Dummy, um nicht immer 1 addieren, bzw. subtrahieren zu muessen
	AUTOLAYOUT_NOTES
};

/*************************************************************************
|*
|* Dialog zur Auswahl eines Folienlayouts
|*
\************************************************************************/

SdNewFoilDlg::SdNewFoilDlg( Window* pWindow, const SfxItemSet& rInAttrs,
							PageKind ePgKind, SdDrawDocShell* pDocShell, BOOL bChangeFoil ) :
				ModalDialog         ( pWindow, SdResId( DLG_NEW_FOIL ) ),
				aEdtName            ( this, SdResId( EDT_NAME ) ),
				aFlName             ( this, SdResId( FL_NAME ) ),
				aFtLayout           ( this, SdResId( FT_LAYOUT ) ),
				aCtlLayout          ( this, SdResId( CTL_LAYOUT )),
				aCbxBackground      ( this, SdResId( CBX_BACKGROUND ) ),
				aCbxObjects         ( this, SdResId( CBX_OBJECTS ) ),
				aFlDisplay          ( this, SdResId( FL_DISPLAY ) ),
				aBtnDelete          ( this, SdResId( BTN_DELETE ) ),
				aBtnOK              ( this, SdResId( BTN_OK ) ),
				aBtnCancel          ( this, SdResId( BTN_CANCEL ) ),
				aBtnHelp            ( this, SdResId( BTN_HELP ) ),
				rOutAttrs			( rInAttrs ),
				ePageKind           ( ePgKind ),
				pDocSh              ( pDocShell )
{
	FreeResource();

	aCtlLayout.SetStyle( WB_3DLOOK | WB_BORDER | WB_ITEMBORDER | WB_TABSTOP |
	                     WB_DOUBLEBORDER | WB_VSCROLL | WB_FLATVALUESET );
	aCtlLayout.EnableFullItemMode( FALSE );

	if( bChangeFoil )
	{
		SetText( String( SdResId(STR_MODIFYPAGE) ) );
		SetHelpId( SID_MODIFYPAGE );
		aEdtName.SetHelpId(HID_SD_CHGFOIL_NAME);
		aCtlLayout.SetHelpId(HID_SD_CHGFOIL_LAYOUT);
		aCbxBackground.SetHelpId(HID_SD_CHGFOIL_BACKGROUND);
		aCbxObjects.SetHelpId(HID_SD_CHGFOIL_OBJECTS);
	}
	else
	{
		SetText( String( SdResId(STR_INSERTPAGE) ) );
		SetHelpId( SID_INSERTPAGE );
	}

	if (ePageKind == PK_NOTES)
	{
		aEdtName.Disable();
		aFlName.Disable();
		aCbxBackground.Disable();
		aBtnDelete.Disable();
	}
	else if (ePageKind == PK_HANDOUT)
	{
		aEdtName.Disable();
		aFlName.Disable();
		aCbxBackground.Disable();
		aCbxObjects.Disable();
		aBtnDelete.Disable();
		aFlDisplay.Disable();
	}

	aCtlLayout.SetStyle( aCtlLayout.GetStyle() | WB_ITEMBORDER | WB_DOUBLEBORDER | WB_VSCROLL | WB_NAMEFIELD | WB_FLATVALUESET );

	aCtlLayout.SetColCount( 4 );
	aCtlLayout.SetLineCount( 3 );
	aCtlLayout.SetExtraSpacing( 2 );
	
	ApplyImages();

	aCtlLayout.Show();

	aCtlLayout.SetDoubleClickHdl( LINK( this, SdNewFoilDlg, ClickLayoutHdl ) );
	aBtnCancel.SetClickHdl( LINK( this, SdNewFoilDlg, ClickCancelHdl ) );
	aBtnOK.SetClickHdl( LINK( this, SdNewFoilDlg, ClickLayoutHdl ) );

	// Wird z.Z. nicht unterstuetzt
	aBtnDelete.Hide();

	Reset();
}

/*************************************************************************
|*
|*	Dtor
|*
*************************************************************************/

SdNewFoilDlg::~SdNewFoilDlg()
{
}

/*************************************************************************
|*
|*	  Initialisierung
|*
*************************************************************************/

void SdNewFoilDlg::Reset()
{
	const SfxPoolItem *pPoolItem = NULL;

	if( rOutAttrs.GetItemState( ATTR_PAGE_NAME, TRUE, &pPoolItem ) == SFX_ITEM_SET )
		aEdtName.SetText( ( ( const SfxStringItem* ) pPoolItem )->GetValue() );

	if( rOutAttrs.GetItemState( ATTR_PAGE_BACKGROUND, TRUE, &pPoolItem ) == SFX_ITEM_SET )
		aCbxBackground.Check( ( ( const SfxBoolItem* ) pPoolItem )->GetValue() );

	if( rOutAttrs.GetItemState( ATTR_PAGE_OBJECTS, TRUE, &pPoolItem ) == SFX_ITEM_SET )
		aCbxObjects.Check( ( ( const SfxBoolItem* ) pPoolItem )->GetValue() );

	if( rOutAttrs.GetItemState( ATTR_PAGE_LAYOUT, TRUE, &pPoolItem ) == SFX_ITEM_SET )
		SetAutoLayout( (AutoLayout) ( ( const SfxAllEnumItem* ) pPoolItem )->GetValue() );
	else
		aCtlLayout.SelectItem( 1 );

	aBtnDelete.Disable();
}

/*************************************************************************
|*
|*	  Fuellt uebergebenen Item-Set mit Dialogbox-Attributen
|*
*************************************************************************/

void SdNewFoilDlg::GetAttr( SfxItemSet& rOutAttrs )
{
	rOutAttrs.Put( SfxStringItem( ATTR_PAGE_NAME,
						aEdtName.GetText() ) );
	rOutAttrs.Put( SfxBoolItem( ATTR_PAGE_BACKGROUND,
						aCbxBackground.IsChecked() ) );
	rOutAttrs.Put( SfxBoolItem( ATTR_PAGE_OBJECTS,
						aCbxObjects.IsChecked() ) );
	rOutAttrs.Put( SfxAllEnumItem( ATTR_PAGE_LAYOUT,
						GetAutoLayout() ) );
}

/*************************************************************************
|*
|* Gibt das Autolayout zurueck
|*
\************************************************************************/

AutoLayout SdNewFoilDlg::GetAutoLayout() const
{
	short nId = aCtlLayout.GetSelectItemId();

	if (ePageKind == PK_NOTES)
	{
		return( NotesLayoutArray[ nId ] );
	}
	else if (ePageKind == PK_HANDOUT)
	{
		return( HandoutLayoutArray[ nId ] );
	}
	else
	{
		return( LayoutArray[ nId ] );
	}
}

/*************************************************************************
|*
|* setzt das AutoLayout
|*
\************************************************************************/

BOOL SdNewFoilDlg::SetAutoLayout( const AutoLayout eAutoLayout )
{
	short               nArray;
    USHORT              nCount = MAX_AUTO_LAYOUT;
	SvtLanguageOptions  aLanguageOptions;
    
    if( !aLanguageOptions.IsVerticalTextEnabled() )
		nCount -= 4;

	for( USHORT i = 1; i < nCount; i++ )
	{
		if (ePageKind == PK_NOTES)
		{
			nArray = NotesLayoutArray[ i ];
		}
		else if (ePageKind == PK_HANDOUT)
		{
			nArray = HandoutLayoutArray[ i ];
		}
		else
		{
			nArray = LayoutArray[ i ];
		}

		if( nArray == eAutoLayout )
		{
			aCtlLayout.SelectItem( i );
			return( TRUE );
		}
	}
	return( FALSE );
}




/** Dialog has been closed without pressing the OK button.  Act like the
    cancel button has been pressed.
*/
BOOL SdNewFoilDlg::Close()
{
    EndDialog (RET_CANCEL);
    return FALSE;
}




/** This handler is called for double clicks on layout buttons and for
    activating the OK button.  It compares the name of the old and new
    layout and simulates the OK button or the Cancel button accordingly.
*/
IMPL_LINK_INLINE_START( SdNewFoilDlg, ClickLayoutHdl, void *, p )
{

	BOOL bEnd = FALSE;
    // Retrieve name of selected layout.
	String aNewName( aEdtName.GetText() );

	// Retrieve old name.
	String aOldName;
	const SfxPoolItem *pPoolItem = NULL;
	if( rOutAttrs.GetItemState( ATTR_PAGE_NAME, TRUE, &pPoolItem ) == SFX_ITEM_SET )
		aOldName = ( ( const SfxStringItem* ) pPoolItem )->GetValue();

	if( aOldName == aNewName )
		bEnd = TRUE;
	else if( pDocSh->CheckPageName( this, aNewName ) )
		bEnd = TRUE;

	if( bEnd )
	{
		aEdtName.SetText( aNewName );
		EndDialog( RET_OK );
	}
	else
		EndDialog( RET_CANCEL );

	return( bEnd );
}
IMPL_LINK_INLINE_END( SdNewFoilDlg, ClickLayoutHdl, void *, p )

/*************************************************************************
|*
|* Cancel-Handler
|*
\************************************************************************/

IMPL_LINK_INLINE_START( SdNewFoilDlg, ClickCancelHdl, void *, p )
{
	EndDialog( RET_CANCEL );
	return 0;
}
IMPL_LINK_INLINE_END( SdNewFoilDlg, ClickCancelHdl, void *, p )

void SdNewFoilDlg::DataChanged( const DataChangedEvent& rDCEvt )
{
    ModalDialog::DataChanged( rDCEvt );

	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
            ApplyImages();
}
/* -----------------------------08.05.2002 14:28------------------------------

 ---------------------------------------------------------------------------*/
namespace sd
{
	struct snewfoil_value_info
	{
		USHORT                              mnBmpResId;
		USHORT                              mnHCBmpResId;
		USHORT                              mnStrResId;
        ::com::sun::star::text::WritingMode meWritingMode;
	};

	static snewfoil_value_info notes[] =
	{
		{ BMP_FOILN_01, BMP_FOILN_01_H, STR_AUTOLAYOUT_NOTES, ::com::sun::star::text::WritingMode_LR_TB },
		{ 0, 0, 0, ::com::sun::star::text::WritingMode_LR_TB }
	};

	static snewfoil_value_info handout[] =
	{
        { BMP_FOILH_01, BMP_FOILH_01_H, STR_AUTOLAYOUT_HANDOUT1, ::com::sun::star::text::WritingMode_LR_TB },
		{ BMP_FOILH_02, BMP_FOILH_02_H, STR_AUTOLAYOUT_HANDOUT2, ::com::sun::star::text::WritingMode_LR_TB },
		{ BMP_FOILH_03, BMP_FOILH_03_H, STR_AUTOLAYOUT_HANDOUT3, ::com::sun::star::text::WritingMode_LR_TB },
		{ BMP_FOILH_04, BMP_FOILH_04_H, STR_AUTOLAYOUT_HANDOUT4, ::com::sun::star::text::WritingMode_LR_TB },
		{ BMP_FOILH_06, BMP_FOILH_06_H, STR_AUTOLAYOUT_HANDOUT6, ::com::sun::star::text::WritingMode_LR_TB },
		{ 0, 0, 0, ::com::sun::star::text::WritingMode_LR_TB }
	};

	static snewfoil_value_info standard[] =
	{
		{ BMP_FOIL_20 , BMP_FOIL_20_H, STR_AUTOLAYOUT_NONE, ::com::sun::star::text::WritingMode_LR_TB },
		{ BMP_FOIL_00 , BMP_FOIL_00_H, STR_AUTOLAYOUT_TITLE, ::com::sun::star::text::WritingMode_LR_TB },
		{ BMP_FOIL_01 , BMP_FOIL_01_H, STR_AUTOLAYOUT_ENUM, ::com::sun::star::text::WritingMode_LR_TB },
		{ BMP_FOIL_03 , BMP_FOIL_03_H, STR_AUTOLAYOUT_2TEXT, ::com::sun::star::text::WritingMode_LR_TB },
		{ BMP_FOIL_19 , BMP_FOIL_19_H, STR_AUTOLAYOUT_ONLY_TITLE, ::com::sun::star::text::WritingMode_LR_TB },
		{ BMP_FOIL_11 , BMP_FOIL_11_H, STR_AUTOLAYOUT_OBJ, ::com::sun::star::text::WritingMode_LR_TB },
		{ BMP_FOIL_02 , BMP_FOIL_02_H, STR_AUTOLAYOUT_CHART, ::com::sun::star::text::WritingMode_LR_TB },
		{ BMP_FOIL_08 , BMP_FOIL_08_H, STR_AUTOLAYOUT_TAB, ::com::sun::star::text::WritingMode_LR_TB },
		{ BMP_FOIL_09 , BMP_FOIL_09_H, STR_AUTOLAYOUT_CLIPTEXT, ::com::sun::star::text::WritingMode_LR_TB },
		{ BMP_FOIL_04 , BMP_FOIL_04_H, STR_AUTOLAYOUT_TEXTCHART, ::com::sun::star::text::WritingMode_LR_TB },
		{ BMP_FOIL_06 , BMP_FOIL_06_H, STR_AUTOLAYOUT_TEXTCLIP, ::com::sun::star::text::WritingMode_LR_TB },
		{ BMP_FOIL_07 , BMP_FOIL_07_H, STR_AUTOLAYOUT_CHARTTEXT, ::com::sun::star::text::WritingMode_LR_TB },
		{ BMP_FOIL_10 , BMP_FOIL_10_H, STR_AUTOLAYOUT_TEXTOBJ, ::com::sun::star::text::WritingMode_LR_TB },
		{ BMP_FOIL_12 , BMP_FOIL_12_H, STR_AUTOLAYOUT_TEXT2OBJ, ::com::sun::star::text::WritingMode_LR_TB },
		{ BMP_FOIL_13 , BMP_FOIL_13_H, STR_AUTOLAYOUT_OBJTEXT, ::com::sun::star::text::WritingMode_LR_TB },
		{ BMP_FOIL_14 , BMP_FOIL_14_H, STR_AUTOLAYOUT_OBJOVERTEXT, ::com::sun::star::text::WritingMode_LR_TB },
		{ BMP_FOIL_15 , BMP_FOIL_15_H, STR_AUTOLAYOUT_2OBJTEXT, ::com::sun::star::text::WritingMode_LR_TB },
		{ BMP_FOIL_16 , BMP_FOIL_16_H, STR_AUTOLAYOUT_2OBJOVERTEXT, ::com::sun::star::text::WritingMode_LR_TB },
		{ BMP_FOIL_17 , BMP_FOIL_17_H, STR_AUTOLAYOUT_TEXTOVEROBJ, ::com::sun::star::text::WritingMode_LR_TB },
		{ BMP_FOIL_18 , BMP_FOIL_18_H, STR_AUTOLAYOUT_4OBJ, ::com::sun::star::text::WritingMode_LR_TB },

		// vertical
        { BMP_FOIL_21 , BMP_FOIL_21_H, STR_AL_VERT_TITLE_TEXT_CHART, ::com::sun::star::text::WritingMode_TB_RL },
		{ BMP_FOIL_22 , BMP_FOIL_22_H, STR_AL_VERT_TITLE_VERT_OUTLINE, ::com::sun::star::text::WritingMode_TB_RL },
		{ BMP_FOIL_23 , BMP_FOIL_23_H, STR_AL_TITLE_VERT_OUTLINE, ::com::sun::star::text::WritingMode_TB_RL },
		{ BMP_FOIL_24 , BMP_FOIL_24_H, STR_AL_TITLE_VERT_OUTLINE_CLIPART, ::com::sun::star::text::WritingMode_TB_RL },

		{ 0, 0, 0, ::com::sun::star::text::WritingMode_LR_TB }
	};
};

using namespace ::sd;

void SdNewFoilDlg::ApplyImages()
{
	const bool              bHighContrast = GetDisplayBackground().GetColor().IsDark() != 0;
	bool                    bInit = aCtlLayout.GetItemCount() == 0;
	SvtLanguageOptions      aLanguageOptions;
	snewfoil_value_info*    pInfo;
    sal_Bool                bVertical = aLanguageOptions.IsVerticalTextEnabled();
    sal_Bool                bRightToLeft = ( pDocSh && 
                                             pDocSh->GetDoc() && 
                                             pDocSh->GetDoc()->GetDefaultWritingMode() == ::com::sun::star::text::WritingMode_RL_TB );

	switch( ePageKind )
	{
    	case PK_NOTES: pInfo = notes; break;
	    case PK_HANDOUT: pInfo = handout; break;
	    default: pInfo = standard; break;
	}

	for( sal_uInt16 i = 1; pInfo->mnBmpResId != 0; i++, pInfo++ )
	{
        if( ( ::com::sun::star::text::WritingMode_TB_RL != pInfo->meWritingMode ) || bVertical )
        {
            Bitmap aBmp( SdResId( bHighContrast ? pInfo->mnHCBmpResId : pInfo->mnBmpResId ) );
		
            if( bRightToLeft && ( ::com::sun::star::text::WritingMode_TB_RL != pInfo->meWritingMode ) )
                aBmp.Mirror( BMP_MIRROR_HORZ );

            if( bInit )
			    aCtlLayout.InsertItem( i,  aBmp, String( SdResId( pInfo->mnStrResId ) ) );
		    else
			    aCtlLayout.SetItemImage( i,  aBmp );
        }
	}
}
