/*************************************************************************
 *
 *  $RCSfile: sprite.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: ka $ $Date: 2000/11/03 15:31:29 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _TOOLS_STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif
#ifndef _SV_IMAGE_HXX //autogen
#include <vcl/image.hxx>
#endif
#ifndef _SV_VIRDEV_HXX //autogen
#include <vcl/virdev.hxx>
#endif
#ifndef _SV_WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif
#ifndef _SV_IMAGE_HXX //autogen
#include <vcl/image.hxx>
#endif
#ifndef _SV_SALBTYPE_HXX //autogen
#include <vcl/salbtype.hxx>
#endif

#include "sprite.hxx"
#include "sdmtf.hxx"

#define SPRITE_TIMEDIST (200UL)

// ----------
// - Sprite -
// ----------

Sprite::Sprite( List* _pListOfImages ) :
			pPaintDev		( NULL ),
			pActBmpEx		( NULL ),
			pListOfBmpEx	( _pListOfImages ),
			pBottomLayer	( NULL ),
			pTopLayer		( NULL ),
			ppTopMtf		( NULL )
{
}

// ------------------------------------------------------------------------

Sprite::~Sprite()
{
	delete pPaintDev;
	delete pBottomLayer;
}

// ------------------------------------------------------------------------

BOOL Sprite::StartMoving( OutputDevice* pOut,
						  OutputDevice* _pBottomLayer,
						  BitmapEx* _pTopLayer,
						  SdMetaFile** _ppTopMtf,
						  Marker* _pObjStartMarker,
						  Marker* _pObjEndMarker )
{
	const Size	aOutSizePix( pOut->GetOutputSizePixel() );
	const Point	aNullPt;
	BOOL		bRet;

	delete pPaintDev;
	pPaintDev = new VirtualDevice();

	delete pBottomLayer;
	pBottomLayer = new VirtualDevice();
	bRet = pBottomLayer->SetOutputSizePixel( aOutSizePix );

	pTopLayer = _pTopLayer;
	ppTopMtf = _ppTopMtf;
	pObjStartMarker = _pObjStartMarker;
	pObjEndMarker = _pObjEndMarker;

	if( bRet )
	{
		if( _pBottomLayer )
		{
			const Point aOrigin( _pBottomLayer->PixelToLogic( aNullPt ) );
			const Size	aOutSize( _pBottomLayer->GetOutputSize() );
			const Point	aDestOrigin( pOut->LogicToPixel( aOrigin ) );
			const Size	aDestSize( pOut->LogicToPixel( aOutSize ) );

			pBottomLayer->DrawOutDev( aDestOrigin, aDestSize, aOrigin, aOutSize, *_pBottomLayer );
			aLayerOffsetPix = aDestOrigin;
		}
		else
		{
			pBottomLayer->DrawOutDev( aNullPt, aOutSizePix,
									  pOut->PixelToLogic( aNullPt ), pOut->GetOutputSize(), *pOut );

			if( pTopLayer )
				aLayerOffsetPix = pOut->LogicToPixel( _pBottomLayer->PixelToLogic( aNullPt ) );
			else
				aLayerOffsetPix = Point();
		}

		if( pListOfBmpEx )
			pListOfBmpEx->Last();

		aOldMap = pOut->GetMapMode();

		if( ( bClipRegion = pOut->IsClipRegion() ) == TRUE )
		{
			aOldClip = pOut->GetClipRegion();
			pOut->EnableMapMode( FALSE );
			pOut->SetClipRegion( pOut->LogicToPixel( aOldClip, aOldMap ) );
		}
		else
			pOut->EnableMapMode( FALSE );

		aPaintRect = Rectangle();
	}

	nLastTime = 0UL;

	return bRet;
}

// ------------------------------------------------------------------------

void Sprite::MoveTo( OutputDevice* pOut, const Point& rPt, const Size* pSz )
{
	if( ImplPrepareMoveTo() )
	{
		ImplDrawSprite( pOut, 
					    pOut->LogicToPixel( rPt, aOldMap ), 
					   ( pSz ? pOut->LogicToPixel( *pSz, aOldMap ) : pActBmpEx->GetSizePixel() ) );
	}
}

// ------------------------------------------------------------------------

void Sprite::MoveTo( OutputDevice* pOut, const Point& rPt, const double& rScaleX, const double& rScaleY )
{
	if( ImplPrepareMoveTo() )
	{
		const Size& rSizePixel = pActBmpEx->GetSizePixel();
		const Size	aSzPixel( FRound( rSizePixel.Width() * rScaleX ), 
							  FRound( rSizePixel.Height() * rScaleY ) );

		ImplDrawSprite( pOut, pOut->LogicToPixel( rPt, aOldMap ), aSzPixel );
	}
}

// ------------------------------------------------------------------------

void Sprite::EndMoving( OutputDevice* pOut )
{
	pOut->EnableMapMode( TRUE );
	
	if( bClipRegion )
		pOut->SetClipRegion( aOldClip );
}

// ------------------------------------------------------------------------

BOOL Sprite::ImplPrepareMoveTo()
{
	DBG_ASSERT( pBottomLayer && pPaintDev, "You have to call ::StartMoving(...) first!" );
	BOOL bRet;

	if( ( bRet = ( pListOfBmpEx != NULL ) ) == TRUE )
	{
		if( !nLastTime || ( ( Time::GetSystemTicks() - nLastTime ) >= SPRITE_TIMEDIST ) )
		{
			if( !( pActBmpEx = (BitmapEx*) pListOfBmpEx->Next() ) )
				pActBmpEx = (BitmapEx*) pListOfBmpEx->First();

			nLastTime = Time::GetSystemTicks();
		}
	}

	return bRet;
}

// ------------------------------------------------------------------------

void Sprite::ImplDrawSprite( OutputDevice* pOut, const Point& rPt, const Size& rSz )
{
	const Rectangle aSpriteRect( rPt, rSz );

	// calculate total paint rect
	aPaintRect.Union( aSpriteRect );

	const Point	aNewPt( aPaintRect.TopLeft() );
	const Size	aNewSize( aPaintRect.GetSize() );

	pPaintDev->SetOutputSizePixel( aNewSize, FALSE );
	
	// BottomLayer
	pPaintDev->DrawOutDev( Point(), aNewSize, aNewPt, aNewSize, *pBottomLayer );

	// Sprite
	pPaintDev->DrawBitmapEx( rPt - aNewPt, rSz, *pActBmpEx );

	// TopLayer
	if( pTopLayer )
		pPaintDev->DrawBitmapEx( Point(), aNewSize, aNewPt - aLayerOffsetPix, aNewSize, *pTopLayer );
	else if( ppTopMtf && *ppTopMtf && pObjEndMarker )
	{
		MapMode		aTempMap( aOldMap );
		const Point	aNewTL( pOut->PixelToLogic( aNewPt, aTempMap ) );

		aTempMap.SetOrigin( Point( -aNewTL.X(), -aNewTL.Y() ) );
		pPaintDev->SetMapMode( aTempMap );
		(*ppTopMtf)->Play( pPaintDev, *pObjEndMarker, MTF_END );
		pPaintDev->SetMapMode( MapMode() );
	}

	// copy back
	pOut->DrawOutDev( aNewPt, aNewSize, Point(), aNewSize, *pPaintDev );

	// update paint rect
	aPaintRect = aSpriteRect;
}
