/*************************************************************************
 *
 *  $RCSfile: deliver.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ok $ $Date: 2000/11/10 12:35:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _DELIVER_HXX
#define _DELIVER_HXX

#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#ifndef _SV_WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif

#ifndef _SV_CONFIG_HXX //autogen
#include <tools/config.hxx>
#endif

class ResMgr;
class Accelerator;
class DeliverDialog;
class DeliverConfig;

//////////////////////////////////////////////////////////////////

#define DELIVER_EVENT_END			1
#define DELIVER_EVENT_START			2
#define DELIVER_EVENT_RUN			3

//////////////////////////////////////////////////////////////////

class DeliverEnvironment
{
	BOOL 			m_bError			: 1;
	BOOL			m_bIsInitial		: 1;
	BOOL			m_bIsNormal			: 1;
	BOOL			m_bIsBigFile		: 1;
	BOOL			m_bIsChannel		: 1;
	BOOL			m_bDoAgent			: 1;

	USHORT 			m_nSystemID;

	ByteString		m_aMajor;
	ByteString		m_aMinor;
	ByteString		m_aSubMinor;
	ByteString		m_aLanguage;

	ByteString 		m_aIniName;
	ByteString 		m_aDeliverPath;
	ByteString 		m_aSolarPath;

	DeliverConfig*	m_pDeliverConfig;
public:
		DeliverEnvironment();
		~DeliverEnvironment();

	void				Reset();

	void				SetError(BOOL bNew) 	 		   		{ m_bError = bNew; }
	BOOL				HasError() const						{ return m_bError; }

	void				SetInitial(BOOL bNew) 	 		   		{ m_bIsInitial = bNew; }
	BOOL				IsInitial() const						{ return m_bIsInitial; }

	void				SetAgent(BOOL bNew) 	 		   		{ m_bDoAgent = bNew; }
	BOOL				DoAgent() const				   			{ return m_bDoAgent; }

	void 				SetConfig(DeliverConfig* pNew);
	DeliverConfig*		GetConfig() const 						{ return m_pDeliverConfig; }

	BOOL 				SetSystemID(USHORT nNew);
	USHORT 				GetSystemID() const				   		{ return m_nSystemID; }
	ByteString			GetSysIDAsByteString(USHORT nId) const;

	void				SetMajor(const ByteString& rNew)  	 	{ m_aMajor = rNew; }
	const ByteString&		GetMajor() const				   		{ return m_aMajor; }
	void				SetMinor(const ByteString& rNew)  	 	{ m_aMinor = rNew; }
	const ByteString&		GetMinor() const				   		{ return m_aMinor; }
	void				SetSubMinor(const ByteString& rNew)  	 	{ m_aSubMinor = rNew; }
	const ByteString&		GetSubMinor() const				   		{ return m_aSubMinor; }
	void				SetLanguage(const ByteString& rNew)  	 	{ m_aLanguage = rNew; }
	const ByteString&		GetLanguage() const				   		{ return m_aLanguage; }
	USHORT 				GetLongLangCode();

	void				SetNormal(BOOL bNew) 	 		   		{ m_bIsNormal = bNew; }
	BOOL				IsNormal() const						{ return m_bIsNormal; }
	void				SetBigFile(BOOL bNew) 	 		   		{ m_bIsBigFile = bNew; }
	BOOL				IsBigFile() const						{ return m_bIsBigFile; }
	void				SetChannel(BOOL bNew) 	 		   		{ m_bIsChannel = bNew; }
	BOOL				IsChannel() const						{ return m_bIsChannel; }

	void				SetIniName(const ByteString& rNew)  	 	{ m_aIniName = rNew; }
	const ByteString&		GetIniName() const				   		{ return m_aIniName; }

	void				SetDeliverPath(const ByteString& rNew)	{ m_aDeliverPath = rNew; }
	const ByteString&		GetDeliverPath() const					{ return m_aDeliverPath; }

	void				SetSolarPath(const ByteString& rNew)		{ m_aSolarPath = rNew; }
	const ByteString&		GetSolarPath() const					{ return m_aSolarPath; }
};

//////////////////////////////////////////////////////////////////

class DeliverWindow : public WorkWindow
{
public:
		DeliverWindow(ResMgr* pMgr);
		~DeliverWindow();

	virtual BOOL    	Close();
};

//////////////////////////////////////////////////////////////////

#define DELIVER_INI_FILENAME		"deliver.ini"
#define DELIVER_INI_SEC_AGENT		"agent"
#define DELIVER_INI_KEY_DOWNROOT	"DownloadRoot"
#define DELIVER_INI_KEY_DOWNURL		"DownloadURL"
#define DELIVER_INI_KEY_TRANSMITTER	"TransmitterFile"

class DConfig : public Config
{
		void 		Error(const ByteString& rMsg);
public:
		DConfig(const ByteString& rFileName);

	//agent
	ByteString		GetDownloadRoot();
	ByteString		GetDownloadURL();
	ByteString		GetTransmitterFile();
};

//////////////////////////////////////////////////////////////////

class DeliverApp : public Application
{
	ResMgr*				m_pResMan;
	DeliverWindow*		m_pAppWin;
	Accelerator*		m_pExitAccel;

	DeliverDialog*		m_pDeliverDialog;
	DeliverEnvironment*	m_pEnv;

	DConfig*			m_pDCfg;

	void					ReadParams();
	ResMgr* 				LoadRessources();

	BOOL 					ScriptOnceAction();
	BOOL 					GetVersionInformation();
	BOOL					InstallAgent();

	DECL_LINK( ExitHdl, Accelerator* );
protected:
	virtual void			Main();
public:
		~DeliverApp();

	virtual void			UserEvent(ULONG nEvent, void* pEventData);
	void					Exit()								{ ExitHdl(0); }

	ResMgr*					GetResMgr() const 					{ return m_pResMan; }
	DeliverEnvironment*		GetEnvironment() const				{ return m_pEnv; }
};

//////////////////////////////////////////////////////////////////

extern DeliverApp* pDeliverApp;

#endif //_DELIVER_HXX
