/*************************************************************************
 *
 *  $RCSfile: fader.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:07:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SD_FADER_HXX
#define _SD_FADER_HXX

#ifndef _SV_WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif
#ifndef _SV_VIRDEV_HXX //autogen
#include <vcl/virdev.hxx>
#endif
#ifndef _SV_TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif

#ifdef UNX
#undef None
#endif

#include "fadedef.h"

/*************************************************************************
|*
|* Durchfuehrung von Ueberblendeffekten fuer die Diashow
|*
\************************************************************************/

#define WAIT_IN_EFFECT_MS	50
#define FADER_MAGIC			0x3456789a

class FuSlideShow;

class Fader
{
private:

	MapMode         aOldMMWin;
	MapMode         aOldMMVDev;
	MapMode         aOldMMVDevOld;
	Timer           aTimer;
	Rectangle       aSource;
	Rectangle       aTarget;
	Rectangle       aSourceLog;
	Rectangle       aTargetLog;
	Window*         pWin;
	FuSlideShow*	pFuslShow;
	VirtualDevice*  pVDev;
	VirtualDevice*  pVDevOld;
	ULONG           nStep;
	ULONG           nMagic;
	::com::sun::star::presentation::FadeEffect eEffect;
	FadeSpeed       eSpeed;
	USHORT          nRowCount;
	USHORT          nColCount;
	USHORT          nPrefCellSize;
	BOOL            bPixelMode;

	ULONG			GetEffectSteps( FadeSpeed eSpeed ) const;
	void			WaitInEffect( ULONG nMilliSeconds ) const;

	void			SwitchToPixel();
	void			SwitchToLogic();

	Rectangle		GetCell( USHORT nCol, USHORT nRow ) const;
	void			CalcCellParams( USHORT nCells );

	void			None( BOOL bWithBeep );
	void			MoveFromTop();
	void			MoveFromLeft();
	void			MoveFromRight();
	void			MoveFromBottom();

	void			FadeFromLeft();
	void			FadeFromUpperLeft();
	void			FadeFromTop();
	void			FadeFromUpperRight();
	void			FadeFromRight();
	void			FadeFromLowerRight();
	void			FadeFromBottom();
	void			FadeFromLowerLeft();
	void			FadeFromCenter();
	void			FadeToCenter();

	void			RollFromTop();
	void			RollFromLeft();
	void			RollFromRight();
	void			RollFromBottom();

	void			VerticalStripes();
	void			HorizontalStripes();

	void			Clockwise();
	void			CounterClockwise();

	void			CloseVertical();
	void			CloseHorizontal();
	void			OpenVertical();
	void			OpenHorizontal();

	void			CellsRandom();
	void			CellsSpiralOutClockwise();
	void			CellsSpiralOutCounterClockwise();
	void			CellsSpiralInClockwise();
	void			CellsSpiralInCounterClockwise();
	void			CellsWavyLineFromTop();
	void			CellsWavyLineFromLeft();
	void			CellsWavyLineFromRight();
	void			CellsWavyLineFromBottom();

	void			RandomEffect();

	void			StretchFromTop();
	void			StretchFromLeft();
	void			StretchFromRight();
	void			StretchFromBottom();

	void			VerticalLines();
	void			HorizontalLines();

//	void			Test();

 public:
					Fader( Window* pWindow, FuSlideShow* pShow = NULL );
					~Fader();

	void			SetWindow( Window* pNewWindow ) { pWin = pNewWindow; }
	Window* 		GetWindow() const { return pWin; }

	void			SetOldVirtualDevice( VirtualDevice* pDev );
	void			SetNewVirtualDevice( VirtualDevice* pDev );

	void			SetEffect( ::com::sun::star::presentation::FadeEffect eNewEffect ) { eEffect = eNewEffect; }
	::com::sun::star::presentation::FadeEffect GetEffect() const { return eEffect; }

	void			SetSpeed( FadeSpeed eNewSpeed ) { eSpeed = eNewSpeed; }
	FadeSpeed		GetSpeed() const { return eSpeed; }

	void			SetSource( const Rectangle& rRect ) { aSourceLog = rRect; }
	void			SetTarget( const Rectangle& rRect ) { aTargetLog = rRect; }
	Rectangle		GetSource() const { return aSourceLog; }
	Rectangle		GetTarget() const { return aTargetLog; }

	void			Fade();
	void			Terminate() { nMagic = 0UL; }
};

#endif // _SD_FADER_HXX

