/*************************************************************************
 *
 *  $RCSfile: makeeas.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: dv $ $Date: 2002/12/13 07:45:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#define INCL_DOSFILEMGR
#include <os2.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <string.h>
#include <stdlib.h>
#include <io.h>
#include <stdio.h>
#include <fcntl.h>

int MakeEAs( char* cpSource, const char* cpDest )
{

struct HoldFEA
{
	ULONG	oNextEntryOffset;
	BYTE	fEA;
	BYTE	cbName;
	USHORT	cbValue;
	CHAR	*szName;
	CHAR	*aValue;
};

#define ulBufSize 200L

PVOID pBuf[ulBufSize];
ULONG ulEntryIdx = 1;
ULONG ulEnumCount = 1;
APIRET rc = 0;
HoldFEA *pFea = 0;
GEA2LIST *pGeaList = 0;
EAOP2 eaopGet;
int fh= 0;

	fh = open( cpDest, O_RDWR | O_BINARY | O_CREAT | O_TRUNC, S_IWRITE );
	if ( -1 == fh )
		return 1;

	for(;;)
	{
		rc |= DosEnumAttribute( ENUMEA_REFTYPE_PATH, (void *)cpSource,
								ulEntryIdx, pBuf, ulBufSize, &ulEnumCount,
								ENUMEA_LEVEL_NO_VALUE);
		if( ulEnumCount != 1 )
			break;
		if ( 0 == rc )
		{
			pFea = new HoldFEA;
			pFea->cbName = ( (PFEA2)pBuf )->cbName;
			pFea->cbValue = ( (PFEA2)pBuf )->cbValue;
			pFea->fEA = ( (PFEA2)pBuf )->fEA;
			pFea->szName = new char[ pFea->cbName + 1 ];
			pFea->aValue = new char[ pFea->cbValue ];
			memcpy( pFea->szName, ( (PFEA2)pBuf )->szName, pFea->cbName + 1 );
			USHORT cbAlloc =
				sizeof(FEA2LIST) + pFea->cbName + 1 + pFea->cbValue;
			char* pAlloc = new char[cbAlloc];
			memset( pAlloc, 0, cbAlloc );
			pGeaList = (GEA2LIST*)pBuf;
			pGeaList->cbList = sizeof(GEA2LIST) + pFea->cbName;
			pGeaList->list[0].oNextEntryOffset = 0L;
			pGeaList->list[0].cbName = pFea->cbName;
			strcpy( pGeaList->list[0].szName, pFea->szName );   // unsupported os #100211# - checked
			eaopGet.fpGEA2List = (GEA2LIST*)pBuf;
			eaopGet.fpFEA2List = (FEA2LIST*)pAlloc;
			eaopGet.fpFEA2List->cbList = cbAlloc;
			rc |= DosQueryPathInfo( (PSZ)cpSource, FIL_QUERYEASFROMLIST,
				(PVOID)&eaopGet, sizeof(EAOP2) );
			int nSize = cbAlloc;
			write( fh, &nSize, sizeof(nSize) );
			int nWritten = write( fh, pAlloc, nSize );
			if ( nWritten != nSize )
			{
				close(fh);
				return 1;
			}
			delete pFea->szName;
			delete pFea->aValue;
			delete pFea;
			delete pAlloc;
		}
		++ulEntryIdx;
	}
	flushall();
	close(fh);
	return rc;
}
