/*************************************************************************
 *
 *  $RCSfile: cntviews.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: svesik $ $Date: 2000/11/22 14:48:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#define ENABLE_BYTESTRING_STREAM_OPERATORS	1
//=========================================================================
//
// class MigrationTask_ChaosViews.
// class MigrationTask_ChaosViews_Impl.
// class ChaosConfigFile_Impl.
// class ChaosViewFile_Impl.
// class StorageStream_Impl.
//
// (C) 1999 StarOffice Entwicklungs GmbH, Hamburg, Germany
//
// $Author: svesik $ $Date: 2000/11/22 14:48:39 $ $Revision: 1.3 $
//
//=========================================================================

#ifndef __STL_USE_NEWALLOC
#define __STL_USE_NEWALLOC 1
#endif
#ifndef __LIST__
#include <list>
#endif
#ifndef __MAP__
#include <map>
#endif

#ifndef _STORE_STORE_HXX_
#include <store/store.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _SV_CONFIG_HXX
#include <tools/config.hxx>
#endif

#include "cntviews.hxx"

#ifndef _SETUP_ENVIRON_HXX
#include "environ.hxx"
#endif

//=========================================================================

#ifdef UNX
#define OFFICE_CONFIG_FILE	"sofficerc"
#else
#define OFFICE_CONFIG_FILE	"soffice.ini"
#endif

#define CHAOS_CONFIG_FILE	"rootstg.scs"

#define OLD_CONFIG_DIR 		"config"
#define NEW_CONFIG_DIR 		"config"
#define OLD_STORE_DIR  		"store"
#define NEW_STORE_DIR  		"store"
#define USER_DIR 			"user"

// from chaos/source/core/cntrnmgr.cxx
#define VIEW_LIST_STREAM	".Views"
#define VIEW_LIST_VERSION	1

//=========================================================================
//
// Copy scc-Files pointing to targets of following types...
//
//=========================================================================

static ByteString aSchemesToMigrate_Impl[] =
{
	"file:",					// Workplace
	"ftp:",
	"imap:",
	"news:",
	"out:",						// Outtray
	"pop3:",
//	"private:channel:",			// Subscriptions
  	"private:searchfolder:",
	"private:trashcan:",
  	"vim:",
//	".component:ss/",			// Schedule
//	".component:Gallery/",
//	".component:Help/",
//	".component:Template/",		// Templates Folder
  	""
};

//=========================================================================
//
// Copy following scs-Files unconditionally...
//
//=========================================================================

static ByteString aFilesToMigrate_Impl[] =
{
	"httpcache.scs",			// HTTP cache
  	""
};

//=========================================================================
//
// Copy following soffice.ini entries...
//
//=========================================================================

// Taken from svtools/source/misc/iniman.cxx
static ByteString aInetIniEntriesToMigrate_Impl[] =
{
	/* 160: */  "Homepage",
	/* 163: */  "ProxyName",
	/* 164: */  "ProxyPort",
	/* 165: */  "ProxyType",
	/* 170: */  "SMTPServer",
	/* 171: */  "POPServer",
	/* 172: */  "MailUserName",
	/* 173: */  "MailPassword",
	/* 174: */  "NoProxy",
	/* 175: */  "HTTPProxyName",
	/* 176: */  "HTTPProxyPort",
	/* 177: */  "FTPProxyName",
	/* 178: */  "FTPProxyPort",
	/* 179: */  "SOCKSProxyName",
	/* 180: */  "SOCKSProxyPort",
	/* 181: */  "SecurityProxyName",
	/* 182: */  "SecurityProxyPort",
	/* 183: */  "NNTPServer",
	/* 187: */ 	"DNS",
	/* 188: */ 	"UserAgent",
//	5.2 ---> /user/config/java.ini /* 190: */ 	"JavaScript",
	/* 191: */ 	"PlugIn",
//	5.2 ---> /user/config/java.ini /* 192: */ 	"Applets",
	/* 193: */	"MailTextFormat",
	/* 198: */	"RevealMailAddr",
	/* 199: */	"ReadTimerOn",
	/* 200: */	"ReadTimerOut",
	/* 201: */	"AutoLoad",
	/* 202: */	"MailTextFontHeight",
  	""
};

//=========================================================================
//=========================================================================
//
// class StorageStream_Impl.
//
//=========================================================================
//=========================================================================

class StorageStream_Impl : public SvStream
{
	store::OStoreStream m_aStream;
	sal_uInt32 			m_nPos;

protected:
	virtual ULONG GetData( char* pData, ULONG nSize );
	virtual ULONG PutData( const char* pData, ULONG nSize );
	virtual ULONG SeekPos( ULONG nPos );
	virtual void  FlushData();
	virtual void  SetSize( ULONG nSize );

public:
	StorageStream_Impl( const store::OStoreStream& rStream )
	: m_aStream( rStream ), m_nPos( 0 ) { bIsWritable = TRUE; }

	virtual ~StorageStream_Impl();
};

//=========================================================================
//
// struct ViewFileEntry_Impl
//
//=========================================================================

struct ViewFileEntry_Impl
{
	ByteString FileURL;
	ByteString ContentType;

	ViewFileEntry_Impl(
				const ByteString& rViewFileURL, const ByteString& rContentType )
	: FileURL( rViewFileURL ), ContentType( rContentType ) {}
};

//=========================================================================
//
// ViewFilesList_Impl.
//
//=========================================================================

typedef std::list< ViewFileEntry_Impl > ViewFilesList_Impl;

//=========================================================================
//=========================================================================
//
// class ChaosConfigFile_Impl.
//
//=========================================================================
//=========================================================================

class ChaosConfigFile_Impl
{
	ViewFilesList_Impl m_aViews;
	ByteString			   m_aFile;

public:
	ChaosConfigFile_Impl( const ByteString& rFile ) : m_aFile( rFile ) {}

	const ViewFilesList_Impl& getViews();
	void setViews( const ViewFilesList_Impl& rViews ) { m_aViews = rViews; }

	BOOL flush();
};

//=========================================================================
//=========================================================================
//
// class ChaosViewFile_Impl.
//
//=========================================================================
//=========================================================================

class ChaosViewFile_Impl
{
	ByteString m_aFile;
	ByteString m_aReferredURL;
	ByteString m_aCacheFileName;
	BOOL   m_bValid : 1;

private:
	BOOL init();
	static String OwnURL2FileName( const ByteString& rOwnURL );

public:
	ChaosViewFile_Impl( const ByteString& rFullName )
	: m_aFile( rFullName ), m_bValid( FALSE ) {}

	BOOL  isValid();
	const ByteString& getReferredURL();
	const ByteString& getCacheFileName();
};

//=========================================================================
//
// FilesMap_Impl.
//
//=========================================================================

struct lessByteString_Impl
{
	bool operator ()( const ByteString& rKey1, const ByteString& rKey2 ) const
	{
		return ( rKey2.CompareTo( rKey1 ) == COMPARE_LESS );
	}
};

//=========================================================================

typedef std::map
<
	ByteString,
	ViewFilesList_Impl*,
	lessByteString_Impl
>
FilesMap_Impl;

//=========================================================================
//=========================================================================
//
// class MigrationTask_ChaosViews_Impl.
//
//=========================================================================
//=========================================================================

class MigrationTask_ChaosViews_Impl
{
	FilesMap_Impl	   m_aFiles;
	ViewFilesList_Impl m_aViews;
	ByteString   	  	   m_aPathFrom;
	BOOL 	      	   m_bInitDone : 1;

	BOOL init( SiEnvironment* pEnv );

public:
	MigrationTask_ChaosViews_Impl() : m_bInitDone( FALSE ) {}
	~MigrationTask_ChaosViews_Impl();

	ULONG calcTotalTransferSize( SiEnvironment* pEnv );
	void  transferFiles( SiEnvironment* pEnv );
	void  transferIniSettings( SiEnvironment* pEnv );
};

//=========================================================================
//=========================================================================
//
// MigrationTask_ChaosViews_Impl Implementation.
//
//=========================================================================
//=========================================================================

MigrationTask_ChaosViews_Impl::~MigrationTask_ChaosViews_Impl()
{
	FilesMap_Impl::const_iterator it  = m_aFiles.begin();
	FilesMap_Impl::const_iterator end = m_aFiles.end();

	while ( it != end )
	{
		// delete string list.
		delete (*it).second;
		it++;
	}
}

//-------------------------------------------------------------------------
static BOOL isLocatedIn( const SiDirEntry& rChild, const SiDirEntry& rParent )
{
	USHORT nLevel = rChild.Level();
	if ( rParent.Level() >= nLevel )
		return FALSE;

	USHORT n = 1;
	while ( n < nLevel )
	{
		const SiDirEntry& rCurr = rChild[ n ];
		if ( rCurr == rParent )
			return TRUE;

		n++;
	}

	return FALSE;
}

//-------------------------------------------------------------------------
BOOL MigrationTask_ChaosViews_Impl::init( SiEnvironment* pEnv )
{
	if ( !m_bInitDone )
	{
		m_bInitDone = TRUE;

		m_aPathFrom = pEnv->GetMigrationPath();

		// Check for /config/rootstg.scs in source directory. This file
		// contains the data we need. If it is missing, we can't migrate.

		SiDirEntry aConfigDir( m_aPathFrom );
		aConfigDir += SiDirEntry( OLD_CONFIG_DIR );

		SiDirEntry aConfigFile( aConfigDir );
		aConfigFile += SiDirEntry( CHAOS_CONFIG_FILE );

		if ( aConfigFile.Exists() )
		{
			// Process files to transfer unconditionally.
			USHORT n = 0;
			ByteString aFile( aFilesToMigrate_Impl[ n ] );
			while ( aFile.Len() )
			{
				m_aFiles[ aFile ] = new ViewFilesList_Impl;

				// Next...
				n++;
				aFile = aFilesToMigrate_Impl[ n ];
			}

			// Obtain list of persistent CHAOS object views ( scc files )
			// from old configuration.

			ChaosConfigFile_Impl aConfig( aConfigFile.GetFull() );
			m_aViews = aConfig.getViews();

			ViewFilesList_Impl::iterator it  = m_aViews.begin();
			ViewFilesList_Impl::iterator end = m_aViews.end();

			while ( it != end )
			{
				SiDirEntry aViewFile( (*it).FileURL );
				SiDirEntry aOldOfficeDir( m_aPathFrom );

				BOOL bInOfficeDir = isLocatedIn( aViewFile, aOldOfficeDir );

				ChaosViewFile_Impl aView( aViewFile.GetFull() );
				if ( aView.isValid() )
				{
					// Check type of view...
					ByteString aReferredURL( aView.getReferredURL() );

					n = 0;
					ByteString aScheme( aSchemesToMigrate_Impl[ n ] );
					while ( aScheme.Len() )
					{
						if ( aReferredURL.CompareTo( aScheme, aScheme.Len() )
						 	 == COMPARE_EQUAL )
						{
							// Okay. This view will be migrated...
							const ByteString aFileName( aView.getCacheFileName() );
							ViewFilesList_Impl* pList = NULL;
							FilesMap_Impl::iterator it1 = m_aFiles.find(
																	aFileName );
							if ( it1 == m_aFiles.end() )
							{
								pList = new ViewFilesList_Impl;
								m_aFiles[ aFileName ] = pList;
							}
							else
							{
								pList = (*it1).second;
							}

							// Does view recide within old office dir tree?
							if ( bInOfficeDir )
							{
								// Yes. Copy it.
								pList->push_back( *it );
							}
							break;
						}

						// Next...
						n++;
						aScheme = aSchemesToMigrate_Impl[ n ];
					}
				}

				if ( bInOfficeDir )
				{
					// "Forget" this view...

					ViewFilesList_Impl::iterator next = it;
					++next;
					m_aViews.erase( it );
					it = next;
				}
				else
					++it;
			}
		}
	}

	return TRUE;
}

//-------------------------------------------------------------------------
ULONG MigrationTask_ChaosViews_Impl::calcTotalTransferSize(
													SiEnvironment* pEnv )
{
	ULONG nSize = 0;

	if ( init( pEnv ) && m_aFiles.size() )
	{
		SiDirEntry aStorePath( m_aPathFrom );
		aStorePath += SiDirEntry( OLD_STORE_DIR );

		SiDirEntry aConfigPath( m_aPathFrom );
		aConfigPath += SiDirEntry( OLD_CONFIG_DIR );

		FilesMap_Impl::const_iterator it  = m_aFiles.begin();
		FilesMap_Impl::const_iterator end = m_aFiles.end();

		while ( it != end )
		{
			SiDirEntry aFile( (*it).first );

			// Process scs file in config directory.

			SiDirEntry aConfigFile( aConfigPath );
			aConfigFile += aFile;

			if ( aConfigFile.Exists() )
				nSize += FileStat( aConfigFile ).GetSize();

			// Process scs file in store directory.

			SiDirEntry aStoreFile( aStorePath );
			aStoreFile += aFile;

			if ( aStoreFile.Exists() )
				nSize += FileStat( aStoreFile ).GetSize();

			// Process scc files referring to store/config file.

			const ViewFilesList_Impl* pViews = (*it).second;

			ViewFilesList_Impl::const_iterator it1  = pViews->begin();
			ViewFilesList_Impl::const_iterator end1 = pViews->end();

			while ( it1 != end1 )
			{
				SiDirEntry aViewFile( (*it1).FileURL );
				if ( aViewFile.Exists() )
					nSize += FileStat( aViewFile ).GetSize();

				it1++;
			}

			it++;
		}
	}

	return nSize;
}

//-------------------------------------------------------------------------
static BOOL ensureDirectoryExists( const SiDirEntry& rDir )
{
	if ( !rDir.Exists() )
		rDir.MakeDir();

	// Note: Return value of MakeDir is not always correct!!!
	if ( !rDir.Exists() )
	{
		DBG_ERROR( "ensureDirectoryExists - Unable to create directory!" );
		return FALSE;
	}

	return TRUE;
}

//-------------------------------------------------------------------------
static BOOL queryViewFileDestination( const SiDirEntry& rOldOfficeDir,
	   								  const SiDirEntry& rNewOfficeDir,
	   								  const SiDirEntry& rOldViewFile,
	   								  SiDirEntry& rNewViewFile )
{
	// (old-office-root)/...  --->  (new-office-root)/user/...

	SiDirEntry aNewViewFile( rNewOfficeDir );
	aNewViewFile += SiDirEntry( USER_DIR );

	USHORT nLevel = rOldViewFile.Level() - rOldOfficeDir.Level();
	do
	{
		nLevel--;
		aNewViewFile += rOldViewFile[ nLevel ].GetName();
	}
	while ( nLevel );

	if ( !ensureDirectoryExists( aNewViewFile[ 1 ] ) )
		return FALSE;

	if ( aNewViewFile.Exists() )
	{
		SiDirEntry aDE( aNewViewFile[ 1 ] );
		if ( !aDE.MakeShortName( aNewViewFile.GetNameUni() ) )
		{
			DBG_ERROR( "queryViewFileDestination - MakeShortName failed!" );
			return FALSE;
		}

		aNewViewFile = aDE;
	}

	rNewViewFile = aNewViewFile;
	return TRUE;
}

//-------------------------------------------------------------------------
static BOOL copyStoreFile( const SiDirEntry& rSource, const SiDirEntry& rDest )
{
#if 1
	// Copy file.
	FileCopier aCopier( rSource, rDest );
	FSysError nError = aCopier.Execute();
	return ( nError == FSYS_ERR_OK );
#else
	// Create new store file at target position. This shrinks
	// and repairs the old file, if necessary/possible!
	storeError nError = store_rebuildFile(
								rSource.GetFull( FSYS_STYLE_HOST ),
								rDest.GetFull( FSYS_STYLE_HOST ) );
	return ( nError == store_E_None );
#endif
}

//-------------------------------------------------------------------------
void MigrationTask_ChaosViews_Impl::transferFiles( SiEnvironment* pEnv )
{
	if ( init( pEnv ) && m_aFiles.size() )
	{
		// <old-office-inst>/store
		SiDirEntry aOldOfficePath( m_aPathFrom );
		SiDirEntry aNewOfficePath( pEnv->GetDestPath() );

		SiDirEntry aOldStorePath( m_aPathFrom );
		aOldStorePath += SiDirEntry( OLD_STORE_DIR );

		// <old-office-inst>/config
		SiDirEntry aOldConfigPath( m_aPathFrom );
		aOldConfigPath += SiDirEntry( OLD_CONFIG_DIR );

		SiDirEntry aNewStorePath ( pEnv->GetDestPath() );
		aNewStorePath += SiDirEntry( USER_DIR );

		SiDirEntry aNewConfigPath( aNewStorePath );

		// <new-office-inst>/user/store
		aNewStorePath  += SiDirEntry( NEW_STORE_DIR );

		// Ensure user/store directory exists.
		if ( !ensureDirectoryExists( aNewStorePath ) )
			return;

		// <new-office-inst>/user/config
		aNewConfigPath += SiDirEntry( NEW_CONFIG_DIR );

		// Ensure user/config directory exists.
		if ( !ensureDirectoryExists( aNewConfigPath ) )
			return;

		FilesMap_Impl::const_iterator it  = m_aFiles.begin();
		FilesMap_Impl::const_iterator end = m_aFiles.end();

		while ( it != end )
		{
			SiDirEntry aFile( (*it).first );

			SiDirEntry aNewConfigFile( aNewConfigPath );
			aNewConfigFile += aFile;

			SiDirEntry aNewStoreFile( aNewStorePath );
			aNewStoreFile += aFile;

			// If a file with the same name as the file currently
			// processed already exists at the new location, we
			// skip the migration of all files related to it!

			if ( !aNewConfigFile.Exists() && !aNewStoreFile.Exists() )
			{
				// Process scs file in config directory.

				SiDirEntry aOldConfigFile( aOldConfigPath );
				aOldConfigFile += aFile;

				if ( aOldConfigFile.Exists() )
				{
					// Copy...
					copyStoreFile( aOldConfigFile, aNewConfigFile );
				}

				// Process scs file in store directory.

				SiDirEntry aOldStoreFile( aOldStorePath );
				aOldStoreFile += aFile;

				if ( aOldStoreFile.Exists() )
				{
					// Copy...
					copyStoreFile( aOldStoreFile, aNewStoreFile );
				}

				// Process scc files referring to store/config file.

				const ViewFilesList_Impl* pViews = (*it).second;

				ViewFilesList_Impl::const_iterator it1  = pViews->begin();
				ViewFilesList_Impl::const_iterator end1 = pViews->end();

				while ( it1 != end1 )
				{
					SiDirEntry aSourceViewFile( (*it1).FileURL );

					SiDirEntry aDestViewFile;
					if ( queryViewFileDestination( aOldOfficePath,
												   aNewOfficePath,
											  	   aSourceViewFile,
											       aDestViewFile ) )
					{
						// Copy...
						if ( copyStoreFile( aSourceViewFile, aDestViewFile ) )
						{
							// Remember new location of copied file.
							ByteString aNewLocation(
									aDestViewFile.GetFull( FSYS_STYLE_URL ) );
							if ( !aDestViewFile.IsCaseSensitive() )
								aNewLocation.ToLowerAscii();

							m_aViews.push_back(
								ViewFileEntry_Impl(
									aNewLocation, (*it1).ContentType ) );
						}
					}

					it1++;
				}
			}

			it++;
		}

		//////////////////////////////////////////////////////////////////
		// Write new CHAOS configuration file ( rootstg.scs )
		//////////////////////////////////////////////////////////////////

		SiDirEntry aChaosConfig( aNewConfigPath );
		aChaosConfig += SiDirEntry( CHAOS_CONFIG_FILE );

		ChaosConfigFile_Impl aConfig( aChaosConfig.GetFull() );
		// Set ne view list.
		aConfig.setViews( m_aViews );

		// Write data.
		aConfig.flush();
	}
}

//-------------------------------------------------------------------------
void MigrationTask_ChaosViews_Impl::transferIniSettings( SiEnvironment* pEnv )
{
	SiDirEntry aSource( pEnv->GetMigrationPath() );
	aSource += SiDirEntry( OFFICE_CONFIG_FILE );

	if ( aSource.Exists() )
	{
		SiDirEntry aDest	( pEnv->GetDestPath() );
		aDest 	+= SiDirEntry( USER_DIR );
		aDest	+= SiDirEntry( OFFICE_CONFIG_FILE );

		Config aSrcCfg( aSource.GetFullUni() );
		Config aDstCfg( aDest.GetFullUni() );

		aSrcCfg.SetGroup( "INet" );
		aDstCfg.SetGroup( "INet" );

		USHORT n = 0;
		ByteString aKey( aInetIniEntriesToMigrate_Impl[ n ] );
		while ( aKey.Len() )
		{
			ByteString aValue( aSrcCfg.ReadKey( aKey ) );
			if ( aValue.Len() )
			{
				aDstCfg.WriteKey( aKey, aValue );
			}

			// Next...
			n++;
			aKey = aInetIniEntriesToMigrate_Impl[ n ];
		}
	}
}

//=========================================================================
//=========================================================================
//
// ChaosConfigFile_Impl Implementation.
//
//=========================================================================
//=========================================================================

const ViewFilesList_Impl& ChaosConfigFile_Impl::getViews()
{
	if ( m_aViews.size() )
		return m_aViews;

	if ( !m_aFile.Len() )
		return m_aViews;

	SiDirEntry aDE( m_aFile );
	if ( !aDE.Exists() )
		return m_aViews;

	store::OStoreFile aStoreFile;
	storeError nError = aStoreFile.create( aDE.GetFullUni(	FSYS_STYLE_HOST ),
										   store_AccessReadOnly );
	if ( nError != store_E_None )
		return m_aViews;

	store::OStoreStream aStoreStream;
	nError = aStoreStream.create(
				aStoreFile, UniString::CreateFromAscii("/"),
				UniString::CreateFromAscii(VIEW_LIST_STREAM),
				store_AccessReadOnly );
	if ( nError != store_E_None )
		return m_aViews;

	StorageStream_Impl aStream( aStoreStream );

	aStream.SetBufferSize( 4096 );
	aStream.SetNumberFormatInt( NUMBERFORMAT_INT_LITTLEENDIAN );

	ULONG nVersion = 0;
	ULONG nCount   = 0;
	aStream >> nVersion;
	aStream >> nCount;

	for ( ULONG n = 0; n < nCount; ++n )
	{
		ByteString aViewURL;
		ByteString aContentType;

		aStream >> aViewURL;
		aStream >> aContentType;

		// Check, whether file decribed by aViewURL exists.
		SiDirEntry aSiDirEntry( aViewURL, FSYS_STYLE_URL  );
		if ( aSiDirEntry.Exists() )
		{
			m_aViews.push_back( ViewFileEntry_Impl( aViewURL,
													aContentType ) );
		}
	}

	return m_aViews;
}

//=========================================================================
BOOL ChaosConfigFile_Impl::flush()
{
	if ( !m_aFile.Len() )
		return FALSE;

	SiDirEntry aDE( m_aFile );
	if ( aDE.Exists() )
		return FALSE;

	sal_uInt32 nCount = m_aViews.size();
	if ( !nCount )
		return TRUE;

	store::OStoreFile aStoreFile;
	storeError nError = aStoreFile.create( aDE.GetFullUni(	FSYS_STYLE_HOST ),
										   store_AccessReadCreate );
	if ( nError != store_E_None )
		return FALSE;

	store::OStoreStream aStoreStream;
	nError = aStoreStream.create(
				aStoreFile, UniString::CreateFromAscii("/"),
				UniString::CreateFromAscii(VIEW_LIST_STREAM),
				store_AccessReadCreate );
	if ( nError != store_E_None )
		return FALSE;

	StorageStream_Impl aStream( aStoreStream );

	aStream.SetBufferSize( 4096 );
	aStream.SetNumberFormatInt( NUMBERFORMAT_INT_LITTLEENDIAN );

	ULONG nVersion = VIEW_LIST_VERSION;
	aStream << nVersion;
	aStream << nCount;

	ViewFilesList_Impl::const_iterator it  = m_aViews.begin();
	ViewFilesList_Impl::const_iterator end = m_aViews.end();

	while ( it != end )
	{
		aStream << (*it).FileURL;
		aStream << (*it).ContentType;

		it++;
	}

	return TRUE;
}

//=========================================================================
//=========================================================================
//
// ChaosViewFile_Impl Implementation.
//
//=========================================================================
//=========================================================================

BOOL ChaosViewFile_Impl::init()
{
	// Avoid multiple runs.
	if ( m_bValid )
		return TRUE;

	///////////////////////////////////////////////////////////////////////
	// Read referred URL from storage file...
	///////////////////////////////////////////////////////////////////////

	if ( !m_aFile.Len() )
		return FALSE;

	SiDirEntry aDE( m_aFile );
	if ( !aDE.Exists() )
		return FALSE;

	store::OStoreFile aStoreFile;
	storeError nError = aStoreFile.create( aDE.GetFullUni(	FSYS_STYLE_HOST ),
										   store_AccessReadOnly );
	if ( nError != store_E_None )
		return FALSE;

	store::OStoreStream aStoreStream;
	nError = aStoreStream.create(
				aStoreFile, UniString::CreateFromAscii("/"),
				UniString::CreateFromAscii("own.props"),
				store_AccessReadOnly );
	if ( nError != store_E_None )
		return FALSE;

	StorageStream_Impl aStream( aStoreStream );

	aStream.SetBufferSize( 4096 );
	aStream.SetNumberFormatInt( NUMBERFORMAT_INT_LITTLEENDIAN );

	sal_uInt32 nSize = 0;
	nError = aStoreStream.getSize( nSize );
	if ( nError != store_E_None )
		return FALSE;

	BYTE* pBuffer = new BYTE[ nSize ];

	aStream.Read( pBuffer, nSize );

	// Search for string ".cache:" in buffer...
	const ByteString aKey( ".cache:" );
	ULONG nPos = 0;
	while ( nPos <= ( nSize - aKey.Len() ) )
	{
		if ( ( pBuffer[ nPos     ] == '.' ) &&
			 ( pBuffer[ nPos + 1 ] == 'c' ) &&
			 ( pBuffer[ nPos + 2 ] == 'a' ) &&
			 ( pBuffer[ nPos + 3 ] == 'c' ) &&
			 ( pBuffer[ nPos + 4 ] == 'h' ) &&
			 ( pBuffer[ nPos + 5 ] == 'e' ) &&
			 ( pBuffer[ nPos + 6 ] == ':' ) )
		{
			// Set buffer pos to begin of persistent string data.
			// See: tools/source/stream/stream.cxx

			aStream.Seek( nPos - 2 );
			aStream >> m_aReferredURL;

			// Remove cache prefix to get the service URL.
			m_aReferredURL.Erase( 0, m_aReferredURL.Search( ':' ) + 1 );

			break;
		}

		nPos++;
	}

	delete [] pBuffer;

	if ( nPos > ( nSize - aKey.Len() ) )
	{
		// Not found!
		return FALSE;
	}

	///////////////////////////////////////////////////////////////////////
	// Calculate cache file name from referred URL...
	///////////////////////////////////////////////////////////////////////
	m_aCacheFileName = ByteString( OwnURL2FileName(m_aReferredURL), osl_getThreadTextEncoding() );

	m_bValid = TRUE;
	return TRUE;
}

//=========================================================================
BOOL ChaosViewFile_Impl::isValid()
{
	init();
	return m_bValid;
}

//=========================================================================
const ByteString& ChaosViewFile_Impl::getReferredURL()
{
	init();
	return m_aReferredURL;
}

//=========================================================================
const ByteString& ChaosViewFile_Impl::getCacheFileName()
{
	init();
	return m_aCacheFileName;
}

//=========================================================================
//static
String ChaosViewFile_Impl::OwnURL2FileName( const ByteString& rOwnURL )
{
	//--------------------------------------------------------------------
	//
	// !!! Code taken from chaos/source/store/cntstgnd.cxx !!!
	//
	//--------------------------------------------------------------------

	ByteString aReferredURL( rOwnURL );

	//////////////////////////////////////////////////////////////////////
	// Check for Dummy-URL
	//////////////////////////////////////////////////////////////////////

	USHORT nLen = aReferredURL.Len();
	if ( ( nLen > 2 ) &&
		 ( aReferredURL.GetChar( nLen - 3 ) == ':' ) &&
		 ( aReferredURL.GetChar( nLen - 2 ) == '/' ) &&
		 ( aReferredURL.GetChar( nLen - 1 ) == '/' ) )
	{
		return String();
	}

	//////////////////////////////////////////////////////////////////////
	// Construct a file name from URL ...
	//////////////////////////////////////////////////////////////////////

	INetURLObject aURLObject( aReferredURL );

	String aFileName;

	// Next part of file name: "username"
	String aUser( aURLObject.GetUser() );
	nLen = aUser.Len();
	if ( nLen )
	{
		USHORT nPos = aUser.Search( '.' );
		while ( nPos != STRING_NOTFOUND )
		{
			aUser.Erase( nPos, 1 );
			nPos = aUser.Search( '.', nPos );
		}

		// User names are generally case sensitive. So any upper-case
		// letters in name will be encoded here into storage filename.
		//
		// Conversion-scheme:
		// <uppercase letter> -> !<uppercase_letter>
		// !                  -> !!
		String aTemp;

		nLen = aUser.Len();
		for ( USHORT n = 0; n < nLen; n++ )
		{
			String aTmp( aUser.GetChar( n ) );
			if ( aTmp == UniString::CreateFromAscii("%") )
			{
				// Skip escape sequences.
				aTemp += UniString::CreateFromAscii("%");
				aTemp += aUser.GetChar( n + 1 );
				aTemp += aUser.GetChar( n + 2 );
				n += 2;
			}
			else
			{
				if ( aTmp == UniString::CreateFromAscii("!") )
					aTemp += '!';
				else
				{
					String aTmpLow( aTmp.ToLowerAscii() );
			 		if ( aTmpLow != aTmp )
					{
						aTemp += '!';
						aTmp = aTmpLow;
					}
				}
				aTemp += aTmp;
			}
		}

		aUser = aTemp;
		aFileName += aUser;
	}

	// Next part of file name: "servername"
	String aHost( aURLObject.GetHost() );
	if ( aHost.Len() )
	{
		USHORT nPos = aHost.Search( '.' );
		while ( nPos != STRING_NOTFOUND )
		{
			aHost.Erase( nPos, 1 );
			nPos = aHost.Search( '.', nPos );
		}

 		aFileName += aHost;

		// Next part of file name: "serverport"
		if ( aURLObject.HasPort() )
	 		aFileName += aURLObject.GetPort();

	}

	// Next part of file name: "protocol-tag"

	String aPrivatePath; // helper
	INetProtocol eProt = aURLObject.GetProtocol();

	// "private:" and ".component:" protocol need special handling.
	BOOL bSpecialProt = ( ( eProt == INET_PROT_PRIVATE ) ||
						  ( eProt == INET_PROT_COMPONENT ) );
	if ( bSpecialProt )
	{
		String aPath( aURLObject.GetURLPath() );

		DBG_ASSERT( aPath.Len(),
					"OwnURL2FileName: Invalid private URL (no path)!" );

		USHORT nPos = 0;
		if ( eProt == INET_PROT_PRIVATE )
		{
			nPos = aPath.Search( UniString::CreateFromAscii("://") );
			if ( nPos != STRING_NOTFOUND )
				nPos += 3; // now after "://"
		}

		if ( nPos != STRING_NOTFOUND )
		{
			nPos = aPath.Search( '/', nPos );
			if ( nPos != STRING_NOTFOUND )
				aPrivatePath = aPath.Erase( nPos + 1 );
		}

		// Remove anwanted characters from path...

		// Note: URL Object does not escape slashes - so remove it manually.
		nPos = aPath.Search( '/' );
		while ( nPos != STRING_NOTFOUND )
		{
			aPath.Erase( nPos, 1 );
			nPos = aPath.Search( '/', nPos );
		}

		// Remove any ':' (cosmetic).
		nPos = aPath.Search( ':' );
		while ( nPos != STRING_NOTFOUND )
		{
			aPath.Erase( nPos, 1 );
			nPos = aPath.Search( ':', nPos );
		}

//		INetURLObject::Escape( aPath );

		aFileName += aPath;
	}
	else
	{
		String aProt( aURLObject.GetScheme( eProt ) );
		aProt.Erase( aProt.Search( ':' ) );
 		aFileName += aProt;
	}

	// Next part of file name: "file extension"
	aFileName += UniString::CreateFromAscii(".scs");

	// Done.
	return aFileName;
}

//=========================================================================
//=========================================================================
//
// StorageStream_Impl Implementation.
//
//=========================================================================
//=========================================================================

// virtual
StorageStream_Impl::~StorageStream_Impl()
{
	Flush();
}

//-------------------------------------------------------------------------
// virtual
ULONG StorageStream_Impl::GetData( char* pData, ULONG nSize )
{
	sal_uInt32 nBytesRead = 0;
	m_aStream.readAt( m_nPos, pData, nSize, nBytesRead );
	m_nPos += nBytesRead;
	return nBytesRead;
}

//-------------------------------------------------------------------------
// virtual
ULONG StorageStream_Impl::PutData( const char* pData, ULONG nSize )
{
	sal_uInt32 nBytesWritten = 0;
	m_aStream.writeAt( m_nPos, pData, nSize, nBytesWritten );
	m_nPos += nBytesWritten;
	return nBytesWritten;
}

//-------------------------------------------------------------------------
// virtual
ULONG StorageStream_Impl::SeekPos( ULONG nPos )
{
	m_nPos = nPos;
	return nPos;
}

//-------------------------------------------------------------------------
// virtual
void StorageStream_Impl::FlushData()
{
	m_aStream.flush();
}

//-------------------------------------------------------------------------
// virtual
void StorageStream_Impl::SetSize( ULONG nSize )
{
	m_aStream.setSize( nSize);
}

//=========================================================================
//=========================================================================
//
// MigrationTask_ChaosViews Implementation.
//
//=========================================================================
//=========================================================================

MigrationTask_ChaosViews::MigrationTask_ChaosViews(
										  SetupMigrationPlugin* pPlugin )
: SetupMigrationTask( pPlugin )
{
	m_pImpl = new MigrationTask_ChaosViews_Impl;
}

//-------------------------------------------------------------------------
MigrationTask_ChaosViews::~MigrationTask_ChaosViews()
{
	delete m_pImpl;
}

//-------------------------------------------------------------------------
// virtual
ULONG MigrationTask_ChaosViews::Execute(
							MigrationExecType eTyp, SiEnvironment* pEnv )
{
	switch ( eTyp )
	{
		// Calculate size of files to transfer ( in bytes ) ...
		case CALCULATE_SIZE:
			return m_pImpl->calcTotalTransferSize( pEnv );

		// Transfer files...
		case EXECUTE:
			m_pImpl->transferFiles( pEnv );
			m_pImpl->transferIniSettings( pEnv );
			break;

		default:
			DBG_ERROR( "MigrationTask_ChaosViews::Execute - Unknown type!" );
			break;
	}
	return 0;
}

