/*************************************************************************
 *
 *  $RCSfile: reg4msdoc.cxx,v $
 *
 *  $Revision: 1.13.114.1 $
 *
 *  last change: $Author: hr $ $Date: 2004/01/15 15:04:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <tools/presys.h>
#include <windows.h>
#include <tools/postsys.h>

#define VCL_NEED_BASETSD

#ifndef _REG4MSDOCMAINDLG_HXX
#include "reg4msdocmaindlg.hxx"
#endif

#ifndef _SETUP_ENVIRON_HXX
#include "environ.hxx"
#endif

#ifndef _SICUSTOM_HXX
#include "sicustom.hxx" 
#endif

#ifndef _OSL_DIAGNOSE_HXX_
#include <osl/diagnose.h>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _CONFIG_HXX
#include <tools/config.hxx>
#endif

#ifndef _TOOLS_RESMGR_HXX
#include <tools/resmgr.hxx>
#endif

#ifndef _OSL_THREAD_H_
#include <osl/thread.h>
#endif

#include <memory>

#ifndef _REGISTER_HXX_
#include "register.hxx"
#endif

#ifndef _PREG4MSDOC_HRC
#include "preg4msdoc.hrc"
#endif

//---------------------------------------
// namespace directives 
//---------------------------------------

using namespace osl;
using namespace rtl;

//---------------------------------------
// extern declarations
//---------------------------------------

extern "C" BOOL _SV_CALL CustomInit( SiSetupFnc* pSetupFnc, SiCustomFnc* pCustomFnc );

//---------------------------------------
//
//---------------------------------------

typedef std::auto_ptr<ResMgr> ResMgrPtr_t;

//---------------------------------------
// forwards
//---------------------------------------

const bool NOT_INSTALLED = false;
const bool INSTALLED        = true;
int QueryModules(SiCustomModuleList* pModuleList, bool bInstallModules = NOT_INSTALLED);

void HandleAfterInstallation(SiCustomEnvironment* pEnv);
rtl::OUString GetFullProgramPath(SiCustomEnvironment* pEnv);

//---------------------------------------
// defines
//---------------------------------------

#define RES_NAME reg4msdoc

//---------------------------------------
// globals 
//---------------------------------------

SiSetupFnc aSetupFnc;

static int g_UserPreferences  = 0;
static int g_UninstallModules = 0;

//---------------------------------------
// constants
//---------------------------------------
 
const OString WRITER_MODULE_ID  = "gid_Module_Prg_Wrt_Bin";
const OString CALC_MODULE_ID    = "gid_Module_Prg_Calc_Bin";
const OString IMPRESS_MODULE_ID = "gid_Module_Prg_Impress_Bin";
const OString ACTIVEX_MODULE_ID = "gid_Module_Optional_Activexcontrol";

const bool INSTALL_MODULES   = false;
const bool UNINSTALL_MODULES = true;

const OUString BACKSLASH = OUString::createFromAscii("\\");

const OString REG4MSDOC_GROUP_NAME("Windows_Desktop_Integration");

const OString RESPKEY_REG4MSWORD("RegisterForMsWord");
const OString RESPKEY_REG4MSEXCEL("RegisterForMsExcel");
const OString RESPKEY_REG4MSPOWERPOINT("RegisterForMsPowerPoint");
const OString RESPKEY_REG4DEFHTMLEDT("RegisterAsDefaultHtmlEditor");

const OString YES("yes");
const OString NO("no");

//---------------------------------------
// Helper functions
//---------------------------------------

inline bool IsBeforeInstallation( SiCustomEnvironment *pEnv )
{ return ( !pEnv->IsModify() && !pEnv->IsRepair() && pEnv->IsInstallation() && pEnv->IsPre() ); } 
    
inline bool IsAfterInstallation( SiCustomEnvironment *pEnv )
{ return ( !pEnv->IsModify() && !pEnv->IsRepair() && pEnv->IsInstallation() && pEnv->IsPost() ); }

inline bool IsDeinstallation( SiCustomEnvironment *pEnv )
{ return ( !pEnv->IsModify() && !pEnv->IsRepair() && pEnv->IsDeinstallation() ); }

inline bool IsSetupModifyBefore(SiCustomEnvironment *pEnv)
{ return (pEnv->IsModify() && pEnv->IsPre()); }

inline bool IsSetupModifyAfter(SiCustomEnvironment *pEnv)
{ return (pEnv->IsModify() && pEnv->IsPost()); }

inline bool IsSetupRepair( SiCustomEnvironment *pEnv )
{ return  pEnv->IsRepair(); }

inline bool IsModule(const OString& ExpectedModuleName, const OString& ModuleName)
{ return (ModuleName.equalsIgnoreAsciiCase(ExpectedModuleName)); }

//---------------------------------------
// traverses the module list and returns
// a number identifying which modules
// should be installed
// the number has to be interpreted as
// bit field
// 0x1 means Writer
// 0x2 means Calc
// 0x4 means Impress
// 0x40 means ActiveX control
//---------------------------------------

int QueryModules(SiCustomModuleList* pModuleList, bool bInstallModules)
{
    int nRet = 0;

    sal_Int32 nModules = pModuleList->Count();
    
    for (sal_Int32 i = 0; i < nModules; i++)
    {                
        SiCustomModuleInfo* pCustModInf = pModuleList->GetObject(i);

        if (pCustModInf->IsSelected() && (pCustModInf->IsInstalled() == bInstallModules))
        {
            ByteString strModID = pModuleList->GetObject(i)->GetModuleID();

            if (IsModule(WRITER_MODULE_ID, strModID))
                nRet |= MOD_WRITER;
            else if (IsModule(CALC_MODULE_ID, strModID))
                nRet |= MOD_CALC;
            else if ( IsModule(IMPRESS_MODULE_ID, strModID))
                nRet |= MOD_IMPRESS;
            else if ( IsModule(ACTIVEX_MODULE_ID, strModID))
                nRet |= MOD_ACTIVEX;

            if ((nRet & MOD_WRITER) && (nRet & MOD_CALC) && (nRet & MOD_IMPRESS) && (nRet & MOD_ACTIVEX))
                break;
        }
    }

    return nRet;
}

/** Returns which modules will be installed
*/
inline int QueryNewInstallModules(SiCustomModuleList* pModuleList)
{
    return QueryModules(pModuleList);
}

/** Returns which modules will be uninstalled
*/
inline int QueryUninstallModules(SiCustomModuleList* pModuleList)
{
    return QueryModules(pModuleList, true);
}

/** Returns which modules are installed and will not change
*/
inline int QueryInstalledModules(SiCustomModuleList* pModuleList)
{
     int nRet = 0;

    sal_Int32 nModules = pModuleList->Count();
    
    for (sal_Int32 i = 0; i < nModules; i++)
    {                
        SiCustomModuleInfo* pCustModInf = pModuleList->GetObject(i);

        if (pCustModInf->IsInstalled() && !pCustModInf->IsSelected())
        {
            ByteString strModID = pModuleList->GetObject(i)->GetModuleID();

            if (IsModule(WRITER_MODULE_ID, strModID))
                nRet |= MOD_WRITER;
            else if (IsModule(CALC_MODULE_ID, strModID))
                nRet |= MOD_CALC;
            else if (IsModule(IMPRESS_MODULE_ID, strModID))
                nRet |= MOD_IMPRESS;
             else if ( IsModule(ACTIVEX_MODULE_ID, strModID))
                nRet |= MOD_ACTIVEX;
               
            if ((nRet & MOD_WRITER) && (nRet & MOD_CALC) && (nRet & MOD_IMPRESS) && (nRet & MOD_ACTIVEX))
                break;
        }
    }

    return nRet;
}

//---------------------------------------
//
//---------------------------------------

bool query_preselect_registration(int App, SiCustomEnvironment* pEnv)
{
    bool install_for_all_user = pEnv->GetBigEnv()->InstallForAllUser();	
	OUString prog_path = GetFullProgramPath(pEnv);
	ResMgrPtr_t res_mgr(CREATEVERSIONRESMGR(RES_NAME));
	    
    return query_preselect_registration_for_ms_application(
        App, prog_path, res_mgr.get(), install_for_all_user);
}

//#######################################
OString query_user_preselect_settings(const OString& named_setting)
{
    Config config_reader(XubString(
        aSetupFnc.fncGetCodeFilename(), osl_getThreadTextEncoding()));
        
    if (config_reader.HasGroup(REG4MSDOC_GROUP_NAME))
    {
        config_reader.SetGroup(REG4MSDOC_GROUP_NAME);
        sal_Int32 group_key_count = config_reader.GetKeyCount();
        
        for (int i = 0; i < group_key_count; i++)     
            if (named_setting.matchIgnoreAsciiCase(config_reader.GetKeyName(i)))
                return config_reader.ReadKey(i);        
    }
    return OString();
}

//#######################################
inline bool query_preselect_ms_word_registration(SiCustomEnvironment* pEnv)
{
    OString user_preselect_setting =
        query_user_preselect_settings(RESPKEY_REG4MSWORD);
    
    if (user_preselect_setting.matchIgnoreAsciiCase(YES))
        return true;
    
    if (user_preselect_setting.matchIgnoreAsciiCase(NO))
        return false;
        
    return query_preselect_registration(MSWORD, pEnv);    
}

//#######################################
inline bool query_preselect_ms_excel_registration(SiCustomEnvironment* pEnv)
{ 
    OString user_preselect_setting =
        query_user_preselect_settings(RESPKEY_REG4MSEXCEL);
    
    if (user_preselect_setting.matchIgnoreAsciiCase(YES))
        return true;
    
    if (user_preselect_setting.matchIgnoreAsciiCase(NO))
        return false;
        
    return query_preselect_registration(MSEXCEL, pEnv); 
}

//#######################################
inline bool query_preselect_ms_power_point_registration(SiCustomEnvironment* pEnv)
{
    OString user_preselect_setting =
        query_user_preselect_settings(RESPKEY_REG4MSPOWERPOINT);
    
    if (user_preselect_setting.matchIgnoreAsciiCase(YES))
        return true;
    
    if (user_preselect_setting.matchIgnoreAsciiCase(NO))
        return false;
    
    return query_preselect_registration(MSPOWERPOINT, pEnv);   
}

//---------------------------------------
//
//---------------------------------------

void SetupQueryReg4MsDocDialog(
    Reg4MsDocMainDialog& aDialog, 
    int NewInstallModules, 
    int InstalledModules, 
    SiCustomEnvironment* pEnv)
{
    aDialog.Reg4MsWord(false);
    aDialog.EnableReg4MsWord(false);

    aDialog.Reg4MsExcel(false);
    aDialog.EnableReg4MsExcel(false);

    aDialog.Reg4MsPowerPoint(false);
    aDialog.EnableReg4MsPowerPoint(false);

    aDialog.Reg4DefHtmlEdt(false);
    aDialog.EnableReg4DefHtmlEdt(false);
    
    ResMgrPtr_t aResMgrPtr(CREATEVERSIONRESMGR(RES_NAME));
    
    if (NewInstallModules & MOD_WRITER)
    {
        aDialog.Reg4MsWord(query_preselect_ms_word_registration(pEnv));
        aDialog.EnableReg4MsWord(true);

        aDialog.Reg4DefHtmlEdt(true);
        aDialog.EnableReg4DefHtmlEdt(true);
    }
    else if (InstalledModules & MOD_WRITER)
    {
        if (IsRegisteredFor(
                GetFullProgramPath(pEnv), 
                aResMgrPtr.get(), 
                pEnv->GetBigEnv()->InstallForAllUser(), 
                MSWORD))        
            aDialog.Reg4MsWord(true);
        else
            aDialog.Reg4MsWord(false);
            
        aDialog.EnableReg4MsWord(true);
        
        if (IsRegisteredFor(
                GetFullProgramPath(pEnv), 
                aResMgrPtr.get(), 
                pEnv->GetBigEnv()->InstallForAllUser(), 
                DEFAULT_HTML_EDITOR_FOR_IE | DEFAULT_SHELL_HTML_EDITOR))
            aDialog.Reg4DefHtmlEdt(true);
        else
            aDialog.Reg4DefHtmlEdt(false);
            
        aDialog.EnableReg4DefHtmlEdt(true);
    }
    
    if (NewInstallModules & MOD_CALC)
    {
        aDialog.Reg4MsExcel(query_preselect_ms_excel_registration(pEnv));
        aDialog.EnableReg4MsExcel(true);
    }
    else if (InstalledModules & MOD_CALC)
    {
        if (IsRegisteredFor(
                GetFullProgramPath(pEnv), 
                aResMgrPtr.get(), 
                pEnv->GetBigEnv()->InstallForAllUser(), 
                MSEXCEL))
            aDialog.Reg4MsExcel(true);
        else
            aDialog.Reg4MsExcel(false);
            
        aDialog.EnableReg4MsExcel(true);
    }
    
    if (NewInstallModules & MOD_IMPRESS)
    {
        aDialog.Reg4MsPowerPoint(query_preselect_ms_power_point_registration(pEnv));
        aDialog.EnableReg4MsPowerPoint(true);
    }
    else if (InstalledModules & MOD_IMPRESS)
    {
        if (IsRegisteredFor(
                GetFullProgramPath(pEnv), 
                aResMgrPtr.get(), 
                pEnv->GetBigEnv()->InstallForAllUser(), 
                MSPOWERPOINT))
            aDialog.Reg4MsPowerPoint(true);
        else
            aDialog.Reg4MsPowerPoint(false);
            
        aDialog.EnableReg4MsPowerPoint(true);
    }
}

//---------------------------------------
//
//---------------------------------------

bool ResponseFileQueryUserPreferences(SiCustomEnvironment* pEnv, SiCustomModuleList* pList, int& UserPref)
{
    int NewInstallModules = QueryNewInstallModules(pList);
    int InstalledModules   = QueryInstalledModules(pList);

    UserPref = 0;

    if ((NewInstallModules & MOD_WRITER) || (InstalledModules & MOD_WRITER))
    {
        UserPref |= MSWORD;
        UserPref |= DEFAULT_HTML_EDITOR_FOR_IE;
		UserPref |= HTML_EDITOR;
        UserPref |= DEFAULT_SHELL_HTML_EDITOR;
    }    
    
    if ((NewInstallModules & MOD_CALC) || (InstalledModules & MOD_CALC))
        UserPref |= MSEXCEL;

    if ((NewInstallModules & MOD_IMPRESS) || (InstalledModules & MOD_IMPRESS))
        UserPref |= MSPOWERPOINT;

    OUString aRespFileName = OUString(
            pEnv->GetResponseFileName().GetBuffer(),
            pEnv->GetResponseFileName().Len(), 
            osl_getThreadTextEncoding());

    Config aRespFile(aRespFileName);

    if (aRespFile.HasGroup(REG4MSDOC_GROUP_NAME))
    {
        aRespFile.SetGroup(REG4MSDOC_GROUP_NAME);

        OString Response = aRespFile.ReadKey(RESPKEY_REG4MSWORD);

        if (Response.matchIgnoreAsciiCase(NO))
            UserPref &= ~MSWORD;            

        Response = aRespFile.ReadKey(RESPKEY_REG4MSEXCEL);

        if (Response.matchIgnoreAsciiCase(NO))
            UserPref &= ~MSEXCEL;

        Response = aRespFile.ReadKey(RESPKEY_REG4MSPOWERPOINT);

        if (Response.matchIgnoreAsciiCase(NO))
            UserPref &= ~MSPOWERPOINT;

        Response = aRespFile.ReadKey(RESPKEY_REG4DEFHTMLEDT);

        if (Response.matchIgnoreAsciiCase(NO))
        {
            UserPref &= ~DEFAULT_HTML_EDITOR_FOR_IE;
            UserPref &= ~DEFAULT_SHELL_HTML_EDITOR;
        }
    }

    return true;
}


//---------------------------------------
//
//---------------------------------------

bool DialogQueryUserPreferences(SiCustomEnvironment* pEnv, SiCustomModuleList* pList, int& UserPref )
{ 
    OSL_ASSERT(pList);

    UserPref = 0;
    
    bool bResult = true;

    int NewInstallModules = QueryNewInstallModules(pList);
    int InstalledModules   = QueryInstalledModules(pList);
    
    if (NewInstallModules || InstalledModules)
    {
        ResMgr *pResMgr = CREATEVERSIONRESMGR(RES_NAME);

        OSL_ENSURE(pResMgr, "could not create res-manager");

        Reg4MsDocMainDialog reg4MsDocDlg(NULL, pResMgr);
    
        SetupQueryReg4MsDocDialog(reg4MsDocDlg, NewInstallModules, InstalledModules, pEnv);

        reg4MsDocDlg.StartAgentDlg();  
        reg4MsDocDlg.SetHelpAvailable(String(ResId(STR_HELP_TEXT, pResMgr)));
        reg4MsDocDlg.Show();
    
        bResult = reg4MsDocDlg.DoModal();

		// we always register as html editor for Internet Explorer 
        // if writer is installed because there's no harm if we do so 
		if ((NewInstallModules & MOD_WRITER) || (InstalledModules & MOD_WRITER))
			UserPref |= HTML_EDITOR;

        if (reg4MsDocDlg.Reg4MsWord())
            UserPref |= MSWORD;

        if (reg4MsDocDlg.Reg4MsExcel())
            UserPref |= MSEXCEL;

        if (reg4MsDocDlg.Reg4MsPowerPoint())
            UserPref |= MSPOWERPOINT;

        if (reg4MsDocDlg.Reg4DefHtmlEdt())
        {
            UserPref |= DEFAULT_HTML_EDITOR_FOR_IE;
            UserPref |= DEFAULT_SHELL_HTML_EDITOR;
        }
    }

    return bResult;
}

//---------------------------------------
//
//---------------------------------------

bool QueryUserPreferences( SiCustomEnvironment* pEnv, SiCustomModuleList* pList, int& UserPref )
{
    bool bResult;

    if (pEnv->IsResponseFileMode())
        bResult = ResponseFileQueryUserPreferences(pEnv, pList, UserPref);
    else
        bResult = DialogQueryUserPreferences(pEnv, pList, UserPref);

    return bResult;
}

//---------------------------------------
//
//---------------------------------------

OUString GetFullProgramPath(SiCustomEnvironment* pEnv)
{
    OUString path;

	SiInstallType InstType = pEnv->GetBigEnv()->GetInstallType();

	BOOL bItWorkstation  = (InstType == IT_WORKSTATION);
	BOOL bItRecover      = (InstType == IT_RECOVER);
	BOOL bItChange		 = (InstType == IT_CHANGE);
    BOOL bItUninstall    = (InstType == IT_UNINSTALL);
    BOOL bInstallFromNet = pEnv->GetBigEnv()->InstallFromNet();

	if (bInstallFromNet && (bItWorkstation || bItRecover || bItChange || bItUninstall))
		path = OStringToOUString(pEnv->GetBigEnv()->GetSourcePath(), osl_getThreadTextEncoding());
	else
		path = OStringToOUString(pEnv->GetDestPath(), osl_getThreadTextEncoding());        

    if (path.lastIndexOf(BACKSLASH) != (path.getLength() - 1))
        path += BACKSLASH;

    path += OUString::createFromAscii("program\\soffice.exe");
    
    return path;
}

//---------------------------------------
//
//---------------------------------------

OUString GetActiveXFromExePath( OUString aExePath )
{
	sal_Int32 aInd = aExePath.lastIndexOf( BACKSLASH );
	OUString aResult = aExePath.copy( 0, aInd );
	aResult += OUString::createFromAscii( "\\so_activex.dll" );

	return aResult;
}

//---------------------------------------
//
//---------------------------------------

bool HandleBeforeInstallation(SiCustomEnvironment* pEnv, SiCustomModuleList* pList)
{
	bool bRet = true;
	bool InstallForAllUser = pEnv->GetBigEnv()->InstallForAllUser();

	if (!pEnv->GetBigEnv()->IsUpdateOldVersion())
	{
		bRet = QueryUserPreferences(pEnv, pList, g_UserPreferences);
	}
	else // don't show the dialog
	{
		g_UserPreferences = FixReturnRegistrationState(InstallForAllUser);
		
		// OO1.0/StarOffice 6.0 always registers for all
		// users, we unregister first to avoid problems
		// because OO 1.1/StarOffice6.1 normaly register 
		// per user, in case of an update installation 
		// 
	    OUString prog_path = GetFullProgramPath(pEnv);
        ResMgrPtr_t res_mgr(CREATEVERSIONRESMGR(RES_NAME));            
        Unregister4MsDocAll(prog_path, res_mgr.get(), true);
	}

	return bRet;
}

//---------------------------------------
// called after the installation of the
// modules finished in case of 
// Installation or Modification
//---------------------------------------

void HandleAfterInstallation(SiCustomEnvironment* pEnv, SiCustomModuleList* pModuleList)
{
	bool InstallForAllUser = pEnv->GetBigEnv()->InstallForAllUser();
	int InstalledModules = QueryInstalledModules( pModuleList );
	OUString aFullProgramPath = GetFullProgramPath( pEnv );
	ResMgrPtr_t aResMgrPtr(CREATEVERSIONRESMGR(RES_NAME));
    
	Register4MsDoc(
		g_UserPreferences, 
		aFullProgramPath, 
		aResMgrPtr.get(),
		InstallForAllUser );

	if( MOD_ACTIVEX & InstalledModules )
		RegisterActiveX4MSDoc( GetActiveXFromExePath( aFullProgramPath ), g_UserPreferences, InstallForAllUser );	
}

//---------------------------------------
//
//---------------------------------------

void HandleDeinstallation(SiCustomEnvironment* pEnv, SiCustomModuleList* pModuleList)
{
	int InstalledModules = QueryInstalledModules( pModuleList );
	OUString aFullProgramPath = GetFullProgramPath( pEnv );
    ResMgrPtr_t aResMgrPtr(CREATEVERSIONRESMGR( RES_NAME));
    bool InstallForAllUser = pEnv->GetBigEnv()->InstallForAllUser();
    
    Unregister4MsDocAll(
        aFullProgramPath, 
        aResMgrPtr.get(),
        InstallForAllUser );

	if( MOD_ACTIVEX & InstalledModules )
		UnregisterActiveX4MSDocAll( GetActiveXFromExePath( aFullProgramPath ), InstallForAllUser );
}

//---------------------------------------
//
//---------------------------------------

bool HandleSetupModifyBefore(SiCustomEnvironment* pEnv, SiCustomModuleList* pModuleList)
{            
	g_UninstallModules = QueryUninstallModules(pModuleList);    

    return QueryUserPreferences(pEnv, pModuleList, g_UserPreferences);
}

//---------------------------------------
//
//---------------------------------------

void HandleSetupModifyAfter(SiCustomEnvironment* pEnv, SiCustomModuleList* pModuleList)
{
    ResMgrPtr_t aResMgrPtr(CREATEVERSIONRESMGR(RES_NAME));
    OUString OfficeExePath = GetFullProgramPath(pEnv);
    bool InstallForAllUser = pEnv->GetBigEnv()->InstallForAllUser();
	int InstalledModules = QueryInstalledModules( pModuleList );
    
    Register4MsDoc(
		g_UserPreferences, 
		OfficeExePath, 
		aResMgrPtr.get(),
        InstallForAllUser);
   

	if( MOD_ACTIVEX & InstalledModules )
		RegisterActiveX4MSDoc( GetActiveXFromExePath( OfficeExePath ), g_UserPreferences, InstallForAllUser );
	
    // assuming that all checkboxes that were not
    // selected mean unregister 
    int Unregister = ~g_UserPreferences;
    
    // we register as html editor for internet explorer
    // if the writer will be installed, so we have to
    // unregister if the writer will be uninstalled
    if (MOD_WRITER & g_UninstallModules)
        Unregister |= HTML_EDITOR;
        
	Unregister4MsDoc(
        Unregister, 
        OfficeExePath,
        aResMgrPtr.get(),
        InstallForAllUser);

	if( MOD_ACTIVEX & g_UninstallModules )
		UnregisterActiveX4MSDocAll( GetActiveXFromExePath( OfficeExePath ), InstallForAllUser );
	else if( MOD_ACTIVEX & InstalledModules )
		UnregisterActiveX4MSDoc( GetActiveXFromExePath( OfficeExePath ), Unregister, InstallForAllUser );

}

//---------------------------------------
//
//---------------------------------------

void HandleSetupRepair(SiCustomEnvironment* pEnv)
{
    ResMgrPtr_t aResMgrPtr(CREATEVERSIONRESMGR( RES_NAME));
    
    RepairRegister4MsDocSettings(
        GetFullProgramPath(pEnv), 
        aResMgrPtr.get(),
        pEnv->GetBigEnv()->InstallForAllUser());
}

//---------------------------------------
// EntryPoint for setup plug-ins
// called by the setup
//---------------------------------------

BOOL _SV_CALL CustomInit(SiSetupFnc* pSetupFnc, SiCustomFnc* pCustomFnc)
{
	// inkompatibel oder nicht vorhanden ?
	if( !pSetupFnc || pSetupFnc->nVersion > SICUSTOM_VERSION )
		return false;

	pCustomFnc->fncMain = (FncPtrCustomMain)CustomMain;

	aSetupFnc.nVersion 		     = pSetupFnc->nVersion;
	aSetupFnc.fncHideSetup	     = pSetupFnc->fncHideSetup;
	aSetupFnc.fncShowSetup	     = pSetupFnc->fncShowSetup;
    aSetupFnc.fncGetCodeFilename = pSetupFnc->fncGetCodeFilename;

	return true;
}

//---------------------------------------
// CustomMain of setup plug-in
// called by the setup
//---------------------------------------

BOOL _SV_CALL CustomMain(SiCustomEnvironment* pEnv, SiCustomModuleList* pList)
{
    bool bRet = true;
    
    if (IsBeforeInstallation(pEnv))
        bRet = HandleBeforeInstallation(pEnv, pList);
    else if (IsAfterInstallation(pEnv))
        HandleAfterInstallation(pEnv, pList);
	else if (IsSetupModifyAfter(pEnv))
		HandleSetupModifyAfter(pEnv, pList);
    else if (IsDeinstallation(pEnv))
        HandleDeinstallation(pEnv, pList);
    else if (IsSetupModifyBefore(pEnv))
        HandleSetupModifyBefore(pEnv, pList);
    else if (IsSetupRepair(pEnv))
        HandleSetupRepair(pEnv);
    else
        OSL_ENSURE(false, "impossible case?");
    
    return bRet;
}


