/*************************************************************************
 *
 *  $RCSfile: listinitializer.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: tra $ $Date: 2001/12/05 14:32:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _LISTINITIALIZER_HXX_
#define _LISTINITIALIZER_HXX_

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#include <tools/config.hxx>
#include "config.hxx"

//--------------------------------------------
//
//--------------------------------------------

const rtl::OString  CONTENT_TYPES_ENTRY  = "Mime_Types_Entry";
const rtl::OString  MAILCAP_ENTRY        = "Mailcap_Entry";
const rtl::OString  SOFFICE_COMMENT_LINE = "#Line added by SUN Microsystems";

//--------------------------------------------
//
//--------------------------------------------

class ListInitializer
{
public:
    ListInitializer( Config& aConfig, OStringList_t& aList ) :
        m_rConfig(aConfig),
        m_List( aList )
    {
        aList.clear();
    }
    
    virtual ~ListInitializer() { }
    
    void Include( const rtl::OString& aName )
    {
        if ( m_rConfig.HasGroup( aName ) )
        {
            m_rConfig.SetGroup( aName );
            sal_Int32 nGrpKeys = m_rConfig.GetKeyCount();

            for ( sal_Int32 i = 0; i < nGrpKeys; i++ )
            {
                if ( QueryInclude( m_rConfig.GetKeyName(i) ) )
                {                                        
                    rtl::OString aEntry = m_rConfig.ReadKey(i);
                    PrepareEntry( aEntry );
                    
                    m_List.push_back( aEntry );
                }
            }
        }
    }

    void operator() ( const rtl::OString& aName )
    {
        Include( aName );
    }
    
protected:
    virtual void PrepareEntry( rtl::OString& aEntry ) { }
    
    virtual bool QueryInclude( const rtl::OString& aName ) 
    { 
        return true; 
    }
    
private:
    Config&        m_rConfig;
    OStringList_t& m_List;
};

//--------------------------------------------
//
//--------------------------------------------

class MimeTypeListInitializer : public ListInitializer
{
public:
    MimeTypeListInitializer( Config& aConfig, OStringList_t& aList ) :
        ListInitializer( aConfig, aList )
    { }
        
protected:
    
    virtual bool QueryInclude( const rtl::OString& aName )
    {
        return (0 == aName.compareTo( CONTENT_TYPES_ENTRY, CONTENT_TYPES_ENTRY.getLength()));  
    }
};

//--------------------------------------------
//
//--------------------------------------------

class MailcapListInitializer : public ListInitializer
{
public:
    MailcapListInitializer( Config& aConfig, OStringList_t& aList, const rtl::OString& aParam ) :
        ListInitializer( aConfig, aList ),
        m_ProgDirParam( "%PROGDIR%" ),
        m_Param( aParam )
    { }
    
protected:

    virtual void PrepareEntry( rtl::OString& aEntry )
    {
        sal_Int32 nIndex = aEntry.indexOf( m_ProgDirParam );

        OSL_ENSURE( nIndex >= 0, "parameter not found" );

        if ( nIndex > 0 )
        {
            sal_Int32 lenParam = m_ProgDirParam.getLength( );
        
            rtl::OString aNewStrStart( aEntry.getStr( ), nIndex - 1 );
            rtl::OString aNewStrEnd( aEntry.getStr( ) + nIndex + lenParam );
        
            aEntry = aNewStrStart + m_Param + aNewStrEnd;
        }  
    }
    
    virtual bool QueryInclude( const rtl::OString& aName )
    {
        return (0 == aName.compareTo( MAILCAP_ENTRY, MAILCAP_ENTRY.getLength()));
    }

private:
    const rtl::OString m_ProgDirParam;
    rtl::OString m_Param;
};

#endif

