/*************************************************************************
 *
 *  $RCSfile: passrv.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:08:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_EDIT_HXX //autogen
#include <vcl/edit.hxx>
#endif

#include "maindlg.hxx"
#include "environ.hxx"

#include "passrv.hxx"
#include "passrv.hrc"

PageASrvServerName::PageASrvServerName( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage			( pParent, rResId ),
	aFTInfo				( this, ResId(FT_INFO, rResId.GetResMgr()) ),
	aFTServerName		( this, ResId(FT_SERVERNAME, rResId.GetResMgr()) ),
	aEDServerName		( this, ResId(ED_SERVERNAME, rResId.GetResMgr()) ),
	aFTPrintServerName	( this, ResId(FT_PRINT_SERVERNAME, rResId.GetResMgr()) ),
	aEDPrintServerName	( this, ResId(ED_PRINT_SERVERNAME, rResId.GetResMgr()) )
{
	SiEnvironment* pEnv = GETDLG()->GetEnv();

	String aTitle( ResId(STR_TITLE, rResId.GetResMgr()) );
	aTitle.SearchAndReplace( UniString::CreateFromAscii("%1"), pEnv->GetProductName() );
	pParent->SetTitleStr( aTitle );

	FreeResource();

	aTitle = aFTInfo.GetText();
	aTitle.SearchAndReplace( UniString::CreateFromAscii("%1"), pEnv->GetProductName() );
	aFTInfo.SetText( aTitle );

	aTitle = aFTServerName.GetText();
	aTitle.SearchAndReplace( UniString::CreateFromAscii("%1"), pEnv->GetProductName() );
	aFTServerName.SetText( aTitle );

	aTitle = aFTPrintServerName.GetText();
	aTitle.SearchAndReplace( UniString::CreateFromAscii("%1"), pEnv->GetProductName() );
	aFTPrintServerName.SetText( aTitle );
}

PageASrvServerName::~PageASrvServerName()
{
}

SvAgentPage* PageASrvServerName::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageASrvServerName( pParent, rResId );
}

BOOL PageASrvServerName::AllowNext()
{
	SiEnvironment* pEnv = GETDLG()->GetEnv();

	ByteString aValue = aEDServerName.GetText();
	aValue.EraseLeadingChars();
	aValue.EraseTrailingChars();
	pEnv->SetServerName( aValue );

	aValue = aEDPrintServerName.GetText();
	aValue.EraseLeadingChars();
	aValue.EraseTrailingChars();
	pEnv->SetPrintServerName( aValue );

	return TRUE;
}

