/*************************************************************************
 *
 *  $RCSfile: ctrlitem.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2000/12/07 14:33:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFXCTRLITEM_HXX
#define _SFXCTRLITEM_HXX

#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif
#include <so3/binding.hxx>

class SfxPoolItem;
class SfxBindings;
class SvStream;

class SfxControllerItem
{
friend SvStream& operator<<( SvStream& rStream, const SfxControllerItem& rFunc );
friend SvStream& operator>>( SvStream& rStream, SfxControllerItem& rFunc );

private:
	USHORT				nId;
	SfxControllerItem*	pNext; // zu benachrichtigendes weiteres ControllerItem
	SfxBindings*		pBindings;

protected:
#if defined( DBG_UTIL ) && defined( _SOLAR__PRIVATE )
	void 				CheckConfigure_Impl( ULONG nType );
#endif

public:
	SfxBindings &		GetBindings() {
							DBG_ASSERT(pBindings, "keine Bindings");
							return *pBindings;
						}
	const SfxBindings &	GetBindings() const {
							DBG_ASSERT(pBindings, "keine Bindings");
							return *pBindings;
						}

						SfxControllerItem(); // fuer arrays
						SfxControllerItem( USHORT nId, SfxBindings & );
	virtual 			~SfxControllerItem();

	void				Bind( USHORT nNewId, SfxBindings * = 0);	// in SfxBindings registrieren
	void				UnBind();
	void				ReBind();
	BOOL				IsBound() const;
	void				UpdateSlot();
	void				ClearCache();
	void				SetBindings(SfxBindings &rBindings) { pBindings = &rBindings; }

	SfxControllerItem*	GetItemLink();
	SfxControllerItem*	ChangeItemLink( SfxControllerItem* pNewLink );

	void                SetId( USHORT nItemId );
	USHORT				GetId() const { return nId; }

	virtual void		StateChanged( USHORT nSID, SfxItemState eState,
									  const SfxPoolItem* pState );
	virtual void        DeleteFloatingWindow();

	SfxMapUnit			GetCoreMetric() const;

	static SfxItemState	GetItemState( const SfxPoolItem* pState );

#if _SOLAR__PRIVATE
	BOOL					IsBindable_Impl() const
							{ return pBindings != NULL; }
#endif
};

//====================================================================

class SfxStatusForwarder: public SfxControllerItem
{
	SfxControllerItem*		pMaster;

protected:
	virtual void		StateChanged( USHORT nSID, SfxItemState eState,
									  const SfxPoolItem* pState );

public:
							SfxStatusForwarder( USHORT nSlotId,
								   SfxControllerItem&rMaster );
};


#endif

