/*************************************************************************
 *
 *  $RCSfile: exchobj.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: dv $ $Date: 2001/07/26 12:02:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// includes *******************************************************************

#pragma hdrstop

#ifndef _FILELIST_HXX //autogen
#include <so3/filelist.hxx>
#endif
#include "exchobj.hxx"

// globals ********************************************************************

#define EXCHANGEOBJ_OBJLIST_SIZE          5
#define EXCHANGEOBJ_OBJLIST_RESIZE        5
#define EXCHANGEOBJ_OBJLIST_DELEGATIONPOS 0

// rtti ***********************************************************************

SO2_IMPL_BASIC_CLASS1( SfxExchangeObject, SvFactory,
					   SvDataObject, SvGlobalName( 0x67493aa0, 0x8720, 0x11d0,
												   0xa4, 0x1f, 0x44, 0x45,
												   0x53, 0x54, 0x0, 0x0 ) );

//*****************************************************************************
// SfxExchangeObject
//*****************************************************************************

SfxExchangeObject::SfxExchangeObject()
	: 	_pObjList( new SvDataObjectMemberList( EXCHANGEOBJ_OBJLIST_SIZE,
											   EXCHANGEOBJ_OBJLIST_RESIZE ) ),
		_pTypeList( NULL )
/*
  [Beschreibung]
  Ueber diesen Ctor kann eine neues Objekt fuer einen neuen Datenaustausch
  angelegt werden.

  [Querverweise]
  <SfxExchangeObject::SfxExchangeObject( SvDataObject* )>
  */
{
}

//*****************************************************************************

SfxExchangeObject::SfxExchangeObject
(
	SvDataObject* pExternal    /* Datenobjekt, das keine Unterklasse der Klasse
								  SfxExchangeObject ist */
)
	: _pObjList( new SvDataObjectMemberList( EXCHANGEOBJ_OBJLIST_SIZE,
											 EXCHANGEOBJ_OBJLIST_RESIZE ) ),
	  _pTypeList( NULL )

/*
  [Beschreibung]
  Ueber diesen Ctor kann ein eine Instanz einer Unterklasse der Klasse
  <SvDataObject>, die nicht von <SfxExchangeObject> abgeleitet ist, wie selbige
  angesteuert werden.
  */
{
	DBG_ASSERT( pExternal, "SfxExchangeObject:ungueltiges Objekt" );
	DBG_ASSERT( !SfxExchangeObjectRef( pExternal ).Is(),
				"SfxExchangeObject:Objekt ist ein <SfxExchangeObject>" );
	// Referenzanlage, da das Objekt u.U. nicht weiter verwendet wird
	SvDataObjectRef xObj = pExternal;

	// Pruefung, ob das Objekt eine Dateiliste enthaelt
	const SvDataTypeList& rList = pExternal->GetTypeList();
	if ( rList.Get( FORMAT_FILE_LIST ) )
	{
		// Erzeugung einzelner Eintraege, damit die Kunden der Klasse
		// keine Sonderbehandlung machen muessen
		SvData aData( FORMAT_FILE_LIST );
		pExternal->GetData( &aData );
		FileList* pFileList;
		if ( aData.GetData( ( SvDataCopyStream** ) &pFileList,
							FileList::StaticType(), TRANSFER_MOVE ) )
		{
			ULONG nPos = pFileList->Count();
			DBG_ASSERT( nPos, "SfxExchangeObject:leere Dateiliste" );
			while ( nPos-- )
			{
				SvDataMemberObjectRef xObject = new SvDataMemberObject();
				SvData* pData = new SvData( FORMAT_FILE, MEDIUM_MEMORY );
				pData->SetData( pFileList->GetFile( nPos ) );
				xObject->Append( pData );
				Insert( xObject );
			}

			delete pFileList;
		}
	}

	// Pruefung, ob eine Dateiliste aufgeloest wurde
	if ( !_pObjList->Count() )
	{
		Insert( pExternal );
	}
}

//*****************************************************************************

SfxExchangeObject::~SfxExchangeObject()
{
	delete _pTypeList;
	delete _pObjList;
}

//*****************************************************************************

SfxExchangeObjectRef SfxExchangeObject::DetectObject_Impl
(
	SvDataObject* pObj    // zu pruefendes Objekt
)
/*
  [Beschreibung]
  Die statische Methode prueft, ob das spezifizierte Objekt eine Instanz der
  Klasse <SfxExchangeObject> ist. Ist dies nicht der Fall, so wird eine
  Instanz der Klasse <SfxExchangeObject> konstruiert, die alle Aufrufe auf das
  Objekt delegiert.
  */
{
	DBG_ASSERT( pObj, "SfxExchangeObject:ungueltiges Objekt" );

	// Pruefung, ob es sich um eine Instanz der Klasse <SfxExchangeObject>
	// handelt
	SfxExchangeObjectRef xExchangeObj( pObj );
	if ( !xExchangeObj.Is() )
	{
		// Erzeugung einer Instanz der Klasse <SfxExchangeObject>, die alle
		// Aufrufe auf die Instanz delegiert
		xExchangeObj = new SfxExchangeObject( pObj );
	}
	return xExchangeObj;
}

//*****************************************************************************

BOOL SfxExchangeObject::SetFileList_Impl
(
	SvData* pData    // Objekt, an dem die Daten gesetzt werden sollen
) const
/*
  [Beschreibung]
  Die Methode setzt an der spezifizierten Instanz eine Liste von Dateien.

  [Anmerkungen]
  Die Methode wird nur gerufen, wenn alle Objekte innerhalb der Instanz, das
  Format fuer Dateien unterstuetzt.

  [Rueckgabewert]
  FALSE, wenn die Aktion fehlgeschlagen ist
  ...
  */
{
	DBG_ASSERT( pData, "SfxExchangeObject:ungueltiges Objekt" );
	DBG_ASSERT( pData->GetFormat() ==  FORMAT_FILE_LIST,
				"SfxExchangeObject:falsches Format fuer SetFileList_Impl" );
	DBG_ASSERT( _pTypeList && _pTypeList->Get( FORMAT_FILE_LIST ),
				"SfxExchangeObject:Format wird nicht unterstuetzt" );

	// Iteration ueber alle Objekte
	FileList* pList = new FileList();
	ULONG nPos = Count();
	DBG_ASSERT( nPos,
				"SfxExchangeObject:Dateiliste mit keinem Objekt" );
	String aFilename;
	SvData* pTempData = new SvData( FORMAT_FILE, MEDIUM_MEMORY );
	while ( nPos-- )
	{
		// Bestimmung des Dateinamens
		SvDataObject* pObj = GetObject( nPos );
		BOOL bResult = pObj->GetData( pTempData );
		if ( !bResult )
		{
			delete pList;
			delete pTempData;
			return FALSE;
		}
		bResult = pTempData->GetData( aFilename );
		if ( !bResult )
		{
			delete pList;
			delete pTempData;
			return FALSE;
		}
		pList->AppendFile( aFilename );
	}
	// Setzung der Liste der Dateinamen am Zielobjekt
	delete pTempData;
	pData->SetData( pList, TRANSFER_MOVE );
	return TRUE;
}

//*****************************************************************************

const SvDataTypeList& SfxExchangeObject::GetTypeList() const
/*
  [Beschreibung]
  Die Methode wird gerufen, um zu bestimmen, welche Datenformate und Medien
  die Instanz unterstuetzt. Sie delegiert den Aufruf auf ein Objekt des
  Datenaustausches.

  [Anmerkungen]
  Das Standardinterface sollte nur aus dem externen Bereich verwendet werden.
  Ansonsten sollte immer direkt ein Objekt aus der Liste angesteuert werden.

  [Rueckgabewert]
  die Liste der Datenformate und Medien

  [Querverweise]
  <SfxExchangeObject::GetData( SvData* )>
  */
{
	DBG_ASSERT( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS < Count(),
				"SfxExchangeObject:Objekt fuer Delegation fehlt" );

	const SvDataTypeList& rList =
		GetObject( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS )->GetTypeList();

	// Pruefung, ob alle Datenobjekte das Format fuer Dateien unterstuetzen
	if ( !rList.Get( FORMAT_FILE_LIST ) )
	{
		if ( !_pTypeList )
		{
			BOOL bSupport = TRUE;
			USHORT nPos = Count();
			while ( nPos-- )
			{
				SvDataObject* pObj = GetObject( nPos );
				const SvDataTypeList& rObjList = pObj->GetTypeList();
				if ( !rObjList.Get( FORMAT_FILE ) )
				{
					bSupport = FALSE;
					break;
				}
			}

			( ( SfxExchangeObject* )( this ) )->_pTypeList =
				new SvDataTypeList( rList );
			if ( bSupport )
			{
				( ( SfxExchangeObject* )( this ) )->_pTypeList->
					Insert( SvDataType( FORMAT_FILE_LIST,
										MEDIUM_MEMORY ) );
			}
		}

		if ( _pTypeList )
		{
			return *_pTypeList;
		}
	}

	return rList;
}

//*****************************************************************************

const SvDataTypeList& SfxExchangeObject::GetSetDataTypeList() const
/*
  [Beschreibung]
  Die Methode wird gerufen, um zu bestimmen, welche Datenformate und Medien
  an der Instanz gesetzt werden koennen. Sie delegiert den Aufruf auf ein
  Objekt des Datenaustausches.

  [Anmerkungen]
  Das Standardinterface sollte nur aus dem externen Bereich verwendet werden.
  Ansonsten sollte immer direkt ein Objekt aus der Liste angesteuert werden.

  [Rueckgabewert]
  die Liste der Datenformate und Medien

  [Querverweise]
  <SfxExchangeObject::SetData( SvData* )>
  */
{
	DBG_ASSERT( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS < Count(),
				"SfxExchangeObject:Objekt fuer Delegation fehlt" );
	return GetObject( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS )->
		GetSetDataTypeList();
}

//*****************************************************************************

BOOL SfxExchangeObject::SetData
(
	SvData* pData    // zu setzende Daten
)
/*
  [Beschreibung]
  Die Methode wird gerufen, um die spezifizierten Daten an der Instanz zu
  setzen. Sie delegiert den Aufruf auf ein Objekt des Datenaustausches.

  [Anmerkungen]
  Das Standardinterface sollte nur aus dem externen Bereich verwendet werden.
  Ansonsten sollte immer direkt ein Objekt aus der Liste angesteuert werden.

  [Rueckgabewert]
  FALSE, wenn die Aktion fehlgeschlagen ist

  [Querverweise]
  <SfxExchangeObject::GetData( SvData* )>
  <SfxExchangeObject::GetDataHere( SvData* )>
  */
{
	DBG_ASSERT( pData, "SfxExchangeObject:ungueltige Daten" );
	DBG_ASSERT( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS < Count(),
				"SfxExchangeObject:Objekt fuer Delegation fehlt" );
	return GetObject( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS )->SetData( pData );
}

//*****************************************************************************

BOOL SfxExchangeObject::GetData
(
	SvData* pData    // Objekt, an dem die Daten zu setzen sind
)
/*
  [Beschreibung]
  Die Methode wird gerufen, um die Daten der Instanz in dem spezifizierten
  Format in der spezifizierten Instanz abzulegen. Sie delegiert den Aufruf auf
  ein Objekt des Datenaustausches.

  [Anmerkungen]
  Das Standardinterface sollte nur aus dem externen Bereich verwendet werden.
  Ansonsten sollte immer direkt ein Objekt aus der Liste angesteuert werden.

  [Rueckgabewert]
  FALSE, wenn die Aktion fehlgeschlagen ist

  [Querverweise]
  <SfxExchangeObject::SetData( SvData* )>
  <SfxExchangeObject::GetDataHere( SvData* )>
  */
{
	DBG_ASSERT( pData, "SfxExchangeObject:ungueltige Daten" );
	DBG_ASSERT( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS < Count(),
				"SfxExchangeObject:Objekt fuer Delegation fehlt" );

	// Pruefung, ob eine Liste von Dateinamen geliefert werden soll
	if ( pData->GetFormat() == FORMAT_FILE_LIST && _pTypeList )
	{
		// Erzeugung der Liste der Dateienamen
		return SetFileList_Impl( pData );
	}
	return GetObject( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS )->GetData( pData );
}

//*****************************************************************************

BOOL SfxExchangeObject::GetDataHere
(
	SvData* pData    // Objekt, an dem die Daten zu setzen sind
)
/*
  [Beschreibung]
  Die Methode wird gerufen, um die Daten der Instanz in dem spezifizierten
  Format und ueber das spezifizierte Medium in der spezifizierten Instanz
  abzulegen. Sie delegiert den Aufruf auf ein Objekt des Datenaustausches.

  [Anmerkungen]
  Das Standardinterface sollte nur aus dem externen Bereich verwendet werden.
  Ansonsten sollte immer direkt ein Objekt aus der Liste angesteuert werden.

  [Rueckgabewert]
  FALSE, wenn die Aktion fehlgeschlagen ist

  [Querverweise]
  <SfxExchangeObject::SetData( SvData* )>
  <SfxExchangeObject::GetData( SvData* )>
  */
{
	DBG_ASSERT( pData, "SfxExchangeObject:ungueltige Daten" );
	DBG_ASSERT( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS < Count(),
				"SfxExchangeObject:Objekt fuer Delegation fehlt" );

	// Pruefung, ob eine Liste von Dateinamen geliefert werden soll
	if ( pData->GetFormat() == FORMAT_FILE_LIST && _pTypeList )
	{
		// Erzeugung der Liste der Dateienamen
		return SetFileList_Impl( pData );
	}
	return GetObject( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS )->
		GetDataHere( pData );
}

//*****************************************************************************

BOOL SfxExchangeObject::QueryDataType
(
	SvDataType& rInOutType    // optimales Medium, optimales Format
)
/*
  [Beschreibung]
  Die Methode wird gerufen, um das beste Format und das beste Medium zu
  bestimmen Daten. Sie delegiert den Aufruf auf ein Objekt des
  Datenaustausches.

  [Anmerkungen]
  Das Standardinterface sollte nur aus dem externen Bereich verwendet werden.
  Ansonsten sollte immer direkt ein Objekt aus der Liste angesteuert werden.

  [Rueckgabewert]
  FALSE, wenn die Aktion fehlgeschlagen ist

  [Querverweise]
  <SfxExchangeObject::SetData( SvData* )>
  <SfxExchangeObject::GetData( SvData* )>
  <SfxExchangeObject::GetDataHere( SvData* )>
  */
{
	DBG_ASSERT( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS < Count(),
				"SfxExchangeObject:Objekt fuer Delegation fehlt" );

	// Pruefung, ob das Format fuer Dateilisten unterstuetzt wird
	const SvDataType* pType;
	if ( _pTypeList && ( pType = _pTypeList->Get( FORMAT_FILE_LIST ) ) )
	{
		// Format fuer Dateilisten als bevorzugtes Format
		rInOutType = *pType;
		return TRUE;
	}
	return GetObject( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS )->
		QueryDataType( rInOutType );
}

//*****************************************************************************

SfxExchangeObjectRef SfxExchangeObject::PasteClipboard()
/*
  [Beschreibung]
  Die statische Methode prueft, ob in der Zwischenablage eine Instanz der
  Klasse <SfxExchangeObject> steht. Ist dieses der Fall wird selbige geliefert.
  Ansonsten wird eine Instanz der Klasse <SfxExchangeObject> erstellt die
  alle Aufrufe auf die Instanz delegiert.

  [Rueckgabewert]
  NULL, wenn die Zwischenablage leer ist
  ...
  */
{
	SvDataObjectRef xObj = SvDataObject::PasteClipboard();
	if ( !xObj.Is() )
	{
#ifndef MAC
		return (SfxExchangeObjectRef)xObj;
#else
		return xObj;
#endif
	}

	// Bestimmung einer Instanz der Klasse <SfxExchangeObject>
	return DetectObject_Impl( xObj );
}

//*****************************************************************************

SfxExchangeObjectRef SfxExchangeObject::PasteDragServer
(
	const DropEvent& rEvt    // Ereignisdaten
)
/*
  [Beschreibung]
  Die statische Methode prueft, ob in beim D&D-Vorgang eine Instanz der Klasse
  <SfxExchangeObject> verwendet wird. Ist dieses der Fall wird selbige
  geliefert.  Ansonsten wird eine Instanz der Klasse <SfxExchangeObject>
  erstellt die alle Aufrufe auf die Instanz delegiert.

  [Rueckgabewert]
  NULL, wenn kein Objekt verfuegbar ist
  ...
  */
{
	SvDataObjectRef xObj = SvDataObject::PasteDragServer( rEvt );
	if ( !xObj.Is() )
	{
#ifndef MAC
		return (SfxExchangeObjectRef)xObj;
#else
		return xObj;
#endif
	}

	// Bestimmung einer Instanz der Klasse <SfxExchangeObject>
	return DetectObject_Impl( xObj );
}


