/*************************************************************************
 *
 *  $RCSfile: itmfac.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:52:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop


#ifndef _TOOLS_TIME_HXX //autogen
#include <tools/time.hxx>
#endif

#ifndef _GLOBNAME_HXX
#include <tools/globname.hxx>
#endif
#include "app.hxx"

class SfxItemFactory_Impl
{
	SvGlobalName      aGlobName;
	SfxItemCreateFunc pFunc;
	SfxPoolItem*      pFactItem;

public:
	SfxItemFactory_Impl(const SvGlobalName& rName, SfxItemCreateFunc pFuncP )
		: aGlobName( rName ), pFunc( pFuncP ), pFactItem( 0 ) {}
	const SvGlobalName& GetGlobalName() const { return aGlobName; }
	SfxPoolItem*  Create( USHORT nId, SvStream* pStrm ) const;
	TypeId GetType() const { return (TypeId) pFunc; }
};

SfxPoolItem* SfxItemFactory_Impl::Create( USHORT nId, SvStream* pStrm ) const
{
	if( !pStrm )
		return (*pFunc)();
	else
	{
		if( !pFactItem )
			((SfxItemFactory_Impl*)this)->pFactItem = (*pFunc )();
		SfxPoolItem* pRet = pFactItem->Create(
			*pStrm, pFactItem->GetVersion( SOFFICE_FILEFORMAT_40 ) );
		pRet->SetWhich( nId );
		return pRet;
	}
}

SfxItemFactoryList::~SfxItemFactoryList()
{
	for ( ULONG n = aList.Count(); n--; )
		delete aList.GetObject(n);
}

SfxItemFactory_Impl* SfxItemFactoryList::GetFactory_Impl(
  const SvGlobalName& rGlob) const
{
	USHORT nCount = ( USHORT ) aList.Count();
	for( USHORT n = 0; n <nCount; n++ )
	{
		SfxItemFactory_Impl* pFact =
			(SfxItemFactory_Impl *) aList.GetObject( n );
		if( pFact->GetGlobalName()	== rGlob )
			return pFact;
	}
	return 0;
}

SfxItemFactory_Impl* SfxItemFactoryList::GetFactory_Impl(
	TypeId aType) const
{
	USHORT nCount = ( USHORT ) aList.Count();
	for( USHORT n = 0; n <nCount; n++ )
	{
		SfxItemFactory_Impl* pFact =
			(SfxItemFactory_Impl *) aList.GetObject( n );
		if( pFact->GetType() == aType )
			return pFact;
	}
	return 0;
}

void SfxItemFactoryList::RegisterItemFactory(
	const SvGlobalName& rName, SfxItemCreateFunc pFunc)
{
	aList.Insert( new SfxItemFactory_Impl( rName, pFunc ), aList.Count() );
}


SfxPoolItem* SfxItemFactoryList::Create(
	const SvGlobalName& rGlob, USHORT nId, SvStream* pStrm ) const
{
	SfxItemFactory_Impl* pFact = GetFactory_Impl( rGlob );
	if( pFact )
		return pFact->Create( nId, pStrm );
	else
		return 0;
}

const SvGlobalName* SfxItemFactoryList::GetGlobalName(
	const SfxPoolItem* pItem ) const
{
	SfxItemFactory_Impl* pFact = GetFactory_Impl( pItem->Type() );
	return pFact ? &pFact->GetGlobalName() : 0;
}

