/*************************************************************************
 *
 *  $RCSfile: loadenv.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: dv $ $Date: 2001/07/03 12:14:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _LOADENV_HXX
#define _LOADENV_HXX


#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _REF_HXX //autogen
#include <tools/ref.hxx>
#endif
#ifndef _SFXLSTNER_HXX //autogen
#include <svtools/lstner.hxx>
#endif
#ifndef   SVTOOLS_ASYNCLINK_HXX
#include <svtools/asynclink.hxx>
#endif

#include <objsh.hxx>
#include <sfxtypes.hxx>

#define LEI_DETECTFILTER	1
#define LEI_LOAD			2
#define LEI_CREATEVIEW		4

class LoadEnvironment_Impl;
SV_DECL_REF( LoadEnvironment_Impl )

class SfxMedium;
class SfxFrame;
class SfxFilterMatcher;
class SfxErrorContext;

class LoadEnvironment_Impl : public SvRefBase, public SfxListener
{
friend class SfxLoadEnvironment;
public:
	enum State { CONNECTING, DETECTING, DOWNLOADING, CREATINGVIEW, DONE };
private:
	State           	eState;
	String          	aURL;
	String          	aMark;
	ULONG           	nTodo;
	SfxObjectShellLock	xDoc;	// wegen Cache-Use (Lock flog beim Remove ab)
	SfxMedium*      	pMedium;
	SfxFrame*       	pFrame;       // Frame, in den geladen werden soll
	SfxFrame*       	pNewFrame;    // Frame, in den geladen werden soll
	ULONG           	nStartEvent;
	ErrCode         	nError;
    SfxErrorContext*    pContext;

	Link            	    aDoneLink;
	Link            	    aDataAvailableLink;
    svtools::AsynchronLink  aDecoupleLink;
	SfxLoadEnvironment*     pAntiImpl;
	LoadEnvironment_ImplRef xThis;

	BOOL            bHidden : 1;
	BOOL            bOpenTemplate : 1;
	BOOL            bReadOnly : 1;
    BOOL            bAllowReadOnly : 1;
	BOOL            bPlugIn : 1;
	BOOL            bNewView : 1;
	BOOL            bIsApi : 1;
	BOOL            bTemplate : 1;
	BOOL            bDocCreated : 1;
	BOOL            bLocal : 1;
	BOOL            bOwnsFrame : 1;
	BOOL            bSalvage : 1;
	BOOL			bUsableForLocal : 1;
	BOOL			bWaitingForFilterDetection : 1;
	BOOL			bProcessing : 1;
    BOOL            bUseCache : 1;

	SfxFilterMatcher* pMatcher;
	LoadEnvironment_ImplRef xOldEnv;

	void            ConvertToTemplate();
	void            DetectFilter();
	void			Execute();
	void            CreateView();
	BOOL            PrepareClose();
	virtual void	Notify( SfxBroadcaster& rBC, const SfxHint& rHint );
	DECL_LINK(		LoadDataAvailable_Impl, void* );
    void            LoadDataAvailable();
	void            Load( const SfxObjectFactory* pFactory );
    void            Error();

					~LoadEnvironment_Impl();
public:

                    LoadEnvironment_Impl( SfxMedium* pMed, SfxFrame* pFrameP=0, sal_uInt32 eToDo=LEI_DETECTFILTER, BOOL bAllowReadOnlyP=TRUE, BOOL bAllowCache=TRUE );
    static LoadEnvironment_Impl* Create( const SfxItemSet& rSet, BOOL bAllowReadOnly = TRUE );

    void            Start();
	void            CancelTransfers();
	ErrCode         DocumentDetected( SfxObjectShell* pShell, ErrCode nErr );
	void            LoadAndCreateView( const SfxObjectFactory* pFactory );

	void            SetFilterMatcher( SfxFilterMatcher* pMatcherP )
					{ pMatcher = pMatcherP; }

	void            SetDataAvailableLink( const Link& rLink )
					{ aDataAvailableLink = rLink; }

	void            SetDoneLink( const Link& rLink )
					{ aDoneLink = rLink;  }

	void            SetMark( const String& rMark )
					{ aMark = rMark; }

	SfxMedium*      GetMedium() const
					{ return pMedium; }

	State           GetState() const
					{ return eState; }

	SfxObjectShell* GetObjectShell() const
					{ return xDoc; }

	SfxFrame*       GetFrame() const
					{ return pFrame; }

	BOOL            IsPlugin() const
					{ return bPlugIn; }

	BOOL			OwnsFrame() const
					{ return bOwnsFrame; }

	ErrCode			GetError() const
					{ return nError; }

    void            SetErrorContext( SfxErrorContext* p )
                    { pContext = p; }
};

SV_IMPL_REF( LoadEnvironment_Impl )

#endif
