/*************************************************************************
 *
 *  $RCSfile: framedlg.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: pb $ $Date: 2002/08/16 06:48:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <svtools/urihelper.hxx>

#pragma hdrstop

#include <comphelper/processfactory.hxx>

#ifndef  _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#include "framedlg.hxx"
#include "sfxresid.hxx"
#include "view.hrc"
#include "frmdescr.hxx"
#include "app.hxx"
#include "viewsh.hxx"
#include "filedlghelper.hxx"

using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::frame;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::ui::dialogs;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::util;
using namespace ::cppu;
using namespace ::rtl;

//==============================================================================

SfxTabPage *CreateFramePropertiesPage_Impl( Window *pParent, const SfxItemSet& rSet )
{
	return new SfxFramePropertiesPage_Impl( pParent, rSet );
}

//------------------------------------------------------------------------------

SfxFramePropertiesPage_Impl::SfxFramePropertiesPage_Impl( Window *pParent, const SfxItemSet& rSet )
	: SfxTabPage( pParent, SfxResId( TP_FRAMEPROPERTIES ), rSet )
	, aFTName ( this, ResId( FT_FRAMENAME ) )
	, aEDName ( this, ResId( ED_FRAMENAME ) )
	, aFTURL ( this, ResId( FT_URL ) )
	, aEDURL ( this, ResId( ED_URL ) )
	, aBTOpen ( this, ResId(BT_FILEOPEN ) )
	, aRBFrameBorderOn ( this, ResId( RB_FRMBORDER_ON ) )
	, aRBFrameBorderOff ( this, ResId( RB_FRMBORDER_OFF ) )
    , aFLFrameBorder( this, ResId( GB_BORDER ) )
	, aFTMarginWidth ( this, ResId( FT_MARGINWIDTH ) )
	, aNMMarginWidth ( this, ResId( NM_MARGINWIDTH ) )
	, aFTMarginHeight ( this, ResId( FT_MARGINHEIGHT ) )
	, aNMMarginHeight ( this, ResId( NM_MARGINHEIGHT ) )
    , aFLMargin( this, ResId( GB_MARGIN ) )
	, aCBMarginWidthDefault( this, ResId( CB_MARGINWIDTHDEFAULT ) )
	, aCBMarginHeightDefault( this, ResId( CB_MARGINHEIGHTDEFAULT ) )
	, aRBScrollingOn ( this, ResId( RB_SCROLLINGON ) )
	, aRBScrollingOff ( this, ResId( RB_SCROLLINGOFF ) )
	, aRBScrollingAuto ( this, ResId( RB_SCROLLINGAUTO ) )
    , aFLScrolling ( this, ResId( GB_SCROLLING ) )
    , aFLSepLeft( this, ResId( FL_SEP_LEFT ) )
    , aFLSepRight( this, ResId( FL_SEP_RIGHT ) )

{
	FreeResource();

	aFLSepLeft.SetStyle(aFLSepLeft.GetStyle()|WB_VERT);
    aFLSepRight.SetStyle(aFLSepRight.GetStyle()|WB_VERT);

	Link aLink( STATIC_LINK( this, SfxFramePropertiesPage_Impl, CheckHdl ) );
	aCBMarginWidthDefault.SetClickHdl( aLink );
	aCBMarginHeightDefault.SetClickHdl( aLink );

	aBTOpen.SetClickHdl( STATIC_LINK( this, SfxFramePropertiesPage_Impl, OpenHdl ) );
}

//------------------------------------------------------------------------------

void SfxFramePropertiesPage_Impl::Reset( const SfxItemSet& rSet )
{
	const SfxPoolItem* pItem;
	if( SFX_ITEM_SET != rSet.GetItemState( GetWhich( SID_FRAMEDESCRIPTOR ), TRUE, &pItem ) )
	{
		DBG_ERROR( "SfxFramePropertiesPage_Impl::Reset(): no item" );
		return;
	}

	const SfxFrameProperties& rProp = ((SfxFrameDescriptorItem*)pItem)->GetProperties();
	SetUpdateMode( FALSE );

	// FrameName und URL
	aEDName.SetText( rProp.aName );
	aEDURL.SetText( rProp.aURL );

	// Margin
	if ( rProp.lMarginWidth == SIZE_NOT_SET )
	{
		aCBMarginWidthDefault.Check( TRUE );
		aNMMarginWidth.SetText( String::CreateFromInt32( DEFAULT_MARGIN_WIDTH )  );
		aFTMarginWidth.Enable( FALSE );
		aNMMarginWidth.Enable( FALSE );
	}
	else
		aNMMarginWidth.SetText( String::CreateFromInt32( rProp.lMarginWidth ) );

	if ( rProp.lMarginHeight == SIZE_NOT_SET )
	{
		aCBMarginHeightDefault.Check( TRUE );
		aNMMarginHeight.SetText( String::CreateFromInt32( DEFAULT_MARGIN_HEIGHT )  );
		aFTMarginHeight.Enable( FALSE );
		aNMMarginHeight.Enable( FALSE );
	}
	else
		aNMMarginHeight.SetText( String::CreateFromInt32( rProp.lMarginHeight ) );

	// ScrollingMode
	BOOL bScrollOn = FALSE;
	BOOL bScrollOff = FALSE;
	BOOL bScrollAuto = FALSE;
	switch( rProp.eScroll )
	{
		case ScrollingYes  :
			bScrollOn = TRUE;
			break;
		case ScrollingNo   :
			bScrollOff = TRUE;
			break;
		case ScrollingAuto :
			bScrollAuto = TRUE;
			break;
	}
	aRBScrollingOn.Check( bScrollOn );
	aRBScrollingOff.Check( bScrollOff );
	aRBScrollingAuto.Check( bScrollAuto );

	// Frame Border
	aRBFrameBorderOn.Check( rProp.bBorderSet && rProp.bHasBorder );
	aRBFrameBorderOff.Check( rProp.bBorderSet && !rProp.bHasBorder );

	SetUpdateMode( TRUE );
}

//------------------------------------------------------------------------------

BOOL SfxFramePropertiesPage_Impl::FillItemSet( SfxItemSet& rSet)
{
	// Zuerst auf Veraenderungen testen
	const SfxPoolItem* pItem=NULL;
	const SfxItemSet *pSet = &GetItemSet();
	if ( GetTabDialog() )
		pSet = GetTabDialog()->GetExampleSet();
	if( SFX_ITEM_SET != pSet->GetItemState( GetWhich( SID_FRAMEDESCRIPTOR ), TRUE, &pItem ) )
	{
		DBG_ERRORFILE( "SfxFramePropertiesPage_Impl::FillItemSet(): no item" );
		return FALSE;;
	}

	const SfxFrameProperties& rProp = ((SfxFrameDescriptorItem*)pItem)->GetProperties();

	BOOL bChange = FALSE;
	String aURL;
	if ( aEDURL.GetText().Len() )
        aURL = URIHelper::SmartRelToAbs( aEDURL.GetText() );
	ScrollingMode eScroll;
	if ( aRBScrollingOn.IsChecked() )
		eScroll = ScrollingYes;
	if ( aRBScrollingOff.IsChecked() )
		eScroll = ScrollingNo;
	if ( aRBScrollingAuto.IsChecked() )
		eScroll = ScrollingAuto;
	long lMarginWidth;
	if ( !aCBMarginWidthDefault.IsChecked() )
		lMarginWidth = (long) aNMMarginWidth.GetText().ToInt32();
	else
		lMarginWidth = SIZE_NOT_SET;

	long lMarginHeight;
	if ( !aCBMarginHeightDefault.IsChecked() )
		lMarginHeight = (long) aNMMarginHeight.GetText().ToInt32();
	else
		lMarginHeight = SIZE_NOT_SET;

	if ( aEDName.GetText() != rProp.aName )
		bChange = TRUE;
	else if ( aURL != rProp.aURL )
		bChange = TRUE;
	else if ( lMarginWidth != rProp.lMarginWidth )
		bChange = TRUE;
	else if ( lMarginHeight != rProp.lMarginHeight )
		bChange = TRUE;
	else if ( rProp.eScroll != eScroll )
		bChange = TRUE;
	else if ( rProp.bHasBorder != aRBFrameBorderOn.IsChecked() )
		bChange = TRUE;

	if ( bChange )
	{
		// Properties der anderen Pages schon vorhanden ?
		SfxFrameProperties aProp;
		aProp = rProp;
		if( SFX_ITEM_SET == rSet.GetItemState( GetWhich( SID_FRAMEDESCRIPTOR ), TRUE, &pItem ) )
			aProp = ((SfxFrameDescriptorItem*)pItem)->GetProperties();

		// Properties dieser Page uebernehmen
		aProp.aName = aEDName.GetText();
		aProp.aURL = aURL;
		aProp.lMarginWidth = lMarginWidth;
		aProp.lMarginHeight = lMarginHeight;
		aProp.eScroll = eScroll;
        aProp.bHasBorder = aRBFrameBorderOn.IsChecked();

		// Item anlegen
		SfxFrameDescriptorItem aItem;
		aItem.SetProperties( aProp );
		rSet.Put( aItem );
	}

	return bChange;
}

//------------------------------------------------------------------------------

IMPL_STATIC_LINK( SfxFramePropertiesPage_Impl, CheckHdl, CheckBox*, pCB )
{
	const SfxPoolItem* pItem;
	if ( SFX_ITEM_SET !=
		 pThis->GetItemSet().GetItemState( pThis->GetWhich( SID_FRAMEDESCRIPTOR ), TRUE, &pItem ) )
	{
		DBG_ERRORFILE( "SfxFramePropertiesPage_Impl::CheckHdl(): no item" );
		return 0L;;
	}

	const SfxFrameProperties& rProp = ((SfxFrameDescriptorItem*)pItem)->GetProperties();

	if ( pCB == &pThis->aCBMarginWidthDefault )
	{
		if ( pCB->IsChecked() )
			pThis->aNMMarginWidth.SetText( String::CreateFromInt32( DEFAULT_MARGIN_WIDTH ) );
		pThis->aFTMarginWidth.Enable( !pCB->IsChecked() );
		pThis->aNMMarginWidth.Enable( !pCB->IsChecked() );
	}

	if ( pCB == &pThis->aCBMarginHeightDefault )
	{
		if ( pCB->IsChecked() )
			pThis->aNMMarginHeight.SetText( String::CreateFromInt32( DEFAULT_MARGIN_HEIGHT ) );
		pThis->aFTMarginHeight.Enable( !pCB->IsChecked() );
		pThis->aNMMarginHeight.Enable( !pCB->IsChecked() );
	}

	return 0L;
}

//------------------------------------------------------------------------------

IMPL_STATIC_LINK( SfxFramePropertiesPage_Impl, OpenHdl, PushButton*, EMPTYARG )
{
    Window* pOldParent = Application::GetDefModalDialogParent();
	Application::SetDefDialogParent( pThis );

    // create the file dialog
	sfx2::FileDialogHelper aFileDlg( WB_OPEN | SFXWB_PASSWORD, *(SfxObjectFactory*) NULL );

	// set the title
	aFileDlg.SetTitle( OUString( String( SfxResId( STR_FRAME_FILEDLG ) ) ) );

	// show the dialog
    if ( aFileDlg.Execute() == ERRCODE_NONE )
		pThis->aEDURL.SetText(
			INetURLObject( aFileDlg.GetPath() ).GetMainURL( INetURLObject::DECODE_WITH_CHARSET ) );

    Application::SetDefDialogParent( pOldParent );
	return 0L;
}

