/*************************************************************************
 *
 *  $RCSfile: prxsettingsentry.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: tra $ $Date: 2001/06/06 09:11:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//-----------------------------------------------------------------------
//	includes of other projects
//-----------------------------------------------------------------------

#ifndef _CPPUHELPER_FACTORY_HXX_
#include <cppuhelper/factory.hxx>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XSET_HPP_
#include <com/sun/star/container/XSet.hpp>
#endif

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

#ifndef _COM_SUN_STAR_SYSTEM_XPROXYSETTINGS_HPP_
#include <com/sun/star/system/XProxySettings.hpp>
#endif

#ifndef _SOPRXSETTINGS_HXX_
#include "soprxsettings.hxx"
#endif

#include <stdio.h>

#ifdef WNT 

#ifndef _SYSPRXSETTINGS_HXX_
#include "sysprxsettings.hxx"
#endif

#endif

//-----------------------------------------------------------------------
// namespace directives
//-----------------------------------------------------------------------

using namespace ::rtl						;
using namespace ::com::sun::star::uno		;
using namespace ::com::sun::star::container	;
using namespace ::com::sun::star::lang		;
using namespace ::com::sun::star::registry	;
using namespace ::cppu					    ;
using com::sun::star::system::XProxySettings;

//-----------------------------------------------------------------------
// defines
//-----------------------------------------------------------------------

#define PROXY_SETTINGS_SERVICE_NAME "com.sun.star.system.ProxySettings"

#define SO_PROXY_SETTINGS_SERVICE_NAME  "com.sun.star.system.SOffice52ProxySettings"
#define SO_PROXY_SETTINGS_IMPL_NAME  "com.sun.star.comp.system.SOffice52ProxySettings"

#define SYSTEM_PROXY_SETTINGS_SERVICE_NAME "com.sun.star.system.SystemProxySettings"
#define SYSTEM_PROXY_SETTINGS_IMPL_NAME "com.sun.star.comp.system.SystemProxySettings"

//-----------------------------------------------------------------------
// 
//-----------------------------------------------------------------------

namespace
{
	Reference< XInterface > SAL_CALL createInstanceSoProxySettings( 
        const Reference< XMultiServiceFactory >& rServiceManager )
	{		        
		return Reference< XInterface >( static_cast< XProxySettings* >( new CSoProxySettings ( ) ) );
	}

#ifdef WNT // system proxy-settings (better IE proxy settings) are only available under Windows

    Reference< XInterface > SAL_CALL createInstanceSysProxySettings( 
        const Reference< XMultiServiceFactory >& rServiceManager )
	{		
		return Reference< XInterface >( static_cast< XProxySettings* >( new CSysProxySettings( ) ) );
	}

#endif
}

//-----------------------------------------------------------------------
// the 3 important functions which will be exported 
//-----------------------------------------------------------------------

extern "C" 
{

//----------------------------------------------------------------------
// component_getImplementationEnvironment
//----------------------------------------------------------------------

void SAL_CALL component_getImplementationEnvironment(
	const sal_Char ** ppEnvTypeName, uno_Environment ** ppEnv )
{	
	*ppEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
}

//-----------------------------------------------------------------------
//
//-----------------------------------------------------------------------

sal_Bool SAL_CALL component_writeInfo( void* pServiceManager, void* pRegistryKey )
{
	sal_Bool bRetVal = sal_True;

	if ( pRegistryKey )
	{
		try
		{
            Reference< XRegistryKey > xKey(
				reinterpret_cast< XRegistryKey * >( pRegistryKey ) );

			OUString str = OUString::createFromAscii( "/" );
            str += OUString::createFromAscii( SO_PROXY_SETTINGS_IMPL_NAME );
			str += OUString::createFromAscii( "/UNO/SERVICES" );
			Reference< XRegistryKey >  xNewKey = xKey->createKey( str );
            xNewKey->createKey( OUString::createFromAscii( SO_PROXY_SETTINGS_SERVICE_NAME ) );

#ifdef WNT // system proxy-settings (better IE proxy settings) are only available under Windows

            str = OUString::createFromAscii( "/" );
            str += OUString::createFromAscii( SYSTEM_PROXY_SETTINGS_IMPL_NAME );
			str += OUString::createFromAscii( "/UNO/SERVICES" );
			xNewKey = xKey->createKey( str );
            xNewKey->createKey( OUString::createFromAscii( SYSTEM_PROXY_SETTINGS_SERVICE_NAME ) );

#endif

		}
		catch( InvalidRegistryException& )
		{			
			OSL_ENSURE(sal_False, "InvalidRegistryException caught");			
			bRetVal = sal_False;
		}
	}

	return bRetVal;
}

//----------------------------------------------------------------------
// component_getFactory 
// returns a factory to create XFilePicker-Services
//----------------------------------------------------------------------

void* SAL_CALL component_getFactory( const sal_Char* pImplName, uno_Interface* pSrvManager, uno_Interface* pRegistryKey )
{
	void* pRet = 0;

	if ( pSrvManager )
	{
        OUString aImplName = OUString::createFromAscii( pImplName );
        Reference< XSingleServiceFactory > xRet;

        Sequence< OUString > supportedServices( 2 );

        supportedServices[0] = OUString::createFromAscii( PROXY_SETTINGS_SERVICE_NAME );

        if ( aImplName == OUString::createFromAscii( SO_PROXY_SETTINGS_IMPL_NAME ) )
        {            
            supportedServices[1] = OUString::createFromAscii( SO_PROXY_SETTINGS_SERVICE_NAME );
        
            xRet = createSingleFactory( 
                reinterpret_cast< XMultiServiceFactory* > ( pSrvManager ), 
                aImplName,
				createInstanceSoProxySettings,
				supportedServices );
        }
		
#ifdef WNT // system proxy-settings (better IE proxy settings) are only available under Windows

        else if ( aImplName == OUString::createFromAscii( SYSTEM_PROXY_SETTINGS_IMPL_NAME ) )
        {
            supportedServices[1] = OUString::createFromAscii( SYSTEM_PROXY_SETTINGS_SERVICE_NAME );

            xRet = createSingleFactory( 
                reinterpret_cast< XMultiServiceFactory* > ( pSrvManager ), 
                aImplName,
				createInstanceSysProxySettings,
				supportedServices );
        }

#endif
        if ( xRet.is( ) )
        {
            xRet->acquire( );
            pRet = xRet.get( );
        }
        

	}

	return pRet;
}

} // extern "C"
