import java.io.File;
import java.io.FileReader;
import java.util.LinkedList;
import java.util.Vector;
import java.util.ListIterator;
import java.util.HashMap;
import java.util.Set;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import com.jrefinery.data.*;
import com.jrefinery.chart.*;
import com.jrefinery.ui.ApplicationFrame;
import com.jrefinery.ui.RefineryUtilities;
import com.jrefinery.date.SerialDate;

final class Statistics {
	private LinkedList statsStringsList, actionsList;
	private ListIterator theListIterator;
	private HashMap statsHash;
	private String syscallFile;
	private String[] curvesNames;
	private String[] grades;
	private int counter;
	
	private void getStatistic() {
		try {
			File statFile = new File(syscallFile);
			if (statFile.canRead()) {
				String theString = "";
				FileReader theFileReader = new FileReader(syscallFile);
				java.io.BufferedReader theStream =
					new java.io.BufferedReader(theFileReader);
				statsStringsList = new LinkedList();
				if (theStream.ready())
					while ((theString = theStream.readLine()) != null)
						statsStringsList.add(theString);
				else
					System.out.println("Cannot get stream ready");
				theStream.close();
				System.out.println("File contains " + statsStringsList.size() + " strings");

				parseStatistic();
			} else
				System.out.println("Cannot open file " + syscallFile);
		}
		catch (Exception theException) {
			System.out.println(theException.getMessage());
		}
	};
	
	private void parseStatistic() {
		theListIterator = statsStringsList.listIterator(0);
		String stand = new String();
		String minor = new String();
		String date = new String();
		String action = new String();
		String grade = new String();
		String callsSum = new String();
		String callsNumber = new String();
		String theCurveName = new String();
		int i = 0;
		while (theListIterator.hasNext()) {
			String theString = (String)theListIterator.next();
			java.util.StringTokenizer theTokenizer =
				new java.util.StringTokenizer(theString);
			while (theTokenizer.hasMoreTokens()) {
				String theWord = theTokenizer.nextToken();
				++i;
				switch (i)
				{
					case 1:
						stand = theWord;
						continue;
					case 2:
						minor = theWord;
						continue;
					case 3:
						date = theWord;
						continue;
					case 8: //grade
						action = theWord;
						continue;
					case 9: //grade
						grade = theWord;
						continue;
					case 10:
						callsSum = theWord;
						continue;
					case 11:
						callsNumber = theWord;
						break;
					default:
						if (i > 11) {
							System.out.println("Invalid file format " +
											theWord);
							System.exit(1);
						};
				};
			};
			theCurveName = stand + "." + minor + "_" + date;
			storeStatistic(action, theCurveName,
							grade, callsSum, callsNumber);
			i = 0;
		};
		theListIterator = actionsList.listIterator(0);
        //clearUpStatistic();
	};
	private void storeStatistic(String action, String curveName, String grade, String callsSum, String callsNumber) {
		if (!statsHash.containsKey(action)) {
			statsHash.put(action, new HashMap());
			actionsList.add(action);
		};
		HashMap curvesHash = (HashMap)statsHash.get(action);
		
		if (!curvesHash.containsKey(curveName))
			curvesHash.put(curveName, new HashMap());
		HashMap gradesMap = (HashMap)curvesHash.get(curveName);
		
		Integer callsValues[] = new Integer[2];
		callsValues[0] = new Integer(callsSum);
		callsValues[1] = new Integer(callsNumber);
		gradesMap.put(new Integer(grade), callsValues);
	};
	
	public String getActionName() {
		if (theListIterator.hasNext())
			return (String) theListIterator.next();
		return "";	
	};
	
	public Statistics (String fileName) {
		// implicit call to super(); here.
		syscallFile = fileName;
		statsHash = new HashMap();
		actionsList = new LinkedList();
		getStatistic();
        counter = 0;
	};
	
    public String[] getCurvesNames(String actionName) {
		HashMap curvesHash = (HashMap)statsHash.get(actionName);
		String[] curvesNames = new String[curvesHash.size()];
		Set curvesSet = curvesHash.keySet();
		Iterator curvesSetIter = curvesSet.iterator();
        short i = 0;
		while (curvesSetIter.hasNext()) // Attention with i!!
			curvesNames[i++] = (String)curvesSetIter.next();
        return curvesNames;
    };
    
    public String[] getGradesNames(TreeSet namesSet) {
        Iterator namesIterator = namesSet.iterator();
        String [] names = new String[namesSet.size()];
        int i = 0;
        Integer grade;
        while (namesIterator.hasNext()) {
            grade = (Integer)namesIterator.next();
            names[i] = convertGradeName(grade.intValue());
            //System.out.println(names[i]);
            ++i;
        };
        return names;
    };
    
	public TreeSet getGradesSet(String actionName, 
                                    String[] curvesNames) {
        TreeSet gradesSet = new TreeSet();
		Iterator gradesSetIter;
        Integer grade;
        for (int i = 0; i < curvesNames.length; i++) {
		    HashMap curvesHash = (HashMap)statsHash.get(actionName);
            HashMap curveGradesMap = (HashMap)curvesHash.get(curvesNames[i]);
			Set curveGradesSet = curveGradesMap.keySet();
			gradesSetIter = curveGradesSet.iterator();
            while(gradesSetIter.hasNext()) {
                gradesSet.add(gradesSetIter.next());
            };
        };
        return gradesSet;
    };
    
	public double [][] getActionData(String actionName, String[] curvesNames, TreeSet gradesSet) {
        double [][] data = new double [curvesNames.length]
                                        [gradesSet.size()];
		HashMap curvesHash = (HashMap)statsHash.get(actionName);
        HashMap gradesMap;
        Iterator gradesSetIter;
		Integer callsValues[];
        
        for (int i = 0; i < curvesNames.length; i++) {
            gradesSetIter = gradesSet.iterator();
            gradesMap = (HashMap)curvesHash.get(curvesNames[i]);
            for (int j = 0; j < gradesSet.size(); j++) {
                Integer grade = (Integer)gradesSetIter.next();
                if (gradesMap.containsKey(grade)) {
				    callsValues = (Integer[])gradesMap.get(grade);
                    if (counter >= callsValues.length) {
                        counter = 0;
                        return new double[0][0];
                    };
                    data[i][j] = callsValues[counter].intValue();
                };
            };
        };
        ++counter;
        return data;
    };
	
	private String convertGradeName(int grade) {
		if (grade < 1024) {return String.valueOf(grade);};
		grade = grade/1024;
		if (grade < 1024) {return String.valueOf(grade) + "Kb";};
		grade = grade/1024;
		return String.valueOf(grade) + "Mb";
	};
};

public final class Graphics /*extends ApplicationFrame*/ {
	private static String syscallFile;
	private static Statistics theStatistics;
    private static String[] curvesNames;
    private static String[] gradesNames;
    private static HashMap actionsDrawn;
    
	private static String getParameters(String [] args) {
		syscallFile = "";
		switch (args.length)
		{
			case 0:
				syscallFile = System.getProperty("user.home") + 
												"/Syscall.txt";
				break;
			case 1:
				syscallFile = String.valueOf(args [0]);
				break;
			default:
				System.out.println("Too many parameters");
				System.exit(1);
		};
		return syscallFile;
	};
    
    private static Object [] getGraphicsInfo(String actionName) {
        Object [] graphicsInfo = new Object[4]; // {actionName, xAxeName, legende}
        if (actionsDrawn.containsKey(actionName)) {
            graphicsInfo [0] = "";
            graphicsInfo [1] = "Office versions";
            graphicsInfo [2] = "Calls (times)";
            graphicsInfo [3] = new Boolean(true);
        } else {
            actionsDrawn.put(actionName, new Integer(1));
            graphicsInfo [0] = actionName;
            graphicsInfo [1] = "";
            graphicsInfo [2] = "Sum (bits)";
            graphicsInfo [3] = new Boolean(false);
        };
        return graphicsInfo;
    };
    
    private static JFreeChart drawIndividualChart (String actionName, double [][] data) {
        JFreeChart chart;
        Object [] graphicsInfo = getGraphicsInfo(actionName);
		double new_data[][] = new double[1][data.length];
        for (int i = 0; i < data.length; i++)
            new_data[0][i] = data[i][0];
		DefaultCategoryDataset dataset = 
            new DefaultCategoryDataset(new_data);
		dataset.setCategories(curvesNames);
        chart = ChartFactory.createVerticalBarChart(
		    (String)graphicsInfo[0], (String)graphicsInfo[1], "Calls (times)", dataset, ((Boolean)graphicsInfo[3]).booleanValue());
        return chart; 
    };

    private static JPanel getJPanel(int rows, int columns) {
        JPanel aJPanel = new JPanel();
        aJPanel.setLayout(new GridLayout(rows, columns));
        aJPanel.setBorder(BorderFactory.createEmptyBorder(1,1,1,1));
        aJPanel.setBackground(Color.red);
        return aJPanel;
    };
    
    private static JFreeChart drawCrowdyChart (String actionName, double [][] data) {
        JFreeChart chart;
        Object [] graphicsInfo = getGraphicsInfo(actionName);
		DefaultCategoryDataset dataset = new DefaultCategoryDataset(data);
		dataset.setSeriesNames(curvesNames);
		dataset.setCategories(gradesNames);
        chart = ChartFactory.createVerticalBarChart(
		    (String)graphicsInfo[0], (String)graphicsInfo[1], (String)graphicsInfo[2], dataset, ((Boolean)graphicsInfo[3]).booleanValue());//legend);
        CategoryPlot plot = chart.getCategoryPlot();
        HorizontalCategoryAxis domainAxis = (HorizontalCategoryAxis) plot.getDomainAxis();
        domainAxis.setVerticalCategoryLabels(true);
        return chart; 
    };
	
    private static void drawStatistics () {
		String actionName;
        JPanel mainPane = new JPanel();
        mainPane.setBackground(Color.red);
        mainPane.setLayout(new GridLayout(2, 2));
        mainPane.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
        HashMap actionInfos = new HashMap();
            JFreeChart chart;
            Vector aChartsVector = new Vector(); 
            final int height = 135;
		while ((actionName = theStatistics.getActionName()).length() != 0) {
            JPanel aJPanel = getJPanel(2, 1);
                
			curvesNames = theStatistics.getCurvesNames(actionName);
            TreeSet gradesSet = theStatistics.getGradesSet(actionName,
                                                            curvesNames);
            gradesNames = theStatistics.getGradesNames(gradesSet);
		    double data[][];
            String lastAction = "";
            while ((data = theStatistics.getActionData(actionName,
                           curvesNames, gradesSet)).length != 0) {
                if (data[0].length > 1) { // more than one participant
                    chart = drawCrowdyChart(actionName + " (sum/calls)", data);
                } else { // bar chart
                    boolean empty = true;
                    for (int i = 0; i < data.length; i++) {
                        if (data[i][0] != 0) {
                            empty = false;
                            break;
                        };
                    };
                    if (empty) continue;
                    chart = drawIndividualChart(actionName + " (calls)", data);
                    chart.setBackgroundPaint(Color.yellow);
                    aChartsVector.add(chart);
                    continue;
                }
                chart.setBackgroundPaint(Color.yellow);
                // OPTIONAL CUSTOMISATION COMPLETED.
                // add the chart to a panel...
                ChartPanel chartPanel = new ChartPanel(chart);
                chartPanel.setPreferredSize(new java.awt.Dimension(500, height));
                aJPanel.add(chartPanel);
                mainPane.add(aJPanel);
            };
		};
        int vectorSize = aChartsVector.size();
        JPanel aJPanel = getJPanel(vectorSize,1);
        while (!aChartsVector.isEmpty()) {
            chart = (JFreeChart)aChartsVector.firstElement();
            aChartsVector.removeElementAt(0);
            ChartPanel chartPanel = new ChartPanel(chart);
            chartPanel.setPreferredSize(new java.awt.Dimension(500, height/vectorSize));
            aJPanel.add(chartPanel);
        };
        mainPane.add(aJPanel);
		ApplicationFrame theAppFrame = new ApplicationFrame("StarOffice system calls statistics");
        theAppFrame.setContentPane(mainPane);
		theAppFrame.pack();
        RefineryUtilities.centerFrameOnScreen(theAppFrame);
        theAppFrame.setVisible(true);
    };
    
	public static void main (String [] args) {
		getParameters(args);
		System.out.println(syscallFile);
		
		theStatistics = new Statistics(syscallFile);
        actionsDrawn = new HashMap();
        drawStatistics();
	};
};
