/*************************************************************************
 *
 *  $RCSfile: outplace.hxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: rt $ $Date: 2003/04/24 14:05:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _OUTPLACE_HXX
#define _OUTPLACE_HXX

#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif

#ifndef _COM_SUN_STAR_DATATRANSFER_XTRANSFERABLE_HPP_
#include <com/sun/star/datatransfer/XTransferable.hpp>
#endif

#include "ipobj.hxx"

//=========================================================================
struct SvOutPlace_Impl;
class SvObjectServer;

class SvOutPlaceObject : public SvInPlaceObject
/*	[Beschreibung]

	Die Klasse SvOutPlaceObject ist ein Wrapper fr alle Windows Ole-Objekte

	[Probleme]
*/
{
	SvOutPlace_Impl *	pImpl;

	void			DataChanged_Impl( BOOL bOnlyEmbedSource );
	void			LoadSO_Cont();
	BOOL			MakeWorkStorageWrap_Impl( SvStorage * pStor );

protected:
	virtual void    FillClass( SvGlobalName * pClassName,
							   ULONG * pFormat,
							   String * pAppName,
							   String * pFullTypeName,
							   String * pShortTypeName,
                               long nFileFormat = SOFFICE_FILEFORMAT_CURRENT ) const;
					// Protokoll
	virtual void    Open( BOOL bOpen );
	virtual void    Embed( BOOL bEmbedded );
	virtual ErrCode Verb( long, SvEmbeddedClient * pCallerClient,
						Window * pWin, const Rectangle * pWorkRectPixel );

					// Datenaustausch
	virtual void    Draw( OutputDevice *,
						  const JobSetup & rSetup,
						  USHORT nAspect = ASPECT_CONTENT );

					// Laden speichern
	virtual BOOL    InitNew( SvStorage * );
	virtual BOOL    Load( SvStorage * );
	virtual BOOL    Save();
	virtual BOOL    SaveAs( SvStorage * );
	virtual void    HandsOff();
	virtual BOOL    SaveCompleted( SvStorage * );

					~SvOutPlaceObject();
public:
					SO2_DECL_BASIC_CLASS(SvOutPlaceObject)
//					SO2_DECL_BASIC_CLASS_DLL(SvOutPlaceObject,SOAPP)
					SvOutPlaceObject();
	static SvInPlaceObjectRef	InsertObject( Window *, SvStorage * pIStorage,
												BOOL & bOut, String & rTypeName, String & rFileName,
												BOOL & bInternal, SvGlobalName & rInternalClassName );
	static SvInPlaceObjectRef	InsertObject( Window *, SvStorage * pIStorage,
											BOOL & bOut, SvGlobalName & rName, String & rFileName );
	static SvInPlaceObjectRef	CreateFromClipboard( SvStorage * );
	static SvInPlaceObjectRef   CreateFromData( const ::com::sun::star::uno::Reference<
												::com::sun::star::datatransfer::XTransferable>&,
												SvStorage*);
	static SvGlobalName			GetCLSID( const String & rFileName );
	static SvInPlaceObjectRef	CreateFromFile( SvStorage * pStor, const String & rFileName );

	static const SvObjectServer* GetInternalServer_Impl( const SvGlobalName& aGlobName );

	void			ClearCache();
	SotStorage *	GetWorkingStorage();
	virtual void    SetVisArea( const Rectangle & rVisArea );
	Rectangle		GetVisArea( USHORT dwAspect ) const;
	void			ViewChanged( USHORT nAspects );
	virtual const SvVerbList & GetVerbList() const;

	virtual UINT32		GetViewAspect() const;
	::com::sun::star::uno::Reference < ::com::sun::star::lang::XComponent > GetUnoComponent() const;
	SvGlobalName		GetObjectCLSID();
	void    DrawObject( OutputDevice *,
						  const JobSetup & rSetup,
						  const Size& rSize,
						  USHORT nAspect = ASPECT_CONTENT );

};

SO2_DECL_IMPL_REF(SvOutPlaceObject)


#endif // _OUTPLACE_HXX

