/*************************************************************************
 *
 *  $RCSfile: ipclient.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:54:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>


#include <ipclient.hxx>
#include <tools/debug.hxx>
#include <vcl/wrkwin.hxx>

#include <so2dll.hxx>
#include <ipobj.hxx>
#include <ipenv.hxx>
#include <soerr.hxx>

#pragma hdrstop

//=========================================================================
//=========================================================================
//=========================================================================
SV_OLE_FACTORY(SvInPlaceClientFactory)
	{
	}
};
TYPEINIT1(SvInPlaceClientFactory,SvOleFactory);

SO2_IMPL_STANDARD_CLASS1_DLL(SvInPlaceClient,SvInPlaceClientFactory,SvEmbeddedClient,
							 0x35356980L, 0x795D, 0x101B,
							 0x80,0x4C,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD )

//=========================================================================
/*	[Beschreibung]

	Makro, um fuer die verschiedenen Konstruktoren die gleich
	Initialisierung sicherzustellen.
*/
#define INIT_CLIENT_CTOR		\
	  pObjI		( NULL )

//=========================================================================
SvInPlaceClient::SvInPlaceClient()
	: INIT_CLIENT_CTOR
/*	[Beschreibung]

	Dieser Konstruktor wird verwendet, wenn man sich vom Client abgeleitet
	hat oder wenn man einen Client zu einem Objekt erstellen will.
*/
{
}

//=========================================================================
SvInPlaceClient::SvInPlaceClient
(
	WorkWindow * pTopWin,	/* i. a. das Applikationsfenster */
	WorkWindow * pDocWin,	/* das Dokumentfenster			*/
	Window * pEditWin		/* Das Fenster in dem das Objekt angezeigt
							   wird */
)
	: INIT_CLIENT_CTOR
/*	[Beschreibung]

	Dieser Konstruktor wird verwendet, wenn der Aufrufer kein eigenes
	SvContainerEnvironment verwenden muss.
*/
{
	SetViewData( new SvContainerEnvironment( this, pTopWin,
											 pDocWin, pEditWin ) );
	bDeleteData = TRUE;
}

//=========================================================================
SvInPlaceClient::~SvInPlaceClient()
/*	[Beschreibung]

	Destruktor der Klasse SvInPlaceClient. Wurde das Environment noch
	nicht freigegeben, dann passiert dies hier.

	[Querverweise]
*/
{
	DBG_ASSERT( LIST_ENTRY_NOTFOUND == GetIPActiveClientList().GetPos( this ),
				"ip-client in ip-client-list" )

}

//=========================================================================
IUnknown * SvInPlaceClient::GetMemberInterface( const SvGlobalName & rName )
{
	return NULL;
}

//=========================================================================
void SvInPlaceClient::TestMemberObjRef( BOOL bFree )
{
#ifdef DBG_UTIL
	if( GetIPObj() )
	{
		ByteString aTest = "\t\tGetIPObj() == ";
		aTest.Append( ByteString::CreateFromInt32( (ULONG)(SvObject *)GetIPObj() ) );
		DBG_TRACE( aTest.GetBuffer() );
	}
#endif
}

//=========================================================================
#ifdef TEST_INVARIANT
void SvInPlaceClient::TestMemberInvariant( BOOL bPrint )
{
}
#endif

//=========================================================================
BOOL SvInPlaceClient::CanInPlaceActivate() const
/*	[Beschreibung]

	Gibt an, ob der Container zum jetzigen Zeitpunkt IP-Aktivierung
	unterst"utzt.

	[R"uckgabewert]

	BOOL		TRUE, der Container unterst"utzt zur Zeit IP-Aktivierung.
				FALSE, der Container unterst"utzt zur Zeit keine
				IP-Aktivierung.
*/
{
	BOOL bRet = FALSE;
	if( Owner() )
	{
		bRet = GetAspect() == ASPECT_CONTENT;
		if( bRet )
			// Nur IP gestatten, wenn das Environment verf"ugbar ist
			bRet = NULL != ((SvInPlaceClient *)this)->GetEnv();
	}
	return bRet;
}

//=========================================================================
SvInPlaceClientList & SvInPlaceClient::GetIPActiveClientList()
/*	[Beschreibung]

	Gibt die Liste aller zu diesem Zeitpunkt IP-Aktiven Clients
	zur"uck.

	[R"uckgabewert]

	SvInPlaceClientList & 	Die Liste der Clients.
*/
{
	SoDll * pSoApp = SOAPP;
	if( !pSoApp->pIPActiveClientList )
		pSoApp->pIPActiveClientList = new SvInPlaceClientList();
	return *pSoApp->pIPActiveClientList;
}

//=========================================================================
void SvInPlaceClient::MakeViewData()
/*	[Beschreibung]

	Gibt das ContainerEnvironment zur"uck. Wurde es nicht im
	Konstruktor "ubergeben, dann muss diese Methode "uberladen
	werden.

	[R"uckgabewert]

	SvClientData * 	Das Environment zu diesem Client wird zur"uckgegeben.

	[Querverweise]

	<SvEmbeddedClient::MakeViewData>, <SvEmbeddedClient::FreeViewData>
*/
{

	if( !Owner() && !HasViewData() && GetProtocol().IsConnect() )
	{
		pData = new SvContainerEnvironment( this );
		bDeleteData = TRUE;
	}
	else
		SvEmbeddedClient::MakeViewData();
}

//=========================================================================
SvContainerEnvironment * SvInPlaceClient::GetEnv()
/*	[Beschreibung]

	Gibt das ContainerEnvironment zur"uck. Ein neues Environment
	wird nur angelegt, wenn der Client "Connected" ist.

	[R"uckgabewert]

	SvContainerEnvironment * 	Das Environment zu diesem Client wird
								zur"uckgegeben.

	[Querverweise]

	<SvProtocol::IsConnect>, <SvInPlaceClient::MakeViewData>
*/
{
	if( !pData && GetProtocol().IsConnect() )
		MakeViewData();
	return PTR_CAST( SvContainerEnvironment, pData );
}

//=========================================================================
void SvInPlaceClient::MakeVisible()
/*	[Beschreibung]

	Das Objekt, mit dem dieses Environment verbunden ist, soll in den
	sichtbaren Bereich des Containers geschoben werden. Als Default wird
	das Top- und das DocWindow angezeigt.
*/
{
	SvEmbeddedClient::MakeVisible();
	if( Owner() )
	{
		SvContainerEnvironment * pEnv = GetEnv();
		if( pEnv )
		{
			WorkWindow * pDoc = pEnv->GetDocWin();
			WorkWindow * pTop = pEnv->GetTopWin();
			if( pDoc )
			{
				if( pDoc->IsMinimized() )
					pDoc->Restore();
				//pDoc->ToTop();
				pDoc->Show();
			}
			if( pTop )
			{
				if( pTop->IsMinimized() )
					pTop->Restore();
				//pTop->ToTop();
				pTop->Show();
			}
		}
	}
}

//=========================================================================
void SvInPlaceClient::Opened
(
	BOOL bOpen	/* TRUE, in den Open-Status.
				   FALSE, in den Connect-Status. */
)
/*	[Beschreibung]

	Dieser Handler wird gerufen, wenn der Open-Status aktiviert oder
	deaktiviert wird.
	Ist bOpen == FALSE, wird die Verbindung aller Environment-Kinder
	abgebrochen.
*/
{
	SvEmbeddedClient::Opened( bOpen );
}

#ifdef WAR_NUR_EIN_TEST
//=========================================================================
void SvInPlaceClient::Embedded
(
	BOOL bEmbed	/* TRUE, in den Embed-Status. FALSE, in den Open-Status. */
)
/*	[Beschreibung]

	Dieser Handler wird gerufen, wenn der Embed-Status aktiviert oder
	deaktiviert wird.
	Es wird zuerst die <SvEmbeddedClient::Embedded()> gerufen. Ist
	bEmbed == FALSE, wird die Verbindung aller Environment-Kinder
	abgebrochen.
*/
{
	SvEmbeddedClient::Embedded( bEmbed );
	if( !bEmbed )
	{
		SvContainerEnvironment * pEnv = GetEnv();
		if( pEnv )
			pEnv->ResetChilds();
	}
}
#endif

//=========================================================================
void SvInPlaceClient::InPlaceActivate
(
	BOOL bActivate	/* TRUE, in den InPlace-Status.
					   FALSE, in den Open-Status. */
)
/*	[Beschreibung]

	Dieser Handler wird gerufen, wenn der InPlace-Status aktiviert oder
	deaktiviert wird.
	Ist bActivate == FALSE, wird die Verbindung aller Environment-Kinder
	abgebrochen.
*/
{
	if( !bActivate )
	{
		SvContainerEnvironment * pEnv = GetEnv();
		pEnv->ResetChilds();
	}

	if( !bActivate && HasViewData() )
		FreeViewData( pData );
}

//=========================================================================
void SvInPlaceClient::UIActivate
(
	BOOL bUIActivate	/* TRUE, in den UI-Status.
						   FALSE, in den IP-Status */
)
/*	[Beschreibung]

	Dieser Handler wird gerufen, wenn der UI-Status aktiviert oder
	deaktiviert wird.
*/
{
	if( Owner() )
	{
		if( !bUIActivate )
		{
			SvInPlaceEnvironment * pActEnv = SOAPP->pUIShowIPEnv;
			SvContainerEnvironment * pEnv = GetEnv();
			if( pActEnv )
			{
				if( !pEnv->IsChild( pActEnv->GetContainerEnv() ) )
				{ // es wurde kein Child aktiviert
					pEnv->GetIPEnv()->DoShowIPObj( FALSE );
				}
			}
			else
			{
				pEnv->GetIPEnv()->DoShowIPObj( FALSE );
				if( pEnv->GetParent() )
					// ein Deactivate ohne ein Activate
					pEnv->GetParent()->ShowUIByChildDeactivate();
			}

		}
	}
}

//=========================================================================
void SvInPlaceClient::DeactivateAndUndo()
{
}

//=========================================================================
void SvInPlaceClient::DiscardUndoState()
{
}


