/*************************************************************************
 *
 *  $RCSfile: cancel.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:58:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFXCANCEL_HXX
#define _SFXCANCEL_HXX

#if SUPD>=364
#define SFX_INSERT_CANCELLABLE InsertCancellable
#define SFX_REMOVE_CANCELLABLE RemoveCancellable
#else
#define SFX_INSERT_CANCELLABLE AddJob
#define SFX_REMOVE_CANCELLABLE RemoveJob
#endif

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif

#ifndef _REF_HXX //autogen
#include <tools/ref.hxx>
#endif

#ifndef _SFXBRDCST_HXX
#include "brdcst.hxx"
#endif

#ifndef _SFXSMPLHINT_HXX
#include "smplhint.hxx"
#endif

class SfxCancellable;

#ifdef _SFX_CANCEL_CXX

#ifndef _SVARRAY_HXX
#include "svarray.hxx"
#endif

SV_DECL_PTRARR( SfxCancellables_Impl, SfxCancellable*, 0, 4 );

#else

typedef SvPtrarr SfxCancellables_Impl;

#endif

//-------------------------------------------------------------------------

class SfxCancelManager: public SfxBroadcaster
, public SvWeakBase

/*	[Beschreibung]

	An Instanzen dieser Klasse k"onnen nebenl"aufige Prozesse angemeldet
	werden, um vom Benutzer abbrechbar zu sein. Werden abbrechbare
	Prozesse (Instanzen von <SfxCancellable>) an- oder abgemeldet, wird
	dies durch einen <SfxSimpleHint> mit dem Flag SFX_HINT_CANCELLABLE
	gebroadcastet.

	SfxCancelManager k"onnen hierarchisch angeordnet werden, so k"onnen
	z.B. Dokument-lokale Prozesse getrennt gecancelt werden.


	[Beispiel]

	SfxCancelManager *pMgr = new SfxCancelManager;
	StartListening( pMgr );
	pMailSystem->SetCancelManager( pMgr )
*/

{
	SfxCancelManager*		_pParent;
	SfxCancellables_Impl 	_aJobs;

public:
							SfxCancelManager( SfxCancelManager *pParent = 0 );
							~SfxCancelManager();

	BOOL                    CanCancel() const;
	void					Cancel( BOOL bDeep );
	SfxCancelManager*		GetParent() const { return _pParent; }

	void					SFX_INSERT_CANCELLABLE( SfxCancellable *pJob );
	void					SFX_REMOVE_CANCELLABLE( SfxCancellable *pJob );
	USHORT					GetCancellableCount() const
							{ return _aJobs.Count(); }
	SfxCancellable* 		GetCancellable( USHORT nPos ) const
							{ return (SfxCancellable*) _aJobs[nPos]; }
};

SV_DECL_WEAK( SfxCancelManager )
//-------------------------------------------------------------------------

class SfxCancellable

/*	[Beschreibung]

	Instanzen dieser Klasse werden immer an einem Cancel-Manager angemeldet,
	der dadurch dem Benutzer signalisieren kann, ob abbrechbare Prozesse
	vorhanden sind und der die SfxCancellable-Instanzen auf 'abgebrochen'
	setzen kann.

	Die im Ctor "ubergebene <SfxCancelManger>-Instanz mu\s die Instanz
	dieser Klasse "uberleben!


	[Beispiel]

	{
		SfxCancellable aCancel( pCancelMgr );
		while ( !aCancel && GetData() )
			Reschedule();
	}

*/

{
	SfxCancelManager*		_pMgr;
	BOOL					_bCancelled;
	String					_aTitle;

public:
							SfxCancellable( SfxCancelManager *pMgr,
											const String &rTitle )
							:	_pMgr( pMgr ),
								_bCancelled( FALSE ),
								_aTitle( rTitle )
							{ pMgr->SFX_INSERT_CANCELLABLE( this ); }

	virtual 				~SfxCancellable();

	void					SetManager( SfxCancelManager *pMgr );
	SfxCancelManager*       GetManager() const { return _pMgr; }

	virtual void			Cancel();
	BOOL					IsCancelled() const { return _bCancelled; }
	operator 				BOOL() const { return _bCancelled; }
	const String&			GetTitle() const { return _aTitle; }
};


#endif

