/*************************************************************************
 *
 *  $RCSfile: optspell.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: tl $ $Date: 2000/11/19 11:31:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

// include ---------------------------------------------------------------

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_TYPE_HXX_
#include <com/sun/star/uno/Type.hxx>
#endif

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif

#ifndef _UNO_LINGU_HXX
#include <unolingu.hxx>
#endif
#ifndef _SVX_DLGUTIL_HXX
#include <dlgutil.hxx>
#endif

#ifndef _SFX_SFXUNO_HXX
#include <sfx2/sfxuno.hxx>
#endif
#ifndef _LINGUISTIC_LNGPROPS_HHX_
#include <linguistic/lngprops.hxx>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_DICTIONARYLISTEVENTFLAGS_HPP_
#include <com/sun/star/linguistic2/DictionaryListEventFlags.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_DICTIONARYLISTEVENT_HPP_
#include <com/sun/star/linguistic2/DictionaryListEvent.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XDICTIONARYLISTEVENTLISTENER_HPP_
#include <com/sun/star/linguistic2/XDictionaryListEventListener.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XDICTIONARYLIST_HPP_
#include <com/sun/star/linguistic2/XDictionaryList.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XSTORABLE_HPP_
#include <com/sun/star/frame/XStorable.hpp>
#endif

#define _SVX_OPTSPELL_CXX

#include "optspell.hrc"
#include "dialogs.hrc"

#define _SVSTDARR_STRINGSDTOR
#include <svtools/svstdarr.hxx>
#define ITEMID_SPELLCHECK	0

#include "optdict.hxx"
#include "optitems.hxx"
#include "optspell.hxx"
#include "dialmgr.hxx"

using namespace osl;
using namespace com::sun::star;
using namespace com::sun::star::uno;
using namespace com::sun::star::frame;
using namespace com::sun::star::beans;
using namespace com::sun::star::lang;
using namespace com::sun::star::linguistic2;

#define C2U(cChar)  rtl::OUString::createFromAscii(cChar)
// static ----------------------------------------------------------------

static const USHORT nNameLen = 8;

static USHORT pRanges[] =
{
	SID_ATTR_SPELL,
	SID_ATTR_SPELL,
	0
};

static Any lcl_Bool2Any(BOOL bVal)
{
    Any aRet(&bVal, ::getBooleanCppuType());
    return aRet;
}

static sal_Bool lcl_Any2Bool(Any& rVal)
{
    return *(sal_Bool*)rVal.getValue();
}

// class SfxSpellTabPage -------------------------------------------------

SfxSpellTabPage::SfxSpellTabPage( Window* pParent,
								  const SfxItemSet& rSet ):

	SfxTabPage( pParent, ResId( RID_SFXPAGE_SPELL, DIALOG_MGR() ), rSet ),

	aBookBtn	( this, ResId( BTN_BOOK ) ),
	aBookLB		( this, ResId( LB_BOOK ) ),
	aBookBox	( this, ResId( GB_BOOK ) ),
	aCapsBtn	( this, ResId( BTN_CAPS ) ),
	aNumBtn		( this, ResId( BTN_NUMS ) ),
	aUpLowBtn	( this, ResId( BTN_UPLOW ) ),
	aAuditBox	( this, ResId( GB_AUDIT ) )
{
	uno::Reference< XDictionaryList > xDicList( SvxGetDictionaryList() );
	if (xDicList.is())
		aDics = xDicList->getDictionaries();
	const SfxSpellCheckItem* pItem = 0;
	SfxItemState eItemState = SFX_ITEM_UNKNOWN;

	eItemState = rSet.GetItemState( GetWhich( SID_ATTR_SPELL ),
									FALSE, (const SfxPoolItem**)&pItem );

	// handelt es sich um ein Default-Item?
	if ( eItemState == SFX_ITEM_DEFAULT )
		pItem = (const SfxSpellCheckItem*)&(rSet.Get( GetWhich( SID_ATTR_SPELL ) ) );
	else if ( eItemState == SFX_ITEM_DONTCARE )
		pItem = NULL;

	aBookBtn.SetClickHdl( LINK( this, SfxSpellTabPage, BookHdl ) );

	// disable controls that can't be used due to missing services
	if (!SvxGetLinguPropertySet().is())
		Enable( FALSE );	// disable everything
	else if (!xDicList.is())
	{   // disable dictionary and dictionary list controls
		aBookBtn.Enable( FALSE );
		aBookLB .Enable( FALSE );
		aBookBox.Enable( FALSE );
	}
	FreeResource();
}

//------------------------------------------------------------------------

USHORT* SfxSpellTabPage::GetRanges()
{
	return pRanges;
}

//------------------------------------------------------------------------

SfxTabPage* SfxSpellTabPage::Create( Window* pParent,
									 const SfxItemSet& rAttrSet )
{
	return ( new SfxSpellTabPage( pParent, rAttrSet ) );
}

//------------------------------------------------------------------------

BOOL SfxSpellTabPage::FillItemSet( SfxItemSet& rCoreSet )
{
	BOOL bModified = TRUE; // !!!!

	uno::Reference< XDictionaryList > xDicList( SvxGetDictionaryList() );

	// Dictionaries verwalten
	const USHORT nCount = aDics.getLength();
	const uno::Reference< XDictionary > *pDic = aDics.getConstArray();
	const USHORT nSize  = aBookLB.GetSelectEntryCount();
	//
	BOOL bIsAnyPosDicActive = FALSE;
	for ( USHORT j=0; j < nCount; ++j )
	{
		uno::Reference< XDictionary1 > xDic( pDic[j], UNO_QUERY);
		if (!xDic.is())
			continue;

		BOOL bNegativ = xDic->getDictionaryType() == DictionaryType_NEGATIVE;
		const String aName( ::GetDicInfoStr( xDic->getName(),
											 xDic->getLanguage(),
											 bNegativ ) );

		BOOL bActivate = FALSE;
		for ( USHORT i=0; i < nSize; ++i )
		{   // Dictionary in der SSelection -> Aktivieren
			if ( aName == aBookLB.GetSelectEntry(i) )
			{
				// any dictionary is persistent not readonly and may hold
				// positive entries?
				uno::Reference< XStorable > xStor( xDic, UNO_QUERY );
				if (xStor.is() && xStor->hasLocation() && !xStor->isReadonly())
					bIsAnyPosDicActive =
							xDic->getDictionaryType() != DictionaryType_NEGATIVE;

				bActivate = TRUE;
				break;
			}
		}
		xDic->setActive( bActivate );

		// nicht in Selektion  -> Remove von der aktiven Liste falls vorhanden
		//if ( i == nSize )
		//	pSpell->RemoveDic(j);
	}

	// set spellchecker properties
	uno::Reference< XPropertySet > xProp( SvxGetLinguPropertySet() );
	if (xProp.is())
	{
		xProp->setPropertyValue( C2U(UPN_IS_SPELL_WITH_DIGITS),
				lcl_Bool2Any( aNumBtn.IsChecked() ) );
		xProp->setPropertyValue( C2U( UPN_IS_SPELL_UPPER_CASE ),
				lcl_Bool2Any( aCapsBtn.IsChecked() ) );
		xProp->setPropertyValue( C2U( UPN_IS_SPELL_CAPITALIZATION ),
				lcl_Bool2Any( aUpLowBtn.IsChecked() ) );
	}
	return bModified;
}

//------------------------------------------------------------------------

void SfxSpellTabPage::Reset( const SfxItemSet& )
{
	UpdateBox();

	// Optionen aus dem Speller einstellen
	uno::Reference< XPropertySet > xProp( SvxGetLinguPropertySet() );
	if (xProp.is())
	{
		aCapsBtn .Check( lcl_Any2Bool(
				xProp->getPropertyValue( C2U( UPN_IS_SPELL_UPPER_CASE ) ) ) );
		aNumBtn  .Check( lcl_Any2Bool(
				xProp->getPropertyValue( C2U( UPN_IS_SPELL_WITH_DIGITS ) ) ) );
		aUpLowBtn.Check( lcl_Any2Bool(
				xProp->getPropertyValue( C2U( UPN_IS_SPELL_CAPITALIZATION ) ) ) );
	}
}

// -----------------------------------------------------------------------

IMPL_LINK( SfxSpellTabPage, BookHdl, Button *, EMPTYARG )
{
	// Selektion sichern
	SvStringsDtor aList;

	USHORT i;
	for ( i=0; i < aBookLB.GetSelectEntryCount(); ++i )
	{
		String* pTmp = new String( aBookLB.GetSelectEntry(i) );
		aList.Insert( pTmp, aList.Count() );
	}

	// erst Pointer auf TabControl holen, dann auf TabDialog
	SvxEditDictionaryDialog* pDlg =
		new SvxEditDictionaryDialog( this, aBookLB.GetSelectEntry(), xSpell );
	pDlg->Execute();
	delete pDlg;
	pDlg = 0;

	aBookLB.Clear();
	UpdateBox();

	// selektieren
	for ( i=0; i < aList.Count(); ++i )
		aBookLB.SelectEntry( *aList[i] );
	return 0;
}

// -----------------------------------------------------------------------

void SfxSpellTabPage::UpdateBox()
{
	const USHORT nCount = aDics.getLength();
	const uno::Reference< XDictionary > *pDic = aDics.getConstArray();
	for ( USHORT i=0; i < nCount; ++i )
	{
		uno::Reference< XDictionary1 > xDic( pDic[i], UNO_QUERY );
		if (!xDic.is())
			continue;

		BOOL bNegativ = xDic->getDictionaryType() == DictionaryType_NEGATIVE;
		const String aName( ::GetDicInfoStr( xDic->getName(),
											 xDic->getLanguage(),
											 bNegativ ) );
		aBookLB.InsertEntry( aName );

		if (xDic->isActive())
			aBookLB.SelectEntry( aName );
	}
}


