/*************************************************************************
 *
 *  $RCSfile: dialdll.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: er $ $Date: 2001/11/23 19:25:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#include <svtools/solar.hrc>
#include <tools/stream.hxx>
#include "dialdll.hxx"
#include "dialmgr.hxx"
#define ITEMID_BRUSH 1
#include "brshitem.hxx"
#include "chardlg.hxx"

#ifndef _SHL_HXX //autogen
#include <tools/shl.hxx>
#endif

#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif

#ifndef _TOOLS_RESMGR_HXX //autogen
#include <tools/resmgr.hxx>
#endif

#ifndef _FILTER_HXX //autogen
#include <svtools/filter.hxx>
#endif

#ifndef _WALLITEM_HXX
#include <svtools/wallitem.hxx>
#endif

// struct DialogsResMgr --------------------------------------------------
DialogsResMgr::DialogsResMgr()
:	pResMgr(0),
	pGrapicFilter(0)
{
#ifndef SVX_LIGHT
	ByteString aName( "svx" );
#else
	ByteString aName( "svl" );
#endif
	INT32 nSolarUpd(SOLARUPD);
	aName += ByteString::CreateFromInt32( nSolarUpd );
    pResMgr = ResMgr::CreateResMgr( aName.GetBuffer(), Application::GetSettings().GetUILanguage() );
}

// -----------------------------------------------------------------------
DialogsResMgr::~DialogsResMgr()
{
	delete pGrapicFilter;
	delete pResMgr;
}

// class SvxDialogDll ----------------------------------------------------
SvxDialogDll::SvxDialogDll()
{
	DBG_ASSERT( !(*GetAppData(SHL_SVX)), "Ctor, but pointer not null" );

	(*(DialogsResMgr**)GetAppData(SHL_SVX)) = new DialogsResMgr;
	SvxBrushItem::InitSfxLink();  //  OV,30.06.1998
}

// -----------------------------------------------------------------------
SvxDialogDll::~SvxDialogDll()
{
	DBG_ASSERT( (*GetAppData(SHL_SVX)), "Dtor, pointer == null" );

	delete (*(DialogsResMgr**)GetAppData(SHL_SVX));
	(*(DialogsResMgr**)GetAppData(SHL_SVX)) = 0;
	delete SfxBrushItemLink::Get();
	(*(SfxBrushItemLink**)GetAppData(SHL_BRUSHITEM)) = 0;
}

// -----------------------------------------------------------------------
void SvxDialogDll::ResetResMgr()
{
	DialogsResMgr* pResMgr = (*(DialogsResMgr**)GetAppData(SHL_SVX));
	DBG_ASSERT( pResMgr, "SvxDialogDll::ResetResMgr - no ResMgr" );
	if ( pResMgr )
	{
		delete pResMgr;
		(*(DialogsResMgr**)GetAppData(SHL_SVX)) = new DialogsResMgr;
	}
}


