/*************************************************************************
 *
 *  $RCSfile: chpfld.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: jp $ $Date: 2001/10/24 18:43:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _CHPFLD_HXX
#define _CHPFLD_HXX

#include "fldbas.hxx"

class SwFrm;
class SwTxtNode;

#ifndef _UNOOBJ_HXX
#include <unoobj.hxx>
#endif

enum SwChapterFormat
{
	CF_BEGIN,
	CF_NUMBER = CF_BEGIN,		// nur die Kapitelnummer
	CF_TITLE,					// nur die "Ueberschrift"
	CF_NUM_TITLE,				// Kapitelnummer und "Ueberschrift"
	CF_NUMBER_NOPREPST,			// nur die Kapitelnummer ohne Post/Prefix
	CF_NUM_NOPREPST_TITLE,		// Kapitelnummer ohne Post/Prefix und "Ueberschrift"
	CF_END
};

/*--------------------------------------------------------------------
	Beschreibung: Kapitel
 --------------------------------------------------------------------*/

class SwChapterFieldType : public SwFieldType
{
public:
	SwChapterFieldType();

	virtual SwFieldType*	Copy() const;

};



/*--------------------------------------------------------------------
	Beschreibung: Kapitelnummer
 --------------------------------------------------------------------*/
class SwChapterField : public SwField
{
	friend class SwChapterFieldType;
	BYTE nLevel;
	String sTitle, sNumber, sPre, sPost;
public:
	SwChapterField(SwChapterFieldType*, ULONG nFmt = 0);

	void ChangeExpansion( const SwFrm*, const SwTxtNode*, BOOL bSrchNum = FALSE);

	virtual String	 Expand() const;
	virtual SwField* Copy() const;

	inline BYTE GetLevel() const;
	inline void	SetLevel(BYTE);

	inline const String& GetNumber() const;
	inline const String& GetTitle() const;
	virtual	BOOL       	QueryValue( com::sun::star::uno::Any& rVal, BYTE nMId ) const;
	virtual	BOOL		PutValue( const com::sun::star::uno::Any& rVal, BYTE nMId );
};

inline BYTE SwChapterField::GetLevel() const 	{ return nLevel; }
inline void	SwChapterField::SetLevel(BYTE nLev) { nLevel = nLev; }
inline const String& SwChapterField::GetNumber() const { return sNumber; }
inline const String& SwChapterField::GetTitle() const { return sTitle; }

#endif // _CHPFLD_HXX
