/*************************************************************************
 *
 *  $RCSfile: sw3misc.cxx,v $
 *
 *  $Revision: 1.22 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 14:19:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#define _ZFORLIST_DECLARE_TABLE

#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif

#pragma hdrstop

#ifndef SVTOOLS_URIHELPER_HXX
#include <svtools/urihelper.hxx>
#endif
#ifndef _SVTOOLS_PASSWORDHELPER_HXX
#include <svtools/PasswordHelper.hxx>
#endif
#ifndef _SFX_PRINTER_HXX
#include <sfx2/printer.hxx>
#endif
#ifndef _SFXDOCINF_HXX
#include <sfx2/docinf.hxx>
#endif

#include <stdio.h>

#ifndef _COM_SUN_STAR_SDB_COMMANDTYPE_HPP_
#include <com/sun/star/sdb/CommandType.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XDICTIONARYLIST_HPP_
#include <com/sun/star/linguistic2/XDictionaryList.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XDICTIONARY_HPP_
#include <com/sun/star/linguistic2/XDictionary.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XDICTIONARY1_HPP_
#include <com/sun/star/linguistic2/XDictionary1.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#ifndef _ZFORLIST_HXX //autogen
#include <svtools/zforlist.hxx>
#endif
#ifndef _SVX_SVXIDS_HRC
#include <svx/svxids.hrc>
#endif
#ifndef _SVDMODEL_HXX //autogen
#include <svx/svdmodel.hxx>
#endif
#ifndef _SVX_BOXITEM_HXX //autogen
#include <svx/boxitem.hxx>
#endif

#ifndef _SWDOCSH_HXX //autogen
#include <docsh.hxx>
#endif
#ifndef _DOCARY_HXX
#include <docary.hxx>
#endif
#ifndef _CHARFMT_HXX //autogen
#include <charfmt.hxx>
#endif
#ifndef _NODE_HXX //autogen
#include <node.hxx>
#endif
#ifndef SW_LINEINFO_HXX //autogen
#include <lineinfo.hxx>
#endif
#ifndef _VIEWOPT_HXX //autogen
#include <viewopt.hxx>
#endif
#ifndef _SWMODULE_HXX //autogen
#include <swmodule.hxx>
#endif
#ifndef _VIEWSH_HXX //autogen
#include <viewsh.hxx>
#endif
#ifndef _PVPRTDAT_HXX
#include <pvprtdat.hxx>
#endif
#ifndef _LINKENUM_HXX
#include <linkenum.hxx>
#endif
#ifndef _SWTYPES_HXX
#include <swtypes.hxx>
#endif
#ifndef _SWTABLE_HXX
#include <swtable.hxx>
#endif
#ifndef _DOC_HXX
#include <doc.hxx>
#endif
#ifndef _PAM_HXX
#include <pam.hxx>
#endif
#ifndef _ROOTFRM_HXX
#include <rootfrm.hxx>
#endif
#ifndef _SW3IMP_HXX
#include <sw3imp.hxx>
#endif
#ifndef _SW3MARKS_HXX
#include <sw3marks.hxx>
#endif
#ifndef _FLYPOS_HXX
#include <flypos.hxx>
#endif
#ifndef _SECTION_HXX
#include <section.hxx>
#endif
#ifndef _PAGEDESC_HXX
#include <pagedesc.hxx>
#endif
#ifndef _BOOKMRK_HXX
#include <bookmrk.hxx>
#endif
#ifndef _POOLFMT_HXX
#include <poolfmt.hxx>
#endif
#ifndef _DOCTXM_HXX
#include <doctxm.hxx>
#endif
#ifndef _CRYPTER_HXX
#include <crypter.hxx>
#endif
#ifndef _DBMGR_HXX
#include <dbmgr.hxx>
#endif
#ifndef _SWTBLFMT_HXX
#include <swtblfmt.hxx>
#endif
#ifndef _FLDUPDE_HXX
#include <fldupde.hxx>
#endif
#ifndef _FLDBAS_HXX
#include <fldbas.hxx>
#endif
#ifndef _NDTXT_HXX
#include <ndtxt.hxx>
#endif
#ifndef _FTNIDX_HXX //autogen
#include <ftnidx.hxx>
#endif

#ifndef _CMDID_H
#include <cmdid.h>
#endif
#ifndef _SWSWERROR_H
#include <swerror.h>
#endif
#ifndef _SWSTYLENAMEMAPPER_HXX
#include <SwStyleNameMapper.hxx>
#endif

using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::linguistic2;

#define URL_DECODE 	\
	, INetURLObject::WAS_ENCODED, INetURLObject::DECODE_UNAMBIGUOUS

//#define TEST_FMTCHACHE

// local record of SWG_TOX
#define SWG_FORMPATTERN_LCL 'P'

// local record of SWG_FORMPATTERN_LCL
#define SWG_FORMTOKEN_LCL 'D'

class Sw3TOXBase : public SwTOXBase
{
	SwNodeIndex *pStartNodeIdx;
	SwNodeIndex *pEndNodeIdx;

	SwSectionFmt *pSectFmt;
	SwSectionFmt *pTitleSectFmt;

	sal_uInt32 nTitleLen;
	sal_uInt16 nStrIdx;

public:

	Sw3TOXBase( const SwTOXType* pTyp, const SwForm& rForm,
				sal_uInt16 nCreaType, const String& rTitle ) :
		SwTOXBase( pTyp, rForm, nCreaType, rTitle ),
		pStartNodeIdx( 0 ), pEndNodeIdx( 0 ),
		pSectFmt( 0 ), pTitleSectFmt( 0 ),
		nTitleLen( 0 ), nStrIdx( IDX_NO_VALUE )
	{}

	~Sw3TOXBase();

	const SwNodeIndex *GetStartNodeIdx() const { return pStartNodeIdx; }
	const SwNodeIndex *GetEndNodeIdx() const { return pEndNodeIdx; }
	void SetNodeIdx( const SwNodeIndex& rNodeIdx );

	SwSectionFmt *GetSectFmt() const { return pSectFmt; }
	void SetSectFmt( SwSectionFmt *pFmt ) { pSectFmt = pFmt; }

	SwSectionFmt *GetTitleSectFmt() const { return pTitleSectFmt; }
	void SetTitleSectFmt( SwSectionFmt *pFmt ) { pTitleSectFmt = pFmt; }

	sal_uInt32 GetTitleLen() const { return nTitleLen; }
	void SetTitleLen( sal_uInt32 n ) { nTitleLen = n; }

	sal_uInt16 GetSectFmtStrIdx() const { return nStrIdx; }
	void SetSectFmtStrIdx( sal_uInt16 n ) { nStrIdx = n; }
};

SV_IMPL_PTRARR(Sw3TOXs,Sw3TOXBase*)

void Sw3TOXBase::SetNodeIdx( const SwNodeIndex& rNodeIdx )
{
	SwNodeIndex *pNdIdx = new SwNodeIndex( rNodeIdx );
	if( pStartNodeIdx )
	{
		ASSERT( !pEndNodeIdx, "more than two TOX indexes" );
		if( !pEndNodeIdx )
		{
			if( rNodeIdx.GetIndex() < pStartNodeIdx->GetIndex() )
			{
				pEndNodeIdx = pStartNodeIdx;
				pStartNodeIdx = pNdIdx;
			}
			else
			{
				pEndNodeIdx = pNdIdx;
			}
		}
	}
	else
	{
		pStartNodeIdx = pNdIdx;
	}
}

Sw3TOXBase::~Sw3TOXBase()
{
	delete pStartNodeIdx;
	delete pEndNodeIdx;

	// Section formats must not be deleted by delete.
	SwDoc *pDoc = 0;
	if( pTitleSectFmt )
	{
		pDoc = pTitleSectFmt->GetDoc();
		pDoc->DelSectionFmt( pTitleSectFmt, sal_False );
	}
	if( pSectFmt )
	{
		if( !pDoc )
			pDoc = pSectFmt->GetDoc();
		pDoc->DelSectionFmt( pSectFmt, sal_False );
	}
}

// Finden eines Formats nach Namen

SwFmt* Sw3IoImp::FindFmt( sal_uInt16 nIdx, sal_uInt8 cKind )
{
	SwFmt* pFmt = NULL;
	switch( nIdx )
	{
		case IDX_NO_VALUE:
			return NULL;	// Direkter Abbruch, kein Assert
		case IDX_DFLT_VALUE:
			switch( cKind )
			{
				case SWG_FLYFMT:
				case SWG_SDRFMT:
				case SWG_FREEFMT:
				case SWG_FRAMEFMT:
					pFmt = pDoc->GetDfltFrmFmt(); break;
				case SWG_CHARFMT:
					pFmt = pDoc->GetDfltCharFmt(); break;
				case SWG_GRFFMT:
					pFmt = (SwFmt*) pDoc->GetDfltGrfFmtColl(); break;
				case SWG_SECTFMT:
				case 0:
					return NULL;	// Direkter Abbruch, kein Assert
			} break;
		default:
			// Holen des Namens und suchen im Doc

// OPT: Cache fuer Formate im StringPool
			if( nIdx < IDX_SPEC_VALUE )
			{
				pFmt = aStringPool.FindCachedFmt( nIdx );
				if( pFmt )
				{
#ifdef TEST_FMTCHACHE
					ASSERT( FindNamedFmt( nIdx, cKind ) == pFmt,
							"Format-Cache liefert falsches Ergebnis" );
#endif
					return pFmt;
				}
			}
// /OPT: Cache fuer Formate im StringPool

			pFmt = FindNamedFmt( nIdx, cKind );
	}
	ASSERT( pFmt, "Format-ID unbekannt" );
	return pFmt;
}

// Suchen eines (benannten) Formats am Dokument

SwFmt* Sw3IoImp::FindNamedFmt( sal_uInt16 nIdx, sal_uInt8 cKind )
{
	if( nIdx < IDX_SPEC_VALUE )
	{
		SwFmt* pFmt;
		const String& rName = aStringPool.Find( nIdx );
		sal_uInt16 n, nArrLen;
		if( cKind == SWG_CHARFMT )
		{
			nArrLen = pDoc->GetCharFmts()->Count();
			for( n = 0; n < nArrLen; n++ )
			{
				pFmt = (SwFmt*) (*pDoc->GetCharFmts())[ n ];
				if( pFmt->GetName() == rName )
				{
// OPT: Cache fuer Formate im StringPool
					aStringPool.SetCachedFmt( nIdx, pFmt );
// /OPT: Cache fuer Formate im StringPool
					return pFmt;
				}
			}
		}
		else if( cKind == SWG_SECTFMT )
		{
			nArrLen = pDoc->GetSections().Count();
			for( n = 0; n < nArrLen; n++ )
			{
				pFmt = pDoc->GetSections()[ n ];
				if( pFmt->GetName() == rName )
				{
// OPT: Cache fuer Formate im StringPool
					aStringPool.SetCachedFmt( nIdx, pFmt );
// /OPT: Cache fuer Formate im StringPool
					return pFmt;
				}
			}
		}
		else
		{
			nArrLen = pDoc->GetFrmFmts()->Count();
			const SwFrmFmts *pFrmFmts = pDoc->GetFrmFmts();
			for( n = 0; n < nArrLen; n++ )
			{
				pFmt = (SwFmt*) (*pFrmFmts)[ n ];
				if( pFmt->GetName() == rName )
				{
// OPT: Cache fuer Formate im StringPool
					aStringPool.SetCachedFmt( nIdx, pFmt );
// /OPT: Cache fuer Formate im StringPool
					return pFmt;
				}
			}

			if( 0 != ( pFmt = pDoc->FindSpzFrmFmtByName( rName )) ||
				0 != ( pFmt = pDoc->FindTblFmtByName( rName )) )
				return pFmt;
		}
		// Vielleicht koennen wir uns eines machen?
		sal_uInt16 nPoolId = aStringPool.FindPoolId( nIdx );
		if( !IsPoolUserFmt( nPoolId ) )  // fix 20976
		{
			pFmt = pDoc->GetFmtFromPool( nPoolId );
			if( pFmt )
				return pFmt;
		}
	}
	ASSERT( !this, "Benanntes Format nicht gefunden" );
// Falls ueber den Organizer, die Styles veraendert wurden, kein Fehler
// melden, sonder auf Standard zurueck fallen
// Error();
	Warning();
	if( cKind == SWG_CHARFMT )
		return pDoc->GetDfltCharFmt();
	else if( cKind==SWG_FRAMEFMT || cKind==SWG_FLYFMT )
		return pDoc->GetFmtFromPool( RES_POOLFRM_FRAME );
	else if( cKind==SWG_SDRFMT )
		return pDoc->GetDfltFrmFmt();

 	Error();			// alle anderen erzeugen einen Fehler
	return NULL;
}

// Suchen einer TextColl am Dokument
SwTxtFmtColl* Sw3IoImp::FindTxtColl( sal_uInt16 nIdx )
{
	if( nIdx < IDX_SPEC_VALUE )
	{
		const String& rName = aStringPool.Find( nIdx );
		sal_uInt16 nArrLen = pDoc->GetTxtFmtColls()->Count();
		for( sal_uInt16 n = 0; n < nArrLen; n++ )
		{
			SwTxtFmtColl* pColl = (SwTxtFmtColl*) (*pDoc->GetTxtFmtColls())[ n ];
			if( pColl->GetName() == rName )
				return pColl;
		}
		// Vielleicht koennen wir uns eines machen?
		sal_uInt16 nPoolId = aStringPool.FindPoolId( nIdx );
		if( nPoolId && !IsPoolUserFmt( nPoolId ) )
		{
			SwTxtFmtColl* pColl = pDoc->GetTxtCollFromPool( nPoolId );
			if( pColl )
				return pColl;
		}
		// Werden nur Seitenvorlagen eingelesen, wird still auf StdColl gemapt
		// in diesem Fall lesen wir naemlich gerade einen Header/Footer ein,
		// und der hat vielleicht eine unbekannte Absatzvorlage
		if( bPageDescs && !bTxtColls )
			return pDoc->GetTxtCollFromPool( RES_POOLCOLL_STANDARD );
		ASSERT( !this, "TextColl nicht gefunden" );

// Falls ueber den Organizer, die Styles veraendert wurden, kein Fehler
// melden, sonder auf Standard zurueck fallen
//	 Error();
		Warning();
	}
	return pDoc->GetTxtCollFromPool( RES_POOLCOLL_STANDARD );
}

// Suchen einer Seitenvorlage am Dokument

SwPageDesc* Sw3IoImp::FindPageDesc( sal_uInt16 nIdx )
{
	if( nIdx < IDX_SPEC_VALUE )
	{
		const String& rName = aStringPool.Find( nIdx );
		sal_uInt16 nArrLen = pDoc->GetPageDescCnt();
		for( sal_uInt16 n = 0; n < nArrLen; n++ )
		{
			const SwPageDesc& rPg = pDoc->GetPageDesc( n );
			if( rPg.GetName() == rName )
				return (SwPageDesc*) &rPg;
		}
		// Vielleicht koennen wir uns eines machen?
		sal_uInt16 nPoolId = aStringPool.FindPoolId( nIdx );
		if( nPoolId )
		{
			SwPageDesc* p = pDoc->GetPageDescFromPool( nPoolId );
			if( p )
				return p;
		}
		ASSERT( !this, "PageDesc nicht gefunden" );
// Falls ueber den Organizer, die Styles veraendert wurden, kein Fehler
// melden, sonder auf Standard zurueck fallen
//	 Error();
		Warning();
	}
	return (SwPageDesc*) &pDoc->GetPageDesc( 0 );
}

//////////////////////////////////////////////////////////////////////////

// Makros

void Sw3IoImp::InMacroTbl()
{
	OpenRec( SWG_MACROTBL );
	while( BytesLeft() )
	{
		OpenRec( SWG_MACRO );
		sal_uInt16 nKey, nScriptType = STARBASIC;
		String aLib, aMac;
		*pStrm >> nKey;
		InString( *pStrm, aLib );
		InString( *pStrm, aMac );

		if( SWG_SVXMACROS <= nVersion )
			*pStrm >> nScriptType;
		pDoc->SetGlobalMacro( nKey, SvxMacro( aMac, aLib,
										(ScriptType)nScriptType ) );
		CloseRec( SWG_MACRO );
	}
	CloseRec( SWG_MACROTBL );
}

void Sw3IoImp::OutMacroTbl()
{
	const SvxMacroTableDtor& rTbl = pDoc->GetMacroTable();
	SvxMacro* pMac = ((SvxMacroTableDtor&) rTbl).First();
	if( !pMac )
		return;

	ASSERT( SOFFICE_FILEFORMAT_31 == pStrm->GetVersion() ||
			SOFFICE_FILEFORMAT_40 == pStrm->GetVersion() ||
			SOFFICE_FILEFORMAT_50 == pStrm->GetVersion(),
			"Macro-Table: Gibt es ein neues Fileformat?" );
	if( SOFFICE_FILEFORMAT_31 == pStrm->GetVersion() )
	{
		// suche das erste StarBasicMacro!
		while( pMac && STARBASIC != pMac->GetScriptType() )
			pMac = ((SvxMacroTableDtor&) rTbl).Next();
		if( !pMac )
			return ;
	}

	OpenRec( SWG_MACROTBL );
	while( pMac && Good() )
	{
		OpenRec( SWG_MACRO );
		*pStrm << (sal_uInt16) rTbl.GetCurKey();
	  	OutString( *pStrm, pMac->GetLibName() );
	 	OutString( *pStrm, pMac->GetMacName() );

		if( SOFFICE_FILEFORMAT_31 == pStrm->GetVersion() )
		{
			do {
				pMac = ((SvxMacroTableDtor&) rTbl).Next();
			} while( pMac && STARBASIC != pMac->GetScriptType() );
		}
		else
		{
			*pStrm << (sal_uInt16)pMac->GetScriptType();
			pMac = ((SvxMacroTableDtor&) rTbl).Next();
		}

		CloseRec( SWG_MACRO );
	}
	CloseRec( SWG_MACROTBL );
}

/*************************************************************************
*
*		Job Setup
*
*************************************************************************/

void Sw3IoImp::InJobSetup()
{
	OpenRec( SWG_JOBSETUP );
	OpenFlagRec();
	CloseFlagRec();

	//JP 13.10.95: laut Changes-Mail von MI
	static sal_uInt16 __READONLY_DATA nRange[] =
					{
						FN_PARAM_ADDPRINTER, FN_PARAM_ADDPRINTER,
						SID_HTML_MODE,	SID_HTML_MODE,
						SID_PRINTER_NOTFOUND_WARN, SID_PRINTER_NOTFOUND_WARN,
						SID_PRINTER_CHANGESTODOC, SID_PRINTER_CHANGESTODOC,
						0
					};
	SfxItemSet *pItemSet = new SfxItemSet( pDoc->GetAttrPool(), nRange );
	SfxPrinter *pPrinter = SfxPrinter::Create( *pStrm, pItemSet );

    if ( !IsVersion(SWG_VIRTUAL_DEVICE) )
        pDoc->_SetUseVirtualDevice( sal_False );
	pDoc->_SetPrt( pPrinter );

    if ( !pPrinter->IsOriginal() )
	{
		pDoc->GetDocShell()->UpdateFontList();
		if ( pDoc->pDrawModel )
            pDoc->pDrawModel->SetRefDevice( pPrinter );

        pDoc->SetOLEPrtNotifyPending( sal_True );
	}

	CloseRec( SWG_JOBSETUP );
}

// Neu fuer OS/2: Wenn das Job-Setup keine Daten enthaelt, dann wird das
// Job-Setup nicht rausgeschrieben.

void Sw3IoImp::OutJobSetup()
{
	SfxPrinter*	pPrt = pDoc->GetPrt();
	if( pPrt )
	{
		OpenRec( SWG_JOBSETUP );
		sal_uInt8 cFlags = 0x00;
		*pStrm << cFlags;
		pPrt->Store( *pStrm );
		CloseRec( SWG_JOBSETUP );
	}
}

/*************************************************************************
*
*		Stringpool (ab Version 2)
*
*************************************************************************/

void Sw3IoImp::InStringPool( sal_uInt8 cType, Sw3StringPool& rPool )
{
	OpenRec( cType );
	if( nVersion < SWG_POOLIDS )
		rPool.LoadOld( *pStrm );
	else
		rPool.Load( *pStrm, nVersion );
	CloseRec( cType );
	if( pStrm->GetError() != SVSTREAM_OK )
	 	Error( ERR_SWG_READ_ERROR );
}

void Sw3IoImp::OutStringPool( sal_uInt8 cType, Sw3StringPool& rPool )
{
	OpenRec( cType );
	rPool.Store( *pStrm );
	CloseRec( cType );
}

void Sw3IoImp::InPasswd()
{
	OpenRec( SWG_PASSWORD );
	if( nVersion >= SWG_CRYPT )
	{
		sal_uInt8 cType;
		ByteString aPasswd;
		*pStrm >> cType;
		// TODO: unicode: It seems that we had a bug here, because the
		// password was converted from the source to the system encoding
		// before it was decrypted. We now decrypt it first.
		pStrm->ReadByteString( aPasswd );
        /*
        // Datum und Uhrzeit als Passwort fuers Passwort nehmen
		sal_Char buf[ 17 ];
		snprintf( buf, sizeof(buf), "%08lx%08lx", nDate, nTime );
		Crypter( buf ).Decrypt( aPasswd );
		switch( cType )
		{
			case 1:
				{
					::com::sun::star::uno::Sequence <sal_Int8> aPWD;
					SvPasswordHelper::GetHashPassword( aPWD,
										String( aPasswd, eSrcSet ));
					pDoc->ChgSectionPasswd( aPWD );
					break;
				}
        }*/
	}
	CloseRec( SWG_PASSWORD );
}

int sw3mark_compare( const Sw3Mark& r1, const Sw3Mark& r2 )
{
	int nRet = 0;
	if( r1.nNodePos < r2.nNodePos )
		nRet = -1;
	else if( r1.nNodePos > r2.nNodePos )
		nRet = 1;
	else if( r1.nNodeOff < r2.nNodeOff )
		nRet = -1;
	else if( r1.nNodeOff > r2.nNodeOff )
		nRet = 1;
	else if( r1.nId < r2.nId )
		nRet = -1;
	else if( r1.nId > r2.nId || r1.eType != r2.eType )
		nRet = 1;

	return nRet;
}

IMPL_CONTAINER_SORT( Sw3Marks, Sw3Mark, sw3mark_compare )

extern sal_Bool lcl_sw3io_isTOXHeaderSection( const SwStartNode& rSttNd );
void Sw3IoImp::CollectMarks( SwPaM* pPaM, sal_Bool bPageOnly )
{
	sal_uInt32 nEndOfIcons = pDoc->GetNodes().GetEndOfExtras().GetIndex();

	// Bereich bestimmen
	sal_uInt32 nStart, nEnd;
	if( !bSaveAll && pPaM )
		nStart = pPaM->GetPoint()->nNode.GetIndex(),
		nEnd   = pPaM->GetMark()->nNode.GetIndex();
	else
		nStart = 0,
		nEnd   = pDoc->GetNodes().GetEndOfContent().GetIndex();
	if( nStart > nEnd )
	{
		// Start muss kleiner als Ende sein
		sal_uInt32 n = nStart; nStart = nEnd; nEnd = n;
	}
	// Array anlegen
	delete pMarks;
	pMarks = 0;

	delete pBookmarks;
	pBookmarks = new Sw3Bookmarks;
	nCntntBkmkStart = 0;

	Sw3Mark aMark;
	// text::Bookmarks absammeln (nicht, wenn Konversion SW2-Textbausteine auf SW3)
	if( !( nGblFlags & SW3F_CONVBLOCK ) )
	{
		//JP 23.09.95: wenn Selektion geschrieben wird, dann auch alle aus
		//				den Sonderbereichen mit nehmen!!
		const SwBookmarks& rMarks = pDoc->GetBookmarks();
		sal_uInt16 nArrLen = rMarks.Count();

		for( sal_uInt16 n = 0; n < nArrLen; ++n )
		{
			SwBookmark* pMark = rMarks.GetObject( n );
			if( !pMark->IsBookMark() )
				continue;

			const SwPosition& rPos1 = pMark->GetPos();
			const SwPosition* pPos2 = pMark->GetOtherPos();
			if( rPos1.nContent.GetIndex() > STRING_MAXLEN52 &&
				( !pPos2 ||
				  (rPos1.nNode.GetIndex() == pPos2->nNode.GetIndex() &&
				   pPos2->nContent.GetIndex() > STRING_MAXLEN52) ) )
				continue;

			if( pDoc->IsInHeaderFooter( rPos1.nNode ) )
			{
				pBookmarks->Insert( pMark, nCntntBkmkStart );
				nCntntBkmkStart++;
			}
			else if( !bPageOnly )
			{
				pBookmarks->Insert( pMark, pBookmarks->Count() );
			}
		}
		nArrLen = pBookmarks->Count();
		if( nArrLen )
		{
			pMarks = new Sw3Marks( nArrLen + nArrLen / 4, nArrLen / 4 );

			if( pPaM )
			{
				for( sal_uInt16 n = 0; n < nArrLen; ++n )
				{
					const SwBookmark* pMark = pBookmarks->GetObject( n );
					ASSERT( pMark->IsBookMark(),
							"Wo kommt da die Nicht text::Bookmark her?" );

					if( !IsSw31Export() && n >= nCntntBkmkStart )
						aMark.SetId( n - nCntntBkmkStart );
					else
						aMark.SetId( n );
					const SwPosition* pPos1 = &pMark->GetPos();
					const SwPosition* pPos2 = pMark->GetOtherPos();
					ASSERT( pPos1->nNode.GetNode().IsTxtNode(),
							 "Bookmark position outside text node" );
					aMark.SetNodePos( pPos1->nNode.GetIndex() );
					if( aMark.GetNodePos() < nEndOfIcons ||
						( aMark.GetNodePos() >= nStart && aMark.GetNodePos() <= nEnd ))
					{
						aMark.SetNodeOff( pPos1->nContent.GetIndex() );
						aMark.SetType( SW3_BOOK_POINT );
						pMarks->Insert( new Sw3Mark(aMark) );
					}
					if( pPos2 )
					{
						ASSERT( pPos2->nNode.GetNode().IsTxtNode(),
								"Other bookmark position outside text node" );
						aMark.SetNodePos( pPos2->nNode.GetIndex() );
						if( aMark.GetNodePos() < nEndOfIcons ||
							( aMark.GetNodePos() >= nStart && aMark.GetNodePos() <= nEnd ))
						{
							aMark.SetNodeOff( pPos2->nContent.GetIndex() );
							aMark.SetType( SW3_BOOK_MARK );
							pMarks->Insert( new Sw3Mark(aMark) );
						}
					}
				}
			}
			else
			{
				for( sal_uInt16 n = 0; n < nArrLen; ++n )
				{
					const SwBookmark* pMark = pBookmarks->GetObject( n );
					ASSERT( pMark->IsBookMark(),
							"Wo kommt da die Nicht Bookmark her?" );

					if( !IsSw31Export() && n >= nCntntBkmkStart )
						aMark.SetId( n - nCntntBkmkStart );
					else
						aMark.SetId( n );

					const SwPosition* pPos = &pMark->GetPos();
					ASSERT( pPos->nNode.GetNode().IsTxtNode(),
							 "Bookmark position outside text node" );

					aMark.SetNodePos( pPos->nNode.GetIndex() );
					aMark.SetNodeOff( pPos->nContent.GetIndex() );
					aMark.SetType( SW3_BOOK_POINT );
					pMarks->Insert( new Sw3Mark(aMark) );

					pPos = pMark->GetOtherPos();
					if( pPos )
					{
						ASSERT( pPos->nNode.GetNode().IsTxtNode(),
								"Other bookmark position outside text node" );
						aMark.SetNodePos( pPos->nNode.GetIndex() );
						aMark.SetNodeOff( pPos->nContent.GetIndex() );
						aMark.SetType( SW3_BOOK_MARK );
						pMarks->Insert( new Sw3Mark(aMark) );
					}
				}
			}
		}
	}

	// Collect TOX sections. To be compatible with the 5.0 file format and
	// earlier file format versions, TOX section are not exported directly.
	// Instead of this, the start and end positions of this sections is
	// exported.
	// MIB 01.09.97: wenn Selektion geschrieben wird, dann auch alle aus
	//				 den Sonderbereichen mit nehmen (##)

	aMark.SetId( 0 );
	const SwSectionFmts& rSectFmts = pDoc->GetSections();

	for( sal_uInt16 i=0; i < rSectFmts.Count(); i++ )
	{
		const SwSectionFmt* pSectFmt = rSectFmts[i];

		// Skip TOXs that are somehow incomplete.
		const SwSection* pSect = pSectFmt->GetSection();
		if( !pSect || TOX_CONTENT_SECTION != pSect->GetType() )
			continue;

		const SwSectionNode *pSectNd = pSectFmt->GetSectionNode();
		if( !pSectNd )
			continue;

		const SwTOXBaseSection *pTOXBaseSect =
			PTR_CAST( SwTOXBaseSection, pSect );
		if( !pTOXBaseSect || !pTOXBaseSect->GetTOXType() )
			continue;

		sal_uInt32 nStartIdx = pSectNd->GetIndex();
		sal_uInt32 nEndIdx = pSectNd->EndOfSectionIndex();

		// Skip TOXs that are not contained within the saved area completely.
		if( nStart >= nEndOfIcons && (nStartIdx < nStart || nEndIdx > nEnd) )
			continue;

		if( !pMarks )
			pMarks = new Sw3Marks( 16, 4 );

		// The start pos is the first section node. If this is the start node
		// of a TOX header section that starts with a text node, the start pos
		// is the second node. See Sw3IoImp::OutSection in sw3sect.cxx.
		nStartIdx++;
		const SwStartNode *pSttNd = pDoc->GetNodes()[nStartIdx]->GetStartNode();
		if( pSttNd && lcl_sw3io_isTOXHeaderSection( *pSttNd ) &&
			pDoc->GetNodes()[nStartIdx+1]->IsTxtNode() ) // could be a start nd
			nStartIdx++;

		aMark.SetNodePos( nStartIdx );
		aMark.SetNodeOff( 0 );
		aMark.SetType( SW3_TOX_POINT );
		pMarks->Insert( new Sw3Mark(aMark) );

		// The end pos is the last but one section node. If this is the end
		// node of a TOX header section that ends with a text node, the end
		// pos is the last but two node. See Sw3IoImp::OutSection in
		// sw3sect.cxx.
		nEndIdx--;
		const SwEndNode *pEndNd = pDoc->GetNodes()[nEndIdx]->GetEndNode();
		if( pEndNd &&
			lcl_sw3io_isTOXHeaderSection( *pEndNd->StartOfSectionNode() ) &&
			pDoc->GetNodes()[nEndIdx-1]->IsTxtNode() ) // could be an end node
			nEndIdx--;

		aMark.SetNodePos( nEndIdx );

		const SwTxtNode *pTxtNd = pDoc->GetNodes()[nEndIdx]->GetTxtNode();
		xub_StrLen nCntntIdx = pTxtNd ? pTxtNd->Len() : 0;
		aMark.SetNodeOff( nCntntIdx );
		aMark.SetType( SW3_TOX_MARK );
		pMarks->Insert( new Sw3Mark(aMark) );

		aMark.SetId( aMark.GetId() + 1 );
	}

	// Ist was da?
	if( !pBookmarks->Count() )
		delete pBookmarks, pBookmarks = NULL;
	ASSERT( !pMarks || pMarks->Count(),
			"Marks-Array haette nicht angelegt werden muessen" );
	if( pMarks && !pMarks->Count() )
		delete pMarks, pMarks = NULL;
}

// Eine Mark einlesen

void Sw3IoImp::InNodeMark( const SwNodeIndex& rPos, xub_StrLen nCntntOff )
{
	OpenRec( SWG_MARK );
	sal_uInt8 cType;
	sal_uInt16 nId, nOff;
	*pStrm >> cType >> nId >> nOff;
	CloseRec( SWG_MARK );

	SwIndex aOff( rPos.GetNode().GetCntntNode(), nCntntOff + nOff );
	if( cType < SW3_BOOK_POINT )
	{
		ASSERT( pTOXs && nId < pTOXs->Count(), "invalid TOX id" );
		if( pTOXs && nId < pTOXs->Count() )
			pTOXs->GetObject( nId )->SetNodeIdx( rPos );
	}
	else if( cType < SW3_REDLINE_START)
	{
		SwBookmark* pBook = 0;
		if( pBookmarks && nId < pBookmarks->Count() )
			pBook = pBookmarks->GetObject( nId );
		ASSERT( pBook, "Ungueltige text::Bookmark-ID" );

		if( pBook )
		{
			switch( cType )
			{
				case SW3_BOOK_POINT:
				{
					delete pBook->pPos1;
					pBook->pPos1 = new SwPosition( rPos, aOff );

					// Da dies die Sort Order durcheinander bringt,
					// die text::Bookmark neu einsortieren!
					SwBookmarks& rMarks = (SwBookmarks&) pDoc->GetBookmarks();

					// JP 19.07.95: das Suchen machen wir ueber den Pointer!!
					// ansonsten muss es vorm setzen der neue
					// Position erfolgen !! (SortArray!!!!!)
					const SwBookmarkPtr* ppMarks = rMarks.GetData();
					for( sal_uInt16 nCnt = rMarks.Count(); nCnt; --nCnt, ++ppMarks )
						if( *ppMarks == pBook )
						{
							rMarks.Remove( rMarks.Count() - nCnt );
							break;
						}

					rMarks.Insert( pBook );
					break;
				}
				case SW3_BOOK_MARK:
					delete pBook->pPos2;
					pBook->pPos2 = new SwPosition( rPos, aOff );
					break;
			}
		}
	}
	else
	{
		Warning();
	}
}

// Die Marks eines Nodes schreiben

void Sw3IoImp::OutNodeMarks( sal_uInt32 nIdx )
{
	if(pMarks )
	{
		for( sal_uInt16 nPos = 0; nPos < pMarks->Count(); ++nPos )
		{
			Sw3Mark *pMark = (*pMarks)[ nPos ];
			if( pMark->GetNodePos() == nIdx )
			{
				OpenRec( SWG_MARK );
				xub_StrLen nOffs = pMark->GetNodeOff();
				if( nOffs > STRING_MAXLEN52 )
					nOffs = STRING_MAXLEN52;
				*pStrm << (sal_uInt8) pMark->GetType()
					   << (sal_uInt16) pMark->GetId()
					   << (sal_uInt16) nOffs;
				CloseRec( SWG_MARK );
				pMarks->Remove( nPos-- );
				delete pMark;
				if( !pMarks->Count() )
				{
					delete pMarks;
					pMarks = NULL;
					break;
				}
			}
			else if( pMark->GetNodePos() > nIdx )
				break;
		}
	}
}

// text::Bookmark einlesen

void Sw3IoImp::InBookmarks()
{
	ASSERT( !pBookmarks || IsVersion(SWG_SVXMACROS),
			"Frueher standen text::Bookmarks doch nur in einem Stream???" )
	if( pBookmarks )
	{
		delete pBookmarks;
		pBookmarks = 0;
	}

	OpenRec( SWG_BOOKMARKS );
	// Die Mark erst einmal an den Anfang setzen
	SwPaM aPaM( pDoc->GetNodes().GetEndOfPostIts() );
	while( BytesLeft() )
	{
		String aShortName, aName;
		OpenRec( SWG_BOOKMARK );
		InString( *pStrm, aShortName );
		InString( *pStrm, aName );
		OpenFlagRec();
		sal_uInt16 nOffset, nKey, nMod;
		*pStrm >> nOffset >> nKey >> nMod;
		CloseFlagRec();
		SwBookmarkPtr pMark = NULL;

		// Gibt es die Marke bereits (tw. fix 23304) ?
		if( bInsert && pDoc->FindBookmark( aName ) != USHRT_MAX )
			pDoc->MakeUniqueBookmarkName( aName );

		pMark = pDoc->MakeBookmark( aPaM, KeyCode( nKey, nMod ),
									aName, aShortName );
		if( pMark )
		{
			// JP 10.12.96: die Macros an den text::Bookmarks koennen von der
			//				UI nirgends gesetzt/angefragt werden. Darum
			//				werden sie auch nicht um den ScriptType erweitert!
			String aMac, aLib;

			InString( *pStrm, aMac );
			InString( *pStrm, aLib );
			SvxMacro aStart( aMac, aLib, STARBASIC );
			pMark->SetStartMacro( aStart );

			InString( *pStrm, aMac );
			InString( *pStrm, aLib );
			SvxMacro aEnd( aMac, aLib, STARBASIC );
			pMark->SetEndMacro( aEnd );
		}
		CloseRec( SWG_BOOKMARK );
		// Und fuer die Mark-Records merken. NULL bedeutet, dass
		// die text::Bookmark eine Dublette war und fortfaellt.
		if( !pBookmarks )
			pBookmarks = new Sw3Bookmarks;
		pBookmarks->Insert( pMark, pBookmarks->Count() );
	}
	CloseRec( SWG_BOOKMARKS );
}

// String		Kurzname
// String		voller Name
// sal_uInt8 		Flags
// sal_uInt16		Offset
// sal_uInt16		KeyCode
// sal_uInt16		Modifier
// String		Name des Startmakros
// String		Lib des Startmakros
// String		Name des Endmakros
// String		Lib des Endmakros

void Sw3IoImp::OutBookmarks( sal_Bool bPageStyles )
{
	ASSERT( bPageStyles || !IsSw31Export(),
			"Beim 3.1-Export kommen keine text::Bookmarks in den Contents-Stream" );

	short nArrLen = pBookmarks ? pBookmarks->Count() : 0;
	if( nArrLen && bPageStyles && !IsSw31Export() )
	{
		ASSERT( nCntntBkmkStart <= nArrLen,
				"Mehr text::Bookmarks in Page-Styles als ueberhaupt vorhanden?" );
		nArrLen = nCntntBkmkStart;
		nCntntBkmkStart = 0;
	}
	ASSERT( IsSw31Export() || nCntntBkmkStart==0,
			"Wieso sind da noch text::Bookmarks aus Seitenvorlagen?" );

	if( nArrLen )
	{
		OpenRec( SWG_BOOKMARKS );
		for( int i = 0; i < nArrLen; i++ )
		{
			SwBookmark& rMark = (SwBookmark&) *(*pBookmarks)[i];
			ASSERT( rMark.IsBookMark(),
					"Wo kommt da die Nicht text::Bookmark her?" )

			const SvxMacro& rStt = rMark.GetStartMacro();
			const SvxMacro& rEnd = rMark.GetEndMacro();
			OpenRec( SWG_BOOKMARK );
			OutString( *pStrm, rMark.GetShortName() );
			OutString( *pStrm, rMark.GetName() );
			*pStrm << (BYTE) 0x06
				   << (sal_uInt16) 0	// frueher: Position, jetzt frei
				   << (sal_uInt16) rMark.GetKeyCode().GetCode()
				   << (sal_uInt16) rMark.GetKeyCode().GetModifier();
						// JP 10.12.96: die Macros an den text::Bookmarks koennen
						//				von der UI nirgends gesetzt/abgefragt
						//				werden. Darum werden sie auch nicht
						//				um den ScriptType erweitert!
			OutString( *pStrm, rStt.GetMacName() );
			OutString( *pStrm, rStt.GetLibName() );
			OutString( *pStrm, rEnd.GetMacName() );
			OutString( *pStrm, rEnd.GetLibName() );
			CloseRec( SWG_BOOKMARK );
		}
		CloseRec( SWG_BOOKMARKS );

		// Wenn die text::Bookmarks fuer Page-Styles geschrienen sind, werden
		// sie geloescht
		if( bPageStyles && !IsSw31Export() )
			pBookmarks->Remove( 0, nArrLen );
	}
}

void Sw3IoImp::InTOXs51()
{
	OpenRec( SWG_TOXDESCS51 );

	// Die Mark erst einmal an den Anfang setzen
	while( BytesLeft() )
	{
		OpenRec( SWG_TOXDESC );
		String aTypeName, aTitle;
		sal_uInt16 nStrIdx = IDX_NO_VALUE;
		if( IsVersion( SWG_LONGIDX ) )
			*pStrm >> nStrIdx;
		else
			InString( *pStrm, aTypeName );

		InString( *pStrm, aTitle );
		sal_uInt8 cFlags = OpenFlagRec();
		sal_Int16 nCreateType;
		sal_uInt16 nFirstTabPos = 0;
		BYTE  cType;
		*pStrm >> nCreateType
			   >> cType;

		if( IsVersion(SWG_TOXTABS) && (cFlags & 0x10) != 0 )
			*pStrm >> nFirstTabPos;
		CloseFlagRec();

		TOXTypes eTOXType = (TOXTypes) cType;

		// Wenn keine Name da ist, dann handelt es sich um
		// das Standard-Verzeichnis des entsprechenden Typs. Der
		// (internationalisierte) Name wird dann gesetzt.
		if( IDX_NO_VALUE != nStrIdx )
			aTypeName = aStringPool.Find( nStrIdx );
		else if( !aTypeName.Len() )
			aTypeName = SwTOXBase::GetTOXName( eTOXType );

		// nach dem TOXType suchen
		sal_uInt16 nTOXType = pDoc->GetTOXTypeCount( eTOXType );
		const SwTOXType* pTOXType = NULL;
		for( sal_uInt16 n = 0; n < nTOXType; n++ )
		{
			const SwTOXType* p = pDoc->GetTOXType( eTOXType, n );
			if( p->GetTypeName() == aTypeName )
			{
				pTOXType = p; break;
			}
		}

		// Falls nicht vorhanden, am Dokument einfuegen
		if( !pTOXType )
		{
			pDoc->InsertTOXType( SwTOXType ( eTOXType, aTypeName ) );
			pTOXType = pDoc->GetTOXType( eTOXType, nTOXType );
		}
		// Die SwForm einlesen
		SwForm aForm( cType );

		sal_Bool bSetTabs = IsVersion(SWG_TOXTABS);
		aForm.SetGenerateTabPos(  bSetTabs && (cFlags & 0x20) != 0 );
		aForm.SetRelTabPos( bSetTabs && (cFlags & 0x40) != 0 );

		sal_uInt8 nPat, nTmpl;
		*pStrm >> nPat;
		for( sal_uInt16 i = 0; Good() && i < nPat; i++ )
		{
			String aText;
			InString( *pStrm, aText );
			if( i < aForm.GetFormMax() )
			{
				if( aText.Len() )
					aText = SwForm::ConvertPatternFrom51(aText, eTOXType);
				aForm.SetPattern( i, aText );
			}
			else if( IsVersion(SWG_LONGIDX) ||
					 TOX_INDEX != eTOXType ||
					 i != OLD_MAXLEVEL )
			{
				// In aelteren Versionen wurden bei Stichwort-
				// Verzeichnissen ein Eintrag zu viel geschrieben.
				Warning();
			}
		}


		*pStrm >> nTmpl;
		for( i = 0; Good() && i < nTmpl; i++ )
		{
			sal_uInt16 nStrIdx;
			*pStrm >> nStrIdx;
			if( i < aForm.GetFormMax() )
			{
				String sNm( aStringPool.Find( nStrIdx ) );
				if( !sNm.Len() )
				{
					// Bug 37672: falls keiner gefunden wird, nehme
					//			die defaults
					sal_uInt16 nPoolIdOffset = 0;
					switch( cType )
					{
						case TOX_INDEX:
							nPoolIdOffset = RES_POOLCOLL_TOX_IDXH -
											RES_POOLCOLL_REGISTER_BEGIN;
							break;
						case TOX_CONTENT:
							if( 6 > i )
								nPoolIdOffset = RES_POOLCOLL_TOX_CNTNTH -
												RES_POOLCOLL_REGISTER_BEGIN;
							else
								nPoolIdOffset = RES_POOLCOLL_TOX_CNTNT6 - 6 -
												RES_POOLCOLL_REGISTER_BEGIN;
							break;
						case TOX_USER:
							nPoolIdOffset = RES_POOLCOLL_TOX_USERH -
											RES_POOLCOLL_REGISTER_BEGIN;
							break;
					}

					sNm = *SwStyleNameMapper::GetRegisterUINameArray()[ nPoolIdOffset + i ];
				}
				aForm.SetTemplate( i, sNm );
			}
			else if( IsVersion(SWG_LONGIDX) ||
					 TOX_INDEX != eTOXType ||
					 i != OLD_MAXLEVEL )
			{
				Warning();
			}
		}


		// SetFirstTabPos modifies the patterns
		// TODO:.is code that OK?
		if( bSetTabs && (cFlags & 0x10) != 0 )
			aForm.SetFirstTabPos( nFirstTabPos );
		else
			//fill tab stop positions into the patterns
			aForm.AdjustTabStops(*pDoc);

		sal_uInt16 nInf;
		*pStrm >> nInf;
		Sw3TOXBase *pTOX = new Sw3TOXBase( pTOXType, aForm, nCreateType,
										   aTitle );
		switch( cType )
		{
			case TOX_INDEX:
				pTOX->SetOptions( nInf );
				break;
			case TOX_CONTENT:
				if( nInf > MAXLEVEL )
					nInf = MAXLEVEL;
				pTOX->SetLevel( nInf );
				break;
			case TOX_USER:
				{
					String sNm( aStringPool.Find( nInf ) );
					if( !sNm.Len() )
						// Bug 37672: falls keiner gefunden wird, nehme
						//			irgendeinen, also Abbildung
						sNm = *SwStyleNameMapper::GetExtraUINameArray()[ RES_POOLCOLL_LABEL_ABB
											- RES_POOLCOLL_EXTRA_BEGIN ];
					// TODO: Does SetTemplateName what it should do?
					pTOX->SetTemplateName( sNm );
				}
				break;
		}

		CloseRec( SWG_TOXDESC );
		if( !Good() )
			break;

		if( !pTOXs )
			pTOXs = new Sw3TOXs;
		pTOXs->C40_INSERT( Sw3TOXBase, pTOX, pTOXs->Count() );
	}
	CloseRec( SWG_TOXDESCS51 );
}


void Sw3IoImp::OutTOXs51()
{
	const SwSectionFmts& rSectFmts = pDoc->GetSections();

	sal_Bool bTOXs = sal_False;
	for( sal_uInt16 nFmt=0; nFmt<rSectFmts.Count(); nFmt++ )
	{
		const SwSectionFmt* pSectFmt = rSectFmts[nFmt];

		// Skip TOXs that are somehow incomplete.
		const SwSection* pSect = pSectFmt->GetSection();
		if( !pSect || TOX_CONTENT_SECTION != pSect->GetType() )
			continue;

		const SwSectionNode *pSectNd = pSectFmt->GetSectionNode();
		if( !pSectNd )
			continue;

		const SwTOXBaseSection *pTOXBaseSect =
			PTR_CAST( SwTOXBaseSection, pSect );
		if( !pTOXBaseSect )
			continue;

		const SwTOXType* pType = pTOXBaseSect->GetTOXType();
		if( !pType )
			continue;

		if( !bTOXs )
		{
			OpenRec( SWG_TOXDESCS51 );
			bTOXs = sal_True;
		}

		OpenRec( SWG_TOXDESC );

		// If it is one of the predefined indexes, its name isn't exported.
		// This way, the index is found in foreign version, too.
		TOXTypes eType = pType->GetType();
		TOXTypes eOldType = eType >= TOX_ILLUSTRATIONS ? TOX_USER : eType;
		const String& rTypeName = pType->GetTypeName();
		if( IsSw31Or40Export() )
		{
			OutString( *pStrm, rTypeName );
		}
		else
		{
			// All types above TOX_USER are new in version 5.2. That for,
			// their names must be written.
			sal_uInt16 nStrIdx =
				( eType >= TOX_ILLUSTRATIONS ||
				  rTypeName != SwTOXBase::GetTOXName(eType) )
				? aStringPool.Find( rTypeName, USHRT_MAX )
				: IDX_NO_VALUE;
			*pStrm << nStrIdx;
		}

		OutString( *pStrm, pTOXBaseSect->GetTitle() );

		const SwForm& rFrm = pTOXBaseSect->GetTOXForm();

		sal_uInt8 cFlags = 0x03; 	// Anzahl Datenbytes
		if( !IsSw31Or40Export() )
		{
			if( rFrm.IsFirstTabPosFlag() )
				cFlags += 0x12;
			if( rFrm.IsGenerateTabPos() )
				cFlags += 0x20;
			if( rFrm.IsRelTabPos() )
				cFlags += 0x40;
		}

		// TODO: Must some flags be masked out?
		sal_uInt16 nCreateType = pTOXBaseSect->GetCreateType();
		if( eType >= TOX_ILLUSTRATIONS )
			nCreateType |= TOX_TEMPLATE;
		*pStrm << (sal_uInt8)   cFlags
			   << (sal_Int16)  nCreateType
			   << (BYTE)   eOldType;
		if( (cFlags & 0x10) != 0 )
			*pStrm << (sal_uInt16)rFrm.GetFirstTabPos();

		// Die SwForm ausgeben
		// Zaehlen der Patterns und Templates
		sal_uInt16 nPat = 0, nTmpl = 0;
		sal_uInt16 nCount = rFrm.GetFormMax();
		if( IsSw31Or40Export() &&  nCount > OLD_MAXLEVEL+1 )
			nCount = OLD_MAXLEVEL+1;
		else if( TOX_AUTHORITIES == eType && nCount > MAXLEVEL+1 )
			nCount = MAXLEVEL+1;

		for( sal_uInt16 i = nCount; i > 0; i-- )
		{
			if( rFrm.GetPattern( i - 1 ).Len() )
			{
				nPat = i; break;
			}
		}
		for( i = nCount; i > 0; i-- )
		{
			if( rFrm.GetTemplate( i - 1 ).Len() )
			{
				nTmpl = i; break;
			}
		}
		// und die Strings der form ausgeben
		*pStrm << (BYTE) nPat;
		for( i = 0; i < nPat; i++ )
		{
			String aPattern( rFrm.GetPattern(i) );
			if( aPattern.Len() )
				aPattern = SwForm::ConvertPatternTo51( aPattern );
			if( IsSw31Or40Export() && TOX_CONTENT == eType && aPattern.Len() )
			{
				xub_StrLen nENPos =
					aPattern.SearchAscii( SwForm::aFormEntryNum );
				xub_StrLen nETPos =
					aPattern.SearchAscii( SwForm::aFormEntryTxt );
				xub_StrLen nStart = 0, nLen = 0;

				if( nENPos != STRING_NOTFOUND &&
					(STRING_NOTFOUND == nETPos || nENPos < nETPos) )
				{
					nStart = nENPos;
					nLen = STRING_NOTFOUND == nETPos
								? SwForm::nFormEntryNumLen
								: (nETPos - nENPos) + SwForm::nFormEntryTxtLen;
				}
				else if( nETPos != STRING_NOTFOUND &&
						 (STRING_NOTFOUND == nENPos || nETPos < nENPos) )
				{
					nStart = nETPos;
					nLen = STRING_NOTFOUND == nENPos
								? SwForm::nFormEntryTxtLen
								: (nENPos - nETPos) + SwForm::nFormEntryNumLen;
				}

				if( nLen > 0 )
				{
					aPattern.Erase( nStart, nLen );
					aPattern.InsertAscii( SwForm::aFormEntry, nStart );
				}
			}
			OutString( *pStrm, aPattern );
		}
		*pStrm << (BYTE) nTmpl;
		for( i = 0; i < nTmpl; i++ )
		{
			const String& rCollNm = rFrm.GetTemplate( i );
			const SwTxtFmtColl* pColl = pDoc->FindTxtFmtCollByName( rCollNm );
			sal_uInt16 nPId = pColl ? pColl->GetPoolFmtId()
								: SwStyleNameMapper::GetPoolIdFromUIName( rCollNm,GET_POOLID_TXTCOLL );
			*pStrm << (sal_uInt16) aStringPool.Find( rCollNm, nPId );
		}
		// Zuletzt noch die Spezial-Variablen
		sal_uInt16 nInf = 0;
		switch( (int) pType->GetType() )
		{
			case TOX_INDEX:
				// TODO: Must some flags be masked out?
				nInf = pTOXBaseSect->GetOptions();
				break;
			case TOX_CONTENT:
				nInf = pTOXBaseSect->GetLevel();
				if( IsSw31Or40Export() && nInf > OLD_MAXLEVEL )
					nInf = OLD_MAXLEVEL;
				break;
			case TOX_ILLUSTRATIONS:
			case TOX_OBJECTS:
			case TOX_TABLES:
				{
					sal_uInt16 nPoolId;
					switch( pType->GetType() )
					{
					case TOX_ILLUSTRATIONS:
						nPoolId = RES_POOLCOLL_LABEL_ABB;
						break;
					case TOX_OBJECTS:
						nPoolId = RES_POOLCOLL_LABEL_FRAME;
						break;
					case TOX_TABLES:
						nPoolId = RES_POOLCOLL_LABEL_TABLE;
						break;
					}
					String aName;
					SwStyleNameMapper::FillUIName( nPoolId, aName );
					nInf = aStringPool.Find( aName, nPoolId );
				}
				break;
			case TOX_USER:
			case TOX_AUTHORITIES:
			default:
				{
					const String sCollNm = pTOXBaseSect->GetTemplateName();
					if( sCollNm.Len() )
					{
						const SwTxtFmtColl* pColl =
							pDoc->FindTxtFmtCollByName( sCollNm );
						sal_uInt16 nPId = pColl ? pColl->GetPoolFmtId()
											: SwStyleNameMapper::GetPoolIdFromUIName( sCollNm,
														GET_POOLID_TXTCOLL );
						nInf = aStringPool.Find( sCollNm, nPId );
					}
					else
						nInf = IDX_NO_VALUE;
				}
				break;
		}
		*pStrm << (sal_uInt16) nInf;

		CloseRec( SWG_TOXDESC );
	}

	if( bTOXs )
		CloseRec( SWG_TOXDESCS51 );
}

extern void lcl_sw3io_FillSetExpFieldName( Sw3IoImp& rIo, sal_uInt16 nStrId,
										   String& rName );

void Sw3IoImp::InTOXs()
{
	OpenRec( SWG_TOXDESCS );
	// Die Mark erst einmal an den Anfang setzen
	SwPosition aPos( pDoc->GetNodes().GetEndOfPostIts() );
	while( BytesLeft() )
	{
		OpenRec( SWG_TOXDESC );

		sal_uInt8 cFlags = OpenFlagRec();

		sal_uInt16 nType, nCreateType, nCaptionDisplay, nStrIdx, nSeqStrIdx, nData;
		sal_uInt16 nOLEOptions = 0;
		sal_uInt8 cFormFlags;

		String aTitle, aName, aDummy;

		*pStrm  >> nType
				>> nCreateType
				>> nCaptionDisplay
				>> nStrIdx
				>> nSeqStrIdx
				>> nData
				>> cFormFlags;
		CloseFlagRec();

		sal_uInt16 nMainStyleIdx = IDX_NO_VALUE;
		InString( *pStrm, aName );
		InString( *pStrm, aTitle );
		if( nVersion < SWG_NEWTOX2 )
			InString( *pStrm, aDummy );		// was AutoMarkURL
		if( IsVersion(SWG_NEWTOX2) )
		{
			*pStrm	>> nOLEOptions
					>> nMainStyleIdx;
		}

		TOXTypes eTOXType = (TOXTypes)nType;
		String aTypeName;
		if( IDX_NO_VALUE != nStrIdx )
			aTypeName = aStringPool.Find( nStrIdx );
		else
			aTypeName = SwTOXBase::GetTOXName( eTOXType );

		// Search TOX type
		sal_uInt16 nTOXTypes = pDoc->GetTOXTypeCount( eTOXType );
		const SwTOXType* pTOXType = NULL;
		for( sal_uInt16 i=0; i<nTOXTypes; i++ )
		{
			const SwTOXType* pTmp = pDoc->GetTOXType( eTOXType, i );
			if( pTmp->GetTypeName() == aTypeName )
			{
				pTOXType = pTmp;
				break;
			}
		}

		// If the TOX type could not be found, it is inserted now.
		if( !pTOXType )
		{
			pDoc->InsertTOXType( SwTOXType ( eTOXType, aTypeName ) );
			pTOXType = pDoc->GetTOXType( eTOXType, nTOXTypes );
		}

		// form patterns
		SwForm aForm( eTOXType );

		aForm.SetGenerateTabPos(  (cFormFlags & 0x01) != 0 );
		aForm.SetRelTabPos( (cFormFlags & 0x02) != 0 );
		aForm.SetCommaSeparated( (cFormFlags & 0x04) != 0 );

		sal_uInt8 nPatterns;
		*pStrm >> nPatterns;
		for( i = 0; Good() && i < nPatterns; i++ )
		{
			OpenRec( SWG_FORMPATTERN_LCL );

			sal_uInt8 nLevel;
			sal_uInt16 nTokens;

			OpenFlagRec();
			*pStrm	>> nLevel
					>> nTokens;
			CloseFlagRec();

			if( nLevel < aForm.GetFormMax() )
			{
				String aPattern;
				for( sal_uInt16 j=0; Good() && j < nTokens; j++  )
				{
					OpenRec( SWG_FORMTOKEN_LCL );

					sal_uInt16 nType, nStrIdx;

					OpenFlagRec();
					*pStrm	>> nType
							>> nStrIdx;
					CloseFlagRec();

					if( nType < TOKEN_END )
					{
                        //#92986# some older versions created a
                        //wrong content index entry definition
                        if(TOKEN_ENTRY == nType && eTOXType == TOX_CONTENT)
                            nType = TOKEN_ENTRY_TEXT;
                        SwFormToken aToken( (FormTokenType)nType );
						if( IDX_NO_VALUE != nStrIdx )
						{
							aToken.sCharStyleName = aStringPool.Find( nStrIdx );
							aToken.nPoolId = aStringPool.FindPoolId( nStrIdx );
						}
						switch( aToken.eTokenType )
						{
						case TOKEN_TAB_STOP:
							{
								sal_Int32 nTabStopPosition;
								sal_uInt16 nTabAlign;
								*pStrm	>> nTabStopPosition
										>> nTabAlign;
								aToken.nTabStopPosition = nTabStopPosition;
								aToken.eTabAlign = nTabAlign;
								if( IsVersion(SWG_TOXTABCHAR) )
								{
									sal_uInt8 cFillChar;
									*pStrm	>> cFillChar;
									aToken.cTabFillChar =
										ByteString::ConvertToUnicode( cFillChar,
																	  eSrcSet );
								}
							}
							break;
						case TOKEN_CHAPTER_INFO:
							{
								sal_uInt16 nChapterFormat;
								*pStrm	>> nChapterFormat;
								aToken.nChapterFormat = nChapterFormat;
							}
							break;
						case TOKEN_TEXT:
							InString( *pStrm, aToken.sText );
							break;
						case TOKEN_AUTHORITY:
							{
								sal_uInt16 nAuthorityField;
								*pStrm  >> nAuthorityField;
								aToken.nAuthorityField = nAuthorityField;
							}
							break;
						}

						aPattern += aToken.GetString();
					}
					else
						Warning();

					CloseRec( SWG_FORMTOKEN_LCL );
				}

				aForm.SetPattern( nLevel, aPattern );
			}
			else
				Warning();

			CloseRec( SWG_FORMPATTERN_LCL );
		}

		sal_uInt8 nTemplates;
		*pStrm >> nTemplates;
		for( i = 0; Good() && i < nTemplates; i++ )
		{
			sal_uInt16 nStrIdx;
			*pStrm >> nStrIdx;
			if( i < aForm.GetFormMax() )
			{
				String sNm( aStringPool.Find( nStrIdx ) );
				ASSERT( sNm.Len(), "Template name not found" );
				if( !sNm.Len() )
				{
					// #37672#: if the style has not been found, use the default
					sal_uInt16 nPoolIdOffset = 0;
					sal_uInt16 nOffs = i;
					switch( eTOXType )
					{
					case TOX_INDEX:
						nPoolIdOffset = RES_POOLCOLL_TOX_IDXH -
										RES_POOLCOLL_REGISTER_BEGIN;
						break;
					case TOX_CONTENT:
						if( 6 > i )
							nPoolIdOffset = RES_POOLCOLL_TOX_CNTNTH -
											RES_POOLCOLL_REGISTER_BEGIN;
						else
							nPoolIdOffset = RES_POOLCOLL_TOX_CNTNT6 - 6 -
											RES_POOLCOLL_REGISTER_BEGIN;
						break;
					case TOX_USER:
						nPoolIdOffset = RES_POOLCOLL_TOX_USERH -
										RES_POOLCOLL_REGISTER_BEGIN;
						break;
					case TOX_ILLUSTRATIONS:
						nPoolIdOffset = RES_POOLCOLL_TOX_ILLUSH -
										RES_POOLCOLL_REGISTER_BEGIN;
						break;
					case TOX_OBJECTS:
						nPoolIdOffset = RES_POOLCOLL_TOX_OBJECTH -
										RES_POOLCOLL_REGISTER_BEGIN;
						break;
					case TOX_TABLES:
						nPoolIdOffset = RES_POOLCOLL_TOX_TABLESH -
										RES_POOLCOLL_REGISTER_BEGIN;
						break;
					case TOX_AUTHORITIES:
						// There is one text collection for all levels only!
						nPoolIdOffset = RES_POOLCOLL_TOX_AUTHORITIESH -
										RES_POOLCOLL_REGISTER_BEGIN;
						if( nOffs > 1 )
							nOffs = 1;
						break;
					}

					sNm = *SwStyleNameMapper::GetRegisterUINameArray()[ nPoolIdOffset + nOffs ];
				}
				aForm.SetTemplate( i, sNm );
			}
			else
			{
				Warning();
			}
		}

		Sw3TOXBase *pTOX = new Sw3TOXBase( pTOXType, aForm, nCreateType,
										   aTitle );
		pTOX->SetTOXName( aName );
		pTOX->SetCaptionDisplay( (SwCaptionDisplay)nCaptionDisplay );
		pTOX->SetOLEOptions( nOLEOptions );

		pTOX->SetProtected( (cFlags & 0x10) != 0 );
		pTOX->SetFromChapter( (cFlags & 0x20) != 0 );
		pTOX->SetFromObjectNames( (cFlags & 0x40) != 0 );
		pTOX->SetLevelFromChapter( (cFlags & 0x80) != 0 );
		if( IDX_NO_VALUE != nMainStyleIdx )
			pTOX->SetMainEntryCharStyle( aStringPool.Find( nMainStyleIdx ) );
		if( IDX_NO_VALUE != nSeqStrIdx )
		{
			String aSequenceName;
			lcl_sw3io_FillSetExpFieldName( *this, nSeqStrIdx, aSequenceName );
			pTOX->SetSequenceName( aSequenceName );
		}

		if( TOX_INDEX == eTOXType )
			pTOX->SetOptions( nData );
		else
		{
			if( nData > MAXLEVEL )
				nData = MAXLEVEL;
			pTOX->SetLevel( nData );
		}

		sal_uInt8 nStyleNames;
		*pStrm >> nStyleNames;
		for( i=0; i < nStyleNames; i++ )
		{
			sal_uInt8 nLevel;
			sal_uInt16 nCount;
			*pStrm	>> nLevel
					>> nCount;

			String aStyleNames;
			for( sal_uInt16 j=0; j<nCount; j++ )
			{
				String aName;
				*pStrm >> nStrIdx;
				if( IDX_NO_VALUE != nStrIdx )
				{
					aName = aStringPool.Find( nStrIdx );

					if( aStyleNames.Len() )
						aStyleNames += TOX_STYLE_DELIMITER;
					aStyleNames += aName;
				}
			}
			if( nLevel < aForm.GetFormMax() )
				pTOX->SetStyleNames( aStyleNames, nLevel );
			else
				Warning();
		}

		// #37672#: every user index must have a style name.
		if( TOX_USER == eTOXType && !pTOX->GetStyleNames(0).Len() )
		{
			String aName = *SwStyleNameMapper::GetExtraUINameArray()[ RES_POOLCOLL_LABEL_ABB
											- RES_POOLCOLL_EXTRA_BEGIN ];
			pTOX->SetStyleNames( aName, 0 );
		}

		cFlags = OpenFlagRec();
		sal_uInt16 nSectStrIdx;
		*pStrm >> nSectStrIdx;
		pTOX->SetSectFmtStrIdx( nSectStrIdx );
		if( (cFlags & 0x10) != 0 )
		{
			sal_uInt32 nTitleLen;
			*pStrm	>> nTitleLen;
			pTOX->SetTitleLen( nTitleLen );
		}
		CloseFlagRec();

		if( SWG_SECTFMT == Peek() )
			pTOX->SetSectFmt( (SwSectionFmt*)InFormat( SWG_SECTFMT, NULL ) );

		if( (cFlags & 0x10) != 0 && SWG_SECTFMT == Peek() )
			pTOX->SetTitleSectFmt( (SwSectionFmt*)InFormat(SWG_SECTFMT,NULL) );

		CloseRec( SWG_TOXDESC );

		if( !Good() )
			break;

		if( !pTOXs )
			pTOXs = new Sw3TOXs;
		pTOXs->C40_INSERT( Sw3TOXBase, pTOX, pTOXs->Count() );
	}
	CloseRec( SWG_TOXDESCS );
}

extern sal_uInt16 lcl_sw3io_GetSetExpFieldPoolId( const String& rName );

void Sw3IoImp::OutTOXs()
{
	const SwSectionFmts& rSectFmts = pDoc->GetSections();

	sal_Bool bTOXs = sal_False;
	for( sal_uInt16 nFmt=0; nFmt<rSectFmts.Count(); nFmt++ )
	{
		const SwSectionFmt* pSectFmt = rSectFmts[nFmt];

		// Skip TOXs that are somehow incomplete.
		const SwSection* pSect = pSectFmt->GetSection();
		if( !pSect || TOX_CONTENT_SECTION != pSect->GetType() )
			continue;

		const SwSectionNode *pSectNd = pSectFmt->GetSectionNode();
		if( !pSectNd )
			continue;

		const SwTOXBaseSection *pTOXBaseSect =
			PTR_CAST( SwTOXBaseSection, pSect );
		if( !pTOXBaseSect )
			continue;

		const SwTOXType* pType = pTOXBaseSect->GetTOXType();
		if( !pType )
			continue;

		if( !bTOXs )
		{
			OpenRec( SWG_TOXDESCS );
			bTOXs = sal_True;
		}

		OpenRec( SWG_TOXDESC );


		sal_uInt8 cFlags = 0x0d; 	// Anzahl Datenbytes
		if( pTOXBaseSect->IsProtected() )
			cFlags += 0x10;
		if( pTOXBaseSect->IsFromChapter() )
			cFlags += 0x20;
		if( pTOXBaseSect->IsFromObjectNames() )
			cFlags += 0x40;
		if( pTOXBaseSect->IsLevelFromChapter() )
			cFlags += 0x80;

		TOXTypes eType = pType->GetType();

		const SwForm& rForm = pTOXBaseSect->GetTOXForm();
		sal_uInt8 cFormFlags = 0x00;
		if( rForm.IsGenerateTabPos() )
			cFormFlags += 0x01;
		if( rForm.IsRelTabPos() )
			cFormFlags += 0x02;
		if( rForm.IsCommaSeparated() )
			cFormFlags += 0x04;

		sal_uInt16 nSeqStrIdx = IDX_NO_VALUE;
		const String& rSequenceName = pTOXBaseSect->GetSequenceName();
		if( rSequenceName.Len() )
		{
			SwFieldType *pFldType =
				pDoc->GetFldType( RES_SETEXPFLD, rSequenceName );
			ASSERT( pFldType, "sequence field type not found" );
			if( pFldType )
			{
				sal_uInt16 nPoolId = lcl_sw3io_GetSetExpFieldPoolId(rSequenceName);
				nSeqStrIdx = aStringPool.Find( rSequenceName, nPoolId );
				ASSERT( IDX_NO_VALUE != nSeqStrIdx,
						"no string pool entry found for sequence field" );
			}
		}

		// If it is one of the predefined indexes, its name isn't exported.
		// This way, the index is found in foreign version, too.
		const String& rTypeName = pType->GetTypeName();
		sal_uInt16 nStrIdx = rTypeName != SwTOXBase::GetTOXName(eType)
				? aStringPool.Find( rTypeName, USHRT_MAX )
				: IDX_NO_VALUE;

		// Options or Level;
		sal_uInt16 nData = 0;
		if( TOX_INDEX == eType )
			nData = pTOXBaseSect->GetOptions();
		else
			nData = pTOXBaseSect->GetLevel();

		*pStrm  << cFlags
				<< (sal_uInt16)  eType
				<< (sal_uInt16)  pTOXBaseSect->GetCreateType()
				<< (sal_uInt16)  pTOXBaseSect->GetCaptionDisplay()
				<< nStrIdx
				<< nSeqStrIdx
				<< nData
				<< cFormFlags;

		sal_uInt16 nMainStyleIdx = IDX_NO_VALUE;
		const String& rMainStyle = pTOXBaseSect->GetMainEntryCharStyle();
		if( rMainStyle.Len() )
		{
			sal_uInt16 nPoolId = SwStyleNameMapper::GetPoolIdFromUIName( rMainStyle, GET_POOLID_CHRFMT );
			nMainStyleIdx = aStringPool.Find( rMainStyle, nPoolId );
		}

		OutString( *pStrm, pTOXBaseSect->GetTOXName() );
		OutString( *pStrm, pTOXBaseSect->GetTitle() );
		*pStrm << (sal_uInt16)	pTOXBaseSect->GetOLEOptions()
			   << (sal_uInt16) nMainStyleIdx;

		// form patterns
		sal_uInt8 nPatterns = 0, i;
		for( i = (sal_uInt8)rForm.GetFormMax(); i > 0; i-- )
		{
			if( rForm.GetPattern( i-1 ).Len() )
			{
				nPatterns = i;
				break;
			}
		}

		*pStrm << (sal_uInt8)nPatterns;
		for( i = 0; i < nPatterns; i++ )
		{
			OpenRec( SWG_FORMPATTERN_LCL );
			*pStrm  << (sal_uInt8)0x03	// flag byte
					<< (sal_uInt8)i;

			sal_uInt16 nToken = 0;
			const String& rPattern = rForm.GetPattern( i );
			if( rPattern.Len() )
			{
				OpenValuePos16( nToken );

				SwFormTokenEnumerator aEnum( rPattern );
				while( aEnum.HasNextToken() )
				{
					SwFormToken aToken( aEnum.GetNextToken() );

					OpenRec( SWG_FORMTOKEN_LCL );
					sal_uInt16 nStrIdx = IDX_NO_VALUE;
					if( aToken.sCharStyleName.Len() )
						nStrIdx = aStringPool.Find( aToken.sCharStyleName,
													aToken.nPoolId );
					*pStrm	<< (sal_uInt8)0x04
							<< (sal_uInt16)aToken.eTokenType
							<< nStrIdx;
					switch( aToken.eTokenType )
					{
					case TOKEN_TAB_STOP:
						*pStrm	<< (sal_Int32)aToken.nTabStopPosition
								<< (sal_uInt16)aToken.eTabAlign
							 	<< (sal_uInt8)aToken.cTabFillChar;
						break;
					case TOKEN_CHAPTER_INFO:
						*pStrm	<< (sal_uInt16)aToken.nChapterFormat;
						break;
					case TOKEN_TEXT:
						OutString( *pStrm, aToken.sText );
						break;
					case TOKEN_AUTHORITY:
						*pStrm  << (sal_uInt16)aToken.nAuthorityField;
						break;
					}

					CloseRec( SWG_FORMTOKEN_LCL );

					nToken++;
				}

				CloseValuePos16( nToken );
			}
			else
			{
				*pStrm << (sal_uInt16)0;
			}

			CloseRec( SWG_FORMPATTERN_LCL );
		}

		// form templates
		sal_uInt8 nTemplates = 0;
		for( i = (sal_uInt8)rForm.GetFormMax(); i > 0; i-- )
		{
			if( rForm.GetTemplate( i-1 ).Len() )
			{
				nTemplates = i;
				break;
			}
		}

		*pStrm << (sal_uInt8) nTemplates;
		for( i = 0; i < nTemplates; i++ )
		{
			const String& rCollNm = rForm.GetTemplate( i );
			const SwTxtFmtColl* pColl = pDoc->FindTxtFmtCollByName( rCollNm );
			sal_uInt16 nPId = pColl ? pColl->GetPoolFmtId()
								: SwStyleNameMapper::GetPoolIdFromUIName( rCollNm,GET_POOLID_TXTCOLL );
			*pStrm << (sal_uInt16) aStringPool.Find( rCollNm, nPId );
		}

		// style names
		sal_uInt8 nStyleNames = 0;
		for( i=0; i<MAXLEVEL; i++ )
		{
			if( pTOXBaseSect->GetStyleNames(i).Len() )
				nStyleNames++;
		}

		*pStrm << nStyleNames;

		for( i=0; i<MAXLEVEL; i++ )
		{
			const String& rStyleNames = pTOXBaseSect->GetStyleNames(i);
			if( rStyleNames.Len() )
			{
				*pStrm	<< (sal_uInt8)i
						<< (sal_uInt16)rStyleNames.GetTokenCount(
														TOX_STYLE_DELIMITER );

				xub_StrLen nStrPos = 0;
				while( nStrPos != STRING_NOTFOUND )
				{
					String aName =
						rStyleNames.GetToken( 0, TOX_STYLE_DELIMITER, nStrPos );
					ASSERT( aName.Len(), "empty style name" );
					sal_uInt16 nStrIdx = IDX_NO_VALUE;
					if( aName.Len() )
					{
						const SwTxtFmtColl *pColl =
							pDoc->FindTxtFmtCollByName( aName );
						sal_uInt16 nPoolId = pColl
							? pColl->GetPoolFmtId()
							: SwStyleNameMapper::GetPoolIdFromUIName( aName, GET_POOLID_TXTCOLL );
						nStrIdx = aStringPool.Find( aName, nPoolId );
					}

					*pStrm	<< nStrIdx;
				}
			}
		}

		// the following stuff is required to export the TOX sections as
		// TOX range.
		cFlags = 0x02;
		sal_uInt32 nTitleLen = 0UL;
		sal_uInt16 nSectStrIdx = aStringPool.Find( pSectFmt->GetName(),
											   pSectFmt->GetPoolFmtId() );
		const SwSectionFmt *pTitleSectFmt = 0;

		sal_uInt32 nNextNdIdx = pSectNd->GetIndex() + 1;
		const SwSectionNode *pNextSectNd =
			pDoc->GetNodes()[nNextNdIdx]->GetSectionNode();
			if( pNextSectNd &&
				TOX_HEADER_SECTION == pNextSectNd->GetSection().GetType() )
		{
			cFlags += 0x14;
			nTitleLen = pNextSectNd->EndOfSectionIndex() - nNextNdIdx - 1;
			pTitleSectFmt = pNextSectNd->GetSection().GetFmt();
		}

		*pStrm	<< cFlags
				<< nSectStrIdx;
		if( pTitleSectFmt )
			*pStrm	<< nTitleLen;

		OutFormat( SWG_SECTFMT, *pSectFmt );
		if( pTitleSectFmt )
			OutFormat( SWG_SECTFMT, *pTitleSectFmt );

		CloseRec( SWG_TOXDESC );
	}

	if( bTOXs )
		CloseRec( SWG_TOXDESCS );
}

void Sw3IoImp::ConnectTOXs()
{
	if( pTOXs )
	{
		for( sal_uInt16 i=0; i < pTOXs->Count(); i++ )
		{
			// #67763# If, for some reason, a TOX's point or mark have not been
			// read, the TOX has to be skipped.
			Sw3TOXBase *pTOX = (*pTOXs)[i];
			ASSERT( pTOX->GetStartNodeIdx() && pTOX->GetEndNodeIdx(),
					"missing TOX index" );
			if( !(pTOX->GetStartNodeIdx() && pTOX->GetEndNodeIdx()) )
				continue;

			ASSERT( pTOX->GetStartNodeIdx()->GetIndex() <=
					pTOX->GetEndNodeIdx()->GetIndex(),
					"wrong TOX index order" );
			if( pTOX->GetStartNodeIdx()->GetIndex() >
										pTOX->GetEndNodeIdx()->GetIndex() )
				continue;

			// Ensure that start and end indices are within the same section.
			// The indices are at content nodes, because they are read at
			// text nodes only.
			if( pTOX->GetStartNodeIdx()->GetNode().FindStartNode() !=
			  	pTOX->GetEndNodeIdx()->GetNode().FindStartNode() )
			{
				ASSERT( !this, "TOX indices are not within the same section" );
				continue;
			}

			// Make TOX name unique.
			const String& rTOXName = pTOX->GetTOXName();
			if( !rTOXName.Len() || bInsert )
			{
				const String *pOldTOXName = rTOXName.Len() ? &rTOXName : 0;
				String aTOXName(
					pDoc->GetUniqueTOXBaseName( *pTOX->GetTOXType(),
												pOldTOXName ) );
				pTOX->SetTOXName( aTOXName );
			}

			// Insert tox. This inserts a section that has the name of the
			// tox type.
			sal_uInt32 nStartNdIdx = pTOX->GetStartNodeIdx()->GetIndex();
			sal_uInt32 nEndNdIdx = pTOX->GetEndNodeIdx()->GetIndex();
			const SwTOXBaseSection *pSect =
				pDoc->InsertTableOf( nStartNdIdx, nEndNdIdx, *pTOX );
			ASSERT( pSect, "insertion of TOX failed" );
			if( !pSect )
				continue;

			ASSERT( pSect->GetName() == pTOX->GetTOXName(),
					"tox has wrong name" );
			ASSERT( pSect->GetFmt()->GetSectionNode()->GetIndex() ==
					nStartNdIdx,
					"unexpected tox section start position" );

			// Copy section format attributes to the new section format.
			// In addition, the section format has to be renamed, because
			// loading the layout requires the frame have the original name.
			SwSectionFmt *pTOXSectFmt = pTOX->GetSectFmt();
			if( pTOXSectFmt )
			{
				SwSectionFmt *pSectFmt = pSect->GetFmt();
				const String& rName = pTOXSectFmt->GetName();
				pSectFmt->SetName( rName );
				pSectFmt->SetAttr( pTOXSectFmt->GetAttrSet() );

				// If the format has been cached already, the cache entry has
				// to be replaced, too.
				sal_uInt16 nStrIdx = pTOX->GetSectFmtStrIdx();
				ASSERT( IDX_NO_VALUE != nStrIdx, "string pool index missing" );
				if( IDX_NO_VALUE != nStrIdx )
				{
#ifndef PRODUCT
					SwFmt *pTmp = aStringPool.FindCachedFmt( nStrIdx );
					ASSERT( !pTmp || pTmp == (SwFmt *)pTOXSectFmt,
							"wrong format cached?" );

#endif
					aStringPool.SetCachedFmt( nStrIdx, pSectFmt );
				}

				// The loaded format isn't required any longer.
				pDoc->DelSectionFmt( pTOXSectFmt, sal_False );
				pTOX->SetSectFmt( 0 );
			}

			sal_uInt32 nTitleLen = pTOX->GetTitleLen();
			ASSERT( !nTitleLen || pTOX->GetTitleSectFmt(),
					"missing tox title section format" );
			if( nTitleLen > 0 && pTOX->GetTitleSectFmt() )
			{
				SwNodeIndex aEndNdIdx( *pTOX->GetStartNodeIdx(), nTitleLen-1 );

				ASSERT( pTOX->GetStartNodeIdx()->GetNode().IsCntntNode(),
						"tox title section start is not a content node" );
				ASSERT( aEndNdIdx.GetNode().IsCntntNode(),
						"tox title section end is not a content node" );
				ASSERT( pTOX->GetStartNodeIdx()->GetIndex() <=
						aEndNdIdx.GetIndex(),
						"invalid TOX title section end" );

				// insert title section
				if( pTOX->GetStartNodeIdx()->GetNode().IsCntntNode() &&
					aEndNdIdx.GetNode().IsCntntNode() &&
					pTOX->GetStartNodeIdx()->GetIndex()<=aEndNdIdx.GetIndex() )
				{
					String aSectName( pTOX->GetTOXName() );
					aSectName.AppendAscii( "_Head" );
					SwSection aSection( TOX_HEADER_SECTION, aSectName );

					pDoc->GetNodes().InsertSection( *pTOX->GetStartNodeIdx(),
							*pTOX->GetTitleSectFmt(), aSection, &aEndNdIdx,
							sal_False );

					// The section format's owner now is the section
					pTOX->SetTitleSectFmt( 0 );
				}
			}
		}

		delete pTOXs;
		pTOXs = 0;
	}
}

// Nicht benutzte Markierungen loeschen

void Sw3IoImp::CleanupMarks()
{
	sal_uInt16 i = 0;
	const SwBookmarks& rMarks = pDoc->GetBookmarks();
	while( i < rMarks.Count() )
	{
		const SwBookmark* pMark = rMarks.GetObject( i );
		if( &pMark->pPos1->nNode.GetNode() == &pDoc->GetNodes().GetEndOfPostIts() )
			pDoc->DelBookmark( i );
		else
			i++;
	}
}

void Sw3IoImp::InDBName()
{
	ByteString sStr8;
	String	sStr, sSQL;
	SwDBData aData;
	OpenRec( SWG_DBNAME );

	// MIB 9.4.97: Die Datenbanknamen koennen 0xff enthalten und muessen
	// deshalb von Hand konvertiert werden.
	pStrm->ReadByteString( sStr8 );
	sStr = ConvertStringNoDbDelim( sStr8,  eSrcSet );
	aData.sDataSource = sStr.GetToken(0, DB_DELIM);
	aData.sCommand = sStr.GetToken(1, DB_DELIM);

	if( IsVersion( SWG_NONUMLEVEL, SWG_DESKTOP40 ) )
	{
		InString( *pStrm, sSQL );
	}
	if( IsVersion( SWG_TARGETFRAME, SWG_EXPORT31 ) )
	{
		// Von der Version SWG_TARGETFRAME bis zur Version SWG_REGISTER
		// stand hier der Default-Target-Frame.
		// Seit der Version SWG_REGISTER steht hier der Tabellenname.
		// Dazwischen wurde ein Leerstring geschrieben.
		String aTableName;
		InString( *pStrm, aTableName );

		if( nVersion < SWG_REGISTER )
		{
			SfxDocumentInfo aInfo( *pDoc->GetInfo() );
			aInfo.SetDefaultTarget( aTableName );
			pDoc->SetInfo( aInfo );
		}
		else if( nVersion >= SWG_DBTABLE )
		{
			aData.sCommand = aTableName;
		}

	}

	// Die folgende Tabelle der Datenbanknamen wird schon seit der
	// Version SWG_USEDDB geschrieben, aber nur fuer Doks seit SWG_DBTABLE
	// gelesen, da vorher kein Datenabnkname enthalten war. Auch der
	// DB-Name des Doks ist erst seit dieser Version gueltig. Die
	// Anzahl der Datenbanken lesen wir aber trotzdem, denn sie
	// koennte 0 sein. Dann verliert man keine Informationen und muss
	// auch keine Warnung hierzu bekommen.
	if( IsVersion( SWG_USEDDB, SWG_EXPORT31, SWG_DESKTOP40 ) )
	{
		if( sSQL.Len() && nVersion >= SWG_DBTABLE )
		{
			aData.sCommand = sSQL;
			aData.nCommandType = sdb::CommandType::COMMAND;
		}

		sal_uInt16 nCount;
		*pStrm >> nCount;
		if( nCount>0 && nVersion >= SWG_DBTABLE )
		{
			// MIB 9.4.97: Die Datenbanknamen koennen 0xff enthalten und
			// muessen deshalb von Hand konvertiert werden.
			String sDBName;
			sal_Int32 nSelStart, nSelEnd;

			SwNewDBMgr& rDBMgr = *pDoc->GetNewDBMgr();
			for( sal_uInt16 i = 0; i < nCount; i++ )
			{
				pStrm->ReadByteString( sStr8 );
				*pStrm >> nSelStart
					   >> nSelEnd;
				sDBName = ConvertStringNoDbDelim( sStr8, eSrcSet );

                SwDBData aData;
                aData.sDataSource = sDBName.GetToken(0, DB_DELIM);
                aData.sCommand = sDBName.GetToken(1, DB_DELIM);
                aData.nCommandType = -1;
                rDBMgr.AddDSData(aData, nSelStart, nSelEnd );
			}
		}
	}
	else
	{
		// sonst zumindest irgendeinen Namen setzen
		aData = pDoc->GetNewDBMgr()->GetAddressDBName();
	}

	CloseRec( SWG_DBNAME );
	pDoc->ChgDBData( aData );
}

void Sw3IoImp::OutDBName()
{
	// Erstmal alle verwendeten Datenbanken holen
	SvStringsDtor aDBNameList;
	pDoc->GetAllUsedDB(aDBNameList);
	sal_uInt16 nCount = aDBNameList.Count();

	OpenRec( SWG_DBNAME );

	if( IsSw31Export() )
	{
		// Datenbanknamen und das SQL-Statement holen
		String sDBDesc, sDBName;
		if( nCount==1 && pDoc->GetNewDBMgr() )
		{
			sDBDesc = *aDBNameList.GetObject(0);
			sDBName = sDBDesc;
		}
		else
		{
			SwDBData aData = pDoc->_GetDBDesc();
			sDBName = aData.sDataSource;
			sDBName += DB_DELIM;
			sDBName += (String)aData.sCommand;
		}

		OutString( *pStrm, sDBName.GetToken( 0, DB_DELIM ) );

		String aTmpStr;
		xub_StrLen nPos = 0;
		if( ( nPos = sDBDesc.Search(';') ) != STRING_NOTFOUND )
			aTmpStr = sDBDesc.Copy( nPos + 1 );
		OutString( *pStrm, aTmpStr );
	}
	else
	{
		// Die Datenbank-Beschreibung koennen wir im 4.0 FF auf einen Schlag
		// rausschreiben
		SwDBData aData = pDoc->_GetDBDesc();
		String sTmpDBName = aData.sDataSource;
		sTmpDBName += DB_DELIM;
		sTmpDBName += (String)aData.sCommand;
		ByteString s8 = ConvertStringNoDbDelim( sTmpDBName, eSrcSet );
		pStrm->WriteByteString( s8 );

		// Datenbankname, SQL-Statement und aktuelle Selektion abspeichern
		long nSelStart, nSelEnd;

		*pStrm << nCount;

		SwNewDBMgr& rDBMgr = *pDoc->GetNewDBMgr();
		for (sal_uInt16 i = 0; i < nCount; i++)
		{
			String sDesc(*aDBNameList.GetObject(i));
			ByteString s8 = ConvertStringNoDbDelim( sDesc, eSrcSet );
			pStrm->WriteByteString( s8 );

            SwDBData aData;
            aData.sDataSource = sDesc.GetToken(0, DB_DELIM);
            aData.sCommand = sDesc.GetToken(1, DB_DELIM);
            aData.nCommandType = -1;
            rDBMgr.GetDSSelection(aData, nSelStart, nSelEnd);

			*pStrm << (sal_Int32)nSelStart
				   << (sal_Int32)nSelEnd;
		}
	}

	CloseRec( SWG_DBNAME );
}

void Sw3IoImp::InDocStat()
{
	OpenRec( SWG_DOCSTAT );
	SwDocStat aDocStat;
	BYTE c;
	*pStrm  >> aDocStat.nTbl
			>> aDocStat.nGrf
			>> aDocStat.nOLE;

	if( IsVersion(SWG_LONGIDX) )
	{
		*pStrm  >> aDocStat.nPage
				>> aDocStat.nPara;
	}
	else
	{
		sal_uInt16 nPage, nPara;
		*pStrm >> nPage
			   >> nPara;

		aDocStat.nPage = nPage;
		aDocStat.nPara = nPara;
	}

	*pStrm	>> aDocStat.nWord
			>> aDocStat.nChar
			>> c;

	aDocStat.bModified = c;

	CloseRec( SWG_DOCSTAT );
	pDoc->SetDocStat( aDocStat );
}

void Sw3IoImp::OutDocStat( sal_Bool bFirst )
{
	sal_uInt32 nAktPos;
	if( bFirst )
	{
		OpenRec( SWG_DOCSTAT );
		nStatStart = pStrm->Tell();
	}
	else
	{
		nAktPos = pStrm->Tell();
		pStrm->Seek( nStatStart );
	}

	const SwDocStat& rDocStat = pDoc->GetDocStat();
	*pStrm << (sal_uInt16)rDocStat.nTbl
		   << (sal_uInt16)rDocStat.nGrf
		   << (sal_uInt16)rDocStat.nOLE;

	if( pStrm->GetVersion() <= SOFFICE_FILEFORMAT_40 )
	{
		*pStrm << (sal_uInt16)rDocStat.nPage
			   << (sal_uInt16)rDocStat.nPara;
	}
	else
	{
		// Die Longs duerfen hier nicht komprimiert geschrieben werden,
		// weil sich dann die Laenge der Dok-Info beim zweiten Schreiben
		// gegenueber dem ersten Schreiben aendern kann.
		*pStrm << (sal_uInt32)rDocStat.nPage
			   << (sal_uInt32)rDocStat.nPara;
	}

	*pStrm << (sal_uInt32)rDocStat.nWord
		   << (sal_uInt32)rDocStat.nChar
		   << (BYTE)rDocStat.bModified;

	if( bFirst )
		CloseRec( SWG_DOCSTAT );
	else
		pStrm->Seek( nAktPos );
}

void Sw3IoImp::InDictionary()
{
	Reference< XDictionaryList > xDicList( ::GetDictionaryList() );
	Sequence< Reference< XDictionary > > aDics;
	if( xDicList.is() )
		aDics = xDicList->getDictionaries();
	const Reference< XDictionary > *pDic = aDics.getConstArray();

	bSpellAllAgain = bSpellWrongAgain = sal_True;

	sal_uInt16 i, nDicCount = (sal_uInt16)aDics.getLength();

	sal_Bool *pChecked = nDicCount > 0 ? new sal_Bool[nDicCount] : 0;
	for( i = 0; i < nDicCount; i++ )
		pChecked[ i ] = !pDic[i]->isActive();

	OpenRec( SWG_DICTIONARY );
	while( BytesLeft() )
	{
		String aStr;
		sal_uInt16 nLanguage;
		sal_uInt16 nCount;
		BYTE c;
		sal_Bool bNeg;
		InString( *pStrm, aStr );
		*pStrm >> nLanguage
			   >> nCount
			   >> c;
		bNeg = c;
		sal_Bool bFound = sal_False;
		for( i = 0; !bFound && ( i < nDicCount ); i++ )
		{
			Reference< XDictionary1 > xDic( pDic[i], UNO_QUERY );
			if( xDic.is()  &&  xDic->isActive() )
				bFound = ( aStr == String(xDic->getName()) &&
						   nLanguage == xDic->getLanguage() &&
						   bNeg == (xDic->getDictionaryType()
						   			== DictionaryType_NEGATIVE) );
		}
		if( bFound )
		{
			ASSERT( pChecked, "Sw3IoImp::InDictonary: pChecked == 0" );
			sal_uInt16 nCnt = pDic[--i]->getCount();
			pChecked[ i ] = sal_True;
			if( nCnt != nCount )
			{
				if( bNeg || nCnt < nCount )
					bSpellAllAgain = sal_True;
				else
					bSpellWrongAgain = sal_True;
			}
		}
		else if( bNeg )
			bSpellWrongAgain = sal_True;
		else
			bSpellAllAgain = sal_True;
	}
	CloseRec( SWG_DICTIONARY );

	for( i = 0; i < nDicCount; i++ )
	{
		if( !pChecked[ i ] )
		{
			if( pDic[i]->getDictionaryType() == DictionaryType_NEGATIVE )
				bSpellAllAgain = sal_True;
			else
				bSpellWrongAgain =sal_True;
		}
	}
	delete[] pChecked;

}

void Sw3IoImp::OutDictionary()
{
	OpenRec( SWG_DICTIONARY );

	Reference< XDictionaryList > xDicList( ::GetDictionaryList() );
	Sequence< Reference< XDictionary > > aDics;
	if( xDicList.is() )
		aDics = xDicList->getDictionaries();
	const Reference< XDictionary > *pDic = aDics.getConstArray();

	sal_uInt16 i, nDicCount = (sal_uInt16)aDics.getLength();
	for( i = 0; i < nDicCount; i++ )
	{
		Reference< XDictionary1 > xDic( pDic[i], UNO_QUERY );
		if( xDic.is()  &&  xDic->isActive() )
		{
			const String aStr( xDic->getName() );
			sal_uInt16 nActLanguage = xDic->getLanguage();
			sal_uInt16 nCount = xDic->getCount();
			sal_Bool bNeg = xDic->getDictionaryType() == DictionaryType_NEGATIVE;
			OutString( *pStrm, aStr );
			*pStrm << (sal_uInt16)nActLanguage
				   << (sal_uInt16)nCount
				   << (BYTE)bNeg;
		}
	}
	CloseRec( SWG_DICTIONARY );
}

void Sw3IoImp::OutNumberFormatter()
{
	SvNumberFormatter* pN = pDoc->GetNumberFormatter( sal_False );
	if( pN )
	{
		OpenRec( SWG_NUMBERFORMATTER );
		pN->Save( *pStrm );
		CloseRec( SWG_NUMBERFORMATTER );
	}
}

void Sw3IoImp::InNumberFormatter()
{
	OpenRec( SWG_NUMBERFORMATTER );

	if( bInsert || bOrganizer )
	{
		Reference< XMultiServiceFactory > xMSF = ::comphelper::getProcessServiceFactory();
		SvNumberFormatter* pN = new SvNumberFormatter( xMSF, LANGUAGE_SYSTEM );
		pN->Load( *pStrm );
		pDoc->GetNumberFormatter( sal_True )->MergeFormatter( *pN );
		delete pN;
	}
	else
		pDoc->GetNumberFormatter( sal_True )->Load( *pStrm );

	CloseRec( SWG_NUMBERFORMATTER );
}

void Sw3IoImp::InLineNumberInfo()
{
	OpenRec( SWG_LINENUMBERINFO );

	sal_uInt8 nType, nPos;
	sal_uInt16 nChrIdx, nPosFromLeft, nCountBy, nDividerCountBy;
	String sDivider;

	sal_uInt8 cFlags = OpenFlagRec();
	*pStrm  >>	nType
			>>	nPos
			>>	nChrIdx
			>>	nPosFromLeft
			>>	nCountBy
			>>	nDividerCountBy;
	CloseFlagRec();

	InString( *pStrm, sDivider );

	SwLineNumberInfo aInfo;

	aInfo.SetPaintLineNumbers( (cFlags & 0x10 ) != 0 );
	aInfo.SetCountBlankLines( (cFlags & 0x20 ) != 0 );
	aInfo.SetCountInFlys( (cFlags & 0x40 ) != 0 );
	aInfo.SetRestartEachPage( (cFlags & 0x80 ) != 0 );
	aInfo.SetPos(  (LineNumberPosition)nPos );

	SvxNumberType aNumType;
	aNumType.SetNumberingType((sal_Int16)nType);
	aInfo.SetNumType( aNumType );

	if( nChrIdx != IDX_NO_VALUE )
	{
		SwCharFmt *pChrFmt = (SwCharFmt *)FindFmt( nChrIdx, SWG_CHARFMT );
		if( pChrFmt )
			aInfo.SetCharFmt( pChrFmt );
	}
	aInfo.SetPosFromLeft( nPosFromLeft );
	aInfo.SetCountBy( nCountBy );
	aInfo.SetDividerCountBy( nDividerCountBy );
	aInfo.SetDivider( sDivider );

	pDoc->SetLineNumberInfo( aInfo );

	CloseRec( SWG_LINENUMBERINFO );
}

void Sw3IoImp::OutLineNumberInfo()
{
	OpenRec( SWG_LINENUMBERINFO );

	const SwLineNumberInfo& rInfo = pDoc->GetLineNumberInfo();

	sal_uInt8 cFlags = 0x0a;
	if( rInfo.IsPaintLineNumbers() )
		cFlags += 0x10;
	if( rInfo.IsCountBlankLines() )
		cFlags += 0x20;
	if( rInfo.IsCountInFlys() )
		cFlags += 0x40;
	if( rInfo.IsRestartEachPage() )
		cFlags += 0x80;

	const SwCharFmt *pCharFmt = (const SwCharFmt *)rInfo.GetRegisteredIn();
	sal_uInt16 nChrIdx = pCharFmt ? aStringPool.Find( pCharFmt->GetName(),
												  pCharFmt->GetPoolFmtId() )
							  : IDX_NO_VALUE;

	*pStrm  << 			cFlags
			<< (sal_uInt8)   rInfo.GetNumType().GetNumberingType()
			<< (sal_uInt8)   rInfo.GetPos()
			<< (sal_uInt16)	nChrIdx
			<< (sal_uInt16) rInfo.GetPosFromLeft()
			<< (sal_uInt16) rInfo.GetCountBy()
			<< (sal_uInt16) rInfo.GetDividerCountBy();
	OutString( *pStrm, rInfo.GetDivider() );

	CloseRec( SWG_LINENUMBERINFO );
}


void Sw3IoImp::InDocDummies()
{
	OpenRec( SWG_DOCDUMMIES );

	sal_uInt32 n1, n2;
	sal_uInt8 n3, n4;
	String sAutoMarkURL, s2;

	*pStrm >> n1 >> n2 >> n3 >> n4;
	InString( *pStrm, sAutoMarkURL );
	InString( *pStrm, s2 );

	// Das 0. und 1. Bit ist der Link Update-Mode
	sal_uInt16 nUpdMode = MANUAL;
	switch( n3 & 0x03 )
	{
	case 1:	nUpdMode = NEVER;			break;
	case 2:	nUpdMode = AUTOMATIC;		break;
	case 3:	nUpdMode = GLOBALSETTING;	break;
	}
	pDoc->SetLinkUpdMode( nUpdMode );

	// das 2. Bit verbleibt im Byte-Dummy1

	// das 3. und 4. Bit ist der Field Update-Mode
	nUpdMode = AUTOUPD_OFF;
	switch( (n3 & 0x18) >> 3 )
	{
	case 0:	nUpdMode = AUTOUPD_OFF;					break;
	case 1:	nUpdMode = AUTOUPD_FIELD_ONLY;			break;
	case 2:	nUpdMode = AUTOUPD_FIELD_AND_CHARTS;	break;
	case 3:	nUpdMode = AUTOUPD_GLOBALSETTING;		break;
	}
	pDoc->SetFldUpdateFlags( nUpdMode );

	// Achtung: Das drittunterste Bit 0x04 wird jetzt benutzt
	// als Flag, ob Absatzabstaende addiert oder maximiert werden
	// 0x20 - makes the same at start of doc an at page starts behind page breaks
	n3 &= 0xE4;

	pDoc->SetULongDummy1( n1 );
	pDoc->SetULongDummy2( n2 );
	pDoc->SetByteDummy1( n3 );
	pDoc->SetByteDummy2( n4 );
	if( sAutoMarkURL.Len() )
		sAutoMarkURL = URIHelper::SmartRelToAbs( sAutoMarkURL );
	pDoc->SetTOIAutoMarkURL( sAutoMarkURL );
	pDoc->SetStringDummy2( s2 );

	CloseRec( SWG_DOCDUMMIES );
}

void Sw3IoImp::OutDocDummies()
{
	OpenRec( SWG_DOCDUMMIES );

	sal_uInt8 n3 = (sal_uInt8)pDoc->GetByteDummy1();
	// Achtung: Das drittunterste Bit 0x04 wird jetzt benutzt
	// als Flag, ob Absatzabstaende addiert oder maximiert werden
	// 0x20 - makes the same at start of doc an at page starts behind page breaks
	ASSERT( (n3 & 0x03) == 0, "Sw3IoImp::OutDocDummies: byte1 falsch" );
	n3 &= 0xfc;

	// Der Link-Update-Mode muss noch etwas konvertiert werden, damit
	// der Default-Wert in den Dummies (0) einem MANUAL (1) entspricht
	switch( pDoc->_GetLinkUpdMode() )
	{
	case MANUAL:		break;
	case NEVER:			n3 |= 0x01;	break;
	case AUTOMATIC:		n3 |= 0x02;	break;
	case GLOBALSETTING:	n3 |= 0x03;	break;
	default:
		ASSERT( !this, "Sw3IoImp::OutDocDummies: Wert von LinkUpdMode unbek." );
		break;
	}

	// Der Feld-Update-Mode muss noch etwas konvertiert werden, damit
	// der Default-Wert in den Dummies (0) einem OFF entspricht
	switch( pDoc->_GetFldUpdateFlags() )
	{
	case AUTOUPD_OFF:				break;
	case AUTOUPD_FIELD_ONLY:		n3 |= ( 0x01 << 3);	break;
	case AUTOUPD_FIELD_AND_CHARTS:	n3 |= ( 0x02 << 3);	break;
	case AUTOUPD_GLOBALSETTING:		n3 |= ( 0x03 << 3);	break;
	default:
		ASSERT( !this, "Sw3IoImp::OutDocDummies: Wert von FieldUpdMode unbek." );
		break;
	}

	String sAutoMarkURL( pDoc->GetTOIAutoMarkURL() );
	if( sAutoMarkURL.Len() )
		sAutoMarkURL = INetURLObject::AbsToRel( sAutoMarkURL URL_DECODE );
	*pStrm	<< (sal_uInt32)pDoc->GetULongDummy1()
			<< (sal_uInt32)pDoc->GetULongDummy2()
			<< n3
			<< (sal_uInt8)pDoc->GetByteDummy2();
	OutString( *pStrm, sAutoMarkURL );
	OutString( *pStrm, pDoc->GetStringDummy2() );

	CloseRec( SWG_DOCDUMMIES );
}

void Sw3IoImp::InPagePreViewPrintData()
{
	OpenRec( SWG_PGPREVIEWPRTDATA );

	sal_uInt8 cFlags;
	sal_uInt8 nRow, nCol;
	sal_uInt32 nLeftSpace, nRightSpace, nTopSpace, nBottomSpace,
			nHorzSpace, nVertSpace;

	*pStrm	>> cFlags
			>> nRow
			>> nCol
			>> nLeftSpace
			>> nRightSpace
			>> nTopSpace
			>> nBottomSpace
			>> nHorzSpace
			>> nVertSpace
			;
	CloseRec( SWG_PGPREVIEWPRTDATA );

	SwPagePreViewPrtData aData;
	aData.SetLeftSpace( nLeftSpace );
	aData.SetRightSpace( nRightSpace );
	aData.SetTopSpace( nTopSpace );
	aData.SetBottomSpace( nBottomSpace );
	aData.SetHorzSpace( nHorzSpace );
	aData.SetVertSpace( nVertSpace );
	aData.SetRow( nRow );
	aData.SetCol( nCol );
	aData.SetLandscape( 0 != ( cFlags & 0x01 ) );
	aData.SetStretch( 0 != ( cFlags & 0x02 ) );
	pDoc->SetPreViewPrtData( &aData );
}

void Sw3IoImp::OutPagePreViewPrintData()
{
	// Wenn keine Daten gesetzt oder keine gueltige Zeile/Spalte
	// gesetzt sind, so braucht es auch nicht geschrieben werden.
	const SwPagePreViewPrtData* pPPVPD = pDoc->GetPreViewPrtData();
	if( !pPPVPD || !pPPVPD->GetCol() || !pPPVPD->GetRow() )
		return;

	OpenRec( SWG_PGPREVIEWPRTDATA );

	sal_uInt8 cFlags = 0;
	if( pPPVPD->GetLandscape() )
		cFlags += 0x01;
	if( pPPVPD->GetStretch() )
		cFlags += 0x02;

	*pStrm	<< cFlags
			<< pPPVPD->GetRow()
			<< pPPVPD->GetCol()
			<< (sal_uInt32)pPPVPD->GetLeftSpace()
			<< (sal_uInt32)pPPVPD->GetRightSpace()
			<< (sal_uInt32)pPPVPD->GetTopSpace()
			<< (sal_uInt32)pPPVPD->GetBottomSpace()
			<< (sal_uInt32)pPPVPD->GetHorzSpace()
			<< (sal_uInt32)pPPVPD->GetVertSpace()
			;
	CloseRec( SWG_PGPREVIEWPRTDATA );
}



