/*************************************************************************
 *
 *  $RCSfile: wizmmgo.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 16:03:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#include "hintids.hxx"

#ifndef _SV_COMBOBOX_HXX //autogen
#include <vcl/combobox.hxx>
#endif
#ifndef _SVX_BOXITEM_HXX //autogen
#include <svx/boxitem.hxx>
#endif


#ifndef _FMTHDFT_HXX //autogen
#include <fmthdft.hxx>
#endif
#include "uiparam.hxx"
#include "wrtsh.hxx"     // Writershell
#include "frmatr.hxx"    // Fussz,Kopfz,FlyHoriOrient
#include "pagedesc.hxx"  // Seitenraender,
#include "wizpage.hxx"
#include "wizgo.hxx"
#include "wizmm.hxx"
#include "numfmtlb.hxx"

////////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef WINDOCHFILM
#define WIZNOFILM
#endif
#ifndef WINDOCHUNDO
#define WIZNOUNDO
#endif
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL MemoDialog::MakeDoc()
{
	BOOL bRet=FALSE;
	String aVorNam;
	if (p1_RBtn_Stil2->IsChecked())
		aVorNam.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "wizmem2" ));
	else if (p1_RBtn_Stil3->IsChecked())
		aVorNam.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "wizmem3" ));
	else
		aVorNam.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "wizmem1" ));

	if (NewVorlage(aVorNam))
	{
#ifdef WIZNOFILM
		pShell->StartAction();
#endif
#ifdef WIZNOUNDO
		pShell->DoUndo(FALSE); // hat leider noch Seiteneffekte
#endif
		SetMarg(aPage1,NULL,&aPage1.aFusz);
		InsTitl();
		InsElem();
		InsFusz();
		InsKopz();
		DelText();
		MarkText();
		CreateMacro();
		SaveMacro();
		FillDocInfo(*pDoku);
#ifdef WIZNOFILM
		pShell->EndAction();
#endif
		if (SaveVorNewDoc(*pDoku)) bRet=TRUE;
	}
	return bRet;
}

void MemoDialog::CreateMacro()
{
	ULONG nDateFmt = NODATE;
	if (p2_CBox_Datum->IsChecked())
		nDateFmt = p2_List_Datum->GetFormat();
	SetCreateMacro(*pDoku,nDateFmt,NOTIME,4,TRUE);
}

void MemoDialog::SaveMacro()
{
	 SetSaveMacro(*pDoku,FALSE,FALSE);
}

void MemoDialog::InsTitl()
{
	if (GotoBookmark("Titl")) {
		if (aPage1.aTitl.IsVisible()) {
			MovFrame(aPage1.aTitl);
			InsLogoObj(aPage1.aTitl);
		} else {
			DelFrame();
		}
	}
}

void MemoDialog::InsElem()
{
	if (aPage1.aEleZ.IsVisible())
	{
		if (GotoBookmark("Datm"))
		{
			if (p2_CBox_Datum->IsChecked())
			{
				if( !pShell->IsEndPara() )
					pShell->MovePara( fnParaCurr, fnParaEnd );
				InsertBookmark("Datum");
			}
			else
				pShell->DelFullPara();
		}
		if (GotoBookmark("Absn"))
		{
			if (p2_CBox_MemoVn->IsChecked())
				InsDocInfBookmark(3);
			else
				pShell->DelFullPara();
		}
		if (GotoBookmark("Empf"))
		{
			if (p2_CBox_MemoAn->IsChecked())
				InsDocInfBookmark(1);
			else
				pShell->DelFullPara();
		}
		if (GotoBookmark("Kopi"))
		{
			if (p2_CBox_KopiAn->IsChecked())
				InsDocInfBookmark(2);
			else
				pShell->DelFullPara();
		}
		if (GotoBookmark("Betr"))
		{
			if (p2_CBox_Betref->IsChecked())
			{
				InsString(p2_Edit_Betref->GetText());
				if( !pShell->IsSttPara() )
					pShell->MovePara( fnParaCurr, fnParaStart );
				InsDocInfBookmark(0);
			}
			else
				pShell->DelFullPara();
		}


        CheckBox* aCBArr[ 4 ] =
			{ p2_CBox_Elem1, p2_CBox_Elem2, p2_CBox_Elem3, p2_CBox_Elem4 };
        Edit* aEDArr[ 4 ] =
			{ p2_Edit_Elem1, p2_Edit_Elem2, p2_Edit_Elem3, p2_Edit_Elem4 };

		ByteString sBook( "Ele0" );
		for( USHORT n = 1; n <= 4; ++n )
		{
			sBook.SetChar( 3, '0' + n );
			if( GotoBookmark( sBook.GetBuffer() ))
			{
				if( aCBArr[ n-1 ]->IsChecked())
				{
					InsString( aEDArr[ n-1 ]->GetText() );
					if( !pShell->IsSttPara() )
						pShell->MovePara( fnParaCurr, fnParaStart );
					InsDocInfBookmark( 3 + n );
				}
				else
					pShell->DelFullPara();
			}
		}
		MovFrame(aPage1.aEleZ);
	} else {
		if (GotoBookmark("Datm")) {
			DelFrame();
		}
	}
}

void MemoDialog::DelFusz()
{
	USHORT nPgDescIdx=pShell->GetCurPageDesc();
	SwPageDesc aPageDesc(pShell->GetPageDesc(nPgDescIdx));
	SwFrmFmt*  pFmt=&aPageDesc.GetMaster();
	pFmt->SetAttr(SwFmtFooter(BOOL(FALSE)));
	aPageDesc.ChgFooterShare(FALSE);
	pShell->ChgPageDesc(nPgDescIdx,aPageDesc);
}

void MemoDialog::DelFuszTr()
{
	USHORT nPgDescIdx=pShell->GetCurPageDesc();
	SwPageDesc aPageDesc(pShell->GetPageDesc(nPgDescIdx));
	SwFrmFmt*  pFmt=&aPageDesc.GetMaster();
	SwFmtFooter aFooterFmt(pFmt->GetFooter());
	SwFrmFmt* pFooterFmt=aFooterFmt.GetFooterFmt();

	pFooterFmt->SetAttr( SvxBoxItem() );

	pFmt->SetAttr(aFooterFmt);
	pShell->ChgPageDesc(nPgDescIdx,aPageDesc);
}

void MemoDialog::DelKopz()
{
	USHORT nPgDescIdx=pShell->GetCurPageDesc();
	SwPageDesc aPageDesc(pShell->GetPageDesc(nPgDescIdx));
	SwFrmFmt*  pFmt=&aPageDesc.GetMaster();
	pFmt->SetAttr(SwFmtHeader(BOOL(FALSE)));
	aPageDesc.ChgHeaderShare(FALSE);
	pShell->ChgPageDesc(nPgDescIdx,aPageDesc);
}

void MemoDialog::DelKopzTr()
{
	USHORT nPgDescIdx=pShell->GetCurPageDesc();
	SwPageDesc aPageDesc(pShell->GetPageDesc(nPgDescIdx));
	SwFrmFmt*  pFmt=&aPageDesc.GetMaster();
	SwFmtHeader aHeaderFmt(pFmt->GetHeader());
	SwFrmFmt* pHeaderFmt=aHeaderFmt.GetHeaderFmt();

	pHeaderFmt->SetAttr( SvxBoxItem() );

	pFmt->SetAttr(aHeaderFmt);
	pShell->ChgPageDesc(nPgDescIdx,aPageDesc);
}

void MemoDialog::InsFusz()
{
	if (aPage1.aFusz.IsVisible()) {
		// Seite 1
		if (GotoBookmark("Dat1")) {
			if (p2_CBox_Datum->IsChecked() && p3_CBox_FDatum->IsChecked()) {
				InsertBookmark("Datum1");
			} else pShell->DelFullPara();
		}
		if (GotoBookmark("Vtr1")) {
			if (p3_CBox_FVertr->IsChecked()) {
				InsString(p3_Edit_FVertr->GetText());
			} else pShell->DelFullPara();
		}
		if (GotoBookmark("Num1")) {
			if (p3_CBox_FPgNum->IsChecked()) {
			} else pShell->DelFullPara();
		}
		if (!aPage1.aFusz.IsTrennlinie()) {
			DelFuszTr();
		}
		// Folgeseiten
		if (GotoBookmark("DtFF")) {
			if (p2_CBox_Datum->IsChecked() && p3_CBox_FDatum->IsChecked()) {
				InsertBookmark("Datum2");
			} else pShell->DelFullPara();
		}
		if (GotoBookmark("VtrF")) {
			if (p3_CBox_FVertr->IsChecked()) {
				InsString(p3_Edit_FVertr->GetText());
			} else pShell->DelFullPara();
		}
		if (GotoBookmark("NmFF")) {
			if (p3_CBox_FPgNum->IsChecked()) {
			} else pShell->DelFullPara();
		}
		if (!aPage1.aFusz.IsTrennlinie()) {
			DelFuszTr();
		}
	} else { // Fusszeilen entfernen
		if (GotoBookmark("Dat1")) {
			DelFusz();
		}
		if (GotoBookmark("DtFF")) {
			DelFusz();
		}
	}
}

void MemoDialog::InsKopz()
{
	if (p3_CBox_KDatum->IsChecked() ||
		(p3_CBox_KThema->IsChecked() && p1_RBtn_TitTxt->IsChecked())||
		p3_CBox_KPgNum->IsChecked()) {
		if (GotoBookmark("DtKF")) {
			if (p2_CBox_Datum->IsChecked() && p3_CBox_KDatum->IsChecked()) {
				InsertBookmark("Datum3");
			} else pShell->DelFullPara();
		}
		if (GotoBookmark("NmKF")) {
			if (p3_CBox_KPgNum->IsChecked()) {
			} else pShell->DelFullPara();
		}
		if (GotoBookmark("ThmF")) {
			if (p3_CBox_KThema->IsChecked() && p1_RBtn_TitTxt->IsChecked()) {
				InsString(p1_CBox_TitTxt->GetText());
			} else pShell->DelFullPara();
		}
		if (!p3_CBox_KTrnLn->IsChecked()) {
			DelKopzTr();
		}
	} else {
		if (GotoBookmark("DtKF")) {
			DelKopz();
		}
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

void MemoDialog::InsDocInfBookmark(USHORT nElemNum)
{
	if (GetDocInfStrOk(nElemNum)) {   // als DocInf freigegeben ?
		USHORT nIdx=nElemNum;      // nIdx geht von 0..aDoku.GetTxFieldAnz()-1
		USHORT i;
		for (i=0; i<nElemNum; i++) // fuer jeden nicht freigeg. davor, Idx um 1 dec.
			if (!GetDocInfStrOk(i)) nIdx--;
		nIdx+=pDoku->GetTxFieldOfs();
		if (nIdx==pDoku->pD_List_InfTit->GetSelectEntryPos())
			InsertBookmark("Titel");
		if (nIdx==pDoku->pD_List_InfTem->GetSelectEntryPos())
			InsertBookmark("Thema");
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////



