#*************************************************************************
#
#   $RCSfile: makefile.mk,v $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************

PRJ=..$/..

PRJNAME=sysui
TARGET=gnomeint

TARGETTYPE=CUI
LIBTARGET=NO
NO_DEFAULT_STL=TRUE
LIBSALCPPRT=$(0)

# --- Settings -----------------------------------------------------

.INCLUDE :  settings.mk

# --- Files --------------------------------------------------------

# gnomeint binary
OBJFILES = $(OBJ)$/gnome-vfs-filetype-registration.obj

APP1TARGET=$(TARGET)
APP1OBJS=$(OBJFILES)
APP1LIBS=
.IF "$(OS)"!="NETBSD"
.IF "$(OS)"!="FREEBSD"
APP1STDLIBS=-ldl
.ENDIF
.ENDIF

# menu launcher files
LAUNCHERDIR = $(MISC)$/gnome

LAUNCHERCOMMENTFILES = \
	$(LAUNCHERDIR)$/ooo$(UPD)writer.desktop \
	$(LAUNCHERDIR)$/ooo$(UPD)draw.desktop \
	$(LAUNCHERDIR)$/ooo$(UPD)impress.desktop \
	$(LAUNCHERDIR)$/ooo$(UPD)calc.desktop \
	$(LAUNCHERDIR)$/ooo$(UPD)math.desktop \
	$(LAUNCHERDIR)$/ooo$(UPD)web.desktop

LAUNCHERNAMEFILES = \
	$(LAUNCHERDIR)$/ooo$(UPD)printeradmin.desktop \
	$(LAUNCHERDIR)$/ooo$(UPD)template.desktop


LANGLAUNCHERCOMMENTFLAGFILE = $(MISC)$/gnomeappcomment.flag
LANGLAUNCHERNAMEFLAGFILE = $(MISC)$/gnomeappname.flag

ZIPFLAGS= -u -r

ZIP1TARGET = gnomeicons
ZIP1LIST   = icons

.IF "$(WITH_LIBSN)"=="YES"
STARTUP_NOTIFY="true"
.ELSE
STARTUP_NOTIFY="false"
.ENDIF

# --- Targets ------------------------------------------------------

.INCLUDE :  target.mk

ALLTAR : LAUNCHERTREE

# ensure unix line ends and attach localization to launcher files
LAUNCHERTREE:  $(LANGLAUNCHERCOMMENTFLAGFILE) $(LANGLAUNCHERNAMEFLAGFILE) 

$(LAUNCHERDIR):
	+@$(MKDIR) -p $(LAUNCHERDIR)

$(LAUNCHERCOMMENTFILES): $(LAUNCHERDIR) $(subst,ooo$(UPD), $(@:f))
	+@tr -d "\015" < $(subst,ooo$(UPD), $(@:f)) > $@ 
	+@echo StartupNotify=$(STARTUP_NOTIFY) >> $@

$(LANGLAUNCHERCOMMENTFLAGFILE): $(LAUNCHERCOMMENTFILES) translate.pl makefile.mk ../share/launcher_comment.ulf
	+@$(PERL) translate.pl ../share/launcher_comment.ulf $(LAUNCHERDIR)$/ooo$(UPD) Comment
	+@touch $(LANGLAUNCHERCOMMENTFLAGFILE)

$(LAUNCHERNAMEFILES): $(LAUNCHERDIR) $(subst,ooo$(UPD), $(@:f))
	+@tr -d "\015" < $(subst,ooo$(UPD), $(@:f)) > $@ 
	+@echo StartupNotify=$(STARTUP_NOTIFY) >> $@

$(LANGLAUNCHERNAMEFLAGFILE): $(LAUNCHERNAMEFILES) translate.pl makefile.mk ../share/launcher_name.ulf 
	+@$(PERL) translate.pl ../share/launcher_name.ulf $(LAUNCHERDIR)$/ooo$(UPD) Name
	+@touch $(LANGLAUNCHERNAMEFLAGFILE)
