/*************************************************************************
 *
 *  $RCSfile: smartvcl.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/15 15:52:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#define NOOLDSV

#include <tools/debug.hxx>

#include <vcl/svapp.hxx>
#include <vcl/wrkwin.hxx>
#include <vcl/msgbox.hxx>

#include <unoiface.hxx>
#include <unoifac2.hxx>

#ifndef __STARDIV_UNO_AWT_WINLSTNR_HXX__ //autogen
#include <stardiv/uno/awt/winlstnr.hxx>
#endif

#ifndef __STARDIV_UNO_REPOS_SERINFO_HXX__ //autogen
#include <stardiv/uno/repos/serinfo.hxx>
#endif

class MyCompListener: public XWindowListener, public UsrObject
{

public:
	// Interface:
	BOOL	queryInterface( UsrUik, XInterfaceRef& rxInterface );

	virtual void disposing( const EventObject& Source );
    virtual void windowResized(const WindowEvent& e);
    virtual void windowMoved(const WindowEvent& e);
    virtual void windowShown(const EventObject& e);
    virtual void windowHidden(const EventObject& e);

	SMART_UNO_DECLARATION( MyCompListener, UsrObject );
};

BOOL MyCompListener::queryInterface( UsrUik aUik, XInterfaceRef& rxInterface )
{
	if( aUik == XWindowListener::getSmartUik() )
		rxInterface = (XWindowListener*)this;
	else
		return UsrObject::queryInterface( aUik, rxInterface );
	return TRUE;
}

void MyCompListener::disposing( const EventObject& Source )
{
	int ndummy = 1;
}

void MyCompListener::windowResized(const WindowEvent& e)
{
	InfoBox( 0, "Component Resized" ).Execute();
}

void MyCompListener::windowMoved(const WindowEvent& e)
{
	// ...
}

void MyCompListener::windowShown(const EventObject& e)
{
}

void MyCompListener::windowHidden(const EventObject& e)
{
}

class MyActionListener: public XActionListener, public UsrObject
{

public:
	// Interface:
	BOOL 	queryInterface( UsrUik aUik, XInterfaceRef& rxInterface );

	virtual void disposing( const EventObject& Source );
    virtual void actionPerformed( const ActionEvent& e );

	SMART_UNO_DECLARATION( MyActionListener, UsrObject );
};

BOOL MyActionListener::queryInterface( UsrUik aUik, XInterfaceRef& rxInterface )
{
	if( aUik == XActionListener::getSmartUik() )
		rxInterface = (XActionListener*)this;
	else
		return UsrObject::queryInterface( aUik, rxInterface );
	return TRUE;
}

void MyActionListener::disposing( const EventObject& Source )
{
	int ndummy = 1;
}

void MyActionListener::actionPerformed(const ActionEvent& e)
{
	InfoBox( 0, "Action!" ).Execute();
}

// -----------------------------------------------------------------------

class MyApp : public Application
{
public:
    void        Main();
};

MyApp aMyApp;

// -----------------------------------------------------------------------

class MyWin : public WorkWindow
{
	XWindowPeerRef		xWin;
	XWindowPeerRef 		xButtonPeer;
	XWindowListenerRef 	xLst;

public:
                MyWin( Window* pParent, WinBits nWinStyle );

    void        MouseMove( const MouseEvent& rMEvt );
    void        MouseButtonDown( const MouseEvent& rMEvt );
    void        MouseButtonUp( const MouseEvent& rMEvt );
    void        KeyInput( const KeyEvent& rKEvt );
    void        KeyUp( const KeyEvent& rKEvt );
    void        Paint( const Rectangle& rRect );
    void        Resize();
};

// -----------------------------------------------------------------------

void MyApp::Main()
{
    MyWin aMainWin( NULL, WB_APP | WB_STDWORK );
    aMainWin.SetText( "Star-View - Workbench" );

	createAndSetDefaultServiceManager();

	XServiceManagerRef xProv = getGlobalServiceManager();

	// MenuBar
	XServiceProviderRef xSSI = 	xProv->queryServiceProvider( L"stardiv.vcl.MenuBar" );
	XInterfaceRef xIFace( xSSI->createInstance(), USR_QUERY );
	XMenuBarRef xMenuBar( xIFace, USR_QUERY );
	xMenuBar->insertItem( 1, L"Item1", 0, 0x7FFF );
	xMenuBar->insertItem( 2, L"Item2", 0, 0x7FFF );

	// PopupMenu
	xSSI = xProv->queryServiceProvider( L"stardiv.vcl.PopupMenu" );
	xSSI->createInstance()->queryInterface( XInterface::getSmartUik(), xIFace );
	XPopupMenuRef xPopupMenu( xIFace, USR_QUERY );
	xPopupMenu->insertItem( 1, L"Sub1", 0, 0x7FFF );
	xPopupMenu->insertItem( 2, L"Sub2", 0, 0x7FFF );
	xPopupMenu->insertItem( 3, L"Sub3", 0, 0x7FFF );

	// PopupMenu2
	xSSI = xProv->queryServiceProvider( L"stardiv.vcl.PopupMenu" );
	xSSI->createInstance()->queryInterface( XInterface::getSmartUik(), xIFace );
	XPopupMenuRef xPopupMenu2( xIFace, USR_QUERY );
	xPopupMenu2->insertItem( 1, L"Sub1 - 222", 0, 0x7FFF );
	xPopupMenu2->insertItem( 2, L"Sub2 - 222", 0, 0x7FFF );
	xPopupMenu2->insertItem( 3, L"Sub3 - 222", 0, 0x7FFF );


	// PopupMenu3
	xSSI = xProv->queryServiceProvider( L"stardiv.vcl.PopupMenu" );
	xSSI->createInstance()->queryInterface( XInterface::getSmartUik(), xIFace );
	XPopupMenuRef xPopupMenu3( xIFace, USR_QUERY );
	xPopupMenu3->insertItem( 1, L"Sub1 - 33333", 0, 0x7FFF );
	xPopupMenu3->insertItem( 2, L"Sub2 - 33333", 0, 0x7FFF );
	xPopupMenu3->insertItem( 3, L"Sub3 - 33333", 0, 0x7FFF );

	xMenuBar->setPopupMenu( 1, xPopupMenu );
	xMenuBar->setPopupMenu( 2, xPopupMenu2 );

	XWindowPeerRef xAppWinRef = aMainWin.GetComponentInterface( TRUE );
	XTopWindowRef xTopWindow( xAppWinRef, USR_QUERY );
	xTopWindow->setMenuBar( xMenuBar );


//	WindowDescriptor aDescr;
//	aDescr.WindowServiceName = L"dialog";
//	aDescr.Type = WindowClass_SIMPLE;
//	aDescr.Parent = Application::GetAppWindow()->GetComponentInterface( TRUE );
//	aDescr.WindowAttributes = WindowAttribute_BORDER;
//	aDescr.Bounds = Rectangle( Point( 50, 50 ), Size( 300, 200 ) );
//	XToolkitRef xToolkit = Application::GetVCLToolkit();
//	XWindowPeerRef xDlg = xToolkit->createWindow( aDescr );
//	XDialogRef xD( xDlg, USR_QUERY );
//	xD->execute();

	aMainWin.Show();

	xMenuBar->insertItem( 3, L"Item3", 0, 0x7FFF );
	xMenuBar->setPopupMenu( 3, xPopupMenu3 );
    Execute();
}

// -----------------------------------------------------------------------

MyWin::MyWin( Window* pParent, WinBits nWinStyle ) :
    WorkWindow( pParent, nWinStyle )
{
}

// -----------------------------------------------------------------------

void MyWin::MouseMove( const MouseEvent& rMEvt )
{
    WorkWindow::MouseMove( rMEvt );
}

// -----------------------------------------------------------------------

void MyWin::MouseButtonDown( const MouseEvent& rMEvt )
{
	GrabFocus();
	if ( rMEvt.GetClicks() == 2 )
	{
		if ( xWin )
		{
			Size aSz( 500, 300 );
			XToolkitRef xToolkit = Application::GetVCLToolkit();
			XDeviceRef xVDev = xToolkit->createScreenCompatibleDevice( aSz.Width(), aSz.Height() );
			XWindowPeerRef xAppWin = Application::GetAppWindow()->GetComponentInterface( TRUE );

			XDeviceRef		xD2( xWin, USR_QUERY );
			XDeviceRef		xD3( xAppWin, USR_QUERY );

			XGraphicsRef xG1 = xVDev->createGraphics();
			XGraphicsRef xG2 = xD2->createGraphics();
			XGraphicsRef xG3 = xD3->createGraphics();

			// XWin => VDev
			xG1->copy( xD2, 0, 0, aSz.Width(), aSz.Height(), 0, 0, aSz.Width(), aSz.Height() );

			xWin->dispose();
			xWin = (XWindowPeer*)NULL;

			Application::GetAppWindow()->Update();
			// XVDev => XAppWin
			xG3->copy( xVDev, 0, 0, aSz.Width(), aSz.Height(), 0, 0, aSz.Width(), aSz.Height() );
		}
		else
		{
			XToolkitRef xToolkit = Application::GetVCLToolkit();
			DBG_ASSERT( xToolkit, "No Toolkit!" );
			if ( xToolkit )
			{
				WindowDescriptor aDescr;
				aDescr.WindowServiceName = L"window";
				aDescr.Type = WindowClass_SIMPLE;
				aDescr.Parent = Application::GetAppWindow()->GetComponentInterface( TRUE );
				aDescr.WindowAttributes = WindowAttribute_SHOW|WindowAttribute_BORDER;
				aDescr.Bounds = Rectangle( Point( 50, 50 ), Size( 300, 200 ) );
				XWindowPeerRef xWinPeer = xToolkit->createWindow( aDescr );
				xWin = xWinPeer;
				if ( !xWin )
					ErrorBox( this, WB_OK, "No Component!" ).Execute();
				else
				{
					XServiceManagerRef xProv = getGlobalServiceManager();
					XServiceProviderRef xSSI = xProv->queryServiceProvider( L"stardiv.vcl.Pointer" );
					XPointerRef xP( xSSI->createInstance(), USR_QUERY );
					xP->setType( SystemPointer_REFHAND );
					xWinPeer->setPointer( xP );
					// Edit
					{
						WindowDescriptor aDescr;
						aDescr.Type = WindowClass_SIMPLE;
						aDescr.WindowServiceName = L"PatternField";
						aDescr.Bounds = Rectangle( Point( 10, 10 ), Size( 200, 60 ) );
						aDescr.WindowAttributes = WindowAttribute_SHOW|WindowAttribute_BORDER|VclWindowPeerAttribute_VSCROLL|VclWindowPeerAttribute_SPIN;
						xWin->queryInterface( XWindowPeer::getSmartUik(), aDescr.Parent );
						XWindowPeerRef xEdit = xToolkit->createWindow( aDescr );
						XSpinFieldRef xSpin( xEdit, USR_QUERY );
						xSpin->enableRepeat( TRUE );
						XPatternFieldRef xPatternField( xEdit, USR_QUERY );
						xPatternField->setMasks( L"aaNN", L"" );
						xPatternField->setStrictFormat( TRUE );



/*
						VCLXComponent* pVCLComponent =
							(VCLXComponent*) xEdit->getImplementation( VCLXComponent_getReflection() );
						if ( pVCLComponent )
						{
							Window* pWindow = pVCLComponent->GetWindow();
							pWindow->SetBackground( Wallpaper( COL_LIGHTBLUE ) );
							AllSettings aSettings( pWindow->GetSettings() );
							StyleSettings aStyle = aSettings.GetStyleSettings();
							aStyle.SetFieldTextColor( COL_YELLOW );
							aStyle.SetFieldColor( COL_LIGHTBLUE );
							aSettings.SetStyleSettings( aStyle );
							pWindow->SetSettings( aSettings );
							pWindow->Invalidate();
						}
*/
					}
					// Button
					{
						WindowDescriptor aDescr;
						aDescr.Type = WindowClass_SIMPLE;
						aDescr.WindowServiceName = L"PushButton";
						aDescr.Bounds = Rectangle( Point( 30, 80 ), Size( 60, 20 ) );
						aDescr.WindowAttributes = WindowAttribute_SHOW;
						xWin->queryInterface( XWindowPeer::getSmartUik(), aDescr.Parent );
						xButtonPeer = xToolkit->createWindow( aDescr );
						if ( xButtonPeer )
						{
							XButtonRef xButton( xButtonPeer, USR_QUERY );
							if ( xButton )
							{
								xButton->setLabel( L"Action!" );
								xButton->addActionListener( new MyActionListener );
							}
						}
					}
/*
					// FileDialog
					{
						WindowDecriptor aDescr;
						aDescr.Type = VCLCOMPONENTTYPE_CONTAINER;
						aDescr.ComponentServiceName = L"filedialog_open";
						aDescr.WindowAttributes = WindowAttribute_MOVEABLE|WindowAttribute_CLOSEABLE;
						aDescr.Parent = (XWindowPeer*)xWin->queryInterface( XWindowPeer::getSmartUik() );
						XWindowPeerRef xDlg = xToolkit->createComponent( aDescr );
						XDialogRef xD = (XDialog*) xDlg->queryInterface( XDialog::getSmartUik() );
						xD->execute();
					}
*/
				}

#if OSL_DEBUG_LEVEL > 1
				Window* pTest = new WorkWindow( NULL, 0 );
				XWindowPeer* pComp = pTest->GetComponentInterface( TRUE );
				int i = 0;
#endif
			}
		}

	}
    WorkWindow::MouseButtonDown( rMEvt );
}

// -----------------------------------------------------------------------

void MyWin::MouseButtonUp( const MouseEvent& rMEvt )
{
    WorkWindow::MouseButtonUp( rMEvt );
}

// -----------------------------------------------------------------------

void MyWin::KeyInput( const KeyEvent& rKEvt )
{
	if ( rKEvt.GetCharCode() == 'x' )
	{
		if( xWin )
		{
			XGraphicsRef xGrf( xWin, USR_QUERY );
			DBG_ASSERT( xGrf, "No Graphics!" );
			if ( xGrf )
			{
				xGrf->drawLine( 0, 0, 50, 50 );
				xGrf->drawLine( 50, 0, 0, 50 );

				EmptyFontDescriptor aFD;
				aFD.Slant = FontSlant_ITALIC;
				xGrf->selectFont( aFD );
				xGrf->drawText( 10, 60, L"SmartUNO..." );
			}
		}
	}
	else if ( rKEvt.GetCharCode() == '+' )
	{
		if( xWin )
		{
			XWindowRef xW( xWin, USR_QUERY );
			Rectangle aR = xW->getPosSize();
			aR.Right() += 10;
			aR.Bottom() += 10;
			xW->setPosSize( aR.Left(), aR.Top(), aR.GetWidth(), aR.GetHeight(), PosSize_POSSIZE );
		}
	}
	else if ( rKEvt.GetCharCode() == '-' )
	{
		if( xWin )
		{
			XWindowRef xW( xWin, USR_QUERY );
			Rectangle aR = xW->getPosSize();
			aR.Right() -= 10;
			aR.Bottom() -= 10;
			xW->setPosSize( aR.Left(), aR.Top(), aR.GetWidth(), aR.GetHeight(), PosSize_POSSIZE );
		}
	}
	else if ( rKEvt.GetCharCode() == 'l' )
	{
		if( xWin )
		{
			XWindowRef xW( xWin, USR_QUERY );
			if ( xLst )
				xW->removeWindowListener( xLst );

			MyCompListener* pLst = new MyCompListener;
			xLst = pLst;
			xW->addWindowListener( xLst );
		}
	}
	else if ( rKEvt.GetCharCode() == 'j' )
	{
		if( xButtonPeer )
		{
			XWindowRef xW( xButtonPeer, USR_QUERY );
			Rectangle aBounds = xW->getPosSize();
			aBounds.Move( 10, 10 );
			xW->setPosSize( aBounds.Left(), aBounds.Top(), aBounds.GetWidth(), aBounds.GetHeight(), PosSize_POSSIZE );
		}
	}

    WorkWindow::KeyInput( rKEvt );
}

// -----------------------------------------------------------------------

void MyWin::KeyUp( const KeyEvent& rKEvt )
{
    WorkWindow::KeyUp( rKEvt );
}

// -----------------------------------------------------------------------

void MyWin::Paint( const Rectangle& rRect )
{
    WorkWindow::Paint( rRect );
}

// -----------------------------------------------------------------------

void MyWin::Resize()
{
    WorkWindow::Resize();
}
