/*************************************************************************
 *
 *  $RCSfile: intn2.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/10/30 13:59:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define private public

#ifndef _INTN_HXX
#include <intn.hxx>
#endif
#ifndef _INTNTAB_HXX
#include <intntab.hxx>
#endif
#ifndef _DEBUG_HXX
#include <debug.hxx>
#endif

// =======================================================================

DBG_NAMEEX( International );
DBG_NAMEEX( LanguageTable );
DBG_NAMEEX( FormatTable );

// =======================================================================

LanguageTable& LanguageTable::operator=( const LanguageTable& rTable )
{
	DBG_CHKTHIS( LanguageTable, NULL );
	DBG_CHKOBJ( &rTable, LanguageTable, NULL );

	eLanguage		= rTable.eLanguage;
	pTypeProc		= rTable.pTypeProc;
	pLowerProc		= rTable.pLowerProc;
	pUpperProc		= rTable.pUpperProc;
	pCompareProc	= rTable.pCompareProc;
	pIndexProc		= rTable.pIndexProc;

	USHORT i;
	for ( i = 0; i < DAYOFWEEK_COUNT; i++ )
		*pDayText[i] = *(rTable.pDayText[i]);
	for ( i = 0; i < DAYOFWEEK_COUNT; i++ )
		*pAbbrevDayText[i] = *(rTable.pAbbrevDayText[i]);
	for ( i = 0; i < MONTH_COUNT; i++ )
		*pMonthText[i] = *(rTable.pMonthText[i]);
	for ( i = 0; i < MONTH_COUNT; i++ )
		*pAbbrevMonthText[i] = *(rTable.pAbbrevMonthText[i]);
	for ( i = 0; i < FOLLOWTEXT_COUNT; i++ )
		pFollowingText[i] = new XubString( *(rTable.pFollowingText[i]) );

	meQuotationMarkStart		= rTable.meQuotationMarkStart;
	meQuotationMarkEnd			= rTable.meQuotationMarkEnd;
	meQuotationMarkStart2		= rTable.meQuotationMarkStart2;
	meQuotationMarkEnd2 		= rTable.meQuotationMarkEnd2;
	meDoubleQuotationMarkStart	= rTable.meDoubleQuotationMarkStart;
	meDoubleQuotationMarkEnd	= rTable.meDoubleQuotationMarkEnd;
	meDoubleQuotationMarkStart2 = rTable.meDoubleQuotationMarkStart2;
	meDoubleQuotationMarkEnd2	= rTable.meDoubleQuotationMarkEnd2;

	return *this;
}

// -----------------------------------------------------------------------

BOOL LanguageTable::operator==( const LanguageTable& rTable ) const
{
	DBG_CHKTHIS( LanguageTable, NULL );
	DBG_CHKOBJ( &rTable, LanguageTable, NULL );

	if ( (eLanguage 					== rTable.eLanguage)					&&
		 (meQuotationMarkStart			== rTable.meQuotationMarkStart) 		&&
		 (meQuotationMarkEnd			== rTable.meQuotationMarkEnd)			&&
		 (meQuotationMarkStart2 		== rTable.meQuotationMarkStart2)		&&
		 (meQuotationMarkEnd2			== rTable.meQuotationMarkEnd2)			&&
		 (meDoubleQuotationMarkStart	== rTable.meDoubleQuotationMarkStart)	&&
		 (meDoubleQuotationMarkEnd		== rTable.meDoubleQuotationMarkEnd) 	&&
		 (meDoubleQuotationMarkStart2	== rTable.meDoubleQuotationMarkStart2)	&&
		 (meDoubleQuotationMarkEnd2 	== rTable.meDoubleQuotationMarkEnd2)	&&
		 (pTypeProc 					== rTable.pTypeProc)					&&
		 (pLowerProc					== rTable.pLowerProc)					&&
		 (pUpperProc					== rTable.pUpperProc)					&&
		 (pCompareProc					== rTable.pCompareProc) 				&&
		 (pIndexProc					== rTable.pIndexProc) )
	{
		USHORT i;
		for ( i = 0; i < DAYOFWEEK_COUNT; i++ )
		{
			if ( *pDayText[i] != *(rTable.pDayText[i]) )
				return FALSE;
		}
		for ( i = 0; i < DAYOFWEEK_COUNT; i++ )
		{
			if ( *pAbbrevDayText[i] != *(rTable.pAbbrevDayText[i]) )
				return FALSE;
		}
		for ( i = 0; i < MONTH_COUNT; i++ )
		{
			if ( *pMonthText[i] != *(rTable.pMonthText[i]) )
				return FALSE;
		}
		for ( i = 0; i < MONTH_COUNT; i++ )
		{
			if ( *pAbbrevMonthText[i] != *(rTable.pAbbrevMonthText[i]) )
				return FALSE;
		}
		for ( i = 0; i < FOLLOWTEXT_COUNT; i++ )
		{
			if ( *pFollowingText[i] != *(rTable.pFollowingText[i]) )
				return FALSE;
		}

		return TRUE;
	}
	else
		return FALSE;
}

// =======================================================================

FormatTable& FormatTable::operator=( const FormatTable& rTable )
{
	DBG_CHKTHIS( FormatTable, NULL );
	DBG_CHKOBJ( &rTable, FormatTable, NULL );

	eLanguage					= rTable.eLanguage;
	eWeekStart					= rTable.eWeekStart;
	eWeekCountStart 			= rTable.eWeekCountStart;
	eDateFormat 				= rTable.eDateFormat;
	cDateSep					= rTable.cDateSep;
	bDateDayLeadingZero 		= rTable.bDateDayLeadingZero;
	bDateMonthLeadingZero		= rTable.bDateMonthLeadingZero;
	bDateCentury				= rTable.bDateCentury;
	eLongDateFormat 			= rTable.eLongDateFormat;
	eLongDateDayOfWeekFormat	= rTable.eLongDateDayOfWeekFormat;
	aLongDateDayOfWeekSep		= rTable.aLongDateDayOfWeekSep;
	bLongDateDayLeadingZero 	= rTable.bLongDateDayLeadingZero;
	aLongDateDaySep 			= rTable.aLongDateDaySep;
	eLongDateMonthFormat		= rTable.eLongDateMonthFormat;
	aLongDateMonthSep			= rTable.aLongDateMonthSep;
	bLongDateCentury			= rTable.bLongDateCentury;
	aLongDateYearSep			= rTable.aLongDateYearSep;
	eTimeFormat 				= rTable.eTimeFormat;
	cTimeSep					= rTable.cTimeSep;
	cTime100SecSep				= rTable.cTime100SecSep;
	bTimeLeadingZero			= rTable.bTimeLeadingZero;
	aTimeAM 					= rTable.aTimeAM;
	aTimePM 					= rTable.aTimePM;
	aTimeStr					= rTable.aTimeStr;
	cNumThousandSep 			= rTable.cNumThousandSep;
	bNumThousandSep 			= rTable.bNumThousandSep;
	cNumDecimalSep				= rTable.cNumDecimalSep;
	bNumLeadingZero 			= rTable.bNumLeadingZero;
	nNumDigits					= rTable.nNumDigits;
	bNumTrailingZeros			= rTable.bNumTrailingZeros;
	nCurrPositiveFormat 		= rTable.nCurrPositiveFormat;
	nCurrNegativeFormat 		= rTable.nCurrNegativeFormat;
	aCurrSymbol 				= rTable.aCurrSymbol;
	aCurrBankSymbol 			= rTable.aCurrBankSymbol;
	aCurrSymbol2				= rTable.aCurrSymbol2;
	aCurrBankSymbol2			= rTable.aCurrBankSymbol2;
	nCurrDigits 				= rTable.nCurrDigits;
	cCurrZeroChar				= rTable.cCurrZeroChar;
	cListSep					= rTable.cListSep;
	nPercentFormat				= rTable.nPercentFormat;
	eMeasurementSystem			= rTable.eMeasurementSystem;

	return *this;
}

// -----------------------------------------------------------------------

BOOL FormatTable::operator==( const FormatTable& rTable ) const
{
	DBG_CHKTHIS( FormatTable, NULL );
	DBG_CHKOBJ( &rTable, FormatTable, NULL );

	if ( (eLanguage 					== rTable.eLanguage)					&&
		 (eWeekStart					== rTable.eWeekStart)					&&
		 (eWeekCountStart				== rTable.eWeekCountStart)				&&
		 (eDateFormat					== rTable.eDateFormat)					&&
		 (cDateSep						== rTable.cDateSep) 					&&
		 (bDateDayLeadingZero			== rTable.bDateDayLeadingZero)			&&
		 (bDateMonthLeadingZero 		== rTable.bDateMonthLeadingZero)		&&
		 (bDateCentury					== rTable.bDateCentury) 				&&
		 (eLongDateFormat				== rTable.eLongDateFormat)				&&
		 (eLongDateDayOfWeekFormat		== rTable.eLongDateDayOfWeekFormat) 	&&
		 (aLongDateDayOfWeekSep 		== rTable.aLongDateDayOfWeekSep)		&&
		 (bLongDateDayLeadingZero		== rTable.bLongDateDayLeadingZero)		&&
		 (aLongDateDaySep				== rTable.aLongDateDaySep)				&&
		 (eLongDateMonthFormat			== rTable.eLongDateMonthFormat) 		&&
		 (aLongDateMonthSep 			== rTable.aLongDateMonthSep)			&&
		 (bLongDateCentury				== rTable.bLongDateCentury) 			&&
		 (aLongDateYearSep				== rTable.aLongDateYearSep) 			&&
		 (eTimeFormat					== rTable.eTimeFormat)					&&
		 (cTimeSep						== rTable.cTimeSep) 					&&
		 (cTime100SecSep				== rTable.cTime100SecSep)				&&
		 (bTimeLeadingZero				== rTable.bTimeLeadingZero) 			&&
		 (aTimeAM						== rTable.aTimeAM)						&&
		 (aTimePM						== rTable.aTimePM)						&&
		 (aTimeStr						== rTable.aTimeStr) 					&&
		 (cNumThousandSep				== rTable.cNumThousandSep)				&&
		 (bNumThousandSep				== rTable.bNumThousandSep)				&&
		 (cNumDecimalSep				== rTable.cNumDecimalSep)				&&
		 (bNumLeadingZero				== rTable.bNumLeadingZero)				&&
		 (nNumDigits					== rTable.nNumDigits)					&&
		 (bNumTrailingZeros 			== rTable.bNumTrailingZeros)			&&
		 (nCurrPositiveFormat			== rTable.nCurrPositiveFormat)			&&
		 (nCurrNegativeFormat			== rTable.nCurrNegativeFormat)			&&
		 (aCurrSymbol					== rTable.aCurrSymbol)					&&
		 (aCurrBankSymbol				== rTable.aCurrBankSymbol)				&&
		 (aCurrSymbol2					== rTable.aCurrSymbol2) 				&&
		 (aCurrBankSymbol2				== rTable.aCurrBankSymbol2) 			&&
		 (nCurrDigits					== rTable.nCurrDigits)					&&
		 (cCurrZeroChar 				== rTable.cCurrZeroChar)				&&
		 (cListSep						== rTable.cListSep) 					&&
		 (nPercentFormat				== rTable.nPercentFormat)				&&
		 (eMeasurementSystem			== rTable.eMeasurementSystem) )
		return TRUE;
	else
		return FALSE;
}

// =======================================================================

void ImplCopyIntnData( International* pIntn )
{
	// Neue Daten anlegen und kopieren
	InternationalData* pNewData = new InternationalData;
	pNewData->nRefCount 		= 0;
	pNewData->bStaticLang		= pIntn->pData->bStaticLang;
	pNewData->bStaticFormat 	= pIntn->pData->bStaticFormat;
	if ( pNewData->bStaticLang )
		pNewData->pLanguage = pIntn->pData->pLanguage;
	else
		pNewData->pLanguage = new LanguageTable( *(pIntn->pData->pLanguage));
	if ( pNewData->bStaticFormat )
		pNewData->pFormat = pIntn->pData->pFormat;
	else
		pNewData->pFormat = new FormatTable(*(pIntn->pData->pFormat));
	pIntn->pData->nRefCount--;
	pIntn->pData = pNewData;
}

// -----------------------------------------------------------------------

static void ImplCopyIntnLangData( International* pIntn )
{
	// Nur wenn Daten mehrfach referenziert werden, muss kopiert werden
	if ( pIntn->pData->nRefCount )
		ImplCopyIntnData( pIntn );

	if ( pIntn->pData->bStaticLang )
	{
		pIntn->pData->pLanguage = new LanguageTable(*(pIntn->pData->pLanguage));
		pIntn->pData->bStaticLang = FALSE;
	}
}

// -----------------------------------------------------------------------

static void ImplCopyIntnFormatData( International* pIntn )
{
	// Nur wenn Daten mehrfach referenziert werden, muss kopiert werden
	if ( pIntn->pData->nRefCount )
		ImplCopyIntnData( pIntn );

	if ( pIntn->pData->bStaticFormat )
	{
		pIntn->pData->pFormat = new FormatTable(*(pIntn->pData->pFormat));
		pIntn->pData->bStaticFormat = FALSE;
	}
}

// =======================================================================

void International::SetQuotationMarkStart( QuotationMark eQuotationMark )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnLangData( this );
	pData->pLanguage->SetQuotationMarkStart( eQuotationMark );
}

// -----------------------------------------------------------------------

void International::SetQuotationMarkEnd( QuotationMark eQuotationMark )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnLangData( this );
	pData->pLanguage->SetQuotationMarkEnd( eQuotationMark );
}

// -----------------------------------------------------------------------

void International::SetQuotationMarkStart2( QuotationMark eQuotationMark )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnLangData( this );
	pData->pLanguage->SetQuotationMarkStart2( eQuotationMark );
}

// -----------------------------------------------------------------------

void International::SetQuotationMarkEnd2( QuotationMark eQuotationMark )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnLangData( this );
	pData->pLanguage->SetQuotationMarkEnd2( eQuotationMark );
}

// -----------------------------------------------------------------------

void International::SetDoubleQuotationMarkStart( QuotationMark eQuotationMark )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnLangData( this );
	pData->pLanguage->SetDoubleQuotationMarkStart( eQuotationMark );
}

// -----------------------------------------------------------------------

void International::SetDoubleQuotationMarkEnd( QuotationMark eQuotationMark )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnLangData( this );
	pData->pLanguage->SetDoubleQuotationMarkEnd( eQuotationMark );
}

// -----------------------------------------------------------------------

void International::SetDoubleQuotationMarkStart2( QuotationMark eQuotationMark )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnLangData( this );
	pData->pLanguage->SetDoubleQuotationMarkStart2( eQuotationMark );
}

// -----------------------------------------------------------------------

void International::SetDoubleQuotationMarkEnd2( QuotationMark eQuotationMark )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnLangData( this );
	pData->pLanguage->SetDoubleQuotationMarkEnd2( eQuotationMark );
}

// -----------------------------------------------------------------------

void International::SetDayText( DayOfWeek eDay, const XubString& rStr )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnLangData( this );
	pData->pLanguage->SetDayText( eDay, rStr );
}

// -----------------------------------------------------------------------

void International::SetAbbrevDayText( DayOfWeek eDay, const XubString& rStr )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnLangData( this );
	pData->pLanguage->SetAbbrevDayText( eDay, rStr );
}

// -----------------------------------------------------------------------

void International::SetMonthText( USHORT nMonth, const XubString& rStr )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnLangData( this );
	pData->pLanguage->SetMonthText( nMonth, rStr );
}

// -----------------------------------------------------------------------

void International::SetAbbrevMonthText( USHORT nMonth, const XubString& rStr )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnLangData( this );
	pData->pLanguage->SetAbbrevMonthText( nMonth, rStr );
}

// -----------------------------------------------------------------------

void International::SetFollowingText( FollowingText eText, const XubString& rStr )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnLangData( this );
	pData->pLanguage->SetFollowingText( eText, rStr );
}

// -----------------------------------------------------------------------

void International::SetWeekStart( DayOfWeek eDay )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetWeekStart( eDay );
}

// -----------------------------------------------------------------------

void International::SetWeekCountStart( WeekCountStart eStart )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetWeekCountStart( eStart );
}

// -----------------------------------------------------------------------

void International::SetDateFormat( DateFormat eFormat )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetDateFormat( eFormat );
}

// -----------------------------------------------------------------------

void International::SetDateSep( xub_Unicode cSep )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetDateSep( cSep );
}

// -----------------------------------------------------------------------

void International::SetDateDayLeadingZero( BOOL bLeading )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetDateDayLeadingZero( bLeading );
}

// -----------------------------------------------------------------------

void International::SetDateMonthLeadingZero( BOOL bLeading )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetDateMonthLeadingZero( bLeading );
}

// -----------------------------------------------------------------------

void International::SetDateCentury( BOOL bCentury )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetDateCentury( bCentury );
}

// -----------------------------------------------------------------------

void International::SetLongDateFormat( DateFormat eFormat )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetLongDateFormat( eFormat );
}

// -----------------------------------------------------------------------

void International::SetLongDateDayOfWeekFormat( DayOfWeekFormat eFormat )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetLongDateDayOfWeekFormat( eFormat );
}

// -----------------------------------------------------------------------

void International::SetLongDateDayOfWeekSep( const XubString& rStr )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetLongDateDayOfWeekSep( rStr );
}

// -----------------------------------------------------------------------

void International::SetLongDateDayLeadingZero( BOOL bLeading )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetLongDateDayLeadingZero( bLeading );
}

// -----------------------------------------------------------------------

void International::SetLongDateDaySep( const XubString& rStr )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetLongDateDaySep( rStr );
}

// -----------------------------------------------------------------------

void International::SetLongDateMonthFormat( MonthFormat eFormat )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetLongDateMonthFormat( eFormat );
}

// -----------------------------------------------------------------------

void International::SetLongDateMonthSep( const XubString& rStr )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetLongDateMonthSep( rStr );
}

// -----------------------------------------------------------------------

void International::SetLongDateCentury( BOOL bCentury )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetLongDateCentury( bCentury );
}

// -----------------------------------------------------------------------

void International::SetLongDateYearSep( const XubString& rStr )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetLongDateYearSep( rStr );
}

// -----------------------------------------------------------------------

void International::SetTimeFormat( TimeFormat eFormat )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetTimeFormat( eFormat );
}

// -----------------------------------------------------------------------

void International::SetTimeSep( xub_Unicode cSep )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetTimeSep( cSep );
}

// -----------------------------------------------------------------------

void International::SetTime100SecSep( xub_Unicode cSep )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetTime100SecSep( cSep );
}

// -----------------------------------------------------------------------

void International::SetTimeLeadingZero( BOOL bLeading )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetTimeLeadingZero( bLeading );
}

// -----------------------------------------------------------------------

void International::SetTimeAM( const XubString& rStr )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetTimeAM( rStr );
}

// -----------------------------------------------------------------------

void International::SetTimePM( const XubString& rStr )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetTimePM( rStr );
}

// -----------------------------------------------------------------------

void International::SetTimeStr( const XubString& rStr )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetTimeStr( rStr );
}

// -----------------------------------------------------------------------

void International::SetNumThousandSep( xub_Unicode cSep )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetNumThousandSep( cSep );
}

// -----------------------------------------------------------------------

void International::EnableNumThousandSep( BOOL bSep )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->EnableNumThousandSep( bSep );
}

// -----------------------------------------------------------------------

void International::SetNumDecimalSep( xub_Unicode cSep )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetNumDecimalSep( cSep );
}

// -----------------------------------------------------------------------

void International::SetNumLeadingZero( BOOL bLeading )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetNumLeadingZero( bLeading );
}

// -----------------------------------------------------------------------

void International::SetNumDigits( USHORT nDigits )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetNumDigits( nDigits );
}

// -----------------------------------------------------------------------

void International::SetNumTrailingZeros( BOOL bNumTrailingZeros )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetNumTrailingZeros( bNumTrailingZeros );
}

// -----------------------------------------------------------------------

void International::SetCurrPositiveFormat( USHORT nFormat )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetCurrPositiveFormat( nFormat );
}

// -----------------------------------------------------------------------

void International::SetCurrNegativeFormat( USHORT nFormat )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetCurrNegativeFormat( nFormat );
}

// -----------------------------------------------------------------------

void International::SetCurrSymbol( const XubString& rSymbol )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetCurrSymbol( rSymbol );
}

// -----------------------------------------------------------------------

void International::SetCurrBankSymbol( const XubString& rSymbol )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetCurrBankSymbol( rSymbol );
}

// -----------------------------------------------------------------------

void International::SetCurrSymbol2( const XubString& rSymbol2 )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetCurrSymbol2( rSymbol2 );
}

// -----------------------------------------------------------------------

void International::SetCurrBankSymbol2( const XubString& rSymbol2 )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetCurrBankSymbol2( rSymbol2 );
}

// -----------------------------------------------------------------------

void International::SetCurrDigits( USHORT nDigits )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetCurrDigits( nDigits );
}

// -----------------------------------------------------------------------

void International::SetCurrZeroChar( xub_Unicode cZeroChar )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetCurrZeroChar( cZeroChar );
}

// -----------------------------------------------------------------------

void International::SetListSep( xub_Unicode cListSep )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetListSep( cListSep );
}

// -----------------------------------------------------------------------

void International::SetPercentFormat( USHORT nFormat )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetPercentFormat( nFormat );
}

// -----------------------------------------------------------------------

void International::SetMeasurementSystem( MeasurementSystem eSystem )
{
	DBG_CHKTHIS( International, NULL );

	ImplCopyIntnFormatData( this );
	pData->pFormat->SetMeasurementSystem( eSystem );
}

// -----------------------------------------------------------------------

BOOL International::operator==( const International& rIntn ) const
{
	DBG_CHKTHIS( International, NULL );
	DBG_CHKOBJ( &rIntn, International, NULL );

	if ( pData == rIntn.pData )
		return TRUE;

	if ( (*(pData->pLanguage) == *(rIntn.pData->pLanguage) ) &&
		 (*(pData->pFormat)   == *(rIntn.pData->pFormat)   ) )
		return TRUE;
	else
		return FALSE;
}

// -----------------------------------------------------------------------

void International::RegisterLanguage( const LanguageTable& rTable )
{
	ImplRegisterLanguageData* pPrev = NULL;
	ImplRegisterLanguageData* pData = ImplGetFirstLanguageData();
	while ( pData )
	{
		// Table gefunden, dann ersetzen
		if ( pData->eLanguage == rTable.eLanguage )
			break;

		pPrev = pData;
		pData = pData->pNext;
	}

	if ( !pData )
	{
		pData = new ImplRegisterLanguageData;
		pData->pTable	= NULL;
		pData->pNext	= NULL;
		pPrev->pNext	= pData;
	}

	pData->eLanguage	= rTable.eLanguage;
	pData->bStandard	= FALSE;
	pData->bSystem		= FALSE;

	// Tabelle kopieren oder ersetzen
	if ( pData->pTable )
		*(pData->pTable) = rTable;
	else
		pData->pTable = new LanguageTable( rTable );
}

// -----------------------------------------------------------------------

BOOL International::IsLanguageAvailable( LanguageType eLanguage )
{
	ImplRegisterLanguageData* pData = ImplGetFirstLanguageData();
	while ( pData )
	{
		// Table gefunden, dann ersetzen
		if ( pData->eLanguage == eLanguage )
			return TRUE;

		pData = pData->pNext;
	}

	return FALSE;
}

// -----------------------------------------------------------------------

USHORT International::GetAvailableLanguageCount()
{
	USHORT						n = 0;
	ImplRegisterLanguageData*	pData = ImplGetFirstLanguageData();
	while ( pData )
	{
		n++;
		pData = pData->pNext;
	}

	return n;
}

// -----------------------------------------------------------------------

LanguageType International::GetAvailableLanguage( USHORT nIndex )
{
	USHORT						n = 0;
	ImplRegisterLanguageData*	pData = ImplGetFirstLanguageData();
	while ( pData )
	{
		if ( n == nIndex )
			return pData->eLanguage;

		n++;
		pData = pData->pNext;
	}

	return LANGUAGE_DONTKNOW;
}

// -----------------------------------------------------------------------

void International::RegisterFormat( const FormatTable& rTable )
{
	ImplRegisterFormatData* pPrev = NULL;
	ImplRegisterFormatData* pData = ImplGetFirstFormatData();
	while ( pData )
	{
		// Table gefunden, dann ersetzen
		if ( pData->eLanguage == rTable.eLanguage )
			break;

		pPrev = pData;
		pData = pData->pNext;
	}

	if ( !pData )
	{
		pData			= new ImplRegisterFormatData;
		pData->pTable	= NULL;
		pData->pNext	= NULL;
		pPrev->pNext	= pData;
	}

	pData->eLanguage	= rTable.eLanguage;
	pData->bStandard	= FALSE;
	pData->bSystem		= FALSE;

	// Tabelle kopieren oder ersetzen
	if ( pData->pTable )
		*(pData->pTable) = rTable;
	else
		pData->pTable = new FormatTable( rTable );
}

// -----------------------------------------------------------------------

BOOL International::IsFormatAvailable( LanguageType eLanguage )
{
	ImplRegisterFormatData* pData = ImplGetFirstFormatData();
	while ( pData )
	{
		// Table gefunden, dann ersetzen
		if ( pData->eLanguage == eLanguage )
			return TRUE;

		pData = pData->pNext;
	}

	return FALSE;
}

// -----------------------------------------------------------------------

USHORT International::GetAvailableFormatCount()
{
	USHORT					n = 0;
	ImplRegisterFormatData* pData = ImplGetFirstFormatData();
	while ( pData )
	{
		n++;
		pData = pData->pNext;
	}

	return n;
}

// -----------------------------------------------------------------------

LanguageType International::GetAvailableFormat( USHORT nIndex )
{
	USHORT					n = 0;
	ImplRegisterFormatData* pData = ImplGetFirstFormatData();
	while ( pData )
	{
		if ( n == nIndex )
			return pData->eLanguage;

		n++;
		pData = pData->pNext;
	}

	return LANGUAGE_DONTKNOW;
}
