/*************************************************************************
 *
 *  $RCSfile: shortcut.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SHORTCUT_HXX
#define _SHORTCUT_HXX

#include <string.hxx>
#include <list.hxx>
#include <fastfsys.hxx>


class KeyValue
{
public:
	KeyValue( const String & crName, const String & crValue );
	KeyValue( const KeyValue & crKeyValue );
	virtual ~KeyValue();

	KeyValue & operator = ( const KeyValue & crKeyValue );

	virtual const String & GetName() const;
	virtual const String & GetValue() const;

	virtual void SetName( const String & crName );
	virtual void SetValue( const String & crValue );
protected:
	String	m_aName;
	String	m_aValue;
private:
	KeyValue();
};


//---------------------------------------------------------------------------
// Impl_Shortcut declaration
//---------------------------------------------------------------------------

DECLARE_LIST( KeyValueList, KeyValue * );

class Impl_Shortcut : public IfcShortcut
{
public:
	Impl_Shortcut( const String & crLanguage, const ItemIDPath & crFolderIDPath );
	virtual ~Impl_Shortcut();

	virtual UINT32 GetValueNameCount() const;
	virtual const String& GetValueName( UINT32 nIndex ) const;

	virtual const String& GetValueContent( const String & crValueName ) const;
	virtual void SetValueContent( const String & crValueName, const String & crValueContent );

	virtual FSysError Load( const ItemIDPath & crIDPath );
	virtual FSysError Store( const String & crTitle, ItemIDPath & rNewIDPath,
		ShortcutFormat ePreferred = SHORTCUT_FORMAT_BESTFIT );
protected:
	KeyValueList	m_aList;
	ShortcutFormat	m_eLoadedFormat;
	String			m_aFolderPath;
	ItemIDPath		m_aFolderIDPath;
	String			m_aLanguage;
	String			m_aCurrentFilePath;

	virtual KeyValue	*FindKeyByName( const String & crName ) const;
	virtual String		GetFilePathFromTitle( const String & crTitle, ShortcutFormat eFormat );
	virtual BOOL		HasExtendedKeys() const;

	virtual FSysError	StoreURL( const String & crTitle, ItemIDPath & rPath );
	virtual FSysError	StoreLink( const String & crTitle, ItemIDPath & rPath );
	virtual FSysError	LoadURL( const String & crFileName );
	virtual FSysError	LoadLink( const String & crFileName );

	virtual void DeleteListItems();

private:
	Impl_Shortcut();
	Impl_Shortcut( const Impl_Shortcut & );
	Impl_Shortcut & operator = ( const Impl_Shortcut & );
};


#endif // _SHORTCUT_HXX
