/*************************************************************************
 *
 *  $RCSfile: rmtpclst.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: kso $ $Date: 2000/10/16 14:54:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UCPRMT_RMTPCLST_HXX_
#include <rmtpclst.hxx>
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTYCHANGEEVENT_HPP_
#include <com/sun/star/beans/PropertyChangeEvent.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XEVENTLISTENER_HPP_
#include <com/sun/star/lang/XEventListener.hpp>
#endif

using namespace com::sun::star;
using namespace ucprmt;

//============================================================================
//
//  PropertiesChangeListener
//
//============================================================================

void
PropertiesChangeListener::addProperties(uno::Sequence< rtl::OUString > const &
										    rTheProperties)
{
	uno::Sequence< rtl::OUString >
		aNewProperties(m_aProperties.getLength()
					       + rTheProperties.getLength());
	rtl::OUString * pNew = aNewProperties.getArray();
	rtl::OUString * pIn = pNew;

	rtl::OUString const * p = m_aProperties.getConstArray();
	rtl::OUString const * pEnd = p + m_aProperties.getLength();
	for (; p != pEnd; ++p)
		*pIn++ = *p;

	p = rTheProperties.getConstArray();
	pEnd = p + rTheProperties.getLength();
	for (; p != pEnd; ++p)
	{
		bool bFound = false;
		for (rtl::OUString const * q = pNew; q != pIn; ++q)
			if (*q == *p)
			{
				bFound = true;
				break;
			}
		if (!bFound)
			*pIn++ = *p;
	}

	aNewProperties.realloc(pIn - pNew);
	m_aProperties = aNewProperties;
}

//============================================================================
bool PropertiesChangeListener::removeProperties(
	     uno::Sequence< rtl::OUString > const & rTheProperties)
{
	uno::Sequence< rtl::OUString > aNewProperties(m_aProperties.getLength());
	rtl::OUString * pNew = aNewProperties.getArray();
	rtl::OUString * pIn = pNew;

	rtl::OUString const * pOld = m_aProperties.getConstArray();
	rtl::OUString const * pOldEnd = pOld + m_aProperties.getLength();
	for (; pOld != pOldEnd; ++pOld)
	{
		bool bFound = false;
		rtl::OUString const * p = rTheProperties.getConstArray();
		rtl::OUString const * pEnd = p + rTheProperties.getLength();
		for (; p != pEnd; ++p)
			if (*p == *pOld)
			{
				bFound = true;
				break;
			}
		if (!bFound)
			*pIn++ = *pOld;
	}

	if (pIn == pNew)
		return false;

	aNewProperties.realloc(pIn - pNew);
	m_aProperties = aNewProperties;
	return true;
}

//============================================================================
bool PropertiesChangeListener::intersectsWith(
	     uno::Sequence< beans::PropertyChangeEvent > const & rEvt) const
{
	rtl::OUString const * p1 = m_aProperties.getConstArray();
	rtl::OUString const * p1End = p1 + m_aProperties.getLength();
	for (; p1 != p1End; ++p1)
	{
		beans::PropertyChangeEvent const * p2 = rEvt.getConstArray();
		beans::PropertyChangeEvent const * p2End = p2 + rEvt.getLength();
		for (; p2 != p2End; ++p2)
			if (*p1 == p2->PropertyName)
				return true;
	}
	return false;
}

//============================================================================
bool PropertiesChangeListener::subsetOf(
	     uno::Sequence< beans::PropertyChangeEvent > const & rEvt) const
{
	rtl::OUString const * p1 = m_aProperties.getConstArray();
	rtl::OUString const * p1End = p1 + m_aProperties.getLength();
	for (; p1 != p1End; ++p1)
	{
		beans::PropertyChangeEvent const * p2 = rEvt.getConstArray();
		beans::PropertyChangeEvent const * p2End = p2 + rEvt.getLength();
		bool bFound = false;
		for (; p2 != p2End; ++p2)
			if (*p1 == p2->PropertyName)
			{
				bFound = true;
				break;
			}
		if (!bFound)
			return false;
	}
	return true;
}

//============================================================================
//
//  PropertiesChangeListeners
//
//============================================================================

void PropertiesChangeListeners::dispose(lang::EventObject const & rSource)
{
	const_iterator aEnd(end());
	for (const_iterator aIt(begin()); aIt != aEnd; ++aIt)
	{
		uno::Reference< lang::XEventListener >
			xListener(aIt->getListener(), uno::UNO_QUERY);
		if (xListener.is())
			xListener->disposing(rSource);
	}
}

