/*************************************************************************
 *
 *  $RCSfile: rmtprov.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:54:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UCPRMT_RMTPROV_HXX_
#include <rmtprov.hxx>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_
#include <cppuhelper/typeprovider.hxx>
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _UCBHELPER_CONTENTIDENTIFIER_HXX
#include <ucbhelper/contentidentifier.hxx>
#endif

#ifndef _UCPRMT_RMTCONN_HXX_
#include <rmtconn.hxx>
#endif

// Definitions for RegexpToConnectionMap (Solaris wouldn't find explicit
// template instantiations for these in another compilation unit...):
#ifndef _UCB_REGEXPMAP_TPT_
#include <regexpmap.tpt>
#endif

using namespace com::sun;
using namespace com::sun::star;
using namespace ucprmt;

//============================================================================
//
//  ContentProvider
//
//============================================================================

bool ContentProvider::parseArguments(rtl::OUString const & rArguments,
                                     rtl::OUString * pRemoteProviderURL,
                                     bool * pOffline)
{
    *pOffline
        = rArguments.compareToAscii(RTL_CONSTASCII_STRINGPARAM("{offline}"))
              == 0;
    *pRemoteProviderURL
        = *pOffline ? rArguments.copy(RTL_CONSTASCII_LENGTH("{offline}")) :
                      rArguments;
    return true;
}

//============================================================================
ContentProvider::ContentProvider(
    uno::Reference< lang::XMultiServiceFactory > const & rTheFactory):
    m_xFactory(rTheFactory),
    m_xConnectionMap(new ConnectionMap(rTheFactory, this))
{
    OSL_ASSERT(m_xFactory.is());
}

//============================================================================
// virtual
uno::Any SAL_CALL ContentProvider::queryInterface(uno::Type const & rType)
    throw (uno::RuntimeException)
{
    uno::Any
        aRet(cppu::queryInterface(
                 rType,
                 static_cast< lang::XServiceInfo * >(this),
                 static_cast< lang::XTypeProvider * >(this),
                 static_cast< star::ucb::XContentProvider * >(this),
                 static_cast< star::ucb::XContentIdentifierFactory * >(this),
                 static_cast< star::ucb::XParameterizedContentProvider * >(
                     this)));
    return aRet.hasValue() ? aRet : OWeakObject::queryInterface(rType);
}

//============================================================================
// virtual
void SAL_CALL ContentProvider::acquire() throw ()
{
    OWeakObject::acquire();
}

//============================================================================
// virtual
void SAL_CALL ContentProvider::release() throw ()
{
    OWeakObject::release();
}

//============================================================================
// virtual
rtl::OUString SAL_CALL ContentProvider::getImplementationName()
    throw (uno::RuntimeException)
{
    return rtl::OUString::createFromAscii(getImplementationName_static());
}

//============================================================================
// virtual
sal_Bool SAL_CALL ContentProvider::supportsService(rtl::OUString const &
                                                       rServiceName)
    throw (uno::RuntimeException)
{
    uno::Sequence< rtl::OUString > aNames(getSupportedServiceNames_static());
    for (sal_Int32 i = 0; i < aNames.getLength(); ++i)
        if (aNames[i] == rServiceName)
            return true;
    return false;
}

//============================================================================
// virtual
uno::Sequence< rtl::OUString > SAL_CALL
ContentProvider::getSupportedServiceNames() throw (uno::RuntimeException)
{
    return getSupportedServiceNames_static();
}

//============================================================================
// virtual
uno::Sequence< uno::Type > SAL_CALL ContentProvider::getTypes()
    throw (uno::RuntimeException)
{
    static cppu::OTypeCollection * pCollection = 0;
    if (!pCollection)
    {
        osl::MutexGuard aGuard(osl::Mutex::getGlobalMutex());
        if (!pCollection)
        {
            static cppu::OTypeCollection
                aTheCollection(
                    getCppuType(
                        static_cast< uno::Reference< lang::XServiceInfo >
                                         const * >(
                            0)),
                    getCppuType(
                        static_cast< uno::Reference< lang::XTypeProvider >
                                         const * >(
                            0)),
                    getCppuType(
                        static_cast<
                                uno::Reference<
                                    star::ucb::XContentProvider > const * >(
                            0)),
                    getCppuType(
                        static_cast<
                                uno::Reference<
                                        star::ucb::XContentIdentifierFactory >
                                    const * >(
                            0)),
                    getCppuType(
                        static_cast<
                                uno::Reference<
                         star::ucb::XParameterizedContentProvider > const * >(
                            0)));
            pCollection = &aTheCollection;
        }
    }
    return pCollection->getTypes();
}

//============================================================================
// virtual
uno::Sequence< sal_Int8 > SAL_CALL ContentProvider::getImplementationId()
    throw (uno::RuntimeException)
{
    static cppu::OImplementationId * pID = 0;
    if (!pID)
    {
        osl::MutexGuard aGuard(osl::Mutex::getGlobalMutex());
        if (!pID)
        {
            static cppu::OImplementationId aTheID(false);
            pID = &aTheID;
        }
    }
    return pID->getImplementationId();
}

//============================================================================
// virtual
uno::Reference< star::ucb::XContent > SAL_CALL
ContentProvider::queryContent(
    uno::Reference< star::ucb::XContentIdentifier > const & rIdentifier)
    throw (star::ucb::IllegalIdentifierException, uno::RuntimeException)
{
    rtl::Reference< Connection > xConnection(findConnection(rIdentifier));
    if (!xConnection.is())
        throw star::ucb::IllegalIdentifierException();

    return xConnection->queryContent(rIdentifier);
}

//============================================================================
// virtual
sal_Int32 SAL_CALL
ContentProvider::compareContentIds(
    uno::Reference< star::ucb::XContentIdentifier > const & rId1,
    uno::Reference< star::ucb::XContentIdentifier > const & rId2)
    throw (uno::RuntimeException)
{
    rtl::Reference< Connection > xConnection1(findConnection(rId1));
    rtl::Reference< Connection > xConnection2(findConnection(rId2));
    if (xConnection1.is() && xConnection1 == xConnection2)
        return xConnection1->compareContentIds(rId1, rId2);

    rtl::OUString aURI1;
    if (rId1.is())
        aURI1 = rId1->getContentIdentifier();
    rtl::OUString aURI2;
    if (rId2.is())
        aURI2 = rId2->getContentIdentifier();
    return aURI1.compareTo(aURI2);
}

//============================================================================
// virtual
uno::Reference< star::ucb::XContentIdentifier > SAL_CALL
ContentProvider::createContentIdentifier(rtl::OUString const & rContentId)
    throw (uno::RuntimeException)
{
    return new ::ucb::ContentIdentifier(rContentId);
}

//============================================================================
// virtual
uno::Reference< star::ucb::XContentProvider > SAL_CALL
ContentProvider::registerInstance(rtl::OUString const & rTemplate,
                                  rtl::OUString const & rArguments,
                                  sal_Bool bReplaceExisting)
    throw (lang::IllegalArgumentException, uno::RuntimeException)
{
    rtl::OUString aRemoteProviderURL;
    bool bOffline;
    if (!parseArguments(rArguments, &aRemoteProviderURL, &bOffline))
        throw lang::IllegalArgumentException(
                  rtl::OUString(
                          RTL_CONSTASCII_USTRINGPARAM(
                              "ucprmt::ContentProvider::registerInstance "))
                      + rArguments,
                  *this,
                  1);

    if (aRemoteProviderURL.getLength() == 0)
        return this;

    rtl::Reference< Connection >
        xConnection(m_xConnectionMap->getConnection(aRemoteProviderURL));
    if (!xConnection.is())
        throw lang::IllegalArgumentException();

    if (!xConnection->addLocalURITemplate(rTemplate,
                                          bReplaceExisting != false))
        return 0;

    //@@@ Also guard above addLocalURITemplate()?  Add commit-or-rollback
    // semantics:
    {
        osl::MutexGuard aGuard(m_aMutex);

        ConnectionCount & rCount = m_aRegisteredConnections[xConnection];

        ++rCount.m_nConnections;
        m_aUriToRegisteredConnectionMap.add(rTemplate,
                                            xConnection,
                                            bReplaceExisting != false);

#if defined UCB_RAP_OFFLINE
        if (bOffline && ++rCount.m_nOfflineModes == 1)
            try
            {
                xConnection->setOfflineMode(true);
            }
            catch (offline::StorageError &)
            {} //TODO!
#endif // UCB_RAP_OFFLINE
    }

    return xConnection.get();
}

//============================================================================
// virtual
uno::Reference< star::ucb::XContentProvider > SAL_CALL
ContentProvider::deregisterInstance(rtl::OUString const & rTemplate,
                                    rtl::OUString const & rArguments)
    throw (lang::IllegalArgumentException, uno::RuntimeException)
{
    rtl::OUString aRemoteProviderURL;
    bool bOffline;
    if (!parseArguments(rArguments, &aRemoteProviderURL, &bOffline))
        throw lang::IllegalArgumentException(
                  rtl::OUString(
                          RTL_CONSTASCII_USTRINGPARAM(
                              "ucprmt::ContentProvider::deregisterInstance "))
                      + rArguments,
                  *this,
                  1);

    if (aRemoteProviderURL.getLength() == 0)
        return this;

    rtl::Reference< Connection >
        xConnection(m_xConnectionMap->getConnection(aRemoteProviderURL));
    if (!xConnection.is())
        throw lang::IllegalArgumentException();

    if (!xConnection->removeLocalURITemplate(rTemplate))
        return 0;

    //@@@ Also guard above removeLocalURITemplate()?  Add commit-or-rollback
    // semantics:
    {
        osl::MutexGuard aGuard(m_aMutex);

        ConnectionCount & rCount = m_aRegisteredConnections[xConnection];

        if (--rCount.m_nConnections == 0)
            m_aRegisteredConnections.erase(xConnection);
        RegexpToConnectionMap::iterator
            aIt(m_aUriToRegisteredConnectionMap.find(rTemplate));
        if (aIt != m_aUriToRegisteredConnectionMap.end())
            m_aUriToRegisteredConnectionMap.erase(aIt);

#if defined UCB_RAP_OFFLINE
        if (bOffline && --rCount.m_nOfflineModes == 0)
            try
            {
                xConnection->setOfflineMode(false);
            }
            catch (offline::StorageError &)
            {} //TODO!
#endif // UCB_RAP_OFFLINE
    }

    return xConnection.get();
}

//============================================================================
// static
sal_Char const * ContentProvider::getImplementationName_static()
{
    return "com.sun.star.comp.ucb.ucp.remote.ContentProvider";
}

//============================================================================
// static
uno::Sequence< rtl::OUString >
ContentProvider::getSupportedServiceNames_static()
{
    uno::Sequence< rtl::OUString > aNames(1);
    aNames[0] = rtl::OUString::createFromAscii(
                    "com.sun.star.ucb.RemoteAccessContentProvider");
    return aNames;
}

//============================================================================
// static
uno::Reference< uno::XInterface > SAL_CALL
ContentProvider::createInstance(
    uno::Reference< lang::XMultiServiceFactory > const & rTheFactory)
{
    return static_cast< uno::XWeak * >(static_cast< cppu::OWeakObject * >(
                                           new ContentProvider(rTheFactory)));
}

//============================================================================
rtl::Reference< Connection >
ContentProvider::findConnection(
    uno::Reference< star::ucb::XContentIdentifier > const & rIdentifier)
    throw (uno::RuntimeException)
{
    if (!rIdentifier.is())
        return 0;

    if (rIdentifier->
            getContentProviderScheme().
                equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("vnd.sun.star.ucb")))
    {
        // Try to create from rIdentifier the uno URL of a remote UCB:
        rtl::OUString aUri(rIdentifier->getContentIdentifier());
        OSL_ENSURE(aUri.compareToAscii(RTL_CONSTASCII_STRINGPARAM(
                                           "vnd.sun.star.ucb"))
                       == 0,
                   "ContentProvider::findConnection(): Bad identifier");
        sal_Int32 nDelim
            = aUri.indexOf(';', RTL_CONSTASCII_LENGTH("vnd.sun.star.ucb:"));
        if (nDelim <= 0)
            return 0;
        rtl::OUStringBuffer aRemoteProviderUrl;
        aRemoteProviderUrl.appendAscii(RTL_CONSTASCII_STRINGPARAM("uno:"));
        aRemoteProviderUrl.
            append(aUri.getStr() + RTL_CONSTASCII_LENGTH("vnd.sun.star.ucb:"),
                   nDelim - RTL_CONSTASCII_LENGTH("vnd.sun.star.ucb:"));
        aRemoteProviderUrl.
            appendAscii(RTL_CONSTASCII_STRINGPARAM(";urp;UCB.Factory"));
        //@@@ normalize aRemoteProviderUrl
        return m_xConnectionMap->
                   getConnection(aRemoteProviderUrl.makeStringAndClear());
    }
    else
    {
        rtl::OUString aUri(rIdentifier->getContentIdentifier());
        {
            osl::MutexGuard aGuard(m_aMutex);
            rtl::Reference< Connection > const * pConnection
                = m_aUriToRegisteredConnectionMap.map(aUri);
            if (pConnection)
                return *pConnection;
            else
                return 0;
        }
    }
}
