/*************************************************************************
 *
 *  $RCSfile: VCLGraphics.m,v $
 *
 *  $Revision: 1.23 $
 *
 *  last change: $Author: hr $ $Date: 2002/08/27 11:37:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *		 - GNU Lesser General Public License Version 2.1
 *		 - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This librArray is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This librArray is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this librArray; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _SV_VCLGRAPHICS_M

#import <VCLGraphics.h>

// =======================================================================

// =======================================================================

// -----------------------------------------------------------------------
//
//                               VCLGraphics
//
// -----------------------------------------------------------------------

@implementation VCLGraphics

// -----------------------------------------------------------------------
//
// Get, and lock, a QuickDraw View
//
// -----------------------------------------------------------------------

+ (CGrafPtr)LockFocusCGrafPort: (VCLView *)hView 
{
	if ( hView != nil )
	{
		if ( [hView isKindOfClass: [NSQuickDrawView class]] )
		{
			CGrafPtr pCGrafPort=NULL;
			RGBColor oldFore, newFore;
			Rect r;
			NSRect viewBounds;
			
			[hView lockFocus];
			
			// [ed] 12/12/01 The Carbon GrafPort only is valid as long as the view has
			// the focus, so we need to be sure to execute lockFocus before assigning
			// the port.
			
			pCGrafPort = [(NSQuickDrawView *)hView qdPort];
			
			return pCGrafPort;
		}
		else
		{
			// [ed] 12/12/01 Error checking
			
			fprintf(stderr, "Non nil hView in LockFocusCGrafPort(), but not a quickdrawview\n");
		} // if
	}
	else
	{
		// [ed] 12/12/01 Error checking
		
		fprintf(stderr, "Nil hView in LockFocusCGrafPort()\n");
	} // if

	return NULL;
} // LockFocusCGrafPort

// -----------------------------------------------------------------------
//
// Close, and unlock, a QuickDraw View
//
// -----------------------------------------------------------------------

+ (void)UnLockFocusCGrafPort: (VCLView *)hView 
{
	if ( hView != nil )
	{
		if ( [hView isKindOfClass: [NSQuickDrawView class]] )
		{
			[hView unlockFocus];
		} // if
	} // if
} // UnLockFocusCGrafPort

@end

// =======================================================================

// =======================================================================

// -----------------------------------------------------------------------
//
//                           C wrapper functions
//
// -----------------------------------------------------------------------

// -----------------------------------------------------------------------
//
// Get, and lock, a QuickDraw View
//
// -----------------------------------------------------------------------

CGrafPtr VCLGraphics_LockFocusCGrafPort ( VCLVIEW hView ) 
{
	if ( (VCLView *)hView == nil )
		return NULL;

	return [ VCLGraphics LockFocusCGrafPort: (VCLView *)hView ];
} // VCLGraphics_LockFocusCGrafPort
	
// -----------------------------------------------------------------------
//
// Close, and unlock, a QuickDraw View
//
// -----------------------------------------------------------------------

void VCLGraphics_UnLockFocusCGrafPort ( VCLVIEW hView ) 
{
	if ( (VCLView *)hView == nil )
		return;

	[ VCLGraphics UnLockFocusCGrafPort: (VCLView *)hView ];
} // VCLGraphics_UnLockFocusCGrafPort

// =======================================================================

// =======================================================================

