/*************************************************************************
 *
 *  $RCSfile: lineinfo.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/19 10:23:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_LINEINFO_HXX
#define _SV_LINEINFO_HXX

#include <tools/gen.hxx>
#include <vclenum.hxx>

// ----------------
// - ImplLineInfo -
// ----------------

class SvStream;

struct ImplLineInfo
{
    USHORT				mnRefCount;
	LineStyle			meStyle;
    long				mnWidth;
	USHORT				mnDashCount;
	long				mnDashLen;
	USHORT				mnDotCount;
	long				mnDotLen;
	long				mnDistance;

						ImplLineInfo();
						ImplLineInfo( const ImplLineInfo& rImplLineInfo );

    friend SvStream&	operator>>( SvStream& rIStm, ImplLineInfo& rImplLineInfo );
    friend SvStream&	operator<<( SvStream& rOStm, const ImplLineInfo& rImplLineInfo );
};

// ------------
// - LineInfo -
// ------------

class LineInfo
{
private:	
    
	ImplLineInfo*	mpImplLineInfo;
	long			n1;
	long			n2;
	long			n3;
	
	void			ImplMakeUnique();

public:
                    
					LineInfo( LineStyle eLineStyle = LINE_SOLID, long nWidth = 0L );
                    LineInfo( const LineInfo& rLineInfo );
                    ~LineInfo();

	LineInfo&		operator=( const LineInfo& rLineInfo );
    BOOL            operator==( const LineInfo& rLineInfo ) const;
    BOOL            operator!=( const LineInfo& rLineInfo ) const { return !(LineInfo::operator==( rLineInfo ) ); }
    BOOL            IsSameInstance( const LineInfo& rLineInfo ) const { return( mpImplLineInfo == rLineInfo.mpImplLineInfo ); }

    void            SetStyle( LineStyle eStyle );
    LineStyle		GetStyle() const { return mpImplLineInfo->meStyle; }

    void            SetWidth( long nWidth );
    long			GetWidth() const { return mpImplLineInfo->mnWidth; }

	void			SetDashCount( USHORT nDashCount );
	USHORT			GetDashCount() const { return mpImplLineInfo->mnDashCount; }

	void			SetDashLen( long nDashLen );
	long			GetDashLen() const { return mpImplLineInfo->mnDashLen; }

	void			SetDotCount( USHORT nDotCount );
	USHORT			GetDotCount() const { return mpImplLineInfo->mnDotCount; }

	void			SetDotLen( long nDotLen );
	long			GetDotLen() const { return mpImplLineInfo->mnDotLen; }

	void			SetDistance( long nDistance );
	long			GetDistance() const { return mpImplLineInfo->mnDistance; }

	BOOL			IsDefault() const { return( !mpImplLineInfo->mnWidth && ( LINE_SOLID == mpImplLineInfo->meStyle ) ); }

    friend SvStream& operator>>( SvStream& rIStm, LineInfo& rLineInfo );
    friend SvStream& operator<<( SvStream& rOStm, const LineInfo& rLineInfo );

#ifdef SMART_UNO_GENERATION

	LineStyle		getStyle() const { return GetStyle(); }
	void 			setStyle( LineStyle eStyle ) { SetStyle( eStyle ); }

	long			getWidth() const { return GetWidth(); }
	void 			setWidth( ULONG nDistance ) { SetWidth( nWidth ); }

	USORT			getDashCount const { return GetDashCount(); }
	void			setDashCount( USHORT nDashCount ) { SetDashCount( nDashCount ); }

	long			getDashLen() const { return GetDashLen(); }
	void			setDashLen( long nDashLen ) { SetDashLen( nDashLen ); }

	USHORT			getDotCount() const { return GetDotCount(); }
	void			setDotCount( USHORT nDotCount ) { SetDotCount( nDotCount ); }

	long			getDotLen() const { GetDotLen(); }
	void			setDotLen( long nDotLen ) { SetDotLen( nDotLen ); }

	long			getDistance() const { return GetDistance(); }
	void			setDistance( long nDistance ) { SetDistance( nDistance ); }

#endif
};

#endif  // _SV_LINEINFO_HXX
