/*************************************************************************
 *
 *  $RCSfile: rmprint.hxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: hr $ $Date: 2002/03/19 11:12:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_RMPRINT_HXX
#define _SV_RMPRINT_HXX

#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif

#include "rvp.hxx"
#ifndef _SV_PPRINT_HXX
#include <print.hxx>
#endif

// forward declaration (see atom.hxx)

namespace utl {
	class AtomClient;
}

// ---------------------
// - RemotePrinterInfo -
// ---------------------

struct RemotePrinterInfo
{
	UniString					aPrinterName;
	UniString					aServerName;
	BOOL						bDefaultPrinter;
	BOOL						bLocalPrinter;
	NMSP_CLIENT::RmQueueInfo	aRmQueueInfo;

	RemotePrinterInfo( const String& rPName, const String& rSName, BOOL bDef, BOOL bLocal, const NMSP_CLIENT::RmQueueInfo& rRmQueueInfo ) :
		aPrinterName( rPName ), aServerName( rSName ), bDefaultPrinter( bDef ), bLocalPrinter( bLocal ), aRmQueueInfo( rRmQueueInfo ) {}

	UniString GetFullName() const
	{
		UniString aFullName( aPrinterName );
		
		if( !bLocalPrinter )
		{
			aFullName += UniString( OUSTRING::createFromAscii( "@" ) );
			aFullName += aServerName;
		}

		return aFullName;
	}
};

DECLARE_LIST( RemotePrinterInfoList, RemotePrinterInfo* );

// ---------------------
// - RemotePrinterList -
// ---------------------

class UnoDispatcher;

// ----------------------
// - ORmPrinterObserver -
// ----------------------

class ORmPrinterObserver : public ::cppu::WeakImplHelper1< NMSP_CLIENT::XRmPrinterObserver >
{
public:

				
							ORmPrinterObserver() {};
							~ORmPrinterObserver() {};
	
	virtual void SAL_CALL	PrinterSettingsChanged() throw();
};

// -------------
// - RmPrinter -
// -------------

class RmPrinter
{
    friend class Printer;
private:
    
	REF( NMSP_CLIENT::XRmPrinter )			mxRemotePrinter;
    NMSP_UNO::Sequence< ::rtl::OUString >	maPaperBins;

    RmPrinter( const RmPrinter& ) {}
	RmPrinter&								operator=( const RmPrinter& ) { return *this; }
										
public:									
										
    RmPrinter() {};

	BOOL									IsValid() const { return mxRemotePrinter.is(); }

	const REF( NMSP_CLIENT::XRmPrinter )&	GetInterface() const { return mxRemotePrinter; }
	void									SetInterface( const REF( NMSP_CLIENT::XRmPrinter )& rxPrinter ) { mxRemotePrinter = rxPrinter; }

public:

    void									CreateInfoInstance( const NMSP_CLIENT::RmQueueInfo& aRmQueueInfo, NMSP_CLIENT::RmJobSetup& rRmJobSetup );
    void									CreatePrintInstance( const NMSP_CLIENT::RmJobSetup& rRmJobSetup );
    BOOL									SetJobSetup( NMSP_CLIENT::RmJobSetup& rRmJobSetup );
    BOOL									SetOrientation( USHORT nOrientation, NMSP_CLIENT::RmJobSetup& rRmJobSetup );
    BOOL									SetPaperBin( USHORT nPaperBin, NMSP_CLIENT::RmJobSetup& rRmJobSetup );
    BOOL									SetPaper( USHORT nPaper, NMSP_CLIENT::RmJobSetup& rRmJobSetup );
    BOOL									SetPaperSizeUser( long nWidth, long nHeight, NMSP_CLIENT::RmJobSetup& rRmJobSetup );
    void									GetPageInfo( long& rOutWidth, long& rOutHeight, long& rPageOffX, long& rPageOffY, 
														 long& rPageWidth, long& rPageHeight );
    USHORT									GetPaperBinCount();
    OUSTRING								GetPaperBinName( USHORT nPaperBin );

	unsigned long							GetCapabilities( USHORT nType );
	void									UserSetup( const REF( NMSP_CLIENT::XRmFrameWindow )& xParent, sal_uInt32 EventID );
};

class RmPageRequestor :
    public ::cppu::WeakImplHelper1< ::com::sun::star::portal::client::XRmPageRequestor >
{
    Printer*									m_pPrinter;
    bool										m_bCompleted;

    DECL_LINK(  PrintPageHdl, void* );
public:
    RmPageRequestor( Printer* pPrinter ) :
            m_pPrinter( pPrinter ),
            m_bCompleted( false )
    {
    }

    virtual ~RmPageRequestor();

    bool isCompleted() const { return m_bCompleted; }

    // XRmPageRequestor
    virtual NMSP_CLIENT::RmJobSetup SAL_CALL requestJobSetup( sal_uInt32 nPage ) throw();
    virtual void SAL_CALL requestPage( sal_uInt32 nPage ) throw();
    virtual void SAL_CALL requestCompleted() throw();
};

#endif // _SV_RMPRINT_HXX
