/*************************************************************************
 *
 *  $RCSfile: macframe.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <svmac.h>



#include <mac_start.h>

#include <graphics routines.h>

#include <Threads.h>

#include <ControlStrip.h>

#include <mac_end.h>



#include <stdlib.h>



#include "tools/solar.h"

// #include "tools.hxx"



#ifndef _SV_SALDATA_HXX

#include <saldata.hxx>

#endif



#include "SVApp.hxx"



#ifndef _SV_SALFRAME_HXX

#include <salframe.hxx>

#endif



#include "main.h"



// =======================================================================



struct PresentationData {

	RgnHandle	aMBarRgn;

	short		nOldMBarHeight;

	BOOL		bControlStripVisible;

};



static Handle hPresentationData=0L;	// always in app heap



// =======================================================================



/*************************************************************************

|*

|*    Application::StartPresentationMode()

|*

|*    Ersterstellung    DV 29.05.95

|*    Letzte Aenderung  WKC 03.07.1997

|*

*************************************************************************/

void Mac_StartPresentationMode( const SalFrame* pFrame, USHORT nFlags )

{

	// wenn hPresentationData != Null ist, dann befinden wir uns schon

	// im PresentationMode

	if ( hPresentationData )

		return;



	// Wenn wir ein Fenster uebergeben bekommen, dann wird die MenuBar

	// versteckt.



	if ( pFrame->maFrameData.mpMacWin )

	{

		hPresentationData = NewHandleClear( sizeof( PresentationData ) );

		HLock ( hPresentationData );

		{

			PresentationData *pPresentationData = (PresentationData*)*hPresentationData;

			pPresentationData->nOldMBarHeight = LMGetMBarHeight();

			// MenubarHeight auf 0 setzen und die Desktop Area neu berechnen

			LMSetMBarHeight( 0 );

	

			Rect aMBarRect = qd.screenBits.bounds;

			aMBarRect.bottom = aMBarRect.top + pPresentationData->nOldMBarHeight;

	

			RgnHandle aMBarRgn = NewRgn();

			RectRgn( aMBarRgn, &aMBarRect );

			RgnHandle aGrayRgn = GetGrayRgn();

			UnionRgn( aGrayRgn, aMBarRgn, aGrayRgn );

			pPresentationData->aMBarRgn = aMBarRgn;

		}

		HUnlock ( hPresentationData );

	}



	// hier koennte jetzt code stehen, der Screensaver ausschaltet etc.

}



// =======================================================================



/*************************************************************************

|*

|*    Application::EndPresentationMode()

|*

|*    Ersterstellung    DV 29.05.95

|*    Letzte Aenderung  WKC 03.07.1997

|*

*************************************************************************/

void Mac_EndPresentationMode( )

{

	RgnHandle	aMBarRgn;

	RgnHandle	aGrayRgn;



	if ( ! hPresentationData )

		return;



	HLock ( hPresentationData );

	{

		PresentationData *pPresentationData = (PresentationData*)*hPresentationData;

		LMSetMBarHeight( pPresentationData->nOldMBarHeight );

		aGrayRgn = GetGrayRgn();

		aMBarRgn = pPresentationData->aMBarRgn;

		DiffRgn( aGrayRgn, aMBarRgn, aGrayRgn );

		DrawMenuBar();

		DisposeRgn( aMBarRgn );

	}

	HUnlock ( hPresentationData );

	DisposeHandle ( hPresentationData ); hPresentationData = 0L;

}



// -----------------------------------------------------------------------



BOOL Mac_IsPresentationMode()

{

	if ( hPresentationData )

		return TRUE;

	else

		return FALSE;

}








