/*************************************************************************
 *
 *  $RCSfile: salbmp.hxx,v $
 *
 *  $Revision: 1.3.274.1 $
 *
 *  last change: $Author: hr $ $Date: 2004/01/15 12:51:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_SALBMP_HXX
#define _SV_SALBMP_HXX

#ifndef _SALSTD_HXX
#include <salstd.hxx>
#endif
#ifndef _SV_SALGTYPE
#include <salgtype.hxx>
#endif
#ifndef _SV_SALDISP_HXX
#include <saldisp.hxx>
#endif

struct	BitmapBuffer;
class	BitmapPalette;
class	SalGraphics;
class	ImplSalDDB;
class	ImplSalBitmapCache;

// -------------
// - SalBitmap -
// -------------

class SalBitmap
{
private:

	static BitmapBuffer*		ImplCreateDIB( const Size& rSize,
											   USHORT nBitCount, 
											   const BitmapPalette& rPal );
	static BitmapBuffer*		ImplCreateDIB( Drawable aDrawable,
											   long nDrawableDepth,
											   long nX, long nY,
											   long nWidth, long nHeight );

public:

	static ImplSalBitmapCache*	mpCache;
	static ULONG				mnCacheInstCount;

	static void					ImplCreateCache();
	static void					ImplDestroyCache();
    void				        ImplRemovedFromCache();

    BOOL                        SnapShot (Display* pDisplay, XLIB_Window hWindow);
    BOOL                        ImplCreateFromXImage (Display* pDisplay, XLIB_Window hWindow, 
                                                      XImage* pImage);
private:


	BitmapBuffer*	mpDIB;
	ImplSalDDB*		mpDDB;
								
public:

	BOOL			ImplCreateFromDrawable( 
#ifdef _USE_PRINT_EXTENSION_ 
											SalDisplay* pDisplay,
#endif
											Drawable aDrawable, 
											long nDrawableDepth,
											long nX, long nY, 
											long nWidth, long nHeight );

	BOOL			ImplCreateLocalFromDrawable( 
											Drawable aDrawable, 
											long nDrawableDepth,
											long nX, long nY, 
											long nWidth, long nHeight );

	XImage*			ImplCreateXImage( 
											SalDisplay* pSalDisp, long nDepth, 
									  		const SalTwoRect& rTwoRect ) const;
#ifdef _USE_PRINT_EXTENSION_
	void			ImplDraw( SalDisplay *pDisplay, Drawable aDrawable, long nDrawableDepth, 
							  const SalTwoRect& rTwoRect, const GC& rGC ) const;
#else
	void			ImplDraw( Drawable aDrawable, long nDrawableDepth, 
							  const SalTwoRect& rTwoRect, const GC& rGC ) const;
#endif
						
public:					
								
					SalBitmap();
					~SalBitmap();
						
	BOOL			Create( const Size& rSize, 
							USHORT nBitCount, 
							const BitmapPalette& rPal );
	BOOL			Create( const SalBitmap& rSalBmp );
	BOOL			Create( const SalBitmap& rSalBmp, 
							SalGraphics* pGraphics );
	BOOL			Create( const SalBitmap& rSalBmp,
							USHORT nNewBitCount );
						
	void			Destroy();
						
	Size			GetSize() const;
	USHORT			GetBitCount() const;
						
	BitmapBuffer*	AcquireBuffer( BOOL bReadOnly );
	void			ReleaseBuffer( BitmapBuffer* pBuffer, BOOL bReadOnly );
};

// --------------
// - ImplSalDDB -
// --------------

class ImplSalDDB
{
private:

	Pixmap			maPixmap;
	SalTwoRect		maTwoRect;
	long			mnDepth;

					ImplSalDDB() {}

    static void	ImplDraw( 
#ifdef _USE_PRINT_EXTENSION_ 
								SalDisplay* pDisplay,
#endif
    Drawable aSrcDrawable, long nSrcDrawableDepth,
						      Drawable aDstDrawable, long nDstDrawableDepth,
						      long nSrcX, long nSrcY, 
						      long nDestWidth, long nDestHeight, 
						      long nDestX, long nDestY, const GC& rGC );
					
public:				
					
					ImplSalDDB( 
#ifdef _USE_PRINT_EXTENSION_ 
								SalDisplay* pDisplay,
#endif
								XImage* pImage, Drawable aDrawable, 
								const SalTwoRect& rTwoRect );
					ImplSalDDB( 
#ifdef _USE_PRINT_EXTENSION_ 
								SalDisplay* pDisplay,
#endif
								Drawable aDrawable, long nDrawableDepth, 
								long nX, long nY, long nWidth, long nHeight );
                    ImplSalDDB (Display* pDisplay, XLIB_Window hWindow, XImage* pImage); 
					~ImplSalDDB();
					
	Pixmap			ImplGetPixmap() const { return maPixmap; }
	long			ImplGetWidth() const { return maTwoRect.mnDestWidth; }
	long			ImplGetHeight() const { return maTwoRect.mnDestHeight; }
	long			ImplGetDepth() const { return mnDepth; }
	ULONG			ImplGetMemSize() const { return( ( maTwoRect.mnDestWidth * maTwoRect.mnDestHeight * mnDepth ) >> 3 ); }
					
	BOOL			ImplMatches( long nDepth, const SalTwoRect& rTwoRect ) const;
	void			ImplDraw( 
#ifdef _USE_PRINT_EXTENSION_ 
								SalDisplay* pDisplay,
#endif
								Drawable aDrawable, long nDrawableDepth, 
								const SalTwoRect& rTwoRect, const GC& rGC ) const;
};

// ----------------------
// - ImplSalBitmapCache -
// ----------------------

class ImplSalBitmapCache
{
private:

	List			maBmpList;
	ULONG			mnTotalSize;

public:				
					
					ImplSalBitmapCache();
					~ImplSalBitmapCache();

	void			ImplAdd( SalBitmap* pBmp, ULONG nMemSize = 0UL, ULONG nFlags = 0UL );
	void			ImplRemove( SalBitmap* pBmp );
	void			ImplClear();
};

#endif // _SV_SALBMP_HXX












































