/*************************************************************************
 *
 *  $RCSfile: charnames.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <string.h>

struct CharTranslation
{
	char*          mpName;
	int            mnLength;
	unsigned char  mcChar;
};

// char encoding latin1 !!!
static CharTranslation pTranslations[] =
{
	{ "tilde",         5, '~' },
	{ "zero",          4, '0' },
	{ "one",           3, '1' },
	{ "two",           3, '2' },
	{ "three",         5, '3' },
	{ "four",          4, '4' },
	{ "five",          4, '5' },
	{ "six",           3, '6' },
	{ "seven",         5, '7' },
	{ "eight",         5, '8' },
	{ "nine",          4, '9' },
	{ "braceleft",     9, '{' },
	{ "braceright",   10, '}' },
	{ "less",          4, '<' },
	{ "greater",       7, '>' },
	{ "colon",         5, ':' },
	{ "semicolon",     9, ';' },
	{ "at",            2, '@' },
	{ "question",      8, '?' },
	{ "asterisk",      8, '*' },
	{ "parenleft",     9, '(' },
	{ "parenright",   10, ')' },
	{ "ampersand",     9, '&' },
	{ "plus",          4, '+' },
	{ "minus",         5, '-' },
	{ "exclam",        6, '!' },
	{ "space",         5, ' ' },
	{ "quotedbl",      8, '"' },
	{ "numbersign",   10, '#' },
	{ "comma",         5, ',' },
	{ "quotesingle",  11, '' },
	{ "period",        6, '.' },
	{ "equal",         5, '=' },
	{ "dollar",        6, '$' },
	{ "asciitilde",   10, '~' },
	{ "underscore",   10, '_' },
	{ "backslash",     9, '\\' },
	{ "grave",         5, 0xc1 },
	{ "bar",           3, '|' },
	{ "degree",        6, '' },
	{ "germandbls",   10, '' },
	{ "slash",         5, '/' },
	{ "percent",       7, '%' },
	{ "hyphen",        6, 0xad },
	{ "bracketleft",  11, '[' },
	{ "bracketright", 12, ']' },
	{ "asciicircum",  11, 0x5e },
	{ "quoteright",   10, 0x27 },
	{ "quoteleft",     9, 0x60 },
	{ "exclamdown",   10, 0xa1 },
	{ "cent",          4, 0xa2 },
	{ "sterling",      8, 0xa3 },
	{ "yen",           3, 0xa5 },
	{ "section",       7, 0xa7 },
	{ "currency",      8, 0xa4 },
	{ "guillemotleft",13, 0xab },
	{ "guillemotright",14,0xbb },
	{ "periodcentered",14,0xb7 },
	{ "paragraph",     9, 0xb6 },
	{ "questiondown", 12, 0xbf },
	{ "acute",         5, 0x92 },
	{ "circumflex",   10, 0x93 },
	{ "macron",        6, 0x95 },
	{ "breve",         5, 0x96 },
	{ "dotaccent",     9, 0x97 },
	{ "dieresis",      8, 0x98 },
	{ "ring",          4, 0x9a },
	{ "cedilla",       7, 0x9b },
	{ "hungarumlaut", 12, 0x9d },
	{ "ogonek",        6, 0x9e },
	{ "caron",         5, 0x9f },
	{ "AE",            2, 0xc6 },
	{ "ordfeminine",  11, 0xaa },
	{ "OSlash",        6, 0xd8 },
	{ "ordmasculine", 12, 0xba },
	{ "ae",            2, 0xe6 },
	{ "dotlessi",      8, 0x90 },
	{ "oslash",        6, 0xf8 },
	{ "brokenbar",     9, 0xa6 },
	{ "copyright",     9, 0xa9 },
	{ "logicalnot",   10, 0xac },
	{ "registered",   10, 0xae },
	{ "plusminus",     9, 0xb1 },
	{ "twosuperior",  10, 0xb2 },
	{ "threesuperior",13, 0xb3 },
	{ "mu",            2, 0xb5 },
	{ "onesuperior",  11, 0xb9 },
	{ "onequarter",   10, 0xbc },
	{ "onehalf",       7, 0xbd },
	{ "threequarters",13, 0xbe },
	{ "Agrave",        6, 0xc0 },
	{ "Aacute",        6, 0xc1 },
	{ "Acircumflex",  11, 0xc2 },
	{ "Atilde",        6, 0xc3 },
	{ "Adieresis",     9, 0xc4 },
	{ "Aring",         5, 0xc5 },
	{ "Ccedilla",      8, 0xc7 },
	{ "Egrave",        6, 0xc8 },
	{ "Eacute",        6, 0xc9 },
	{ "Ecircumflex",  11, 0xca },
	{ "Edieresis",     9, 0xcb },
	{ "Igrave",        6, 0xcc },
	{ "Iacute",        6, 0xcd },
	{ "Icircumflex",  11, 0xce },
	{ "Idieresis",     9, 0xcf },
	{ "Eth",           3, 0xd0 },
	{ "Ntilde",        6, 0xd1 },
	{ "Ograve",        6, 0xd2 },
	{ "Oacute",        6, 0xd3 },
	{ "Ocircumflex",  11, 0xd4 },
	{ "Otilde",        6, 0xd5 },
	{ "Odieresis",     9, 0xd6 },
	{ "multiply",      8, 0xd7 },
	{ "Ugrave",        6, 0xd9 },
	{ "Uacute",        6, 0xda },
	{ "Ucircumflex",  11, 0xdb },
	{ "Udieresis",     9, 0xdc },
	{ "Yacute",        6, 0xdd },
	{ "Thorn",         5, 0xde },
	{ "agrave",        6, 0xe0 },
	{ "aacute",        6, 0xe1 },
	{ "acircumflex",  11, 0xe2 },
	{ "atilde",        6, 0xe3 },
	{ "adieresis",     9, 0xe4 },
	{ "aring",         5, 0xe5 },
	{ "ccedilla",      8, 0xe7 },
	{ "egrave",        6, 0xe8 },
	{ "eacute",        6, 0xe9 },
	{ "ecircumflex",  11, 0xea },
	{ "edieresis",     9, 0xeb },
	{ "igrave",        6, 0xec },
	{ "iacute",        6, 0xed },
	{ "icircumflex",  11, 0xee },
	{ "idieresis",     9, 0xef },
	{ "eth",           3, 0xf0 },
	{ "ntilde",        6, 0xf1 },
	{ "ograve",        6, 0xf2 },
	{ "oacute",        6, 0xf3 },
	{ "ocircumflex",  11, 0xf4 },
	{ "otilde",        6, 0xf5 },
	{ "odieresis",     9, 0xf6 },
	{ "divide",        6, 0xf7 },
	{ "ugrave",        6, 0xf9 },
	{ "uacute",        6, 0xfa },
	{ "ucircumflex",  11, 0xfb },
	{ "udieresis",     9, 0xfc },
	{ "yacute",        6, 0xfd },
	{ "thorn",         5, 0xfe },
	{ "ydieresis",     9, 0xff }
};

unsigned char TranslateCharName( char* pName )
{
	int nLength = strlen( pName );

	if( nLength == 1 )
		return (unsigned char)(*pName);
	
	for( int i = 0; i < sizeof( pTranslations )/sizeof( pTranslations[0] ); i++ )
	{
		if( pTranslations[i].mnLength == nLength &&
			! strncmp( pTranslations[i].mpName, pName, nLength ) )
			return pTranslations[i].mcChar;
	}
	return (unsigned char)0;
}
