/*************************************************************************
 *
 *  $RCSfile: observer.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:18:12 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _VOS_OBSERVER_HXX_
#define _VOS_OBSERVER_HXX_

#ifndef _VOS_TYPES_HXX_
#	include <vos/types.hxx>
#endif
#ifndef _VOS_REFERNCE_HXX_
#	include <vos/refernce.hxx>
#endif

#ifdef _USE_NAMESPACE
namespace vos
{     
#endif

// *******************************************************

/** IObserver

	@author  Bernd Hofner
	@version 0.1
*/

class IObserver : public NAMESPACE_VOS(IReference) 
{
public:

	/// callback function to notify the observer about some event
	virtual void SAL_CALL notify(sal_Int32 code, void* pData)= 0;

	/**
		STL demands this operators if you want to place
		IExecutables per value in collections.
	*/
	virtual sal_Bool SAL_CALL operator<(const IObserver&) const= 0;
	virtual sal_Bool SAL_CALL operator>(const IObserver&) const= 0;
	virtual sal_Bool SAL_CALL operator==(const IObserver&) const= 0;
	virtual sal_Bool SAL_CALL operator!=(const IObserver&) const= 0;
};


// *******************************************************

/** IObserved

	Just an idea.
	@author  Bernd Hofner
	@version 0.1
*/
class IObserved : public NAMESPACE_VOS(IReference) 
{
protected:
	friend class IObserver;

	virtual void SAL_CALL registerObserver(IObserver*)= 0;
	virtual void SAL_CALL deregisterObserver(IObserver*)= 0;

public:
	virtual void SAL_CALL dispatchToObservers(sal_Int32 code, void* pData)= 0;
};

/** OObserver

	add default-implementation of refence-counting behaviour to IObserver-Interface

	@author  Bernd Hofner
	@version 0.1
*/
class OObserver : virtual public NAMESPACE_VOS(IObserver),
				  virtual public NAMESPACE_VOS(OReference)
{
public:
	/*
		Since the dominance of the OReferenceCounter impl.
		of the IReferenceCounter is not granted, delegate
		the methods to this branch of the diamond-shaped
		inheritance tree.
	*/

	virtual ~OObserver()
	{
	}

	virtual RefCount SAL_CALL acquire()
	{
		return OReference::acquire();
	}

	virtual RefCount SAL_CALL release()
	{
		return OReference::release();
	}
	
	virtual RefCount SAL_CALL referenced() const
	{
		return OReference::referenced();
	}
	/**
		STL demands this operators if you want to place
		IExecutables per value in collections.
		Use a default implementation of the comparison-operators
		here without a correct semantic.
	*/
	virtual sal_Bool SAL_CALL operator<(const IObserver&) const
	{
		return sal_False;
	}

	virtual sal_Bool SAL_CALL operator>(const IObserver&) const
	{
		return sal_False;
	}

	virtual sal_Bool SAL_CALL operator==(const IObserver&) const
	{
		return sal_True;
	}

	virtual sal_Bool SAL_CALL operator!=(const IObserver&) const
	{
		return sal_False;
	}

};

#ifdef _USE_NAMESPACE
}
#endif

#endif	// _VOS_OBSERVER_HXX_

