/*************************************************************************
 *
 *  $RCSfile: thrdsrv.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:18:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#if defined GCC && (defined LINUX || defined FREEBSD)
sal_Int32 dummy_global_2 = 0;
#endif

#if defined HPUX
#  if defined(__HPACC_NOEH)
#    undef __HPACC_NOEH
#    include <new.h>
#    define __HPACC_NOEH
#  else
#    include <new.h>
#  endif
#endif


#include <osl/diagnose.h>
#include <vos/thrdsrv.hxx>

#ifdef _USE_NAMESPACE
using namespace vos;
#endif

VOS_IMPLEMENT_CLASSINFO(VOS_CLASSNAME(OThreadingServer, vos), 
						VOS_NAMESPACE(OThreadingServer, vos), 
						VOS_NAMESPACE(OObject, vos), 0);


OThreadingServer::OThreadingServer() 
{
}

OThreadingServer::~OThreadingServer() 
{
	// TRACE("~OThreadingServer()\n");

	OExecutableThread* pThread;

	while(!m_Pool.empty())
	{
		pThread= m_Pool.front();
		m_Pool.erase(m_Pool.begin());
		delete pThread;
	}
}


void OThreadingServer::add(const ORef<IExecutable>& ref) 
{

	OExecutableThread* pThread= new OExecutableThread(ref, 
													  this);

	VOS_NAMESPACE(OGuard, vos) Guard(&m_Lock);
	m_Pool.insert(m_Pool.end(), pThread);
	pThread->create();
}

void OThreadingServer::remove(const ORef<IExecutable>& ref) 
{		

	NAMESPACE_VOS(OGuard) Guard(&m_Lock);

	OExecutableThread* pThread;
	NAMESPACE_STD(vector<OExecutableThread*>)::iterator it;

	for(it= m_Pool.begin(); it != m_Pool.end();it++) {
		if( (*it)->getExecutable().isEqualBody(ref) ) {
			pThread= (*it);
			m_Pool.erase(it);
			delete pThread;
			return;
		}
	}

}


void OThreadingServer::complete() 
{
	while(getNextCompleted().isValid());
}

ORef<IExecutable> OThreadingServer::getNextCompleted() 
{

	m_Lock.acquire();

	// return empty reference if no more executables in server
	if(m_Pool.empty() && m_CompletedQueue.isEmpty()) {
		m_Lock.release();
		return ORef<IExecutable>();
	}

	m_Lock.release();

	return m_CompletedQueue.getHead();

}

void OThreadingServer::notify(sal_Int32 code, void* pData) {

	VOS_NAMESPACE(OGuard, vos) Guard(&m_Lock);

	OExecutableThread* pThread= (OExecutableThread*)pData;

	ORef<IExecutable> Executable= pThread->getExecutable();
	
	// remove it from collection
	remove(Executable);

	// place it in completed-queue
	m_CompletedQueue.addTail(Executable);

}

