/*************************************************************************
 *
 *  $RCSfile: protocol.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:18:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _PROTOCOL_HXX_
#define _PROTOCOL_HXX_ "$Revision: 1.1.1.1 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

namespace com
{
namespace sun
{
namespace star
{
namespace proxy
{

/*========================================================================
 *
 * IProtocolHandler interface.
 *
 *======================================================================*/
class IProtocolHandler
{
public:
	virtual ~IProtocolHandler (void) {}

	virtual void init   (void) = 0;
	virtual void update (const sal_uInt8 *pData, sal_uInt32 nSize) = 0;
	virtual void final  (void) = 0;

protected:
	IProtocolHandler (void) {}
};

/*========================================================================
 *
 * IProtocolHandlerFactory interface.
 *
 *======================================================================*/
class IProtocolHandlerFactory
{
public:
	virtual IProtocolHandler* createInstance (const rtl::OString &rName) = 0;

protected:
	IProtocolHandlerFactory (void) {}
	virtual ~IProtocolHandlerFactory (void) {}
};

/*========================================================================
 *
 * OProtocolHandlerRegistry interface.
 *
 *======================================================================*/
class OProtocolHandlerRegistry
{
public:
	static sal_Bool queryFactory (
		const rtl::OUString      &rProtocol,
		IProtocolHandlerFactory *&rpFactory);

	static sal_Bool registerFactory (
		const rtl::OUString     &rProtocol,
		IProtocolHandlerFactory *pFactory);

	static sal_Bool deregisterFactory (
		const rtl::OUString     &rProtocol,
		IProtocolHandlerFactory *pFactory);

protected:
	OProtocolHandlerRegistry (void);
	virtual ~OProtocolHandlerRegistry (void);

	virtual sal_Bool queryFactory_Impl (
		const rtl::OUString      &rProtocol,
		IProtocolHandlerFactory *&rpFactory) = 0;

	virtual sal_Bool registerFactory_Impl (
		const rtl::OUString     &rProtocol,
		IProtocolHandlerFactory *pFactory) = 0;

	virtual sal_Bool deregisterFactory_Impl (
		const rtl::OUString     &rProtocol,
		IProtocolHandlerFactory *pFactory) = 0;

private:
	/** The single instance.
	 */
	static OProtocolHandlerRegistry *m_pThis;

	/** Not implemented.
	 */
	OProtocolHandlerRegistry (const OProtocolHandlerRegistry&);
	OProtocolHandlerRegistry& operator= (const OProtocolHandlerRegistry&);
};

/*========================================================================
 *
 * The End.
 *
 *======================================================================*/

} // proxy
} // star
} // sun
} // com

#endif /* !_PROTOCOL_HXX_ */

