/*************************************************************************
 *
 *  $RCSfile: FullVectorBtree.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:02:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.xmlsearch.db;

public class FullVectorBtree extends VectorBtree {
  private final static int MaxVeclen = 128;
  private final static double SplitRatio = 0.5;

  protected class FullVectorBlock extends VectorBlock {
    public FullVectorBlock(int size) {
      super(size);
    }

    public boolean isFull() {
      //return pbl->_leaf ? pbl->_free > _leafDataLimit : pbl->_free == _maxEntries;
      return _isLeaf ? _free > _leafDataLimit : _free == _maxEntries;
    }
    
    /*
      private int compressVector(byte[] base, byte[] key, byte[] result) {
      int i, j;
      for (i = 0; base[i] == key[i]; i++)
      ;
      result[0] = (byte)i;
      for (j = 1; i < _vecLen; )
      result[j++] = key[i++];
      return j;
      }
      */
     
    private boolean insertVector(byte[] key) {
      // System.out.println("insert to " + number);
      for (int index = 0, nBytesEq = 0, i, j;;) {
      SEARCH: {
	if (_data[index] == nBytesEq) {
	  for (i = _data[index]&0xFF, j = index + 1; i < _vecLen; i++, j++)
	    if (key[i] == _data[j])
	      ++nBytesEq;
	    else if ((key[i]&0xFF) < (_data[j]&0xFF)) {
	      int delta = _vecLen + 1 - nBytesEq;
	      enableModif(this);
	      System.arraycopy(_data, j, _data, j + delta, _free - j + 1);
	      for (i = nBytesEq; i < _vecLen; i++)
		_data[j++] = key[i];
	      _data[j] = (byte)nBytesEq;
	      _free += delta;
	      declareModif(this);
	      return true;
	    }
	    else			/* key[i] > _data[j] */
	      break SEARCH;
  
	  if (i == _vecLen)		/* or nBytesEq == _vecLen */
	    return true;		/* equal vector found */
	}
	else if (_data[index] < nBytesEq) {
	  int delta = _vecLen + 1 - nBytesEq;
	  enableModif(this);
	  System.arraycopy(_data, index, _data, index+delta, _free-index+1);
	  _data[index] = (byte)nBytesEq;
	  for (i = nBytesEq; i < _vecLen; i++)
	    _data[++index] = key[i];
	  _free += delta;
	  declareModif(this);
	  return true;
	}
      }
      index += _vecLen + 1 - _data[index];
      }
    }
     
    private void splitBlockInt(FullVectorBlock bl, int vn,
			       FullVectorBlock newbl) {
      // System.out.println("splitBlockInt " + number);
      int half = (int)(_free * SplitRatio);
      int n = _free - half - 1;
      enableModif(newbl);
      newbl._isLeaf = false;
      newbl._free = 0;
      System.arraycopy(_data, vector(half), bl._data, vector(vn), _vecLen);
      System.arraycopy(_data, vector(half+1), newbl._data, vector(0), _vecLen*n);
      System.arraycopy(_data, 4*(half + 1), newbl._data, 0, 4*(n + 1));
      newbl._free = n;
      enableModif(this);
      _free = half;
      declareModif(this);
      declareModif(newbl);
    }

    // half the data in this will stay, 2nd half to move to newbl, pointer to bl
    private boolean splitBlock(FullVectorBlock bl, int vn,
			       FullVectorBlock newbl) {
      int count, half, middle = 0, i;
      byte[] buffer = new byte[MaxVeclen];
      enableModif(newbl);
      // init newbl as a leaf block
      newbl._isLeaf = true;
      newbl._free = 0;
      newbl._data[0] = (byte)0xFF;
  
      // count entries
      assert(_free > 0 && _free <= _blockSize);
      for (count = i = 0; i < _free; count++, i += _vecLen+1-(_data[i]&0xFF))
	;
      half = (int)(count*SplitRatio + 1);
      // expand middle entries
      for (i = count = 0; count < half; i += _vecLen + 1 - _data[i], count++) {
	System.arraycopy(_data, i + 1, buffer, _data[i], _vecLen - _data[i]);
	middle = i;
      }
  
      enableModif(this);
      System.arraycopy(buffer, 0, bl._data, vector(vn), _vecLen);
      System.arraycopy(_data, i+1, buffer, _data[i], _vecLen - _data[i]);
      newbl.insertVector(buffer);
      i += _vecLen + 1 - (_data[i]&0xFF);
      enableModif(newbl);		// again after insert_vec
      System.arraycopy(_data, i, newbl._data, newbl._free, _free - i + 1);
      newbl._data[newbl._free = _free - i + _vecLen + 1] = (byte)0xFF;
      _data[_free = middle] = (byte)0xFF;
      declareModif(this);
      declareModif(newbl);
      return true;
    }

    // y -- block to split
    // 1st half stays in y, 2nd goes to z, mid-entry placed at 'i' in this
    private void splitChild(int i, FullVectorBlock y, FullVectorBlock z) {
      //      Block* z = access_new_block();
      //      System.err.println("splitting " + y._number + " parent is " + number);
      int n = _free - i;
      //    System.err.println(_free+" splitChild; i = " + i + " vec " + vector(i + 1));
      enableModif(this);
      //  ::memmove(VECADDR(x, i + 1), VECADDR(x, i), _vecLen*n);
      // make space in this._data for a new vector
      System.arraycopy(_data, vector(i), _data, vector(i + 1), _vecLen*n);
      //      ::memmove(&BLKREFS(x)[i + 1], &BLKREFS(x)[i], sizeof(BlockId)*(n + 1));
      // make space in this for a new pointer
      System.arraycopy(_data, 4*i, _data, 4*(i + 1), 4*(n + 1));
      if (y._isLeaf)
	y.splitBlock(this, i, z);
      else
	y.splitBlockInt(this, i, z);
      //      BLKREFS(x)[i + 1] = BL_NUM(z);
      setIntegerAt(4*(i + 1), z._number);
      ++_free;
      declareModif(this);
    }
  }

  protected FullVectorBtree() {/*empty*/}
  
  public FullVectorBtree(VectorBtreeParameters params, boolean update)
    throws Exception {
      _params = params;
      _vecLen = params.getVectorLength();
      _blockSize = params.getBlockSize();
      _blockManager = new BlockManager(params, update, new BlockFactory() {
	public Block makeBlock() { return new FullVectorBlock(_blockSize); }
      });
      _maxEntries=(_blockSize-Block.HEADERLEN-Block.IDLEN)/(_vecLen+Block.IDLEN);
      // System.out.println("_maxEntries = " + _maxEntries);
      if ((_maxEntries & 1) == 0)	// needs to be odd
	_maxEntries--;
      _leafDataLimit = _blockSize - _vecLen -  Block.HEADERLEN - Block.IDLEN;
      _vectorsOffset = (_maxEntries + 1)*Block.IDLEN;
      _root = accessBlock(params.getRootPosition());
  }
  
  public boolean insertVector(byte[] key) throws Exception {
    if (((FullVectorBlock)_root).isFull()) {
      FullVectorBlock newRoot = getNewBlock();
      lock(newRoot);	// root is always locked
      enableModif(newRoot);
      newRoot._isLeaf = false;
      newRoot._free = 0;
      newRoot.setIntegerAt(0, _root._number);
      declareModif(newRoot);
      // System.out.println("new root; splitting old" + newRoot._number);
      newRoot.splitChild(0, (FullVectorBlock)_root, getNewBlock());
      newRoot.setIntegerAt(0, _root._number);
      unlock(_root);
      _params.setRoot(newRoot._number);
      _root = newRoot;
      // System.out.println("========= BEGIN =======================");
      /*
	try {
	mapProcessor(_root, new EdgePrinter());
	} catch (Exception e) {}
	*/
      // System.out.println("========= END =========================");
      lock(newRoot);	// root is always locked
    }
    return treeInsertNonfullRoot(key);
  }

  private boolean treeInsertNonfull(FullVectorBlock bl, byte[] key) 
    throws Exception {
      if (bl._isLeaf)
	return bl.insertVector(key);
      else {
	int i = bl.findIndex(key);
	if (i < 0)
	  return true;
	else {
	  lock(bl);
	  FullVectorBlock child = (FullVectorBlock)accessChild(bl, i);
	  if (child.isFull()) {
	    lock(child);
	    bl.splitChild(i, child, getNewBlock());
	    unlock(child);
	    //	    if (::memcmp(key, VECADDR(pbl, i), _vecLen) > 0)
	    if (memcmp(key, bl._data, vector(i), _vecLen) > 0)
	      child = (FullVectorBlock)accessChild(bl, i + 1);
	  }
	  unlock(bl);
	  return treeInsertNonfull(child, key);
	}
      }
  }
  
  private boolean treeInsertNonfullRoot(byte[] key)
    throws Exception {
      if (_root._isLeaf)
	return ((FullVectorBlock)_root).insertVector(key);
      else {
	int i = _root.findIndex(key);
	if (i < 0)
	  return true;
	else {
	  FullVectorBlock child = (FullVectorBlock)accessChild(_root, i);
	  if (child.isFull()) {
	    lock(child);
	    ((FullVectorBlock)_root).splitChild(i, child, getNewBlock());
	    unlock(child);
	    
	    if (memcmp(key, _root._data, vector(i), _vecLen) > 0)
	      child = (FullVectorBlock)accessChild(_root, i + 1);
	  }
	  return treeInsertNonfull(child, key);
	}
      }
  }
  
  private FullVectorBlock getNewBlock() throws Exception {
    return (FullVectorBlock)_blockManager.getNewBlock();
  }

  private void enableModif(Block bl) {}
  
  private void declareModif(Block bl) {
    _blockManager.setModified(bl._number);
  }
  
  public void close() throws Exception {
    _blockManager.close();
  }
}
