/*************************************************************************
 *
 *  $RCSfile: GuiDemo.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:03:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.xmlsearch.gui;

import com.jclark.xsl.om.*;

import java.awt.*;
import java.awt.event.*;

import java.io.*;
import java.util.*;
import java.text.*;
import java.net.URL;

import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.text.*;
import javax.swing.table.*;
import javax.swing.text.html.*;
import javax.swing.event.*;
// for configuration
import org.w3c.dom.Element;

import com.sun.xmlsearch.xml.qe.*;
import com.sun.xmlsearch.util.*;
import com.sun.xmlsearch.tree.*;

public final class GuiDemo extends JApplet {
    private XmlSearchClient _searchClient = new XmlSearchClient();
    private ServicesFrame _servicesFrame = new ServicesFrame();
    private ModelFrame _modelFrame = new ModelFrame();
    private ServiceNode _serviceTree;
    private String _currentDocUrl;
    private String _currentDocType;
    private String[] _commandLineArgs;
    private QueryProcessor[] _queryServices;
    private HitListPanel _hitListPanel = new HitListPanel();

    private JTextField _queryField;
    private JTextField _inElement;
    private TextPanel _textPanel;
    private TocPanel _tocPanel;

    private JSplitPane _docPane, _mainPane;
    private String _collectionType = null;
    private Hashtable _tocTreeCache = new Hashtable();
    private Hashtable _docRequests = new Hashtable();
    private Hashtable _docTypes = new Hashtable();
    
    
    private final class ServicesFrame extends JFrame {
	private JPanel _panel;
  
	public ServicesFrame() {
	    super("Select collections");
	    setBackground(Color.lightGray);
	    getContentPane().setLayout(new BorderLayout());
	    _panel = new JPanel();
	    getContentPane().add("Center", _panel);
	    pack();
	    addWindowListener(new WindowAdapter() {
		    public void windowClosing(WindowEvent e) {
			System.exit(0);
		    }});
	    setSize(200, 300);
	    show();
	}

	public void showServices() {
	    JTree tree = new JTree(new DefaultTreeModel(_serviceTree));
	    getContentPane().remove(_panel);
	    _panel = new JPanel();
	    _panel.setLayout(new BorderLayout());
	    getContentPane().add("Center", _panel);
	    for (int i = 0; i < tree.getRowCount(); i++)
		tree.expandRow(i);
	    tree.addTreeSelectionListener(new ServiceSelectionListener());
	    _panel.add("Center", new JScrollPane(tree));
	    show();
	}
    } // end of ServicesFrame

    private final class ModelFrame extends JFrame {
	private JPanel _panel;
  
	public ModelFrame() {
	    super("Select scope");
	    setBackground(Color.lightGray);
	    getContentPane().setLayout(new BorderLayout());
	    _panel = new JPanel();
	    getContentPane().add("Center", _panel);
	    pack();
	    addWindowListener(new WindowAdapter() {
		    public void windowClosing(WindowEvent e) {
			System.exit(0);
		    }});
	    setSize(200, 300);
	    show();
	}

	public void showModel() {
	    try {
		CollectionModel cmodel =
		    _searchClient.getCollectionModel(_collectionType);
		TocTree.TocNode modelRoot = cmodel.getTreeRoot();
		JTree tree = new JTree(new DefaultTreeModel(modelRoot));
		tree.setCellRenderer(new TocCellRenderer());
	  
		//tree.addTreeSelectionListener(new ScopeSelectionListener());

		getContentPane().remove(_panel);
		_panel = new JPanel();
		_panel.setLayout(new BorderLayout());
		getContentPane().add("Center", _panel);
		for (int i = 0; i < tree.getRowCount(); i++)
		    tree.expandRow(i);
		tree.addTreeSelectionListener(new ScopeSelectionListener());
		_panel.add("Center", new JScrollPane(tree));
		show();
	    }
	    catch (Exception e) {
		e.printStackTrace();
	    }
	}
    } // end of ModelFrame

    private final class ServiceNode implements TreeNode {
	private QueryProcessor _service;
	private String         _serviceName;
	private ServiceNode    _parent;
	private Vector         _children = new Vector();

	public ServiceNode(String name, QueryProcessor service) {
	    // System.out.println("new ServiceNode for " + name);
	    _serviceName = name;
	    _service = service;
	}

	public void collectServices(Vector result) throws Exception {
	    if (_service != null) {
		result.addElement(_service);
		_collectionType = _service.getDocumentType();
	    }
	    for (int i = 0; i < _children.size(); i++)
		((ServiceNode)_children.elementAt(i)).collectServices(result);
	}

	public QueryProcessor getService() {
	    return _service;
	}

	public void addChild(ServiceNode node) {
	    _children.addElement(node);
	}

	public String toString() {
	    return _serviceName;
	}

	public TreeNode getParent() {
	    return _parent;
	}

	public boolean getAllowsChildren() {
	    return true;
	}

	public boolean isLeaf() {
	    return getChildCount() == 0;
	}

	public int getChildCount() {
	    return _children.size();
	}

	public TreeNode getChildAt(int i) {
	    return (TreeNode)_children.elementAt(i);
	}

	public int getIndex(final TreeNode node) {
	    return isLeaf() ? -1 : _children.indexOf(node);
	}
    
	public Enumeration children() {
	    return _children.elements();
	}
    } // end of ServiceNode
  

    private void buildServiceTree(QueryProcessor[] processors) {
	try {
	    Hashtable nodes = new Hashtable();
	    ServiceNode root = new ServiceNode("all collections", null);
	    for (int i = 0; i < processors.length; i++) {
		QueryProcessor proc = processors[i];
		StringTokenizer topics =
		    new StringTokenizer(proc.getClassification(),"/");
		ServiceNode currentNode = root;
		while (true) {
		    String topic = topics.nextToken();
		    if (topics.hasMoreTokens()) {
			ServiceNode topicNode = (ServiceNode)nodes.get(topic);
			if (topicNode == null) {
			    topicNode = new ServiceNode(topic, null);
			    nodes.put(topic, topicNode);
			    currentNode.addChild(topicNode);
			}
			currentNode = topicNode;
		    }
		    else {
			ServiceNode topicNode = new ServiceNode(topic, proc);
			nodes.put(topic, topicNode);
			currentNode.addChild(topicNode);
			break;
		    }
		}
	    }
	    _serviceTree = root;
	}
	catch (Exception e) {
	    e.printStackTrace();
	}
    }

    private final class TextPanel extends JPanel {
	private final class HitAreaPainter
	    implements Highlighter.HighlightPainter {
	    private final Color _color;

	    public HitAreaPainter(Color c) {
		_color = c;
	    }

	    public void paint(Graphics g, int offs0, int offs1,
			      Shape bounds, JTextComponent c) {
		/*
		  try {
		  Rectangle hitArea = _editorPane.modelToView(offs0);
		  FontMetrics fm = null;
		  for (int i = 0; i < _extents.size(); i++) {
		  Extent extent = (Extent)_extents.elementAt(i);
		  Rectangle r = null;
		  while (true) {
		  try {
		  r = _editorPane.modelToView(extent.getStart());
		  if (r != null)
		  break;
		  }
		  catch (Throwable t) {
		  System.err.println(t);
		  Thread.sleep(1000);
		  }
		  }

		  hitArea.add(r.x, r.y);
		  final int lastLetter = extent.getEnd() - 1;
		  javax.swing.text.Element text =
		  _document.getCharacterElement(lastLetter);
		  if (text != null) {
		  fm = g.getFontMetrics(_document.getFont(text.getAttributes()));
		  r = _editorPane.modelToView(lastLetter);
		  hitArea.add(r.x + fm.getMaxAdvance(), r.y + fm.getHeight());
		  }
		  }
		  if (fm != null)
		  hitArea.grow(hitArea.x > 0 ? fm.getMaxAdvance()/2 : 0,
		  fm.getHeight()/4);
		  g.setColor(_color);
		  g.fillRect(hitArea.x, hitArea.y, hitArea.width, hitArea.height);
		  }
		  catch (Exception e) {
		  e.printStackTrace();
		  }
		*/
	    }
	} // end of HitAreaPainter
  
	private HTMLDocument _document;
	private Vector _extents;
	private DefaultHighlighter.DefaultHighlightPainter _painter1;
	private HitAreaPainter _painter2;
	private JScrollPane _scroller;
	private MyHTMLPane _editorPane;
	private JViewport _viewPort;
	private DefaultHighlighter _highlighter;
	private Extent _hitExtent;

	private final class MyHTMLPane extends JEditorPane {
	    private HTMLDocument _doc;

	    public synchronized HTMLDocument load(final InputStream in) {
		try {
		    HTMLEditorKit kit = new HTMLEditorKit();
		    setEditorKit(kit);
		    _doc = (HTMLDocument) kit.createDefaultDocument();
		    setDocument(_doc);
		    _doc.setPreservesUnknownTags(true); // for '<hl>'
		    _doc.setTokenThreshold(Integer.MAX_VALUE);
		    read(in, _doc);
		    setEditable(false);
		}
		catch (Exception e) {
		    e.printStackTrace();
		}
		return _doc;
	    }
      
	    public synchronized Vector getExtents(int nHighlights) {
		Vector result = new Vector();
		if (nHighlights > 0) {
		    int counter = 0, start = 0;
		    ElementIterator ei = new ElementIterator(_doc);
		    javax.swing.text.Element el;
		LOOP:
		    for (el = ei.first(); el != null; el = ei.next())
			if (el.getName().equals(HtmlContent.HighlightTag))
			    switch (counter++ % 4) {
			    case 1:		// every second...
				start = el.getEndOffset();
				break;
		
			    case 2:		// ... and third
				result.addElement(new
				    Extent(start, el.getStartOffset()));
				if (--nHighlights == 0)
				    break LOOP;
			    }
		}
		return result;
	    }
	}	// end of MyHTMLPane

	public TextPanel() {
	    super(true);
	    // Force SwingSet to come up in the Cross Platform L&F
	    try {
		UIManager
		    .setLookAndFeel(UIManager
				    .getCrossPlatformLookAndFeelClassName());
		// If you want the System L&F instead,
		// comment out the above line and
		// uncomment the following:
		// UIManager.setLookAndFeel(UIManager
		// .getSystemLookAndFeelClassName());
	    } catch (Exception exc) {
		System.err.println("Error loading L&F: " + exc);
	    }
	    setBorder(BorderFactory.createEtchedBorder());
	    setLayout(new BorderLayout());
    
	    _scroller = new JScrollPane();
	    add("Center", _scroller);
    
	    _painter1 =
		new DefaultHighlighter.DefaultHighlightPainter(Color.pink);
	    _painter2 = new HitAreaPainter(new Color((float)0.7, (float)0.7,
						     (float)0.7, (float)0.4));
	    _viewPort = new JViewport();
	    _editorPane = new MyHTMLPane();
	    _viewPort.add(_editorPane);
	    _scroller.setViewport(_viewPort);
	    _hitExtent = null;
	}
  
	private final class DocumentLoader extends SwingWorker {
	    private DocumentFragment _fragment;
	    private MyHTMLPane _pane;
	    private int _nHighlights;

	    public DocumentLoader(DocumentFragment fragment) {
		_fragment = fragment;
	    }

	    public Object construct() {
		_pane = new MyHTMLPane();
		_pane.load(_fragment.getInputStream());
		_nHighlights = _fragment.getNumberOfHighlights();
		System.out.println("DocumentLoader, _nHighlights = " + _nHighlights);
		_viewPort = new JViewport();
		_viewPort.add(_pane);
		_scroller.setViewport(_viewPort);
		_editorPane = _pane;
		_editorPane.addHyperlinkListener(createHyperLinkListener());
		_pane.validate();
		if (_nHighlights > 0) {
		    DefaultHighlighter highlighter = new DefaultHighlighter();
		    _pane.setHighlighter(highlighter);
		    _extents = _pane.getExtents(_nHighlights);
		    installHighlights(_pane, highlighter);
		}
		return "done";
	    }
	
	    public void finished() {
		try {
		    if (_nHighlights == 0)
			_viewPort.scrollRectToVisible(new Rectangle(10, 10));
		    else {
			(new Thread() {
				public void run() {
				    try {
					scrollToHit(_pane);
				    }
				    catch (Exception e) {
					System.err.println(e);
				    }
				}}).start();
		    }
		}
		catch (Exception e) {
		    e.printStackTrace();
		}
		finally {
		    repaint();
		    changeCursorToWait(false);
		    System.gc();
		}
	    }
	} // end of DocumentLoader

	/*
	  public synchronized void show(InputStream in, int nHighlights) {
	  _hitExtent = null;
	  _extents = new Vector();
	  SwingWorker worker = new DocumentLoader(in, nHighlights);
	  worker.startThread();
	  (new Thread() {
	  public void run() {
	  try {
	  Thread.sleep(4000);
	  repaint();
	  }
	  catch (Exception e) {
	  }
	  }}).start();
	  }
	*/
    
	public synchronized void show(DocumentFragment fragment) {
	    _hitExtent = null;
	    _extents = new Vector();
	    SwingWorker worker = new DocumentLoader(fragment);
	    worker.startThread();
	}

	private void installHighlights(MyHTMLPane pane,
				       DefaultHighlighter highlighter) {
	    try {
		if (_extents != null) {
		    int min = Integer.MAX_VALUE;
		    int max = Integer.MIN_VALUE;
		    for (int i = 0; i < _extents.size(); i++) {
			Extent extent = (Extent)_extents.elementAt(i);
			int start = extent.getStart();
			int end = extent.getEnd();
			// individual token highlight
			highlighter.addHighlight(start, end, _painter1);
			// update bounds
			if (start < min)
			    min = start;
			if (end > max)
			    max = end;
		    }
		    if (min < max) {		// matching terms' group
			highlighter.addHighlight(min, max, _painter2);
			_hitExtent = new Extent(min, max);
		    }
		}
	    }
	    catch (BadLocationException e) {
		e.printStackTrace();
	    }
	}
	  
	private void scrollToHit(MyHTMLPane pane) throws Exception {
	    if (_hitExtent != null) {
		int start = _hitExtent.getStart();
		int end   = _hitExtent.getEnd();
		System.out.println("start = " + start);
		Rectangle hitArea = null;
		int nAttempts = 3;
		while (nAttempts-- > 0) {
		    try {
			hitArea = pane.modelToView(start);
			if (hitArea != null) {
			    Thread.sleep(1000);
			    hitArea = pane.modelToView(start);
			    break;
			}
		    }
		    catch (Throwable t) {
			System.err.println(t);
		    }
		    System.out.println("hitArea = " + hitArea);
		    Thread.sleep(1000);
		}
		
		System.out.println("hitArea = " + hitArea);
		if (hitArea != null) {
		    hitArea = hitArea.union(pane.modelToView(end));
		    if (_viewPort.getViewRect().contains(hitArea) == false) {
			// try to show the hit in the middle of pane
			hitArea.translate(0, _viewPort.getViewRect().height/2);
			_viewPort.scrollRectToVisible(hitArea);
		    }
		}
	    }
	    else
		System.err.println("no _hitExtent");
	}

	public HyperlinkListener createHyperLinkListener() {
	    return new HyperlinkListener() {
		    public void hyperlinkUpdate(HyperlinkEvent e) {
			if (e.getEventType() ==
			    HyperlinkEvent.EventType.ACTIVATED) {
			    System.out.println(e.getDescription());
			    showDocFragment(e.getDescription(), "/doc");
			}
		    }
		};
	}
    } // end of TextPanel

    private final class TocCellRenderer extends JLabel implements TreeCellRenderer {
	public Component getTreeCellRendererComponent(JTree tree,
						      Object value,
						      boolean sel,
						      boolean expanded,
						      boolean leaf,
						      int row,
						      boolean hasFocus) {
	    String text = "";
	    if (value instanceof TocTree.TocNode)
		text = ((TocTree.TocNode)value).getTitle();
	    setEnabled(tree.isEnabled());
	    setText(text);
	    setForeground(sel ? Color.red : Color.black);
	    return this;
	}
    }	// end of TocCellRenderer

    private final class TocPanel extends JPanel implements TreeSelectionListener {
	protected DefaultMutableTreeNode rootNode;
	protected DefaultTreeModel treeModel;
	protected JTree tree;
	private Toolkit toolkit = Toolkit.getDefaultToolkit();

	public TocPanel() {
	    rootNode = new DefaultMutableTreeNode("Table of Contents");
	    treeModel = new DefaultTreeModel(rootNode);
	    tree = new JTree(treeModel);
	    tree.setEditable(false);
	    tree.setCellRenderer(new TocCellRenderer());
	    tree.getSelectionModel().setSelectionMode
		(TreeSelectionModel.DISCONTIGUOUS_TREE_SELECTION);
	    tree.setShowsRootHandles(false);
	    setLayout(new GridLayout(1,0));
	    add(new JScrollPane(tree));
	    tree.addTreeSelectionListener(this);
	}
    
	public void valueChanged(TreeSelectionEvent e) {
	    TreePath path = tree.getSelectionPath();
	    if (path == null)	// rm selection
		return;
	    Object selected = path.getLastPathComponent();
	    if (selected instanceof TocTree.TocNode) {
		changeCursorToWait(true);
		showDocFragment(_currentDocUrl,
				_currentDocType,
				((TocTree.TocNode)selected).getXPath());
	    }
	}

	public void loadToc(DocumentFragment fragment) {
	    tree.removeTreeSelectionListener(this);
	    TocTree.TocNode[] tocPath = fragment.nodes();
	    rootNode.removeAllChildren();
	    treeModel.reload();
	    treeModel = new DefaultTreeModel(tocPath[0]);
	    tree.setModel(treeModel);
	  
	    TreePath treePath = new TreePath(tocPath[0]);
	    for (int i = 1; i < tocPath.length; i++) {
		treePath = treePath.pathByAddingChild(tocPath[i]);
		tree.addSelectionPath(treePath);
	    }
	    tree.addTreeSelectionListener(this);
	}
    } // end of TocPanel
    
    public void showDocFragment(String link, String xPath) {
	System.out.println("LINK = " + link);
	final int comma = link.indexOf(',');
	showDocFragment(link.substring(comma + 1),
			link.substring(0, comma),
			xPath);
    }
    
    public void showDocFragment(String docUrlString, String type, String xPath) {
	DocumentRequest request = getDocRequest(docUrlString, type);
	request.setFocus(new MultiTokenLocator(xPath));
	SwingWorker worker = new DocumentFragmentThread(request);
	worker.startThread();
    }

    public GuiDemo() {
	super();
    }

    public GuiDemo(String[] args) {
	if (args.length == 0)
	    args = new String[] { "-configFile", "defaultGuiConfig.cfg" };
	_commandLineArgs = args;
    }

    private void initialize(String[] args) {
	try {
	    Element config = Configuration.configElementFromArgs(args);
	    if (config != null) {
		_searchClient.init(config);
		_queryServices = _searchClient.getProcessors();
		buildServiceTree(_queryServices);
		_servicesFrame.showServices();
	    }
	}
	catch (Exception e) {
	    e.printStackTrace();
	}
    }

    public static void main(String[] args) {
	try {
	    final ExtensibleURLStreamHandlerFactory factory =
		new ExtensibleURLStreamHandlerFactory();
	    
	    factory.setHandler("star", "com.sun.xmlsearch.util.StarURLStreamHandler");
	    
	    URL.setURLStreamHandlerFactory(factory);
		
	    final GuiDemo applet = new GuiDemo(args);
	    JFrame frame = new JFrame("XML Document Search");
	    frame.getContentPane().add("Center", applet);
	    frame.addWindowListener(new WindowAdapter() {
		    public void windowClosing(WindowEvent e) {
			applet.close();
			System.exit(0);
		    }});
	    applet.init();
	    applet.start();
	    frame.pack();
	    frame.setSize(new Dimension(800, 800));
	    frame.setVisible(true);
	}
	catch (Throwable t) {
	    t.printStackTrace(System.out);
	}
    }

    public void close() {
	_searchClient.close();
    }

    /*
      private final class HitListPanel extends JPanel {
    
      private final class QueryHitRenderer extends JLabel implements ListCellRenderer {
      public Component getListCellRendererComponent(JList list,
      Object object,
      int index,
      boolean isSelected,
      boolean hasFocus) {
      if (object instanceof QueryHitData) {
      QueryHitData hit = (QueryHitData) object;
      final int n = hit.getNumberOfTerms();
      String doc = hit.getDocument();
      StringBuffer buffer = new StringBuffer(128);
      buffer.append(doc.substring(doc.lastIndexOf('/') + 1));
      buffer.append("        ");
      for (int i = 0; i < n; i++) {
      String term = hit.getTerm(i);
      buffer.append(" ");
      buffer.append(term != null ? term : " ... ");
      }
      setText(buffer.toString());
      }
      setForeground(isSelected ? Color.red : Color.black);
      return this;
      }
      }

      JList listBox;
      JScrollPane scrollPane;
      DefaultListModel model = new DefaultListModel();

      public HitListPanel() {
      setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
      listBox = new JList(model) {
      public Dimension getMaximumSize() {
      return new Dimension(400, super.getMaximumSize().height);
      }
      };
      listBox.addListSelectionListener(new ListSelectionListener() {
      public void valueChanged(ListSelectionEvent ev) {
      if (ev.getValueIsAdjusting()) {
      Object object = model.elementAt(listBox.getSelectedIndex());
      if (object instanceof QueryHitData)
      showHit((QueryHitData) object);
      }
      }
      });
      listBox.setCellRenderer(new QueryHitRenderer());

      scrollPane = new JScrollPane(listBox);
      scrollPane.setAlignmentX(LEFT_ALIGNMENT);
      scrollPane.setAlignmentY(TOP_ALIGNMENT);
      add(scrollPane);
      }
    
      public void loadHits(QueryResults hits) {
      model.removeAllElements();
      if (hits.isNonEmpty()) {
      QueryHitIterator iter = hits.makeQueryHitIterator();
      do {
      model.addElement(iter.getHit());
      }
      while (iter.next());
      }
      }
      }
    */

    private final class HitListPanel extends JPanel {
	DefaultTableModel model = new DefaultTableModel();
	JTable hitTable = new JTable(model);
	JScrollPane scrollPane;
	QueryResults _results;
    
	public HitListPanel() {
	    model.addColumn("score");
	    model.addColumn("document");
	    model.addColumn("matching terms");
      
	    hitTable.setModel(model);
	    hitTable.getSelectionModel()
		.addListSelectionListener(new ListSelectionListener() {
			public void valueChanged(ListSelectionEvent ev) {
			    if (ev.getValueIsAdjusting())
				showHit(_results, hitTable.getSelectedRow());
			}
		    });
	    hitTable.getSelectionModel()
		.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
	    setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
	    scrollPane = new JScrollPane(hitTable);
	    scrollPane.setAlignmentX(LEFT_ALIGNMENT);
	    scrollPane.setAlignmentY(TOP_ALIGNMENT);
	    add(scrollPane);
	}
    
	public void loadHits(QueryResults hits) {
	    _results = hits;
	    int lastRow = model.getRowCount() - 1;
	    while (lastRow >= 0)
		model.removeRow(lastRow--);

	    if (hits.isNonEmpty()) {
		QueryHitIterator iter = hits.makeQueryHitIterator();
		do {
		    QueryHitData hit = iter.getHit();
		    String doc = hit.getDocument();
		    final int n = hit.getNumberOfTerms();
		    StringBuffer buffer = new StringBuffer(128);
		    for (int i = 0; i < n; i++) {
			String term = hit.getTerm(i);
			buffer.append(term != null ? term : "--");
			if (i < n - 1)
			    buffer.append(", ");
		    }
		    model.addRow(new Object[] { new Double(100.0 - hit.getPenalty()),
						doc.substring(doc.lastIndexOf('/') + 1),
						buffer.toString() });
		}
		while (iter.next());
		hitTable.addRowSelectionInterval(0, 0);
	    }
	}
    } // end of HitListPanel

    static void makeButton(Container cont, Component comp,
			   int x, int y, int w, int h,
			   double weightx, double weighty) {
	GridBagLayout gbl = (GridBagLayout)cont.getLayout();
	GridBagConstraints c = new GridBagConstraints();

	c.fill = GridBagConstraints.BOTH;
	c.gridx = x;
	c.gridy = y;
	c.gridwidth = w;
	c.gridheight = h;
	c.weightx = weightx;
	c.weighty = weighty;
	cont.add(comp);
	gbl.setConstraints(comp, c);
    }
  
    public void start() {}

    private final class ScopeSelectionListener implements TreeSelectionListener {
	public void valueChanged(TreeSelectionEvent e) {
	    System.out.println(e);
	    TreePath path = e.getPath();
	    if (path == null)	// rm selection
		return;
	    Object selected = path.getLastPathComponent();
	    if (selected instanceof TocTree.TocNode) {
		_inElement.setText(((TocTree.TocNode)selected).getXPath());
		startSearch();
	    }
	}
    } // end of ScopeSelectionListener
      
    private final class ServiceSelectionListener implements TreeSelectionListener {
	public void valueChanged(TreeSelectionEvent e) {
	    TreePath path = e.getPath();
	    if (path == null)	// rm selection
		return;
	    Object selected = path.getLastPathComponent();
	    if (selected instanceof ServiceNode) {
		try {
		    Vector services = new Vector();
		    ((ServiceNode)selected).collectServices(services);
		    _searchClient.setupQueryProcessor(services);
		    _inElement.setText("");
	  
		    _collectionType =
			((QueryProcessor)services.elementAt(0))
			.getDocumentType();
		    _modelFrame.showModel();
		    startSearch();
		}
		catch (Exception ex) {
		    ex.printStackTrace();
		}
	    }
	}
    } // end of ScopeSelectionListener
 
    private JMenuBar createMenus() {
	JMenuItem mi;
	final JMenuBar menuBar = new JMenuBar();
	JMenu fileMenu = (JMenu) menuBar.add(new JMenu("File"));
	createMenuItem(fileMenu,
		       "Exit",
		       0,
		       new AbstractAction() {
			       public void actionPerformed(ActionEvent e) {
				   close();
				   System.exit(0);
			       }
			   });

	createMenuItem(fileMenu,
		       "Scope",
		       0,
		       new AbstractAction() {
			       public void actionPerformed(ActionEvent e) {
				   Object[]      message = new Object[1];
				   try {
				       CollectionModel cmodel =
					   _searchClient
					   .getCollectionModel(_collectionType);
				       TocTree.TocNode modelRoot =
					   cmodel.getTreeRoot();
				       JTree tree =
					   new JTree(new DefaultTreeModel(modelRoot));
				       tree.setCellRenderer(new TocCellRenderer());
	  
				       for (int i = 0; i < tree.getRowCount(); i++)
					   tree.expandRow(i);

				       tree.addTreeSelectionListener(new ScopeSelectionListener());
				       /*
					 TreeSelectionModel model = new DefaultTreeSelectionModel();
					 model.setSelectionMode(TreeSelectionModel.DISCONTIGUOUS_TREE_SELECTION);
					 tree.setSelectionModel(model);
				       */
				       message[0] = new JScrollPane(tree);
	  
				       String[] options = { "Dismiss" };
				       JOptionPane.showOptionDialog(menuBar,
								    message,
								    "select scope",
								    JOptionPane.DEFAULT_OPTION,
								    JOptionPane.QUESTION_MESSAGE,
								    null,
								    options,
								    options[0]);
				   }
				   catch (Exception ex) {
				       ex.printStackTrace();
				   }
			       }
			   });
    
    
	createMenuItem(fileMenu,
		       "Services",
		       0,
		       new AbstractAction() {
			       public void actionPerformed(ActionEvent e) {
				   if (_servicesFrame == null)
				       _servicesFrame = new ServicesFrame();

				   /*
				     Object[]      message = new Object[1];
				     try {
				     JTree tree = new JTree(new DefaultTreeModel(_serviceTree));
				     for (int i = 0; i < tree.getRowCount(); i++)
				     tree.expandRow(i);
				     tree.addTreeSelectionListener(new ServiceSelectionListener());
				     message[0] = new JScrollPane(tree);
	  
				     String[] options = { "Dismiss" };
				     JOptionPane.showOptionDialog(menuBar,
				     message,
				     "select services",
				     JOptionPane.DEFAULT_OPTION,
				     JOptionPane.QUESTION_MESSAGE,
				     null,
				     options,
				     options[0]);
				     }
				     catch (Exception ex) {
				     ex.printStackTrace();
				     }
				   */
			       }
			   });
    
	return menuBar;
    }

    /**
     * Creates a generic menu item
     */
    private JMenuItem createMenuItem(JMenu menu, String label, int mnemonic,
				     Action action) {
	JMenuItem mi = (JMenuItem) menu.add(new JMenuItem(label));
	mi.setMnemonic(mnemonic);
	if(action == null)
	    mi.setEnabled(false);
	else
	    mi.addActionListener(action);
	return mi;
    }
  
    private final class SearchThread extends SwingWorker {
	private final String _queryLine;
	private final String _scopeLine;
    
	public SearchThread(String queryLine, String scopeLine) {
	    _queryLine = queryLine;
	    _scopeLine = scopeLine;
	}

	public Object construct() {
	    changeCursorToWait(true);
	    QueryResults results =
		_searchClient.runQuery(_queryLine, _scopeLine);
	    results.translate();
	    groupHits(results);
	    _hitListPanel.loadHits(results);
	    // show first hit
	    showHit(results, 0);
	    return results;
	}
    
	public void finished() {
	    changeCursorToWait(false);
	    repaint();
	}
    } // end of SearchThread

    private final class DocumentFragmentThread extends SwingWorker {
	private DocumentRequest _request;

	public DocumentFragmentThread(DocumentRequest request) {
	    _request = request;
	}

	public Object construct() {
	    try {
		synchronized (_searchClient) {
		    DocumentFragment fragment = getDocumentFragment(_request);
		    _currentDocUrl = _request.getDocument();
		    _currentDocType = _request.getDocumentType();
		    _tocPanel.loadToc(fragment);
		    _textPanel.show(fragment);
		    return fragment;
		}
	    }
	    catch (Exception e) {
		e.printStackTrace();
		return null;
	    }
	}
    
	public void finished() {
	    changeCursorToWait(false);
	    repaint();
	}
    } // end of DocumentFragmentThread

    private DocumentFragment getDocumentFragment(DocumentRequest request)
	throws Exception {
	String document = request.getDocument();
	TocTree tocTree = (TocTree)_tocTreeCache.get(document);
	final boolean tocNeeded = tocTree == null;
	// request TOC if not in cache
	request.requestToc(tocNeeded);
	DocumentFragment result = _searchClient.getDocumentFragment(request);
	if (tocNeeded)
	    _tocTreeCache.put(document, result.getTocTree());
	else
	    result.setTOC(tocTree);	// reuse cached TOC
	return result;
    }
  
    private void showHit(QueryResults results, int index) {
	if (results.size() > index) {
	    QueryHitData hit = results.getHit(index);
	    DocumentRequest request = getDocRequest(hit.getDocument(),
						    hit.getDocumentType());
	    request.setFocus(hit.getLocator());
	    SwingWorker worker = new DocumentFragmentThread(request);
	    worker.startThread();
	}
    }

    private DocumentRequest getDocRequest(String document, String type) {
	DocumentRequest req = (DocumentRequest)_docRequests.get(document);
	return req != null ? req : new DocumentRequest(document, type);
    }

    private void groupHits(QueryResults hits) {
	_docRequests.clear();
	_docTypes.clear();
	if (hits.isNonEmpty()) {
	    final QueryHitIterator iter = hits.makeQueryHitIterator();
	    do {
		final QueryHitData hit = iter.getHit();
		final String doc = hit.getDocument();
		Vector docLocators = (Vector)_docRequests.get(doc);
		if (docLocators == null) {
		    _docRequests.put(doc, docLocators = new Vector());
		    System.out.println("doc = " + doc);
		    
		    System.out.println("hit.getDocumentType() " + hit.getDocumentType());
		    
		    _docTypes.put(doc, hit.getDocumentType());
		}
		docLocators.addElement(hit.getLocator());
	    }
	    while (iter.next());
	    final Enumeration keys = _docRequests.keys();
	    do {
		final String doc = (String)keys.nextElement();
		final String docType = (String)_docTypes.get(doc);
		DocumentRequest request = new DocumentRequest(doc, docType);
		request.setLocators((Vector)_docRequests.get(doc));
		_docRequests.put(doc, request);
	    }
	    while (keys.hasMoreElements());
	}
    }

    private synchronized void startSearch() {
	if (_queryField.getText().trim().length() > 0) {
	    SwingWorker worker = new SearchThread(_queryField.getText(),
						  _inElement.getText());
	    worker.startThread();
	}
    }

    public void init() {
	if (_commandLineArgs != null)
	    initialize(_commandLineArgs);
	else
	    initialize(new String[] { "-configURL", getParameter("configURL") });

	JPanel mainPanel = new JPanel();
	Box mainBox = Box.createVerticalBox();
	Box menuBox = Box.createHorizontalBox();
	GridBagLayout layout = new GridBagLayout();
    
	menuBox.add(createMenus());
	menuBox.add(Box.createHorizontalGlue());
	mainBox.add(menuBox);
	mainBox.add(mainPanel);
    
	mainPanel.setLayout(layout);
    
	JPanel f = new JPanel();
	f.setLayout(new GridBagLayout());
	f.setBorder(BorderFactory.createTitledBorder("Query"));
	_queryField = new JTextField("select font style", 5);
	_inElement = new JTextField("", 5);
	makeButton(f, new Label("Search for:"), 0, 0, 1, 1, 0.0, 0.0);
	makeButton(f, new Label("In scope:"),   0, 1, 1, 1, 0.0, 0.0);

	makeButton(f, _queryField,              1, 0, 1, 1, 1.0, 0.0);
	makeButton(f, _inElement,               1, 1, 1, 1, 1.0, 0.0);

	ActionListener al = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    startSearch();
		}};

	_queryField.addActionListener(al);
	_inElement.addActionListener(al);

	_tocPanel = new TocPanel();
	_textPanel = new TextPanel();

	_docPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,
				  _tocPanel, _textPanel);
	_mainPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT,
				   _hitListPanel, _docPane);
	_mainPane.setMinimumSize(new Dimension(400, 200));
	_tocPanel.setMinimumSize(new Dimension(70, 200));
	_textPanel.setMinimumSize(new Dimension(400, 200));
	_hitListPanel.setMinimumSize(new Dimension(500, 70));
	_mainPane.setContinuousLayout(true);
	_mainPane.setOneTouchExpandable(true);
	_docPane.setContinuousLayout(true);
	_docPane.setOneTouchExpandable(true);
	_mainPane.setDividerLocation(50);
	_docPane.setDividerLocation(150);

	GridBagConstraints c = new GridBagConstraints();
	c.gridx = 0;
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.weightx = 1.0;
	c.fill = GridBagConstraints.HORIZONTAL;
	mainPanel.add(f);
	layout.setConstraints(f, c);
    
	c = new GridBagConstraints();
	c.gridx = 0;
	c.weightx = 1.0;
	c.weighty = 1.0;
	c.gridheight = GridBagConstraints.REMAINDER;
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.fill = GridBagConstraints.BOTH;
	mainPanel.add(_mainPane);
	layout.setConstraints(_mainPane, c);
	getContentPane().add(mainBox);
    }

    /*
      private final class HtmlContext implements XmlSearchContext {
      // current heuristic: find first parent represented in TOC
      public Node[] getNodesToTransform(Node docRoot, Node hitNode) {
      Node parent = hitNode.getParent();
      while (_searchClient.getTocNodeForDocNode(parent) == null)
      parent = parent.getParent();
      return new Node[] { parent };
      }
  
      public String getTransformUrlString(String docUrlString) {
      int lastSlash = docUrlString.lastIndexOf('/');
      return lastSlash != -1
      // default 'well-known' name
      ? docUrlString.substring(0, lastSlash + 1) + "toHtml.xsl"
      : null;
      }
      } // end of HtmlContext
  
      public String getHtmlTransformUrlString(String docUrlString) {
      return getTransformUrlString(docUrlString, "toHtml.xsl");
      }

      public String getTransformUrlString(String docUrlString, String fileName) {
      int lastSlash = docUrlString.lastIndexOf('/');
      return lastSlash != -1
      // default 'well-known' name
      ? docUrlString.substring(0, lastSlash + 1) + fileName
      : null;
      }
    */

    private synchronized void changeCursorToWait(boolean wait) {
	setCursor(new Cursor(wait
			     ? Cursor.WAIT_CURSOR
			     : Cursor.DEFAULT_CURSOR));
    }
}
