/*************************************************************************
 *
 *  $RCSfile: GenericXMLExportFilter.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: jsc $ $Date: 2001/11/08 16:59:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Martin Gallwey (gallwey@sun.com)
 *
 *
 ************************************************************************/

#ifndef _GENERICXMLEXPORTFILTER_HXX
#include <GenericXMLExportFilter.hxx>
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XACTIVEDATASOURCE_HPP_
#include <com/sun/star/io/XActiveDataSource.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif

using rtl::OUString;
using com::sun::star::uno::Sequence;
using com::sun::star::uno::Reference;
using com::sun::star::uno::Any;
using com::sun::star::uno::UNO_QUERY;
using com::sun::star::uno::XInterface;
using com::sun::star::uno::Exception;
using com::sun::star::uno::RuntimeException;
using com::sun::star::lang::XMultiServiceFactory;
using com::sun::star::io::XActiveDataSource;
using com::sun::star::io::XOutputStream;
using com::sun::star::beans::PropertyValue;
using com::sun::star::document::XExporter;
using com::sun::star::document::XFilter;

sal_Bool SAL_CALL GenericXMLExportFilter::filter( const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& aDescriptor ) 
	throw (RuntimeException)
{
	sal_Int32 nLength = aDescriptor.getLength();
	const PropertyValue * pValue = aDescriptor.getConstArray();
	OUString sFileName;
	Reference < XOutputStream > xOutputStream;
	for ( sal_Int32 i = 0 ; i < nLength; i++)
	{
		if ( pValue[i].Name.equalsAsciiL ( RTL_CONSTASCII_STRINGPARAM ( "OutputStream" ) ) )
		{
			pValue[i].Value >>= xOutputStream;
			break;
		}
	}
	if ( !xOutputStream.is() )
	{
		OSL_ASSERT ( 0 );
		return sal_False;
	}
	const OUString sSaxWriter ( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.xml.sax.Writer") );
	/* The idea was that it could invoke a different export component based on the filtername
	 * but for the moment, we just want it to export writer files 
	   for example:
		   if ( msFilterName.equalsAsciiL ( RTL_CONSTASCII_STRINGPARAM ( "writer_Flat_XML_File" ) ) ) */
	const OUString sXMLExportService ( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.comp.Writer.XMLExporter" ) ); 

	Reference < XActiveDataSource > xSaxWriter( mxMSF->createInstance( sSaxWriter ), UNO_QUERY );

	xSaxWriter->setOutputStream( xOutputStream );
	Sequence < Any > aAnys ( 1 );
	aAnys[0] <<= xSaxWriter;
	Reference < XExporter > xExporter( mxMSF->createInstanceWithArguments ( sXMLExportService, aAnys ), UNO_QUERY );
	Reference < XFilter > xFilter( xExporter, UNO_QUERY );
	xExporter->setSourceDocument ( mxDoc );
	return xFilter->filter ( aDescriptor );
}
void SAL_CALL GenericXMLExportFilter::cancel(  ) 
	throw (RuntimeException)
{
}
// XExporter
void SAL_CALL GenericXMLExportFilter::setSourceDocument( const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent >& xDoc ) 
	throw (::com::sun::star::lang::IllegalArgumentException, RuntimeException)
{
	mxDoc = xDoc;
}
// XInitialization
void SAL_CALL GenericXMLExportFilter::initialize( const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any >& aArguments ) 
	throw (Exception, RuntimeException)
{
	if ( aArguments.getLength() )
		aArguments[0] >>= msFilterName;
}
OUString GenericXMLExportFilter_getImplementationName ()
	throw (RuntimeException)
{
	return OUString ( RTL_CONSTASCII_USTRINGPARAM ( "com.sun.star.comp.Writer.GenericXMLExportFilter" ) );
}
#define SERVICE_NAME "com.sun.star.document.ExportFilter"
sal_Bool SAL_CALL GenericXMLExportFilter_supportsService( const OUString& ServiceName ) 
	throw (RuntimeException)
{
    return ServiceName.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM ( SERVICE_NAME ) );
}
Sequence< OUString > SAL_CALL GenericXMLExportFilter_getSupportedServiceNames(  ) 
	throw (RuntimeException)
{
	Sequence < OUString > aRet(1);
    OUString* pArray = aRet.getArray();
    pArray[0] =  OUString ( RTL_CONSTASCII_USTRINGPARAM ( SERVICE_NAME ) );
    return aRet;
}
#undef SERVICE_NAME

Reference< XInterface > SAL_CALL GenericXMLExportFilter_createInstance( const Reference< XMultiServiceFactory > & rSMgr)
	throw( Exception )
{
	return (cppu::OWeakObject*) new GenericXMLExportFilter( rSMgr );
}

// XServiceInfo
OUString SAL_CALL GenericXMLExportFilter::getImplementationName(  ) 
	throw (RuntimeException)
{
	return GenericXMLExportFilter_getImplementationName();
}
sal_Bool SAL_CALL GenericXMLExportFilter::supportsService( const OUString& rServiceName ) 
	throw (RuntimeException)
{
    return GenericXMLExportFilter_supportsService( rServiceName );
}
::com::sun::star::uno::Sequence< OUString > SAL_CALL GenericXMLExportFilter::getSupportedServiceNames(  ) 
	throw (RuntimeException)
{
    return GenericXMLExportFilter_getSupportedServiceNames();
}
