COMMENT %
        Operating System Layer (osl)
        
        Thread Stack Switching

        17-FEB-98       created         hro
 
   $RCSfile: switch.asm,v $
 
   $Revision: 1.2 $
 
   last change: $Author: mh $ $Date: 2000/11/28 18:27:49 $
 
   The Contents of this file are made available subject to the terms of
   either of the following licenses
 
          - GNU Lesser General Public License Version 2.1
          - Sun Industry Standards Source License Version 1.1
 
   Sun Microsystems Inc., October, 2000
 
   GNU Lesser General Public License Version 2.1
   =============================================
   Copyright 2000 by Sun Microsystems, Inc.
   901 San Antonio Road, Palo Alto, CA 94303, USA
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License version 2.1, as published by the Free Software Foundation.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
 
   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
   MA  02111-1307  USA
 
 
  Sun Industry Standards Source License Version 1.1
   =================================================
   The contents of this file are subject to the Sun Industry Standards
   Source License Version 1.1 (the "License"); You may not use this file
   except in compliance with the License. You may obtain a copy of the
   License at http://www.openoffice.org/license.html.
 
   Software provided under this License is provided on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
   See the License for the specific provisions governing your rights and
   obligations concerning the Software.
 
   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 
   Copyright: 2000 by Sun Microsystems, Inc.
 
   All Rights Reserved.
 
   Contributor(s): _______________________________________
 
 
%

                PUBLIC  _transfer_context
                PUBLIC  _create_context

                EXTRN   _thread_exit:FAR
                EXTRN   _thread_startup      : FAR
                

_DATA   SEGMENT DWORD PUBLIC 'DATA'
_DATA   ENDS

switch_CODE   SEGMENT WORD PUBLIC 'CODE'
.286



startup PROC FAR

; Jetzt die Tools-Daten aus dem abgelegten Stack holen

		  push	ss
        pop		es
        mov     ds,es:[2]
        xor		 di,di
        xor		 si,si
        cld
        mov		 cx,8
        rep	    movsw

        mov     ax,_DATA
        mov     ds,ax
        sti
        cld
        ret
startup ENDP

shutdown PROC FAR
        push    dx
        push    ax
        call _thread_exit
shutdown ENDP

switch_context PROC FAR
        mov es,dx
        mov di,ax
        mov es:[di],sp
        mov es:[di+2],ss
        mov es,cx
        mov di,bx
        cli
        mov sp,es:[di]
        mov ss,es:[di+2]
        ret
switch_context ENDP



;       void *create_context(void *stackbase, void *entry, void *param, unsigned short stksize);
;       ES:DI   ->      stackbase
;       CX:BX   ->      entry
;       DX:AX   ->      param
;       SI      ->      stksize
;       result  ->      DX:AX

_create_context PROC FAR
        push    bp
        mov     bp,sp
        push    di
        push    es

        les		di,[bp+6]

; Den aktuellen Stackbase ablegen, da sollte spaetestens bei Aktivierung des
; Thread der Zeiger fuer die Tools-Daten gesetzt sein.

        mov		word ptr es:[0],0
        mov		es:[2],ss

        add     di,[bp+18]
        std
        sub     di,2
        mov     ax,[bp+16]
        stosw
        mov     ax,[bp+14]
        stosw
        mov     ax,seg shutdown
        stosw
        mov     ax,offset shutdown
        stosw
        mov     ax,[bp+12]
        stosw
        mov     ax,[bp+10]
        stosw
        mov     ax,seg _thread_startup
        stosw
        mov     ax,offset _thread_startup
        stosw
        mov		 ax,seg startup
        stosw
        mov     ax,offset startup
        stosw
        add     di,2
        cld
        mov     dx,es
        mov     ax,di

        pop     es
        pop     di
        pop     bp

        ret
_create_context ENDP


;       void transfer_context(void **curContext, void **newContext);
;       ES:DI   ->      curContext
;       DS:SI   ->      newContext

transfer_context_ PROC FAR
IFDEF __386__
        pushad
        pushfd
        push fs
        push gs
ELSE
        pusha
        pushf
ENDIF
        push ds
        push es

        call switch_context

        pop es
        pop ds
        
IFDEF __386__
        pop     gs
        pop     fs
        popfd
        popad
ELSE
        popf
        popa
ENDIF
        ret
transfer_context_ ENDP

_transfer_context PROC FAR
        push bp
        mov  bp,sp
        push ax
        push bx
        push cx
        push dx
        mov  ax,[bp+6]
        mov  dx,[bp+8]
        mov  bx,[bp+10]
        mov  cx,[bp+12]
        call transfer_context_
        pop  dx
        pop  cx
        pop  bx
        pop  ax
        pop  bp
        ret
_transfer_context ENDP


switch_CODE   ENDS

                END
